/*
 * Decompiled with CFR 0.152.
 */
package ast.AST;

import ast.AST.Ast;
import ast.AST.AstVisitor;
import ast.AST.Node;
import ast.AST.SimpleNode;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;

public class ASTNode
extends SimpleNode
implements Cloneable {
    public static boolean IN_CIRCLE = false;
    public static boolean CHANGE = false;
    public static boolean LAST_CYCLE = false;
    public static boolean generatedWithCircularEnabled = true;
    public static boolean generatedWithCacheCycle = true;
    public static int boundariesCrossed = 0;
    protected static State state = new State();
    public boolean inCircle = false;
    public boolean isFinal = false;
    protected static final int REWRITE_CHANGE = 1;
    protected static final int REWRITE_NOCHANGE = 2;
    protected static final int REWRITE_INTERRUPT = 3;
    private int childIndex;
    protected static int duringClassRelations = 0;
    public static boolean aspectJ = false;
    public static boolean rewriteEnabled = false;
    public static boolean circularEnabled = true;
    public static boolean visitCheckEnabled = true;
    public static boolean traceVisitCheck = false;
    public static boolean cacheCycle = true;
    public static String createDefaultMap = "new java.util.HashMap(4)";
    public static String createDefaultSet = "new java.util.HashSet(4)";
    private static final Collection emptyCollection = new ArrayList(0);
    private boolean emptyCollection_visited = false;

    public ASTNode(int i) {
        super(i);
    }

    public ASTNode(Ast p, int i) {
        this(i);
        this.parser = p;
    }

    public ASTNode() {
        this(0);
    }

    public Object clone() throws CloneNotSupportedException {
        ASTNode node = (ASTNode)super.clone();
        node.emptyCollection_visited = false;
        node.inCircle = false;
        node.isFinal = false;
        return node;
    }

    public ASTNode copy() {
        try {
            ASTNode node = (ASTNode)this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public ASTNode fullCopy() {
        ASTNode res = this.copy();
        int i = 0;
        while (i < this.getNumChild()) {
            ASTNode node = this.getChildNoTransform(i);
            if (node != null) {
                node = node.fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    public void dumpTree(String indent, PrintStream pStream) {
        pStream.println(String.valueOf(indent) + "ASTNode");
        String childIndent = String.valueOf(indent) + "  ";
        int i = 0;
        while (i < this.getNumChild()) {
            this.getChild(i).dumpTree(childIndent, pStream);
            ++i;
        }
    }

    public Object jjtAccept(AstVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void jjtAddChild(Node n, int i) {
        this.checkChild(n, i);
        super.jjtAddChild(n, i);
    }

    public void checkChild(Node n, int i) {
    }

    public ASTNode getChild(int i) {
        return ASTNode.getChild(this, i);
    }

    public static ASTNode getChild(ASTNode that, int i) {
        ASTNode node = that.getChildNoTransform(i);
        if (node.isFinal) {
            return node;
        }
        if (!node.mayHaveRewrite()) {
            node.isFinal = that.isFinal;
            return node;
        }
        if (!node.inCircle) {
            int rewriteState;
            int num = boundariesCrossed;
            do {
                state.push(1);
                ASTNode oldNode = node;
                oldNode.inCircle = true;
                node = node.rewriteTo();
                oldNode.inCircle = false;
                that.setChild(node, i);
            } while ((rewriteState = state.pop()) == 1);
            if (rewriteState == 2 && that.isFinal) {
                node.isFinal = true;
                boundariesCrossed = num;
            }
        } else if (that.isFinal != node.isFinal) {
            ++boundariesCrossed;
        }
        return node;
    }

    public int getIndexOfChild(ASTNode node) {
        if (node.childIndex < this.getNumChild() && node == this.getChildNoTransform(node.childIndex)) {
            return node.childIndex;
        }
        int i = 0;
        while (i < this.getNumChild()) {
            if (this.getChildNoTransform(i) == node) {
                node.childIndex = i;
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void addChild(ASTNode node) {
        this.setChild(node, this.getNumChild());
        if (node != null) {
            node.setParent(this);
        }
    }

    public ASTNode getChildNoTransform(int i) {
        return (ASTNode)this.children[i];
    }

    public int getNumChild() {
        return this.children == null ? 0 : this.children.length;
    }

    public void setChild(ASTNode node, int i) {
        if (this.children == null) {
            this.children = new ASTNode[i + 1];
        } else if (i >= this.children.length) {
            ASTNode[] c = new ASTNode[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = node;
        if (node != null) {
            node.setParent(this);
            node.childIndex = i;
        }
    }

    public void insertChild(ASTNode node, int i) {
        if (this.children == null) {
            this.children = new ASTNode[i + 1];
            this.children[i] = node;
        } else {
            ASTNode[] c = new ASTNode[this.children.length + 1];
            System.arraycopy(this.children, 0, c, 0, i);
            c[i] = node;
            if (i < this.children.length) {
                System.arraycopy(this.children, i, c, i + 1, this.children.length - i);
            }
            this.children = c;
        }
        if (node != null) {
            node.setParent(this);
            node.childIndex = i;
        }
    }

    public ASTNode getParent() {
        if (((ASTNode)this.parent).isFinal != this.isFinal) {
            ++boundariesCrossed;
        }
        return (ASTNode)this.parent;
    }

    public void setParent(ASTNode node) {
        this.parent = node;
    }

    protected static boolean duringClassRelations() {
        if (duringClassRelations == 0) {
            return false;
        }
        state.pop();
        state.push(3);
        return true;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public String toReferenceType(String value, String type) {
        if (type.equals("int")) {
            return "new Integer(" + value + ")";
        }
        if (type.equals("short")) {
            return "new Short(" + value + ")";
        }
        if (type.equals("long")) {
            return "new Long(" + value + ")";
        }
        if (type.equals("float")) {
            return "new Float(" + value + ")";
        }
        if (type.equals("double")) {
            return "new Double(" + value + ")";
        }
        if (type.equals("boolean")) {
            return "Boolean.valueOf(" + value + ")";
        }
        if (type.equals("char")) {
            return "new Character(" + value + ")";
        }
        return value;
    }

    public String fromReferenceType(String value, String type) {
        if (type.equals("int")) {
            return "((Integer)" + value + ").intValue()";
        }
        if (type.equals("short")) {
            return "((Short)" + value + ").shortValue()";
        }
        if (type.equals("long")) {
            return "((Long)" + value + ").longValue()";
        }
        if (type.equals("float")) {
            return "((Float)" + value + ").floatValue()";
        }
        if (type.equals("double")) {
            return "((Double)" + value + ").doubleValue()";
        }
        if (type.equals("boolean")) {
            return "((Boolean)" + value + ").booleanValue()";
        }
        if (type.equals("char")) {
            return "((Character)" + value + ").charValue()";
        }
        return "(" + type + ")" + value;
    }

    public Collection emptyCollection() {
        if (this.emptyCollection_visited) {
            System.out.println("Circular definition of attr: emptyCollection in class: " + this.getClass().getName());
        }
        this.emptyCollection_visited = true;
        Collection emptyCollection_value = this.emptyCollection_compute();
        this.emptyCollection_visited = false;
        return emptyCollection_value;
    }

    private Collection emptyCollection_compute() {
        return emptyCollection;
    }

    public ASTNode rewriteTo() {
        if (state.peek() == 1) {
            state.pop();
            state.push(2);
        }
        return this;
    }

    static class State {
        private int[] stack = new int[64];
        private int pos = 0;

        private void ensureSize(int size) {
            if (size < this.stack.length) {
                return;
            }
            int[] newStack = new int[this.stack.length * 2];
            System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
            this.stack = newStack;
        }

        public void push(int i) {
            this.ensureSize(this.pos + 1);
            this.stack[this.pos++] = i;
        }

        public int pop() {
            return this.stack[--this.pos];
        }

        public int peek() {
            return this.stack[this.pos - 1];
        }
    }
}

