/*
 * Decompiled with CFR 0.152.
 */
package ast.AST;

import ast.AST.ASTNode;
import ast.AST.Ast;
import ast.AST.AstVisitor;
import ast.AST.Components;
import ast.AST.Id;
import ast.AST.Node;
import java.io.PrintStream;

public class AggregateComponents
extends Components
implements Cloneable {
    private boolean name_visited = false;
    private boolean type_visited = false;
    private boolean constrParmType_visited = false;

    public AggregateComponents(int i) {
        super(i);
    }

    public AggregateComponents(Ast p, int i) {
        this(i);
        this.parser = p;
    }

    public AggregateComponents() {
        this(0);
        this.setChild(null, 0);
    }

    public AggregateComponents(Id p0) {
        this.setChild(p0, 0);
        if (p0 != null) {
            p0.setParent(this);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        AggregateComponents node = (AggregateComponents)super.clone();
        node.name_visited = false;
        node.type_visited = false;
        node.constrParmType_visited = false;
        node.inCircle = false;
        node.isFinal = false;
        return node;
    }

    public ASTNode copy() {
        try {
            AggregateComponents node = (AggregateComponents)this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public ASTNode fullCopy() {
        AggregateComponents res = (AggregateComponents)this.copy();
        int i = 0;
        while (i < this.getNumChild()) {
            ASTNode node = this.getChildNoTransform(i);
            if (node != null) {
                node = node.fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    public void dumpTree(String indent, PrintStream pStream) {
        pStream.println(String.valueOf(indent) + "AggregateComponents");
        String childIndent = String.valueOf(indent) + "  ";
        int i = 0;
        while (i < this.getNumChild()) {
            this.getChild(i).dumpTree(childIndent, pStream);
            ++i;
        }
    }

    public Object jjtAccept(AstVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void jjtAddChild(Node n, int i) {
        this.checkChild(n, i);
        super.jjtAddChild(n, i);
    }

    public void checkChild(Node n, int i) {
        if (i == 0 && !(n instanceof Id)) {
            throw new Error("Child number 0 of AggregateComponents has the type " + n.getClass().getName() + " which is not an instance of Id");
        }
    }

    public int getNumChild() {
        return 1;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void setId(Id node) {
        this.setChild(node, 0);
        if (node != null) {
            node.setParent(this);
        }
    }

    public Id getId() {
        return (Id)this.getChild(0);
    }

    public Id getIdNoTransform() {
        return (Id)this.getChildNoTransform(0);
    }

    public void jjtGenCheckTreeStructure(PrintStream stream, int j) {
        stream.println("  if(i == " + j + " && !(n instanceof " + this.type() + ")) " + " throw new Error(\"Child number " + j + " of " + this.hostClass().name() + " has the type \" + n.getClass().getName() + \" which is not an instance of " + this.type() + "\");");
    }

    public void jaddGen(PrintStream stream, int index, boolean publicModifier) {
        String s = "    // Declared in " + this.hostClass().getFileName() + " line " + this.hostClass().getStartLine() + "\n" + "    public void set#NAME#(#TYPE# node) {\n" + "        setChild(node, #INDEX#);\n" + "    }\n";
        s = !this.isNTA() ? String.valueOf(s) + "    public #TYPE# get#NAME#() {\n" + "        return (#TYPE#)getChild(#INDEX#);\n" + "    }\n\n" + "    public #TYPE# get#NAME#NoTransform() {\n" + "        return (#TYPE#)getChildNoTransform(#INDEX#);\n" + "    }\n\n" : String.valueOf(s) + "    public #TYPE# get#NAME#NoTransform() {\n" + "        return (#TYPE#)getChildNoTransform(#INDEX#);\n" + "    }\n\n";
        s = s.replaceAll("#TYPE#", this.getId().type());
        s = s.replaceAll("#NAME#", this.getId().name());
        s = s.replaceAll("#INDEX#", String.valueOf(index));
        if (!publicModifier) {
            s = s.replaceAll("    public ", "    private ");
        }
        stream.println(s);
    }

    public String name() {
        if (this.name_visited) {
            System.out.println("Circular definition of attr: name in class: " + this.getClass().getName());
        }
        this.name_visited = true;
        String name_value = this.name_compute();
        this.name_visited = false;
        return name_value;
    }

    private String name_compute() {
        return this.getId().name();
    }

    public String type() {
        if (this.type_visited) {
            System.out.println("Circular definition of attr: type in class: " + this.getClass().getName());
        }
        this.type_visited = true;
        String type_value = this.type_compute();
        this.type_visited = false;
        return type_value;
    }

    private String type_compute() {
        return this.getId().type();
    }

    public String constrParmType() {
        if (this.constrParmType_visited) {
            System.out.println("Circular definition of attr: constrParmType in class: " + this.getClass().getName());
        }
        this.constrParmType_visited = true;
        String constrParmType_value = this.constrParmType_compute();
        this.constrParmType_visited = false;
        return constrParmType_value;
    }

    private String constrParmType_compute() {
        return this.getId().type();
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

