/*
 * Decompiled with CFR 0.152.
 */
package ast.AST;

import ast.AST.ASTDecl;
import ast.AST.ASTNode;
import ast.AST.Ast;
import ast.AST.AstVisitor;
import ast.AST.AttrDecl;
import ast.AST.Defines_ASTDecl_hostClass;
import ast.AST.List;
import ast.AST.Node;
import ast.AST.Parameter;
import java.io.File;
import java.io.PrintStream;
import jrag.AST.SimpleNode;

public abstract class AttrEq
extends ASTNode
implements Cloneable {
    private String tokenString_Name;
    private String tokenString_FileName;
    private int tokenint_StartLine;
    private int tokenint_EndLine;
    public SimpleNode rhs;
    private boolean parametersDecl_visited = false;
    private boolean parameters_visited = false;
    private boolean interfaceParameters_visited = false;
    private boolean interfaceParametersDecl_visited = false;
    private boolean interfaceParametersStart_visited = false;
    private boolean interfaceParametersContinue_visited = false;
    private boolean name_visited = false;
    private boolean type_visited = false;
    private boolean signature_visited = false;
    private boolean hostClass_visited = false;

    public AttrEq(int i) {
        super(i);
    }

    public AttrEq(Ast p, int i) {
        this(i);
        this.parser = p;
    }

    public AttrEq() {
        this(0);
        this.setChild(new List(), 0);
        this.getChildNoTransform(0).setParent(this);
    }

    public AttrEq(List p0, String p1, String p2, int p3, int p4) {
        this.setChild(p0, 0);
        if (p0 != null) {
            p0.setParent(this);
        }
        this.setName(p1);
        this.setFileName(p2);
        this.setStartLine(p3);
        this.setEndLine(p4);
    }

    public Object clone() throws CloneNotSupportedException {
        AttrEq node = (AttrEq)super.clone();
        node.parametersDecl_visited = false;
        node.parameters_visited = false;
        node.interfaceParameters_visited = false;
        node.interfaceParametersDecl_visited = false;
        node.interfaceParametersStart_visited = false;
        node.interfaceParametersContinue_visited = false;
        node.name_visited = false;
        node.type_visited = false;
        node.signature_visited = false;
        node.hostClass_visited = false;
        node.inCircle = false;
        node.isFinal = false;
        return node;
    }

    public void dumpTree(String indent, PrintStream pStream) {
        pStream.println(String.valueOf(indent) + "AttrEq" + "\"" + this.getName() + "\"" + "\"" + this.getFileName() + "\"" + "\"" + this.getStartLine() + "\"" + "\"" + this.getEndLine() + "\"");
        String childIndent = String.valueOf(indent) + "  ";
        int i = 0;
        while (i < this.getNumChild()) {
            this.getChild(i).dumpTree(childIndent, pStream);
            ++i;
        }
    }

    public Object jjtAccept(AstVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void jjtAddChild(Node n, int i) {
        this.checkChild(n, i);
        super.jjtAddChild(n, i);
    }

    public void checkChild(Node n, int i) {
        if (i == 0) {
            if (!(n instanceof List)) {
                throw new Error("Child number 0 of AttrEq has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            int k = 0;
            while (k < ((List)n).getNumChild()) {
                if (!(((List)n).getChildNoTransform(k) instanceof Parameter)) {
                    throw new Error("Child number " + k + " in ParameterList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of Parameter");
                }
                ++k;
            }
        }
    }

    public int getNumChild() {
        return 1;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void setParameterList(List list) {
        this.setChild(list, 0);
        if (list != null) {
            list.setParent(this);
        }
    }

    public int getNumParameter() {
        return this.getParameterList().getNumChild();
    }

    public Parameter getParameter(int i) {
        return (Parameter)this.getParameterList().getChild(i);
    }

    public void addParameter(Parameter node) {
        List list = this.getParameterList();
        list.setChild(node, list.getNumChild());
        if (node != null) {
            node.setParent(list);
        }
    }

    public void setParameter(Parameter node, int i) {
        List list = this.getParameterList();
        list.setChild(node, i);
        if (node != null) {
            node.setParent(list);
        }
    }

    public List getParameterList() {
        return (List)this.getChild(0);
    }

    public List getParameterListNoTransform() {
        return (List)this.getChildNoTransform(0);
    }

    public void setName(String value) {
        this.tokenString_Name = value;
    }

    public String getName() {
        return this.tokenString_Name;
    }

    public void setFileName(String value) {
        this.tokenString_FileName = value;
    }

    public String getFileName() {
        return this.tokenString_FileName;
    }

    public void setStartLine(int value) {
        this.tokenint_StartLine = value;
    }

    public int getStartLine() {
        return this.tokenint_StartLine;
    }

    public void setEndLine(int value) {
        this.tokenint_EndLine = value;
    }

    public int getEndLine() {
        return this.tokenint_EndLine;
    }

    public String aspectName() {
        String pattern;
        String name = this.getFileName().substring(0, this.getFileName().length() - 5);
        String string = File.separator.equals("\\") ? (pattern = "\\\\") : File.separator;
        String[] names = name.split(string);
        return names[names.length - 1];
    }

    public void setRHS(SimpleNode node) {
        this.rhs = node;
    }

    public SimpleNode getRHS() {
        return this.rhs;
    }

    public String attributeSignature() {
        if (this.getNumParameter() == 0) {
            return this.getName();
        }
        StringBuffer s = new StringBuffer();
        s.append(this.getName());
        int i = 0;
        while (i < this.getNumParameter()) {
            s.append("_" + this.getParameter(i).getType());
            ++i;
        }
        return s.toString();
    }

    public String attributeName() {
        return this.getName();
    }

    public String hostFileComment() {
        return "    // Declared in " + this.getFileName() + " at line " + this.getStartLine() + "\n";
    }

    public String computeMethod() {
        return "";
    }

    public abstract AttrDecl decl();

    public abstract String error();

    public String parametersDecl() {
        if (this.parametersDecl_visited) {
            System.out.println("Circular definition of attr: parametersDecl in class: " + this.getClass().getName());
        }
        this.parametersDecl_visited = true;
        String parametersDecl_value = this.parametersDecl_compute();
        this.parametersDecl_visited = false;
        return parametersDecl_value;
    }

    private String parametersDecl_compute() {
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < this.getNumParameter()) {
            Parameter p = this.getParameter(i);
            s.append(String.valueOf(p.getType()) + " " + p.getName());
            if (i < this.getNumParameter() - 1) {
                s.append(", ");
            }
            ++i;
        }
        return s.toString();
    }

    public String parameters() {
        if (this.parameters_visited) {
            System.out.println("Circular definition of attr: parameters in class: " + this.getClass().getName());
        }
        this.parameters_visited = true;
        String parameters_value = this.parameters_compute();
        this.parameters_visited = false;
        return parameters_value;
    }

    private String parameters_compute() {
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < this.getNumParameter()) {
            Parameter p = this.getParameter(i);
            s.append(p.getName());
            if (i < this.getNumParameter() - 1) {
                s.append(", ");
            }
            ++i;
        }
        return s.toString();
    }

    public String interfaceParameters() {
        if (this.interfaceParameters_visited) {
            System.out.println("Circular definition of attr: interfaceParameters in class: " + this.getClass().getName());
        }
        this.interfaceParameters_visited = true;
        String interfaceParameters_value = this.interfaceParameters_compute();
        this.interfaceParameters_visited = false;
        return interfaceParameters_value;
    }

    private String interfaceParameters_compute() {
        return "caller, child" + (this.parameters().equals("") ? "" : ", " + this.parameters());
    }

    public String interfaceParametersDecl() {
        if (this.interfaceParametersDecl_visited) {
            System.out.println("Circular definition of attr: interfaceParametersDecl in class: " + this.getClass().getName());
        }
        this.interfaceParametersDecl_visited = true;
        String interfaceParametersDecl_value = this.interfaceParametersDecl_compute();
        this.interfaceParametersDecl_visited = false;
        return interfaceParametersDecl_value;
    }

    private String interfaceParametersDecl_compute() {
        return "ASTNode caller, ASTNode child" + (this.parametersDecl().equals("") ? "" : ", " + this.parametersDecl());
    }

    public String interfaceParametersStart() {
        if (this.interfaceParametersStart_visited) {
            System.out.println("Circular definition of attr: interfaceParametersStart in class: " + this.getClass().getName());
        }
        this.interfaceParametersStart_visited = true;
        String interfaceParametersStart_value = this.interfaceParametersStart_compute();
        this.interfaceParametersStart_visited = false;
        return interfaceParametersStart_value;
    }

    private String interfaceParametersStart_compute() {
        return "this, null" + (this.parameters().equals("") ? "" : ", " + this.parameters());
    }

    public String interfaceParametersContinue() {
        if (this.interfaceParametersContinue_visited) {
            System.out.println("Circular definition of attr: interfaceParametersContinue in class: " + this.getClass().getName());
        }
        this.interfaceParametersContinue_visited = true;
        String interfaceParametersContinue_value = this.interfaceParametersContinue_compute();
        this.interfaceParametersContinue_visited = false;
        return interfaceParametersContinue_value;
    }

    private String interfaceParametersContinue_compute() {
        return "this, caller" + (this.parameters().equals("") ? "" : ", " + this.parameters());
    }

    public String name() {
        if (this.name_visited) {
            System.out.println("Circular definition of attr: name in class: " + this.getClass().getName());
        }
        this.name_visited = true;
        String name_value = this.name_compute();
        this.name_visited = false;
        return name_value;
    }

    private String name_compute() {
        return this.getName();
    }

    public String type() {
        if (this.type_visited) {
            System.out.println("Circular definition of attr: type in class: " + this.getClass().getName());
        }
        this.type_visited = true;
        String type_value = this.type_compute();
        this.type_visited = false;
        return type_value;
    }

    private String type_compute() {
        if (this.decl() != null) {
            return this.decl().type();
        }
        throw new Error("Undefined type used in AttrEq " + this.signature() + " in " + this.hostClass().name());
    }

    public String signature() {
        if (this.signature_visited) {
            System.out.println("Circular definition of attr: signature in class: " + this.getClass().getName());
        }
        this.signature_visited = true;
        String signature_value = this.signature_compute();
        this.signature_visited = false;
        return signature_value;
    }

    private String signature_compute() {
        if (this.getNumParameter() == 0) {
            return this.getName();
        }
        StringBuffer s = new StringBuffer();
        s.append(this.getName());
        int i = 0;
        while (i < this.getNumParameter()) {
            s.append("_" + this.getParameter(i).getType());
            ++i;
        }
        return s.toString();
    }

    public ASTDecl hostClass() {
        if (this.hostClass_visited) {
            System.out.println("Circular definition of attr: hostClass in class: " + this.getClass().getName());
        }
        this.hostClass_visited = true;
        ASTDecl hostClass_value = this.hostClass_compute();
        this.hostClass_visited = false;
        return hostClass_value;
    }

    private ASTDecl hostClass_compute() {
        ASTNode n = this.getParent();
        ASTNode caller = this;
        AttrEq child = null;
        while (!(n instanceof Defines_ASTDecl_hostClass)) {
            child = caller;
            caller = n;
            n = n.getParent();
        }
        return ((Defines_ASTDecl_hostClass)((Object)n)).Define_ASTDecl_hostClass(caller, child);
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

