/*
 * Decompiled with CFR 0.152.
 */
package ast.AST;

import ast.AST.ASTDecl;
import ast.AST.ASTNode;
import ast.AST.Ast;
import ast.AST.AstVisitor;
import ast.AST.Defines_ASTDecl_hostClass;
import ast.AST.Defines_Grammar_env;
import ast.AST.Grammar;
import ast.AST.Node;
import java.io.PrintStream;

public abstract class Components
extends ASTNode
implements Cloneable {
    private boolean className_visited = false;
    private boolean astError_visited = false;
    private boolean env_visited = false;
    private boolean hostClass_visited = false;

    public Components(int i) {
        super(i);
    }

    public Components(Ast p, int i) {
        this(i);
        this.parser = p;
    }

    public Components() {
        this(0);
    }

    public Object clone() throws CloneNotSupportedException {
        Components node = (Components)super.clone();
        node.className_visited = false;
        node.astError_visited = false;
        node.env_visited = false;
        node.hostClass_visited = false;
        node.inCircle = false;
        node.isFinal = false;
        return node;
    }

    public void dumpTree(String indent, PrintStream pStream) {
        pStream.println(String.valueOf(indent) + "Components");
        String childIndent = String.valueOf(indent) + "  ";
        int i = 0;
        while (i < this.getNumChild()) {
            this.getChild(i).dumpTree(childIndent, pStream);
            ++i;
        }
    }

    public Object jjtAccept(AstVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void jjtAddChild(Node n, int i) {
        this.checkChild(n, i);
        super.jjtAddChild(n, i);
    }

    public void checkChild(Node n, int i) {
    }

    public int getNumChild() {
        return 0;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public boolean isNTA() {
        return false;
    }

    public void jjtGenCheckTreeStructure(PrintStream stream, int j) {
    }

    public abstract void jaddGen(PrintStream var1, int var2, boolean var3);

    public boolean declared() {
        return this.env().lookup(this.type()) != null;
    }

    public abstract String name();

    public abstract String type();

    public abstract String constrParmType();

    public String className() {
        if (this.className_visited) {
            System.out.println("Circular definition of attr: className in class: " + this.getClass().getName());
        }
        this.className_visited = true;
        String className_value = this.className_compute();
        this.className_visited = false;
        return className_value;
    }

    private String className_compute() {
        return this.hostClass().name();
    }

    public String astError() {
        if (this.astError_visited) {
            System.out.println("Circular definition of attr: astError in class: " + this.getClass().getName());
        }
        this.astError_visited = true;
        String astError_value = this.astError_compute();
        this.astError_visited = false;
        return astError_value;
    }

    private String astError_compute() {
        StringBuffer result = new StringBuffer();
        if (this.hostClass().lookupComponents(this.name()) != this) {
            result.append(String.valueOf(this.hostClass().getFileName()) + ":" + this.hostClass().getStartLine() + " ");
            result.append("Component name " + this.name() + " is not unique in " + "production rule for " + this.hostClass().name() + "\n");
        }
        if (!this.declared()) {
            result.append(String.valueOf(this.hostClass().getFileName()) + ":" + this.hostClass().getStartLine() + " ");
            result.append("Type " + this.type() + " of component " + this.name() + " in production " + this.hostClass().name() + " is not declared\n");
        }
        return result.toString();
    }

    public Grammar env() {
        if (this.env_visited) {
            System.out.println("Circular definition of attr: env in class: " + this.getClass().getName());
        }
        this.env_visited = true;
        Grammar env_value = this.env_compute();
        this.env_visited = false;
        return env_value;
    }

    private Grammar env_compute() {
        ASTNode n = this.getParent();
        ASTNode caller = this;
        Components child = null;
        while (!(n instanceof Defines_Grammar_env)) {
            child = caller;
            caller = n;
            n = n.getParent();
        }
        return ((Defines_Grammar_env)((Object)n)).Define_Grammar_env(caller, child);
    }

    public ASTDecl hostClass() {
        if (this.hostClass_visited) {
            System.out.println("Circular definition of attr: hostClass in class: " + this.getClass().getName());
        }
        this.hostClass_visited = true;
        ASTDecl hostClass_value = this.hostClass_compute();
        this.hostClass_visited = false;
        return hostClass_value;
    }

    private ASTDecl hostClass_compute() {
        ASTNode n = this.getParent();
        ASTNode caller = this;
        Components child = null;
        while (!(n instanceof Defines_ASTDecl_hostClass)) {
            child = caller;
            caller = n;
            n = n.getParent();
        }
        return ((Defines_ASTDecl_hostClass)((Object)n)).Define_ASTDecl_hostClass(caller, child);
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

