/*
 * Decompiled with CFR 0.152.
 */
package ast.AST;

import ast.AST.ASTDecl;
import ast.AST.ASTNode;
import ast.AST.Ast;
import ast.AST.AstVisitor;
import ast.AST.AttrEq;
import ast.AST.ClassDecl;
import ast.AST.Components;
import ast.AST.Defines_Collection_findFathers_ASTDecl;
import ast.AST.Defines_Collection_findSubclasses_ASTDecl;
import ast.AST.Defines_Grammar_env;
import ast.AST.IdDecl;
import ast.AST.InhDecl;
import ast.AST.InhEq;
import ast.AST.InterfaceDecl;
import ast.AST.List;
import ast.AST.Node;
import ast.AST.Parameter;
import ast.AST.ParseException;
import ast.AST.Rewrite;
import ast.AST.RewriteList;
import ast.AST.SynDecl;
import ast.AST.SynEq;
import ast.AST.TokenMgrError;
import ast.AST.TypeDecl;
import jastadd.JastAddCodeGen;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import jrag.AST.ASTCompilationUnit;
import jrag.AST.ASTExpression;
import jrag.AST.JragParser;
import jrag.AST.SimpleNode;
import jrag.ClassBodyObject;
import jrag.Unparse;

public class Grammar
extends ASTNode
implements Cloneable,
Defines_Collection_findFathers_ASTDecl,
Defines_Collection_findSubclasses_ASTDecl,
Defines_Grammar_env {
    public LinkedList compUnits;
    private Set lookup_String_visited;
    private boolean subclassMap_visited;
    private boolean subclassMap_computed;
    private HashMap subclassMap_value;
    private boolean fatherMap_visited;
    private boolean fatherMap_computed;
    private HashMap fatherMap_value;
    private boolean inhEqMap_visited;
    private boolean inhEqMap_computed;
    private HashMap inhEqMap_value;
    private boolean rewriteAspects_visited;
    private boolean rewriteAspects_computed;
    private Collection rewriteAspects_value;
    private boolean astErrors_visited;
    private boolean collectAstErrors_visited;
    private boolean roots_visited;
    private boolean errors_visited;
    private boolean collectErrors_visited;

    public Grammar(int i) {
        super(i);
        this.isFinal = true;
        this.compUnits = new LinkedList();
        this.lookup_String_visited = new HashSet(4);
        this.subclassMap_visited = false;
        this.subclassMap_computed = false;
        this.fatherMap_visited = false;
        this.fatherMap_computed = false;
        this.inhEqMap_visited = false;
        this.inhEqMap_computed = false;
        this.rewriteAspects_visited = false;
        this.rewriteAspects_computed = false;
        this.astErrors_visited = false;
        this.collectAstErrors_visited = false;
        this.roots_visited = false;
        this.errors_visited = false;
        this.collectErrors_visited = false;
    }

    public Grammar(Ast p, int i) {
        this(i);
        this.parser = p;
    }

    public Grammar() {
        this(0);
        this.setChild(new List(), 0);
        this.getChildNoTransform(0).setParent(this);
    }

    public Grammar(List p0) {
        this.isFinal = true;
        this.compUnits = new LinkedList();
        this.lookup_String_visited = new HashSet(4);
        this.subclassMap_visited = false;
        this.subclassMap_computed = false;
        this.fatherMap_visited = false;
        this.fatherMap_computed = false;
        this.inhEqMap_visited = false;
        this.inhEqMap_computed = false;
        this.rewriteAspects_visited = false;
        this.rewriteAspects_computed = false;
        this.astErrors_visited = false;
        this.collectAstErrors_visited = false;
        this.roots_visited = false;
        this.errors_visited = false;
        this.collectErrors_visited = false;
        this.setChild(p0, 0);
        if (p0 != null) {
            p0.setParent(this);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Grammar node = (Grammar)super.clone();
        node.lookup_String_visited = new HashSet(4);
        node.subclassMap_visited = false;
        node.subclassMap_computed = false;
        node.fatherMap_visited = false;
        node.fatherMap_computed = false;
        node.inhEqMap_visited = false;
        node.inhEqMap_computed = false;
        node.rewriteAspects_visited = false;
        node.rewriteAspects_computed = false;
        node.astErrors_visited = false;
        node.collectAstErrors_visited = false;
        node.roots_visited = false;
        node.errors_visited = false;
        node.collectErrors_visited = false;
        node.inCircle = false;
        node.isFinal = false;
        return node;
    }

    public ASTNode copy() {
        try {
            Grammar node = (Grammar)this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public ASTNode fullCopy() {
        Grammar res = (Grammar)this.copy();
        int i = 0;
        while (i < this.getNumChild()) {
            ASTNode node = this.getChildNoTransform(i);
            if (node != null) {
                node = node.fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    public void dumpTree(String indent, PrintStream pStream) {
        pStream.println(String.valueOf(indent) + "Grammar");
        String childIndent = String.valueOf(indent) + "  ";
        int i = 0;
        while (i < this.getNumChild()) {
            this.getChild(i).dumpTree(childIndent, pStream);
            ++i;
        }
    }

    public Object jjtAccept(AstVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void jjtAddChild(Node n, int i) {
        this.checkChild(n, i);
        super.jjtAddChild(n, i);
    }

    public void checkChild(Node n, int i) {
        if (i == 0) {
            if (!(n instanceof List)) {
                throw new Error("Child number 0 of Grammar has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            int k = 0;
            while (k < ((List)n).getNumChild()) {
                if (!(((List)n).getChildNoTransform(k) instanceof TypeDecl)) {
                    throw new Error("Child number " + k + " in TypeDeclList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of TypeDecl");
                }
                ++k;
            }
        }
    }

    public int getNumChild() {
        return 1;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void setTypeDeclList(List list) {
        this.setChild(list, 0);
        if (list != null) {
            list.setParent(this);
        }
    }

    public int getNumTypeDecl() {
        return this.getTypeDeclList().getNumChild();
    }

    public TypeDecl getTypeDecl(int i) {
        return (TypeDecl)this.getTypeDeclList().getChild(i);
    }

    public void addTypeDecl(TypeDecl node) {
        List list = this.getTypeDeclList();
        list.setChild(node, list.getNumChild());
        if (node != null) {
            node.setParent(list);
        }
    }

    public void setTypeDecl(TypeDecl node, int i) {
        List list = this.getTypeDeclList();
        list.setChild(node, i);
        if (node != null) {
            node.setParent(list);
        }
    }

    public List getTypeDeclList() {
        return (List)this.getChild(0);
    }

    public List getTypeDeclListNoTransform() {
        return (List)this.getChildNoTransform(0);
    }

    public TypeDecl findClassDecl(String name) {
        TypeDecl t = this.lookup(name);
        if (t == null) {
            t = new ClassDecl(new IdDecl(name), new List(), new List(), new List(), new List(), new List(), new List(), "", 0, 0);
            this.addTypeDecl(t);
        }
        return t;
    }

    public TypeDecl findInterfaceDecl(String name) {
        TypeDecl t = this.lookup(name);
        if (t == null) {
            t = new InterfaceDecl(new IdDecl(name), new List(), new List(), new List(), new List(), new List(), new List(), "", 0, 0);
            this.addTypeDecl(t);
        }
        return t;
    }

    public void addRewriteList(String className, SimpleNode condition, SimpleNode result, String fileName, int startLine, int endLine, String parentName, String childName) {
        TypeDecl c = this.lookup(className);
        if (c != null && c instanceof ASTDecl) {
            RewriteList r = new RewriteList();
            r.setFileName(fileName);
            r.setStartLine(startLine);
            r.setEndLine(endLine);
            r.setCondition(condition);
            r.setResult(result);
            r.setParentName(parentName);
            r.setChildName(childName);
            ((ASTDecl)c).addRewrite(r);
        } else if (c != null) {
            System.err.println("Can not rewrite to non AST class " + className + " in " + fileName + " at line " + startLine);
        } else {
            System.err.println("Can not rewrite to unknown class " + className + " in " + fileName + " at line " + startLine);
        }
    }

    public void addRewrite(String className, SimpleNode condition, SimpleNode result, String fileName, int startLine, int endLine) {
        TypeDecl c = this.lookup(className);
        if (c != null && c instanceof ASTDecl) {
            Rewrite r = new Rewrite();
            r.setFileName(fileName);
            r.setStartLine(startLine);
            r.setEndLine(endLine);
            r.setCondition(condition);
            r.setResult(result);
            ((ASTDecl)c).addRewrite(r);
        } else if (c != null) {
            System.err.println("Can not rewrite to non AST class " + className + " in " + fileName + " at line " + startLine);
        } else {
            System.err.println("Can not rewrite to unknown class " + className + " in " + fileName + " at line " + startLine);
        }
    }

    public void addSynDecl(String name, String type, String className, boolean isLazy, String fileName, int startLine, int endLine, List parameterList, ASTExpression bottomValue) {
        TypeDecl c = this.lookup(className);
        if (c != null) {
            SynDecl decl = new SynDecl();
            decl.setName(name);
            decl.setType(type);
            decl.setLazy(isLazy);
            decl.setFileName(fileName);
            decl.setStartLine(startLine);
            decl.setEndLine(endLine);
            decl.setParameterList(parameterList);
            decl.setBottomValue(bottomValue);
            c.addSynDecl(decl);
        } else {
            System.err.println("Can not add synthesized attribute " + type + " " + name + " to unknown class " + className + " in " + fileName + " at line " + startLine);
        }
    }

    public void addSynEq(String name, String className, SimpleNode rhs, String fileName, int startLine, int endLine, List list) {
        TypeDecl c = this.lookup(className);
        if (c != null) {
            SynEq equ = new SynEq();
            equ.setName(name);
            equ.setFileName(fileName);
            equ.setStartLine(startLine);
            equ.setEndLine(endLine);
            equ.setRHS(rhs);
            equ.setParameterList(list);
            c.addSynEq(equ);
        } else {
            System.err.println("Can not add equation for synthesized attribute " + name + " to unknown class " + className + " in " + fileName + " at line " + startLine);
        }
    }

    public void addInhDecl(String name, String type, String className, boolean isLazy, String fileName, int startLine, int endLine, List parameterList, ASTExpression bottomValue) {
        TypeDecl c = this.lookup(className);
        if (c != null) {
            InhDecl decl = new InhDecl();
            decl.setName(name);
            decl.setType(type);
            decl.setLazy(isLazy);
            decl.setFileName(fileName);
            decl.setStartLine(startLine);
            decl.setEndLine(endLine);
            decl.setParameterList(parameterList);
            decl.setBottomValue(bottomValue);
            c.addInhDecl(decl);
        } else {
            System.err.println("Can not add inherited attribute " + type + " " + name + " to unknown class " + className + " in " + fileName + " at line " + startLine);
        }
    }

    public void addInhEq(String sonName, String name, String className, SimpleNode rhs, String fileName, int startLine, int endLine, List list) {
        this.addInhEq(sonName, name, className, rhs, fileName, startLine, endLine, list, null);
    }

    public void addInhEq(String sonName, String name, String className, SimpleNode rhs, String fileName, int startLine, int endLine, List list, Parameter p) {
        TypeDecl c = this.lookup(className);
        if (c != null) {
            Components comp = c.components(sonName);
            if (comp != null) {
                InhEq equ = new InhEq();
                equ.setName(name);
                equ.setFileName(fileName);
                equ.setStartLine(startLine);
                equ.setEndLine(endLine);
                equ.setRHS(rhs);
                equ.setComponents(comp);
                equ.setParameterList(list);
                if (p != null) {
                    equ.setIndex(p);
                }
                c.addInhEq(equ);
            } else {
                System.err.println("Inh equation in " + c.name() + " defining" + " equation for attribute " + name + " in unknown son " + sonName);
            }
        } else {
            System.err.println("Can not add equation for inherited attribute " + name + " to unknown class " + className + " in " + fileName + " at line " + startLine);
        }
    }

    public void addComponents(String className, List componentsList) {
        TypeDecl d = this.lookup(className);
        if (d != null) {
            d.setComponentsList(componentsList);
        }
    }

    public void addCompUnit(ASTCompilationUnit compUnit) {
        this.compUnits.add(compUnit);
    }

    public Iterator getCompUnits() {
        return this.compUnits.iterator();
    }

    public void addClassBodyDecl(SimpleNode n, String className, String fileName) {
        TypeDecl c = this.lookup(className);
        if (c != null) {
            c.classBodyDecls.add(new ClassBodyObject(n, fileName, n.firstToken.beginLine));
        } else {
            System.err.println("Can not add member to unknown class " + className + " in " + fileName);
        }
    }

    public void addInterface(SimpleNode nameList, String className, String fileName) {
        if (nameList == null) {
            System.out.println("Panic");
        } else {
            TypeDecl c = this.lookup(className);
            if (c != null) {
                c.implementsList.add(nameList);
            } else {
                int line = nameList.firstToken.beginLine;
                System.err.println("Can not add interface to unknown class " + className + " in " + fileName + " at line " + line);
            }
        }
    }

    public void addRefinedSynEq(String name, String className, SimpleNode rhs, String fileName, int startLine, int endLine, List list) {
        TypeDecl c = this.lookup(className);
        if (c != null) {
            SynEq equ = new SynEq();
            equ.setName(name);
            equ.setFileName(fileName);
            equ.setStartLine(startLine);
            equ.setEndLine(endLine);
            equ.setRHS(rhs);
            equ.setParameterList(list);
            c.refinedSynEqs.add(equ);
        } else {
            System.err.println("Can not add equation for synthesized attribute " + name + " to unknown class " + className + " in " + fileName + " at line " + startLine);
        }
    }

    public void addRefinedInhEq(String sonName, String name, String className, SimpleNode rhs, String fileName, int startLine, int endLine, List list) {
        this.addRefinedInhEq(sonName, name, className, rhs, fileName, startLine, endLine, list, null);
    }

    public void addRefinedInhEq(String sonName, String name, String className, SimpleNode rhs, String fileName, int startLine, int endLine, List list, Parameter p) {
        TypeDecl c = this.lookup(className);
        if (c != null) {
            Components comp = c.components(sonName);
            if (comp != null) {
                InhEq equ = new InhEq();
                equ.setName(name);
                equ.setFileName(fileName);
                equ.setStartLine(startLine);
                equ.setEndLine(endLine);
                equ.setRHS(rhs);
                equ.setComponents(comp);
                equ.setParameterList(list);
                if (p != null) {
                    equ.setIndex(p);
                }
                c.refinedInhEqs.add(equ);
            } else {
                System.err.println("Inh equation in " + c.name() + " defining" + " equation for attribute " + name + " in unknown son " + sonName);
            }
        } else {
            System.err.println("Can not add equation for inherited attribute " + name + " to unknown class " + className + " in " + fileName + " at line " + startLine);
        }
    }

    public void addRefinedClassBodyDecl(SimpleNode n, String className, String fileName) {
        TypeDecl c = this.lookup(className);
        if (c != null) {
            c.refinedClassBodyDecls.add(new ClassBodyObject(n, fileName, n.firstToken.beginLine));
        } else {
            System.err.println("Can not add member to unknown class " + className + " in " + fileName);
        }
    }

    public void abstractAncestors() {
        ASTDecl cl = new ASTDecl();
        IdDecl name = new IdDecl();
        name.setID("ASTNode");
        cl.setIdDecl(name);
        this.addTypeDecl(cl);
        cl = new ASTDecl();
        name = new IdDecl();
        name.setID("List");
        cl.setIdDecl(name);
        this.addTypeDecl(cl);
        cl = new ASTDecl();
        name = new IdDecl();
        name.setID("Opt");
        cl.setIdDecl(name);
        this.addTypeDecl(cl);
    }

    public void genAGCode(PrintStream s, String aspectName) {
        ASTNode.aspectJ = true;
        s.print(this.genImportsList());
        s.print("aspect " + aspectName + " {\n");
        int i = 0;
        while (i < this.getNumTypeDecl()) {
            this.getTypeDecl(i).genAGCode(s);
            ++i;
        }
        s.print("}\n");
    }

    public String genImportsList() {
        StringBuffer buf = new StringBuffer();
        Iterator iter = this.getCompUnits();
        if (iter.hasNext()) {
            while (iter.hasNext()) {
                ASTCompilationUnit u = (ASTCompilationUnit)iter.next();
                buf.append(Unparse.ajc$interMethodDispatch1$jrag_Unparse$jrag_AST_ASTCompilationUnit$getImports(u));
            }
            buf.append("\n\n");
        }
        return buf.toString();
    }

    public Iterator inhAttrSet() {
        return this.inhEqMap().keySet().iterator();
    }

    public void genRewriteOrderChecks(PrintStream out) {
        Iterator iter = this.rewriteAspects().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            String s = "    protected static int during" + name + " = 0;\n" + "    protected static boolean during" + name + "() {\n" + "        if(during" + name + " == 0) {\n" + "            return false;\n" + "        }\n" + "        else {\n" + "            state.pop();\n" + "            state.push(ASTNode.REWRITE_INTERRUPT);\n" + "            return true;\n" + "        }\n" + "    }\n";
            out.print(s);
        }
    }

    public void createInterfaces(File outputDir, String pack) throws FileNotFoundException {
        Iterator iter = this.inhEqMap().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String attrId = (String)entry.getKey();
            AttrEq attr = (AttrEq)((LinkedList)entry.getValue()).get(0);
            String interfaceName = pack.equals("") ? "Defines_" + attrId : String.valueOf(pack.replace('.', File.separatorChar)) + File.separator + "Defines_" + attrId;
            File file = new File(outputDir, String.valueOf(interfaceName) + ".java");
            PrintStream p = new PrintStream(new FileOutputStream(file));
            if (!pack.equals("")) {
                p.println("package " + pack + ";");
                p.println();
            }
            Iterator itr = this.getCompUnits();
            while (itr.hasNext()) {
                ASTCompilationUnit u = (ASTCompilationUnit)itr.next();
                p.print(Unparse.ajc$interMethodDispatch1$jrag_Unparse$jrag_AST_ASTCompilationUnit$getImports(u));
            }
            p.print("\n\n");
            String s = "public interface Defines_#TYPE#_#NAME# {\n    public #TYPE# Define_#TYPE#_#METHODNAME#(#INTERFACEPARMDECL#);\n}\n";
            s = s.replaceAll("#TYPE#", attr.type());
            s = s.replaceAll("#NAME#", attr.attributeSignature());
            s = s.replaceAll("#METHODNAME#", attr.attributeName());
            s = s.replaceAll("#PARMDECL#", attr.parametersDecl());
            s = s.replaceAll("#INTERFACEPARMDECL#", attr.interfaceParametersDecl());
            p.print(s);
        }
    }

    public static Grammar createGrammar() {
        Grammar g = new Grammar();
        g.abstractAncestors();
        return g;
    }

    public Collection addAst(String fileName) throws FileNotFoundException {
        return this.addAst(fileName, new FileInputStream(fileName));
    }

    public Collection addAst(String fileName, InputStream is) {
        try {
            Ast parser = new Ast(is);
            parser.fileName = fileName;
            Grammar g = parser.Grammar();
            int i = 0;
            while (i < g.getNumTypeDecl()) {
                this.addTypeDecl(g.getTypeDecl(i));
                ++i;
            }
            return parser.parseErrors();
        }
        catch (TokenMgrError e) {
            ArrayList<String> c = new ArrayList<String>();
            c.add(String.valueOf(fileName) + ": " + e.getMessage());
            return c;
        }
        catch (ParseException parseException) {
            return this.emptyCollection();
        }
    }

    public Collection addJrag(String fileName) throws FileNotFoundException {
        return this.addJrag(fileName, new FileInputStream(fileName));
    }

    public Collection addJrag(String fileName, InputStream is) {
        try {
            JragParser jp = new JragParser(is);
            jp.inputStream = is;
            jp.root = this;
            jp.setFileName(fileName);
            ASTCompilationUnit au = jp.CompilationUnit();
            this.addCompUnit(au);
        }
        catch (jrag.AST.ParseException e) {
            StringBuffer msg = new StringBuffer();
            msg.append(Integer.toString(e.currentToken.next.beginLine));
            msg.append(";");
            msg.append(Integer.toString(e.currentToken.next.beginColumn));
            msg.append(";");
            msg.append(Integer.toString(e.currentToken.next.endLine));
            msg.append(";");
            msg.append(Integer.toString(e.currentToken.next.endColumn));
            msg.append(";");
            msg.append("Syntax error");
            ArrayList<String> c = new ArrayList<String>();
            c.add(msg.toString());
            return c;
        }
        catch (jrag.AST.TokenMgrError e) {
            ArrayList<String> c = new ArrayList<String>();
            c.add(String.valueOf(fileName) + ": " + e.getMessage());
            return c;
        }
        return this.emptyCollection();
    }

    public TypeDecl lookup(String name) {
        String _parameters = name;
        if (this.lookup_String_visited.contains(_parameters)) {
            System.out.println("Circular definition of attr: lookup in class: " + this.getClass().getName());
        }
        this.lookup_String_visited.add(_parameters);
        TypeDecl lookup_String_value = this.lookup_compute(name);
        this.lookup_String_visited.remove(_parameters);
        return lookup_String_value;
    }

    private TypeDecl lookup_compute(String name) {
        int i = 0;
        while (i < this.getNumTypeDecl()) {
            if (this.getTypeDecl(i).name().equals(name)) {
                return this.getTypeDecl(i);
            }
            ++i;
        }
        return null;
    }

    public HashMap subclassMap() {
        if (this.subclassMap_computed) {
            return this.subclassMap_value;
        }
        if (this.subclassMap_visited) {
            System.out.println("Circular definition of attr: subclassMap in class: " + this.getClass().getName());
        }
        this.subclassMap_visited = true;
        int num = ASTNode.boundariesCrossed;
        boolean isFinal = this.isFinal;
        this.subclassMap_value = this.subclassMap_compute();
        if (isFinal && num == ASTNode.boundariesCrossed) {
            this.subclassMap_computed = true;
        }
        this.subclassMap_visited = false;
        return this.subclassMap_value;
    }

    private HashMap subclassMap_compute() {
        ASTDecl decl;
        HashMap map = new HashMap();
        int j = 0;
        while (j < this.getNumTypeDecl()) {
            if (this.getTypeDecl(j) instanceof ASTDecl) {
                decl = (ASTDecl)this.getTypeDecl(j);
                map.put(decl, new ArrayList());
            }
            ++j;
        }
        j = 0;
        while (j < this.getNumTypeDecl()) {
            if (this.getTypeDecl(j) instanceof ASTDecl && (decl = (ASTDecl)this.getTypeDecl(j)).superClass() != null) {
                ((ArrayList)map.get(decl.superClass())).add(decl);
            }
            ++j;
        }
        return map;
    }

    public HashMap fatherMap() {
        if (this.fatherMap_computed) {
            return this.fatherMap_value;
        }
        if (this.fatherMap_visited) {
            System.out.println("Circular definition of attr: fatherMap in class: " + this.getClass().getName());
        }
        this.fatherMap_visited = true;
        int num = ASTNode.boundariesCrossed;
        boolean isFinal = this.isFinal;
        this.fatherMap_value = this.fatherMap_compute();
        if (isFinal && num == ASTNode.boundariesCrossed) {
            this.fatherMap_computed = true;
        }
        this.fatherMap_visited = false;
        return this.fatherMap_value;
    }

    private HashMap fatherMap_compute() {
        ASTDecl decl;
        HashMap map = new HashMap();
        int j = 0;
        while (j < this.getNumTypeDecl()) {
            if (this.getTypeDecl(j) instanceof ASTDecl) {
                decl = (ASTDecl)this.getTypeDecl(j);
                map.put(decl, new HashSet());
            }
            ++j;
        }
        j = 0;
        while (j < this.getNumTypeDecl()) {
            if (this.getTypeDecl(j) instanceof ASTDecl) {
                decl = (ASTDecl)this.getTypeDecl(j);
                Iterator iter = decl.getComponents();
                while (iter.hasNext()) {
                    Components c = (Components)iter.next();
                    TypeDecl t = this.lookup(c.type());
                    if (t == null) continue;
                    ((HashSet)map.get(t)).add(decl);
                }
            }
            ++j;
        }
        return map;
    }

    public HashMap inhEqMap() {
        if (this.inhEqMap_computed) {
            return this.inhEqMap_value;
        }
        if (this.inhEqMap_visited) {
            System.out.println("Circular definition of attr: inhEqMap in class: " + this.getClass().getName());
        }
        this.inhEqMap_visited = true;
        int num = ASTNode.boundariesCrossed;
        boolean isFinal = this.isFinal;
        this.inhEqMap_value = this.inhEqMap_compute();
        if (isFinal && num == ASTNode.boundariesCrossed) {
            this.inhEqMap_computed = true;
        }
        this.inhEqMap_visited = false;
        return this.inhEqMap_value;
    }

    private HashMap inhEqMap_compute() {
        HashMap map = new HashMap();
        int i = 0;
        while (i < this.getNumTypeDecl()) {
            if (this.getTypeDecl(i) instanceof ASTDecl) {
                map.putAll(((ASTDecl)this.getTypeDecl(i)).inhEqMap());
            }
            ++i;
        }
        return map;
    }

    public Collection rewriteAspects() {
        if (this.rewriteAspects_computed) {
            return this.rewriteAspects_value;
        }
        if (this.rewriteAspects_visited) {
            System.out.println("Circular definition of attr: rewriteAspects in class: " + this.getClass().getName());
        }
        this.rewriteAspects_visited = true;
        int num = ASTNode.boundariesCrossed;
        boolean isFinal = this.isFinal;
        this.rewriteAspects_value = this.rewriteAspects_compute();
        if (isFinal && num == ASTNode.boundariesCrossed) {
            this.rewriteAspects_computed = true;
        }
        this.rewriteAspects_visited = false;
        return this.rewriteAspects_value;
    }

    private Collection rewriteAspects_compute() {
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < this.getNumTypeDecl()) {
            if (this.getTypeDecl(i) instanceof ASTDecl) {
                ASTDecl decl = (ASTDecl)this.getTypeDecl(i);
                int j = 0;
                while (j < decl.getNumRewrite()) {
                    Rewrite r = decl.getRewrite(j);
                    set.add(r.aspectName());
                    ++j;
                }
            }
            ++i;
        }
        return set;
    }

    public String astErrors() {
        if (this.astErrors_visited) {
            System.out.println("Circular definition of attr: astErrors in class: " + this.getClass().getName());
        }
        this.astErrors_visited = true;
        String astErrors_value = this.astErrors_compute();
        this.astErrors_visited = false;
        return astErrors_value;
    }

    private String astErrors_compute() {
        return this.collectAstErrors();
    }

    public String collectAstErrors() {
        if (this.collectAstErrors_visited) {
            System.out.println("Circular definition of attr: collectAstErrors in class: " + this.getClass().getName());
        }
        this.collectAstErrors_visited = true;
        String collectAstErrors_value = this.collectAstErrors_compute();
        this.collectAstErrors_visited = false;
        return collectAstErrors_value;
    }

    private String collectAstErrors_compute() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.getNumTypeDecl()) {
            result.append(this.getTypeDecl(i).collectAstErrors());
            ++i;
        }
        ArrayList l = this.roots();
        if (l.isEmpty()) {
            result.append("No root node available\n");
        }
        return result.toString();
    }

    public ArrayList roots() {
        if (this.roots_visited) {
            System.out.println("Circular definition of attr: roots in class: " + this.getClass().getName());
        }
        this.roots_visited = true;
        ArrayList roots_value = this.roots_compute();
        this.roots_visited = false;
        return roots_value;
    }

    private ArrayList roots_compute() {
        ArrayList<ASTDecl> l = new ArrayList<ASTDecl>();
        int i = 0;
        while (i < this.getNumTypeDecl()) {
            ASTDecl decl;
            if (this.getTypeDecl(i) instanceof ASTDecl && (decl = (ASTDecl)this.getTypeDecl(i)).isRootNode()) {
                l.add(decl);
            }
            ++i;
        }
        return l;
    }

    public String errors() {
        if (this.errors_visited) {
            System.out.println("Circular definition of attr: errors in class: " + this.getClass().getName());
        }
        this.errors_visited = true;
        String errors_value = this.errors_compute();
        this.errors_visited = false;
        return errors_value;
    }

    private String errors_compute() {
        return this.collectErrors();
    }

    public String collectErrors() {
        if (this.collectErrors_visited) {
            System.out.println("Circular definition of attr: collectErrors in class: " + this.getClass().getName());
        }
        this.collectErrors_visited = true;
        String collectErrors_value = this.collectErrors_compute();
        this.collectErrors_visited = false;
        return collectErrors_value;
    }

    private String collectErrors_compute() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.getNumTypeDecl()) {
            result.append(this.getTypeDecl(i).collectErrors());
            ++i;
        }
        return result.toString();
    }

    public Collection Define_Collection_findFathers(ASTNode caller, ASTNode child, ASTDecl node) {
        if (caller == this.getTypeDeclListNoTransform()) {
            caller.getIndexOfChild(child);
            HashSet set = new HashSet();
            set.addAll((HashSet)this.fatherMap().get(node));
            if (node.superClass() != null) {
                set.addAll(node.superClass().fathers());
            }
            return set;
        }
        ASTNode n = this.getParent();
        caller = this;
        child = null;
        while (!(n instanceof Defines_Collection_findFathers_ASTDecl)) {
            child = caller;
            caller = n;
            n = n.getParent();
        }
        return ((Defines_Collection_findFathers_ASTDecl)((Object)n)).Define_Collection_findFathers(caller, child, node);
    }

    public Collection Define_Collection_findSubclasses(ASTNode caller, ASTNode child, ASTDecl target) {
        if (caller == this.getTypeDeclListNoTransform()) {
            caller.getIndexOfChild(child);
            return (Collection)this.subclassMap().get(target);
        }
        ASTNode n = this.getParent();
        caller = this;
        child = null;
        while (!(n instanceof Defines_Collection_findSubclasses_ASTDecl)) {
            child = caller;
            caller = n;
            n = n.getParent();
        }
        return ((Defines_Collection_findSubclasses_ASTDecl)((Object)n)).Define_Collection_findSubclasses(caller, child, target);
    }

    public Grammar Define_Grammar_env(ASTNode caller, ASTNode child) {
        if (caller == this.getTypeDeclListNoTransform()) {
            caller.getIndexOfChild(child);
            return this;
        }
        ASTNode n = this.getParent();
        caller = this;
        child = null;
        while (!(n instanceof Defines_Grammar_env)) {
            child = caller;
            caller = n;
            n = n.getParent();
        }
        return ((Defines_Grammar_env)((Object)n)).Define_Grammar_env(caller, child);
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    public void jastAddGen(File file, String string, String string2, boolean bl) {
        JastAddCodeGen.ajc$interMethod$jastadd_JastAddCodeGen$ast_AST_Grammar$jastAddGen(this, file, string, string2, bl);
    }

    public void weaveInterfaceIntroductions() {
        JastAddCodeGen.ajc$interMethod$jastadd_JastAddCodeGen$ast_AST_Grammar$weaveInterfaceIntroductions(this);
    }
}

