/*
 * Decompiled with CFR 0.152.
 */
package ast.AST;

import ast.AST.ASTDecl;
import ast.AST.ASTNode;
import ast.AST.Ast;
import ast.AST.AstVisitor;
import ast.AST.AttrDecl;
import ast.AST.List;
import ast.AST.Node;
import ast.AST.Parameter;
import jastadd.JastAdd;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;

public class InhDecl
extends AttrDecl
implements Cloneable {
    private String tokenString_Name;
    private String tokenString_Type;
    private boolean tokenboolean_Lazy;
    private String tokenString_FileName;
    private int tokenint_StartLine;
    private int tokenint_EndLine;
    private boolean error_visited = false;

    public InhDecl(int i) {
        super(i);
    }

    public InhDecl(Ast p, int i) {
        this(i);
        this.parser = p;
    }

    public InhDecl() {
        this(0);
        this.setChild(new List(), 0);
        this.getChildNoTransform(0).setParent(this);
    }

    public InhDecl(List p0, String p1, String p2, boolean p3, String p4, int p5, int p6) {
        this.setChild(p0, 0);
        if (p0 != null) {
            p0.setParent(this);
        }
        this.setName(p1);
        this.setType(p2);
        this.setLazy(p3);
        this.setFileName(p4);
        this.setStartLine(p5);
        this.setEndLine(p6);
    }

    public Object clone() throws CloneNotSupportedException {
        InhDecl node = (InhDecl)super.clone();
        node.error_visited = false;
        node.inCircle = false;
        node.isFinal = false;
        return node;
    }

    public ASTNode copy() {
        try {
            InhDecl node = (InhDecl)this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public ASTNode fullCopy() {
        InhDecl res = (InhDecl)this.copy();
        int i = 0;
        while (i < this.getNumChild()) {
            ASTNode node = this.getChildNoTransform(i);
            if (node != null) {
                node = node.fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    public void dumpTree(String indent, PrintStream pStream) {
        pStream.println(String.valueOf(indent) + "InhDecl" + "\"" + this.getName() + "\"" + "\"" + this.getType() + "\"" + "\"" + this.getLazy() + "\"" + "\"" + this.getFileName() + "\"" + "\"" + this.getStartLine() + "\"" + "\"" + this.getEndLine() + "\"");
        String childIndent = String.valueOf(indent) + "  ";
        int i = 0;
        while (i < this.getNumChild()) {
            this.getChild(i).dumpTree(childIndent, pStream);
            ++i;
        }
    }

    public Object jjtAccept(AstVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void jjtAddChild(Node n, int i) {
        this.checkChild(n, i);
        super.jjtAddChild(n, i);
    }

    public void checkChild(Node n, int i) {
        if (i == 0) {
            if (!(n instanceof List)) {
                throw new Error("Child number 0 of AttrDecl has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            int k = 0;
            while (k < ((List)n).getNumChild()) {
                if (!(((List)n).getChildNoTransform(k) instanceof Parameter)) {
                    throw new Error("Child number " + k + " in ParameterList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of Parameter");
                }
                ++k;
            }
        }
    }

    public int getNumChild() {
        return 1;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void setParameterList(List list) {
        this.setChild(list, 0);
        if (list != null) {
            list.setParent(this);
        }
    }

    public int getNumParameter() {
        return this.getParameterList().getNumChild();
    }

    public Parameter getParameter(int i) {
        return (Parameter)this.getParameterList().getChild(i);
    }

    public void addParameter(Parameter node) {
        List list = this.getParameterList();
        list.setChild(node, list.getNumChild());
        if (node != null) {
            node.setParent(list);
        }
    }

    public void setParameter(Parameter node, int i) {
        List list = this.getParameterList();
        list.setChild(node, i);
        if (node != null) {
            node.setParent(list);
        }
    }

    public List getParameterList() {
        return (List)this.getChild(0);
    }

    public List getParameterListNoTransform() {
        return (List)this.getChildNoTransform(0);
    }

    public void setName(String value) {
        this.tokenString_Name = value;
    }

    public String getName() {
        return this.tokenString_Name;
    }

    public void setType(String value) {
        this.tokenString_Type = value;
    }

    public String getType() {
        return this.tokenString_Type;
    }

    public void setLazy(boolean value) {
        this.tokenboolean_Lazy = value;
    }

    public boolean getLazy() {
        return this.tokenboolean_Lazy;
    }

    public void setFileName(String value) {
        this.tokenString_FileName = value;
    }

    public String getFileName() {
        return this.tokenString_FileName;
    }

    public void setStartLine(int value) {
        this.tokenint_StartLine = value;
    }

    public int getStartLine() {
        return this.tokenint_StartLine;
    }

    public void setEndLine(int value) {
        this.tokenint_EndLine = value;
    }

    public int getEndLine() {
        return this.tokenint_EndLine;
    }

    public String callCompute() {
        if (this.getLazy() && this.getNumParameter() == 0) {
            return "        #NAME#_value = getParent().Define_#TYPE#_#METHODNAME#(" + this.interfaceParametersStart() + ");\n";
        }
        return "        #TYPE# #NAME#_value = getParent().Define_#TYPE#_#METHODNAME#(" + this.interfaceParametersStart() + ");\n";
    }

    public String circularComputeCall() {
        return "getParent().Define_#TYPE#_#METHODNAME#(" + this.interfaceParametersStart() + ")";
    }

    public String error() {
        if (this.error_visited) {
            System.out.println("Circular definition of attr: error in class: " + this.getClass().getName());
        }
        this.error_visited = true;
        String error_value = this.error_compute();
        this.error_visited = false;
        return error_value;
    }

    private String error_compute() {
        StringBuffer result = new StringBuffer();
        if (!JastAdd.noInhEqCheck) {
            if (this.hostClass().lookupInhDecl(this.signature()) != this) {
                result.append(String.valueOf(this.getFileName()) + ":" + this.getStartLine() + " ");
                result.append("Multiple declaration of attribute " + this.name() + " in class " + this.hostClass().name() + "\n");
            } else {
                HashSet set = new HashSet();
                Iterator iter = this.hostClass().fathers().iterator();
                while (iter.hasNext()) {
                    ASTDecl father = (ASTDecl)iter.next();
                    if (father.hasInhEqFor(this.hostClass(), this.signature(), set)) continue;
                    result.append(String.valueOf(this.getFileName()) + ":" + this.getStartLine() + " ");
                    result.append("Missing inherited equation for attribute " + this.name() + " in class " + this.hostClass().name() + " when being child of " + father.name() + "\n");
                    System.out.println(String.valueOf(father.name()) + "->" + this.hostClass().name());
                    System.out.print(String.valueOf(this.getFileName()) + ":" + this.getStartLine() + " ");
                    System.out.print("Missing inherited equation for attribute " + this.name() + " in class " + this.hostClass().name() + " when being child of " + father.name() + "\n");
                }
            }
        }
        return result.toString();
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

