/*
 * Decompiled with CFR 0.152.
 */
package ast.AST;

import ast.AST.ASTNode;
import ast.AST.Ast;
import ast.AST.AstVisitor;
import ast.AST.AttrDecl;
import ast.AST.AttrEq;
import ast.AST.Components;
import ast.AST.List;
import ast.AST.ListComponents;
import ast.AST.Node;
import ast.AST.Opt;
import ast.AST.Parameter;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;

public class InhEq
extends AttrEq
implements Cloneable {
    private String tokenString_Name;
    private String tokenString_FileName;
    private int tokenint_StartLine;
    private int tokenint_EndLine;
    private Components tokenComponents_Components;
    private boolean decl_visited = false;
    private boolean decl_computed = false;
    private AttrDecl decl_value;
    private boolean error_visited = false;

    public InhEq(int i) {
        super(i);
    }

    public InhEq(Ast p, int i) {
        this(i);
        this.parser = p;
    }

    public InhEq() {
        this(0);
        this.setChild(new List(), 0);
        this.getChildNoTransform(0).setParent(this);
        this.setChild(new Opt(), 1);
        this.getChildNoTransform(1).setParent(this);
    }

    public InhEq(List p0, String p1, String p2, int p3, int p4, Components p5, Opt p6) {
        this.setChild(p0, 0);
        if (p0 != null) {
            p0.setParent(this);
        }
        this.setName(p1);
        this.setFileName(p2);
        this.setStartLine(p3);
        this.setEndLine(p4);
        this.setComponents(p5);
        this.setChild(p6, 1);
        if (p6 != null) {
            p6.setParent(this);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        InhEq node = (InhEq)super.clone();
        node.decl_visited = false;
        node.decl_computed = false;
        node.error_visited = false;
        node.inCircle = false;
        node.isFinal = false;
        return node;
    }

    public ASTNode copy() {
        try {
            InhEq node = (InhEq)this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public ASTNode fullCopy() {
        InhEq res = (InhEq)this.copy();
        int i = 0;
        while (i < this.getNumChild()) {
            ASTNode node = this.getChildNoTransform(i);
            if (node != null) {
                node = node.fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    public void dumpTree(String indent, PrintStream pStream) {
        pStream.println(String.valueOf(indent) + "InhEq" + "\"" + this.getName() + "\"" + "\"" + this.getFileName() + "\"" + "\"" + this.getStartLine() + "\"" + "\"" + this.getEndLine() + "\"" + "\"" + this.getComponents() + "\"");
        String childIndent = String.valueOf(indent) + "  ";
        int i = 0;
        while (i < this.getNumChild()) {
            this.getChild(i).dumpTree(childIndent, pStream);
            ++i;
        }
    }

    public Object jjtAccept(AstVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void jjtAddChild(Node n, int i) {
        this.checkChild(n, i);
        super.jjtAddChild(n, i);
    }

    public void checkChild(Node n, int i) {
        if (i == 0) {
            if (!(n instanceof List)) {
                throw new Error("Child number 0 of InhEq has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            int k = 0;
            while (k < ((List)n).getNumChild()) {
                if (!(((List)n).getChildNoTransform(k) instanceof Parameter)) {
                    throw new Error("Child number " + k + " in ParameterList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of Parameter");
                }
                ++k;
            }
        }
        if (i == 1) {
            if (!(n instanceof Opt)) {
                throw new Error("Child number 1 of InhEq has the type " + n.getClass().getName() + " which is not an instance of Opt");
            }
            if (((Opt)n).getNumChild() != 0 && !(((Opt)n).getChildNoTransform(0) instanceof Parameter)) {
                throw new Error("Optional Index has the type " + ((Opt)n).getChildNoTransform(0).getClass().getName() + " which is not an instance of Parameter");
            }
        }
    }

    public int getNumChild() {
        return 2;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void setParameterList(List list) {
        this.setChild(list, 0);
        if (list != null) {
            list.setParent(this);
        }
    }

    public int getNumParameter() {
        return this.getParameterList().getNumChild();
    }

    public Parameter getParameter(int i) {
        return (Parameter)this.getParameterList().getChild(i);
    }

    public void addParameter(Parameter node) {
        List list = this.getParameterList();
        list.setChild(node, list.getNumChild());
        if (node != null) {
            node.setParent(list);
        }
    }

    public void setParameter(Parameter node, int i) {
        List list = this.getParameterList();
        list.setChild(node, i);
        if (node != null) {
            node.setParent(list);
        }
    }

    public List getParameterList() {
        return (List)this.getChild(0);
    }

    public List getParameterListNoTransform() {
        return (List)this.getChildNoTransform(0);
    }

    public void setName(String value) {
        this.tokenString_Name = value;
    }

    public String getName() {
        return this.tokenString_Name;
    }

    public void setFileName(String value) {
        this.tokenString_FileName = value;
    }

    public String getFileName() {
        return this.tokenString_FileName;
    }

    public void setStartLine(int value) {
        this.tokenint_StartLine = value;
    }

    public int getStartLine() {
        return this.tokenint_StartLine;
    }

    public void setEndLine(int value) {
        this.tokenint_EndLine = value;
    }

    public int getEndLine() {
        return this.tokenint_EndLine;
    }

    public void setComponents(Components value) {
        this.tokenComponents_Components = value;
    }

    public Components getComponents() {
        return this.tokenComponents_Components;
    }

    public void setIndexOpt(Opt opt) {
        this.setChild(opt, 1);
        if (opt != null) {
            opt.setParent(this);
        }
    }

    public boolean hasIndex() {
        return this.getIndexOpt().getNumChild() != 0;
    }

    public Parameter getIndex() {
        return (Parameter)this.getIndexOpt().getChild(0);
    }

    public void setIndex(Parameter node) {
        this.getIndexOpt().setChild(node, 0);
        if (node != null) {
            node.setParent(this.getIndexOpt());
        }
    }

    public Opt getIndexOpt() {
        return (Opt)this.getChild(1);
    }

    public Opt getIndexOptNoTransform() {
        return (Opt)this.getChildNoTransform(1);
    }

    public AttrDecl decl() {
        if (this.decl_computed) {
            return this.decl_value;
        }
        if (this.decl_visited) {
            System.out.println("Circular definition of attr: decl in class: " + this.getClass().getName());
        }
        this.decl_visited = true;
        int num = ASTNode.boundariesCrossed;
        boolean isFinal = this.isFinal;
        this.decl_value = this.decl_compute();
        if (isFinal && num == ASTNode.boundariesCrossed) {
            this.decl_computed = true;
        }
        this.decl_visited = false;
        return this.decl_value;
    }

    private AttrDecl decl_compute() {
        return this.hostClass().getInhDeclFor(this.signature(), new HashSet());
    }

    public String error() {
        if (this.error_visited) {
            System.out.println("Circular definition of attr: error in class: " + this.getClass().getName());
        }
        this.error_visited = true;
        String error_value = this.error_compute();
        this.error_visited = false;
        return error_value;
    }

    private String error_compute() {
        StringBuffer result = new StringBuffer();
        if (this.hostClass().lookupComponents(this.getComponents().name()) == null) {
            result.append(String.valueOf(this.getFileName()) + ":" + this.getStartLine() + " ");
            result.append("Inherited equation for unknown son " + this.getComponents().name() + " in class " + this.hostClass().name() + "\n");
            Iterator iter = this.hostClass().getComponents();
            while (iter.hasNext()) {
                Components c = (Components)iter.next();
                result.append(String.valueOf(c.type()) + " " + c.name() + "\n");
            }
        } else {
            InhEq equation = this.hostClass().lookupInhEq(this.signature(), this.getComponents().name());
            if (equation != null && equation != this) {
                result.append(String.valueOf(this.getFileName()) + ":" + this.getStartLine() + " ");
                result.append("Multiple equation for inherited attribute " + this.getComponents().name() + "." + this.name() + " in class " + this.hostClass().name());
                result.append(" and " + equation.name() + " in class " + equation.hostClass().name() + " in " + equation.getFileName() + ":" + equation.getStartLine() + "\n");
            } else if (this.hasIndex() && !(this.getComponents() instanceof ListComponents)) {
                result.append(String.valueOf(this.getFileName()) + ":" + this.getStartLine() + " ");
                result.append("May not supply index for non list child " + this.getComponents().name() + " in class " + this.hostClass().name() + "\n");
            }
        }
        return result.toString();
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

