/*
 * Decompiled with CFR 0.152.
 */
package ast.AST;

import ast.AST.ASTNode;
import ast.AST.Ast;
import ast.AST.AstVisitor;
import ast.AST.Node;
import java.io.PrintStream;

public class List
extends ASTNode
implements Cloneable {
    public List(int i) {
        super(i);
    }

    public List(Ast p, int i) {
        this(i);
        this.parser = p;
    }

    public List() {
        this(0);
    }

    public Object clone() throws CloneNotSupportedException {
        List node = (List)super.clone();
        node.inCircle = false;
        node.isFinal = false;
        return node;
    }

    public ASTNode copy() {
        try {
            List node = (List)this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public ASTNode fullCopy() {
        List res = (List)this.copy();
        int i = 0;
        while (i < this.getNumChild()) {
            ASTNode node = this.getChildNoTransform(i);
            if (node != null) {
                node = node.fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    public void dumpTree(String indent, PrintStream pStream) {
        pStream.println(String.valueOf(indent) + "List");
        String childIndent = String.valueOf(indent) + "  ";
        int i = 0;
        while (i < this.getNumChild()) {
            this.getChild(i).dumpTree(childIndent, pStream);
            ++i;
        }
    }

    public Object jjtAccept(AstVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void jjtAddChild(Node n, int i) {
        this.checkChild(n, i);
        super.jjtAddChild(n, i);
    }

    public void checkChild(Node n, int i) {
        if (!(n instanceof ASTNode)) {
            throw new Error("The node type of child " + i + " must be an instance of ASTNode");
        }
    }

    public List add(ASTNode node) {
        this.addChild(node);
        return this;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

