/*
 * Decompiled with CFR 0.152.
 */
package ast.AST;

import ast.AST.ASTNode;
import ast.AST.Ast;
import ast.AST.AstVisitor;
import ast.AST.Components;
import ast.AST.Id;
import ast.AST.Node;
import java.io.PrintStream;

public class ListComponents
extends Components
implements Cloneable {
    private boolean name_visited = false;
    private boolean type_visited = false;
    private boolean constrParmType_visited = false;

    public ListComponents(int i) {
        super(i);
    }

    public ListComponents(Ast p, int i) {
        this(i);
        this.parser = p;
    }

    public ListComponents() {
        this(0);
        this.setChild(null, 0);
    }

    public ListComponents(Id p0) {
        this.setChild(p0, 0);
        if (p0 != null) {
            p0.setParent(this);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ListComponents node = (ListComponents)super.clone();
        node.name_visited = false;
        node.type_visited = false;
        node.constrParmType_visited = false;
        node.inCircle = false;
        node.isFinal = false;
        return node;
    }

    public ASTNode copy() {
        try {
            ListComponents node = (ListComponents)this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public ASTNode fullCopy() {
        ListComponents res = (ListComponents)this.copy();
        int i = 0;
        while (i < this.getNumChild()) {
            ASTNode node = this.getChildNoTransform(i);
            if (node != null) {
                node = node.fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    public void dumpTree(String indent, PrintStream pStream) {
        pStream.println(String.valueOf(indent) + "ListComponents");
        String childIndent = String.valueOf(indent) + "  ";
        int i = 0;
        while (i < this.getNumChild()) {
            this.getChild(i).dumpTree(childIndent, pStream);
            ++i;
        }
    }

    public Object jjtAccept(AstVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void jjtAddChild(Node n, int i) {
        this.checkChild(n, i);
        super.jjtAddChild(n, i);
    }

    public void checkChild(Node n, int i) {
        if (i == 0 && !(n instanceof Id)) {
            throw new Error("Child number 0 of ListComponents has the type " + n.getClass().getName() + " which is not an instance of Id");
        }
    }

    public int getNumChild() {
        return 1;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void setId(Id node) {
        this.setChild(node, 0);
        if (node != null) {
            node.setParent(this);
        }
    }

    public Id getId() {
        return (Id)this.getChild(0);
    }

    public Id getIdNoTransform() {
        return (Id)this.getChildNoTransform(0);
    }

    public void jjtGenCheckTreeStructure(PrintStream stream, int j) {
        stream.println("  if(i == " + j + ") {");
        stream.println("    if(!(n instanceof List)) throw new Error(\"Child number " + j + " of " + this.hostClass().name() + " has the type \" + n.getClass().getName() + \" which is not an instance of List\");");
        stream.println("    for(int k = 0; k < ((List)n).getNumChild(); k++)");
        stream.println("      if(!(((List)n).getChildNoTransform(k) instanceof " + this.type() + "))" + " throw new Error(\"Child number \" + k + \" in " + this.name() + "List" + " has the type \" + ((List)n).getChildNoTransform(k).getClass().getName() + \" which is not an instance of " + this.type() + "\");");
        stream.println("  }");
    }

    public void jaddGen(PrintStream stream, int index, boolean publicModifier) {
        String s = "    // Declared in " + this.hostClass().getFileName() + " line " + this.hostClass().getStartLine() + "\n" + "    public void set#NAME#List(List list) {\n" + "        setChild(list, #INDEX#);\n" + "    }\n\n" + "    public int getNum#NAME#() {\n" + "        return get#NAME#List().getNumChild();\n" + "    }\n\n" + "    public #TYPE# get#NAME#(int i) {\n" + "        return (#TYPE#)get#NAME#List().getChild(i);\n" + "    }\n\n" + "    public void add#NAME#(#TYPE# node) {\n" + "        List list = get#NAME#List();\n" + "        list.setChild(node, list.getNumChild());\n" + "    }\n\n" + "    public void set#NAME#(#TYPE# node, int i) {\n" + "        List list = get#NAME#List();\n" + "        list.setChild(node, i);\n" + "    }\n";
        s = !this.isNTA() ? String.valueOf(s) + "    public List get#NAME#List() {\n" + "        return (List)getChild(#INDEX#);\n" + "    }\n\n" + "    public List get#NAME#ListNoTransform() {\n" + "        return (List)getChildNoTransform(#INDEX#);\n" + "    }\n\n" : String.valueOf(s) + "    public List get#NAME#ListNoTransform() {\n" + "        return (List)getChildNoTransform(#INDEX#);\n" + "    }\n\n";
        s = s.replaceAll("#TYPE#", this.getId().type());
        s = s.replaceAll("#NAME#", this.getId().name());
        s = s.replaceAll("#INDEX#", String.valueOf(index));
        if (!publicModifier) {
            s = s.replaceAll("    public ", "    private ");
        }
        stream.println(s);
    }

    public String name() {
        if (this.name_visited) {
            System.out.println("Circular definition of attr: name in class: " + this.getClass().getName());
        }
        this.name_visited = true;
        String name_value = this.name_compute();
        this.name_visited = false;
        return name_value;
    }

    private String name_compute() {
        return this.getId().name();
    }

    public String type() {
        if (this.type_visited) {
            System.out.println("Circular definition of attr: type in class: " + this.getClass().getName());
        }
        this.type_visited = true;
        String type_value = this.type_compute();
        this.type_visited = false;
        return type_value;
    }

    private String type_compute() {
        return this.getId().type();
    }

    public String constrParmType() {
        if (this.constrParmType_visited) {
            System.out.println("Circular definition of attr: constrParmType in class: " + this.getClass().getName());
        }
        this.constrParmType_visited = true;
        String constrParmType_value = this.constrParmType_compute();
        this.constrParmType_visited = false;
        return constrParmType_value;
    }

    private String constrParmType_compute() {
        return "List";
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

