/*
 * Decompiled with CFR 0.152.
 */
package ast.AST;

import ast.AST.ASTNode;
import ast.AST.AggregateComponentsNTA;
import ast.AST.Ast;
import ast.AST.AstVisitor;
import ast.AST.AttrDecl;
import ast.AST.Components;
import ast.AST.List;
import ast.AST.ListComponentsNTA;
import ast.AST.Node;
import ast.AST.OptionalComponentNTA;
import ast.AST.Parameter;
import ast.AST.TokenComponentNTA;
import java.io.PrintStream;

public class SynDecl
extends AttrDecl
implements Cloneable {
    private String tokenString_Name;
    private String tokenString_Type;
    private boolean tokenboolean_Lazy;
    private String tokenString_FileName;
    private int tokenint_StartLine;
    private int tokenint_EndLine;
    private boolean error_visited = false;

    public SynDecl(int i) {
        super(i);
    }

    public SynDecl(Ast p, int i) {
        this(i);
        this.parser = p;
    }

    public SynDecl() {
        this(0);
        this.setChild(new List(), 0);
        this.getChildNoTransform(0).setParent(this);
    }

    public SynDecl(List p0, String p1, String p2, boolean p3, String p4, int p5, int p6) {
        this.setChild(p0, 0);
        if (p0 != null) {
            p0.setParent(this);
        }
        this.setName(p1);
        this.setType(p2);
        this.setLazy(p3);
        this.setFileName(p4);
        this.setStartLine(p5);
        this.setEndLine(p6);
    }

    public Object clone() throws CloneNotSupportedException {
        SynDecl node = (SynDecl)super.clone();
        node.error_visited = false;
        node.inCircle = false;
        node.isFinal = false;
        return node;
    }

    public ASTNode copy() {
        try {
            SynDecl node = (SynDecl)this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public ASTNode fullCopy() {
        SynDecl res = (SynDecl)this.copy();
        int i = 0;
        while (i < this.getNumChild()) {
            ASTNode node = this.getChildNoTransform(i);
            if (node != null) {
                node = node.fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    public void dumpTree(String indent, PrintStream pStream) {
        pStream.println(String.valueOf(indent) + "SynDecl" + "\"" + this.getName() + "\"" + "\"" + this.getType() + "\"" + "\"" + this.getLazy() + "\"" + "\"" + this.getFileName() + "\"" + "\"" + this.getStartLine() + "\"" + "\"" + this.getEndLine() + "\"");
        String childIndent = String.valueOf(indent) + "  ";
        int i = 0;
        while (i < this.getNumChild()) {
            this.getChild(i).dumpTree(childIndent, pStream);
            ++i;
        }
    }

    public Object jjtAccept(AstVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void jjtAddChild(Node n, int i) {
        this.checkChild(n, i);
        super.jjtAddChild(n, i);
    }

    public void checkChild(Node n, int i) {
        if (i == 0) {
            if (!(n instanceof List)) {
                throw new Error("Child number 0 of AttrDecl has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            int k = 0;
            while (k < ((List)n).getNumChild()) {
                if (!(((List)n).getChildNoTransform(k) instanceof Parameter)) {
                    throw new Error("Child number " + k + " in ParameterList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of Parameter");
                }
                ++k;
            }
        }
    }

    public int getNumChild() {
        return 1;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void setParameterList(List list) {
        this.setChild(list, 0);
        if (list != null) {
            list.setParent(this);
        }
    }

    public int getNumParameter() {
        return this.getParameterList().getNumChild();
    }

    public Parameter getParameter(int i) {
        return (Parameter)this.getParameterList().getChild(i);
    }

    public void addParameter(Parameter node) {
        List list = this.getParameterList();
        list.setChild(node, list.getNumChild());
        if (node != null) {
            node.setParent(list);
        }
    }

    public void setParameter(Parameter node, int i) {
        List list = this.getParameterList();
        list.setChild(node, i);
        if (node != null) {
            node.setParent(list);
        }
    }

    public List getParameterList() {
        return (List)this.getChild(0);
    }

    public List getParameterListNoTransform() {
        return (List)this.getChildNoTransform(0);
    }

    public void setName(String value) {
        this.tokenString_Name = value;
    }

    public String getName() {
        return this.tokenString_Name;
    }

    public void setType(String value) {
        this.tokenString_Type = value;
    }

    public String getType() {
        return this.tokenString_Type;
    }

    public void setLazy(boolean value) {
        this.tokenboolean_Lazy = value;
    }

    public boolean getLazy() {
        return this.tokenboolean_Lazy;
    }

    public void setFileName(String value) {
        this.tokenString_FileName = value;
    }

    public String getFileName() {
        return this.tokenString_FileName;
    }

    public void setStartLine(int value) {
        this.tokenint_StartLine = value;
    }

    public int getStartLine() {
        return this.tokenint_StartLine;
    }

    public void setEndLine(int value) {
        this.tokenint_EndLine = value;
    }

    public int getEndLine() {
        return this.tokenint_EndLine;
    }

    public String circularComputeCall() {
        return "#METHODNAME#_compute(#PARM#)";
    }

    public boolean isNTA() {
        return this.findCorrespondingNTA() != null;
    }

    public String higherOrderAttributeCode() {
        StringBuffer result = new StringBuffer();
        Components comp = this.findCorrespondingNTA();
        if (comp != null) {
            String attrName = this.getName().substring(3);
            if (comp.name().equals(attrName) && (comp instanceof OptionalComponentNTA || comp instanceof TokenComponentNTA || comp instanceof AggregateComponentsNTA)) {
                result.append("            set" + attrName + "(#NAME#_value);\n");
            }
            if (attrName.equals(String.valueOf(comp.name()) + "Opt") && comp instanceof OptionalComponentNTA) {
                result.append("        set" + attrName + "(#NAME#_value);\n");
            }
            if (attrName.equals(String.valueOf(comp.name()) + "List") && comp instanceof ListComponentsNTA) {
                result.append("        set" + attrName + "(#NAME#_value);\n");
            }
        }
        return result.toString();
    }

    public String error() {
        if (this.error_visited) {
            System.out.println("Circular definition of attr: error in class: " + this.getClass().getName());
        }
        this.error_visited = true;
        String error_value = this.error_compute();
        this.error_visited = false;
        return error_value;
    }

    private String error_compute() {
        StringBuffer result = new StringBuffer();
        SynDecl decl = this.hostClass().lookupSynDecl(this.signature());
        if (decl != null && decl != this) {
            result.append(String.valueOf(this.getFileName()) + ":" + this.getStartLine() + " ");
            result.append("Multiple declaration of attribute " + this.name() + " in class " + this.hostClass().name());
            result.append(" and " + decl.name() + " in class " + decl.hostClass().name() + " in " + decl.getFileName() + ":" + decl.getStartLine() + "\n");
        } else {
            StringBuffer r = new StringBuffer();
            this.hostClass().checkSynEqs(this.signature(), r);
            if (r.length() != 0) {
                result.append(String.valueOf(this.getFileName()) + ":" + this.getStartLine() + " ");
                result.append("Syn eq for " + this.name() + " missing in the following classes:");
                result.append(r.toString());
                result.append("\n");
            }
        }
        return result.toString();
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

