/*
 * Decompiled with CFR 0.152.
 */
package ast.AST;

import ast.AST.ASTNode;
import ast.AST.Ast;
import ast.AST.AstVisitor;
import ast.AST.AttrDecl;
import ast.AST.AttrEq;
import ast.AST.List;
import ast.AST.Node;
import ast.AST.Parameter;
import java.io.PrintStream;
import jrag.AST.ASTBlock;
import jrag.Unparse;

public class SynEq
extends AttrEq
implements Cloneable {
    private String tokenString_Name;
    private String tokenString_FileName;
    private int tokenint_StartLine;
    private int tokenint_EndLine;
    private boolean decl_visited = false;
    private boolean decl_computed = false;
    private AttrDecl decl_value;
    private boolean error_visited = false;

    public SynEq(int i) {
        super(i);
    }

    public SynEq(Ast p, int i) {
        this(i);
        this.parser = p;
    }

    public SynEq() {
        this(0);
        this.setChild(new List(), 0);
        this.getChildNoTransform(0).setParent(this);
    }

    public SynEq(List p0, String p1, String p2, int p3, int p4) {
        this.setChild(p0, 0);
        if (p0 != null) {
            p0.setParent(this);
        }
        this.setName(p1);
        this.setFileName(p2);
        this.setStartLine(p3);
        this.setEndLine(p4);
    }

    public Object clone() throws CloneNotSupportedException {
        SynEq node = (SynEq)super.clone();
        node.decl_visited = false;
        node.decl_computed = false;
        node.error_visited = false;
        node.inCircle = false;
        node.isFinal = false;
        return node;
    }

    public ASTNode copy() {
        try {
            SynEq node = (SynEq)this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public ASTNode fullCopy() {
        SynEq res = (SynEq)this.copy();
        int i = 0;
        while (i < this.getNumChild()) {
            ASTNode node = this.getChildNoTransform(i);
            if (node != null) {
                node = node.fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    public void dumpTree(String indent, PrintStream pStream) {
        pStream.println(String.valueOf(indent) + "SynEq" + "\"" + this.getName() + "\"" + "\"" + this.getFileName() + "\"" + "\"" + this.getStartLine() + "\"" + "\"" + this.getEndLine() + "\"");
        String childIndent = String.valueOf(indent) + "  ";
        int i = 0;
        while (i < this.getNumChild()) {
            this.getChild(i).dumpTree(childIndent, pStream);
            ++i;
        }
    }

    public Object jjtAccept(AstVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void jjtAddChild(Node n, int i) {
        this.checkChild(n, i);
        super.jjtAddChild(n, i);
    }

    public void checkChild(Node n, int i) {
        if (i == 0) {
            if (!(n instanceof List)) {
                throw new Error("Child number 0 of SynEq has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            int k = 0;
            while (k < ((List)n).getNumChild()) {
                if (!(((List)n).getChildNoTransform(k) instanceof Parameter)) {
                    throw new Error("Child number " + k + " in ParameterList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of Parameter");
                }
                ++k;
            }
        }
    }

    public int getNumChild() {
        return 1;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void setParameterList(List list) {
        this.setChild(list, 0);
        if (list != null) {
            list.setParent(this);
        }
    }

    public int getNumParameter() {
        return this.getParameterList().getNumChild();
    }

    public Parameter getParameter(int i) {
        return (Parameter)this.getParameterList().getChild(i);
    }

    public void addParameter(Parameter node) {
        List list = this.getParameterList();
        list.setChild(node, list.getNumChild());
        if (node != null) {
            node.setParent(list);
        }
    }

    public void setParameter(Parameter node, int i) {
        List list = this.getParameterList();
        list.setChild(node, i);
        if (node != null) {
            node.setParent(list);
        }
    }

    public List getParameterList() {
        return (List)this.getChild(0);
    }

    public List getParameterListNoTransform() {
        return (List)this.getChildNoTransform(0);
    }

    public void setName(String value) {
        this.tokenString_Name = value;
    }

    public String getName() {
        return this.tokenString_Name;
    }

    public void setFileName(String value) {
        this.tokenString_FileName = value;
    }

    public String getFileName() {
        return this.tokenString_FileName;
    }

    public void setStartLine(int value) {
        this.tokenint_StartLine = value;
    }

    public int getStartLine() {
        return this.tokenint_StartLine;
    }

    public void setEndLine(int value) {
        this.tokenint_EndLine = value;
    }

    public int getEndLine() {
        return this.tokenint_EndLine;
    }

    public String computeMethod() {
        if (this.getRHS() instanceof ASTBlock) {
            return "    private #TYPE# #CLASS#.#METHODNAME#_compute(#PARMDECL#) " + Unparse.ajc$interMethodDispatch1$jrag_Unparse$jrag_AST_SimpleNode$unparse(this.getRHS()) + "\n\n";
        }
        return "    private #TYPE# #CLASS#.#METHODNAME#_compute(#PARMDECL#) {  return " + Unparse.ajc$interMethodDispatch1$jrag_Unparse$jrag_AST_SimpleNode$unparse(this.getRHS()) + ";  }\n\n";
    }

    public AttrDecl decl() {
        if (this.decl_computed) {
            return this.decl_value;
        }
        if (this.decl_visited) {
            System.out.println("Circular definition of attr: decl in class: " + this.getClass().getName());
        }
        this.decl_visited = true;
        int num = ASTNode.boundariesCrossed;
        boolean isFinal = this.isFinal;
        this.decl_value = this.decl_compute();
        if (isFinal && num == ASTNode.boundariesCrossed) {
            this.decl_computed = true;
        }
        this.decl_visited = false;
        return this.decl_value;
    }

    private AttrDecl decl_compute() {
        return this.hostClass().lookupSynDecl(this.signature());
    }

    public String error() {
        if (this.error_visited) {
            System.out.println("Circular definition of attr: error in class: " + this.getClass().getName());
        }
        this.error_visited = true;
        String error_value = this.error_compute();
        this.error_visited = false;
        return error_value;
    }

    private String error_compute() {
        StringBuffer result = new StringBuffer();
        if (this.hostClass().lookupSynDecl(this.signature()) == null) {
            result.append(String.valueOf(this.getFileName()) + ":" + this.getStartLine() + " ");
            result.append("Synthesized attribute " + this.name() + " assigned in class " + this.hostClass().name() + " is not declared\n");
        } else {
            SynEq equation = this.hostClass().lookupSynEq(this.signature());
            if (equation != null && equation != this) {
                result.append(String.valueOf(this.getFileName()) + ":" + this.getStartLine() + " ");
                result.append("Multiple equations for synthesized attribute " + this.name() + " in class " + this.hostClass().name());
                result.append(" and " + equation.name() + " in class " + equation.hostClass().name() + " in " + equation.getFileName() + ":" + equation.getStartLine() + "\n");
            }
        }
        return result.toString();
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

