/*
 * Decompiled with CFR 0.152.
 */
package ast.AST;

import ast.AST.ASTNode;
import ast.AST.Ast;
import ast.AST.AstVisitor;
import ast.AST.Components;
import ast.AST.Node;
import ast.AST.TokenId;
import java.io.PrintStream;

public class TokenComponent
extends Components
implements Cloneable {
    private boolean name_visited = false;
    private boolean type_visited = false;
    private boolean constrParmType_visited = false;

    public TokenComponent(int i) {
        super(i);
    }

    public TokenComponent(Ast p, int i) {
        this(i);
        this.parser = p;
    }

    public TokenComponent() {
        this(0);
        this.setChild(null, 0);
    }

    public TokenComponent(TokenId p0) {
        this.setChild(p0, 0);
        if (p0 != null) {
            p0.setParent(this);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        TokenComponent node = (TokenComponent)super.clone();
        node.name_visited = false;
        node.type_visited = false;
        node.constrParmType_visited = false;
        node.inCircle = false;
        node.isFinal = false;
        return node;
    }

    public ASTNode copy() {
        try {
            TokenComponent node = (TokenComponent)this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public ASTNode fullCopy() {
        TokenComponent res = (TokenComponent)this.copy();
        int i = 0;
        while (i < this.getNumChild()) {
            ASTNode node = this.getChildNoTransform(i);
            if (node != null) {
                node = node.fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    public void dumpTree(String indent, PrintStream pStream) {
        pStream.println(String.valueOf(indent) + "TokenComponent");
        String childIndent = String.valueOf(indent) + "  ";
        int i = 0;
        while (i < this.getNumChild()) {
            this.getChild(i).dumpTree(childIndent, pStream);
            ++i;
        }
    }

    public Object jjtAccept(AstVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void jjtAddChild(Node n, int i) {
        this.checkChild(n, i);
        super.jjtAddChild(n, i);
    }

    public void checkChild(Node n, int i) {
        if (i == 0 && !(n instanceof TokenId)) {
            throw new Error("Child number 0 of TokenComponent has the type " + n.getClass().getName() + " which is not an instance of TokenId");
        }
    }

    public int getNumChild() {
        return 1;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void setTokenId(TokenId node) {
        this.setChild(node, 0);
        if (node != null) {
            node.setParent(this);
        }
    }

    public TokenId getTokenId() {
        return (TokenId)this.getChild(0);
    }

    public TokenId getTokenIdNoTransform() {
        return (TokenId)this.getChildNoTransform(0);
    }

    public void jaddGen(PrintStream stream, int index, boolean publicModifier) {
        String s = "    // Declared in " + this.hostClass().getFileName() + " line " + this.hostClass().getStartLine() + "\n" + "    private #TYPE# token#TYPE#_#ID#;\n" + "    public void set#ID#(#TYPE# value) {\n" + "        token#TYPE#_#ID# = value;\n" + "    }\n";
        if (!this.isNTA()) {
            s = String.valueOf(s) + "    public #TYPE# get#ID#() {\n" + "        return token#TYPE#_#ID#;\n" + "    }\n\n";
        }
        s = s.replaceAll("#ID#", this.getTokenId().getID());
        s = s.replaceAll("#TYPE#", this.getTokenId().getTYPE());
        if (!publicModifier) {
            s = s.replaceAll("    public ", "    private ");
        }
        stream.println(s);
    }

    public boolean declared() {
        return true;
    }

    public String name() {
        if (this.name_visited) {
            System.out.println("Circular definition of attr: name in class: " + this.getClass().getName());
        }
        this.name_visited = true;
        String name_value = this.name_compute();
        this.name_visited = false;
        return name_value;
    }

    private String name_compute() {
        return this.getTokenId().name();
    }

    public String type() {
        if (this.type_visited) {
            System.out.println("Circular definition of attr: type in class: " + this.getClass().getName());
        }
        this.type_visited = true;
        String type_value = this.type_compute();
        this.type_visited = false;
        return type_value;
    }

    private String type_compute() {
        return this.getTokenId().type();
    }

    public String constrParmType() {
        if (this.constrParmType_visited) {
            System.out.println("Circular definition of attr: constrParmType in class: " + this.getClass().getName());
        }
        this.constrParmType_visited = true;
        String constrParmType_value = this.constrParmType_compute();
        this.constrParmType_visited = false;
        return constrParmType_value;
    }

    private String constrParmType_compute() {
        return this.getTokenId().getTYPE();
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

