/*
 * Decompiled with CFR 0.152.
 */
package jastadd;

import ast.AST.ASTNode;
import ast.AST.Ast;
import ast.AST.Grammar;
import ast.AST.ParseException;
import ast.AST.TokenMgrError;
import ast.AST.TypeDecl;
import jastadd.CommandLineArguments;
import jastadd.JastAddCodeGen;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jrag.AST.ASTCompilationUnit;
import jrag.AST.JragParser;

public class JastAdd {
    static final String VERSION = "JastAdd II (http://jastadd.cs.lth.se) version R20060729";
    static final String VERSIONINFO = "\n// Generated with JastAdd II (http://jastadd.cs.lth.se) version R20060729\n\n";
    static List files = new ArrayList();
    static String pack;
    static PrintStream pStream;
    static File outputDir;
    static String grammar;
    static Grammar root;
    public static boolean jjtree;
    public static boolean rewriteEnabled;
    public static boolean beaver;
    public static boolean visitCheckEnabled;
    public static boolean publicModifier;
    public static boolean cacheCycle;
    public static String defaultMap;
    public static String defaultSet;
    public static boolean lazyMaps;
    public static boolean noInhEqCheck;

    public static void main(String[] args) {
        files = new ArrayList();
        jjtree = false;
        rewriteEnabled = false;
        beaver = false;
        visitCheckEnabled = true;
        publicModifier = true;
        cacheCycle = true;
        defaultMap = null;
        defaultSet = null;
        lazyMaps = false;
        noInhEqCheck = false;
        if (JastAdd.readArgs(args)) {
            System.exit(1);
        }
        ASTNode.rewriteEnabled = rewriteEnabled;
        ASTNode.visitCheckEnabled = visitCheckEnabled;
        ASTNode.cacheCycle = cacheCycle;
        if (defaultMap != null) {
            ASTNode.createDefaultMap = defaultMap;
        }
        if (defaultSet != null) {
            ASTNode.createDefaultSet = defaultSet;
        }
        long time = System.currentTimeMillis();
        root = new Grammar();
        root.abstractAncestors();
        ArrayList<String> errors = new ArrayList<String>();
        Iterator iter = files.iterator();
        while (iter.hasNext()) {
            String fileName = (String)iter.next();
            if (!fileName.endsWith(".ast")) continue;
            try {
                Ast parser = new Ast(new FileInputStream(fileName));
                parser.fileName = new File(fileName).getName();
                Grammar g = parser.Grammar();
                int i = 0;
                while (i < g.getNumTypeDecl()) {
                    root.addTypeDecl(g.getTypeDecl(i));
                    ++i;
                }
                Iterator errorIter = parser.getErrors();
                while (errorIter.hasNext()) {
                    String[] s = ((String)errorIter.next()).split(";");
                    errors.add("Syntax error in " + fileName + " at line " + s[0] + ", column " + s[1]);
                }
            }
            catch (TokenMgrError e) {
                System.out.println("Lexical error in " + fileName + ": " + e.getMessage());
                System.exit(1);
            }
            catch (ParseException parseException) {
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("File error: Abstract syntax grammar file " + fileName + " not found");
                System.exit(1);
            }
        }
        if (!errors.isEmpty()) {
            iter = errors.iterator();
            while (iter.hasNext()) {
                System.out.println(iter.next());
            }
            System.exit(1);
        }
        long astParseTime = System.currentTimeMillis() - time;
        String astErrors = root.astErrors();
        long astErrorTime = System.currentTimeMillis() - time - astParseTime;
        if (!astErrors.equals("")) {
            System.out.println("Semantic error:");
            System.out.println(astErrors);
            System.exit(1);
        }
        Iterator iter2 = files.iterator();
        while (iter2.hasNext()) {
            String fileName = (String)iter2.next();
            if (!fileName.endsWith(".jrag") && !fileName.endsWith(".jadd")) continue;
            try {
                FileInputStream inputStream = new FileInputStream(fileName);
                JragParser jp = new JragParser(inputStream);
                jp.inputStream = inputStream;
                jp.root = root;
                jp.setFileName(new File(fileName).getName());
                ASTCompilationUnit au = jp.CompilationUnit();
                root.addCompUnit(au);
            }
            catch (jrag.AST.ParseException e) {
                StringBuffer msg = new StringBuffer();
                msg.append("Syntax error in " + fileName + " at line " + e.currentToken.next.beginLine + ", column " + e.currentToken.next.beginColumn);
                System.out.println(msg.toString());
                System.exit(1);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("File error: Aspect file " + fileName + " not found");
                System.exit(1);
            }
        }
        long jragParseTime = System.currentTimeMillis() - time - astErrorTime;
        int i = 0;
        while (i < root.getNumTypeDecl()) {
            TypeDecl typeDecl = root.getTypeDecl(i);
            typeDecl.processRefinedClassBodyDecls();
            typeDecl.processRefinedSynEqs();
            typeDecl.processRefinedInhEqs();
            ++i;
        }
        JastAddCodeGen.ajc$interMethodDispatch1$jastadd_JastAddCodeGen$ast_AST_Grammar$weaveInterfaceIntroductions(root);
        String err = root.errors();
        if (!err.equals("")) {
            System.out.println("Semantic errors: \n" + err);
            System.exit(1);
        }
        long jragErrorTime = System.currentTimeMillis() - time - jragParseTime;
        JastAddCodeGen.ajc$interMethodDispatch1$jastadd_JastAddCodeGen$ast_AST_Grammar$jastAddGen(root, outputDir, grammar, pack, publicModifier);
        try {
            root.createInterfaces(outputDir, pack);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File error: Output directory " + outputDir + " does not exist or is write protected");
            System.exit(1);
        }
        long cfr_ignored_0 = System.currentTimeMillis() - time - jragErrorTime;
    }

    public static boolean readArgs(String[] args) {
        CommandLineArguments cla = new CommandLineArguments(args);
        if (cla.hasLongOption("jjtree")) {
            jjtree = true;
            if (!cla.hasLongOption("grammar")) {
                System.out.println("Missing grammar option that is required in jjtree-mode");
                return true;
            }
            grammar = cla.getLongOptionValue("grammar", "Unknown");
        }
        if (cla.hasLongOption("defaultMap")) {
            defaultMap = cla.getLongOptionValue("defaultMap", null);
        }
        if (cla.hasLongOption("defaultSet")) {
            defaultSet = cla.getLongOptionValue("defaultSet", null);
        }
        lazyMaps = cla.hasLongOption("lazyMaps");
        publicModifier = !cla.hasLongOption("private");
        rewriteEnabled = cla.hasLongOption("rewrite");
        beaver = cla.hasLongOption("beaver");
        visitCheckEnabled = !cla.hasLongOption("novisitcheck");
        cacheCycle = !cla.hasLongOption("noCacheCycle");
        noInhEqCheck = cla.hasLongOption("noInhEqCheck");
        String outputDirName = cla.getLongOptionValue("o", System.getProperty("user.dir"));
        outputDir = new File(outputDirName);
        if (!outputDir.exists()) {
            System.out.println("Output directory does not exist");
            System.exit(1);
        }
        if (!outputDir.isDirectory()) {
            System.out.println("Output directory is not a directory");
            System.exit(1);
        }
        if (!outputDir.canWrite()) {
            System.out.println("Output directory is write protected");
            System.exit(1);
        }
        pack = cla.getLongOptionValue("package", "");
        int n = cla.getNumOperands();
        int k = 0;
        while (k < n) {
            String fileName = cla.getOperand(k);
            if (!(fileName.endsWith(".ast") || fileName.endsWith(".jrag") || fileName.endsWith(".jadd"))) {
                System.out.println("FileError: " + fileName + " is of unknown file type");
                return true;
            }
            files.add(fileName);
            ++k;
        }
        if (cla.hasLongOption("version")) {
            System.out.println(VERSION);
            return true;
        }
        if (cla.hasLongOption("help") || files.isEmpty()) {
            System.out.println("JastAdd II (http://jastadd.cs.lth.se) version R20060729\n");
            JastAdd.printHelp();
            return true;
        }
        return false;
    }

    public static void printHelp() {
        System.out.println("This program reads a number of .jrag, .jadd, and .ast files");
        System.out.println("and creates the nodes in the abstract syntax tree");
        System.out.println();
        System.out.println("The .jrag source files may contain declarations of synthesized ");
        System.out.println("and inherited attributes and their corresponding equations.");
        System.out.println("It may also contain ordinary Java methods and fields.");
        System.out.println();
        System.out.println("Source file syntax can be found at http://jastadd.cs.lth.se");
        System.out.println();
        System.out.println("Options:");
        System.out.println("  --help (prints this text and stops)");
        System.out.println("  --version (prints version information and stops)");
        System.out.println("  --package=PPP (optional package for generated files, default is none)");
        System.out.println("  --o=DDD (optional base output directory, default is current directory");
        System.out.println("  --beaver (use beaver base node)");
        System.out.println("  --jjtree (use jjtree base node, this requires --grammar to be set)");
        System.out.println("  --grammar=GGG (the parser for the grammar is called GGG, required when using jjtree)");
        System.out.println("  --rewrite (enable ReRAGs support)");
        System.out.println("  --novisitcheck (disable circularity check for attributes)");
        System.out.println("  --noCacheCycle (disable cache cyle optimization for circular attributes)");
        System.out.println();
        System.out.println("Arguments:");
        System.out.println("Names of .ast, .jrag and .jadd source files");
        System.out.println();
        System.out.println("Example: The following command reads and translates files NameAnalysis.jrag");
        System.out.println("and TypeAnalysis.jrag, weaves PrettyPrint.jadd into the abstract syntax tree");
        System.out.println("defined in the grammar Toy.ast.");
        System.out.println("The result is the generated classes for the nodes in the AST that are placed");
        System.out.println("in the package ast.");
        System.out.println();
        System.out.println("JastAdd --package=ast Toy.ast NameAnalysis.jrag TypeAnalysis.jrag PrettyPrinter.jadd");
        System.out.println();
        System.out.println("Stopping program");
    }
}

