/*
 * Decompiled with CFR 0.152.
 */
package jastadd;

import jastadd.JastAdd;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class JastAddTask
extends Task {
    private LinkedHashSet files = new LinkedHashSet();
    private boolean jjtree = false;
    private String grammar = null;
    private boolean beaver = false;
    private String packageName = null;
    private String outdir = null;
    private String defaultMap = null;
    private String defaultSet = null;
    private boolean lazyMaps = false;
    private boolean rewrite = false;
    private boolean novisitcheck = false;
    private boolean noCacheCycle = false;
    private boolean noInhEqCheck = false;

    public void init() {
        super.init();
    }

    public void addConfiguredFileSet(FileSet fileset) {
        DirectoryScanner s = fileset.getDirectoryScanner(this.getProject());
        String[] files = s.getIncludedFiles();
        String baseDir = s.getBasedir().getPath();
        int i = 0;
        while (i < files.length) {
            this.files.add(String.valueOf(baseDir) + File.separator + files[i]);
            ++i;
        }
    }

    public void setJjtree(boolean b) {
        this.jjtree = b;
    }

    public void setGrammar(String g) {
        this.grammar = g;
    }

    public void setBeaver(boolean b) {
        this.beaver = b;
    }

    public void setPackage(String name) {
        this.packageName = name;
    }

    public void setOutdir(String dir) {
        this.outdir = dir;
    }

    public void setDefaultMap(String map) {
        this.defaultMap = map;
    }

    public void setDefaultSet(String set) {
        this.defaultSet = set;
    }

    public void setLazyMaps(boolean b) {
        this.lazyMaps = b;
    }

    public void setRewrite(boolean b) {
        this.rewrite = b;
    }

    public void setNovisitcheck(boolean b) {
        this.novisitcheck = b;
    }

    public void setNoCacheCycle(boolean b) {
        this.noCacheCycle = b;
    }

    public void setNoInhEqCheck(boolean b) {
        this.noInhEqCheck = b;
    }

    public void execute() throws BuildException {
        if (this.jjtree && this.grammar == null) {
            throw new BuildException("JJTree option requires grammar to be set");
        }
        if (this.jjtree && this.beaver) {
            throw new BuildException("Can not generate AST for both JJTree and Beaver");
        }
        if (this.files.size() == 0) {
            throw new BuildException("JastAdd requires grammar and aspect files");
        }
        File generated = new File(String.valueOf(this.packageName == null ? "" : String.valueOf(this.packageName) + "/") + "ASTNode.java");
        if (generated.exists()) {
            boolean changed = false;
            Iterator iter = this.files.iterator();
            while (iter.hasNext()) {
                String fileName = (String)iter.next();
                File file = new File(fileName);
                if (file.exists() && file.lastModified() <= generated.lastModified()) continue;
                changed = true;
            }
            if (!changed) {
                return;
            }
        }
        ArrayList<String> args = new ArrayList<String>();
        if (this.jjtree) {
            args.add("--jjtree");
            args.add("--grammar=" + this.grammar);
        }
        if (this.beaver) {
            args.add("--beaver");
        }
        if (this.packageName != null) {
            args.add("--package=" + this.packageName);
        }
        if (this.outdir != null) {
            args.add("--o=" + this.outdir);
        }
        if (this.defaultMap != null) {
            args.add("--defaultMap=" + this.defaultMap);
        }
        if (this.defaultSet != null) {
            args.add("--defaultSet=" + this.defaultSet);
        }
        if (this.lazyMaps) {
            args.add("--lazyMaps");
        }
        if (this.rewrite) {
            args.add("--rewrite");
        }
        if (this.novisitcheck) {
            args.add("--novisitcheck");
        }
        if (this.noCacheCycle) {
            args.add("--noCacheCycle");
        }
        if (this.noInhEqCheck) {
            args.add("--noInhEqCheck");
        }
        args.addAll(this.files);
        int i = 0;
        String[] argsArray = new String[args.size()];
        Iterator iter = args.iterator();
        while (iter.hasNext()) {
            argsArray[i] = ((String)iter.next()).trim();
            ++i;
        }
        System.err.println("generating node types and weaving aspects");
        JastAdd.main(argsArray);
        System.err.println("done");
    }
}

