import java.io.*;
public class ComputationTests extends TestCaseOutput {
  private void assertComputationByAOP(String calcName, String resultName) {
    String[] args = new String[] { calcName };
    ComputationByAOP.main(args);
    assertOutput(new File(resultName));
  }
  
  public void testInteractiveByAOP() {
    assertComputationByAOP("ComputationTests/interactiveExample.calc", "ComputationTests/interactiveExample.res");
  }
  
  public void testNonInteractiveByAOP() {
    assertComputationByAOP("ComputationTests/nonInteractiveExample.calc", "ComputationTests/nonInteractiveExample.res");
  }
  
  private void assertComputationByVisitor(String calcName, String resultName) {
    String[] args = new String[] { calcName };
    ComputationByVisitor.main(args);
    assertOutput(new File(resultName));
  }
  
  public void testInteractiveByVisitor() {
    assertComputationByVisitor("ComputationTests/interactiveExample.calc", "ComputationTests/interactiveExample.res");
  }
  
  public void testNonInteractiveByVisitor() {
    assertComputationByVisitor("ComputationTests/nonInteractiveExample.calc", "ComputationTests/nonInteractiveExample.res");
  }
}
