/*
  This program parses Calc programs and prints the resulting AST.
  Calc programs should be entered on standard input.
  The resulting AST is printed on standard output.
*/
import AST.*;
import java.io.*;

class DumpCalcExpression {

  public static void main(String args[]) {
    if(args.length != 1) {
      System.err.println("DumpCalcExpression: missing file command line argument");
      System.exit(1);
    }
    try {
      CalcParser parser = new CalcParser(new FileReader(args[0]));

      // Start parsing from the nonterminal "Start".
      Start ast = parser.Start();
    
      // Print the resulting AST on standard output.
      ast.dumpTree("  ", System.out);      
    }
    catch (FileNotFoundException e) {
      System.err.println("DumpCalcExpression: file " + args[0] + " not found");
    }
    catch (ParseException e) {
      System.out.println(e.getMessage());
    }
  }
  
}
