import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;

import junit.framework.TestCase;

public abstract class TestCaseOutput extends TestCase {

	private PrintStream out;
	private ByteArrayOutputStream stream;

	protected void setUp() throws Exception {
		super.setUp();
		out = System.out;
		stream = new ByteArrayOutputStream();
		PrintStream printStream = new PrintStream(stream, true);
		System.setOut(printStream);
	}

	protected void tearDown() throws Exception {
		super.tearDown();
		if(System.out != null && System.out != out) {
			System.setOut(out);
		}
		stream.close();
		stream = null;
	}

	public void assertOutput(String result) {
		assertOutput("", result);
	}

	public void assertOutput(String msg, String result) {
		assertEquals(msg, result, stream.toString());
	}
	
	public void assertOutput(File file) {
		assertOutput("", file);
	}
	
	public void assertOutput(String msg, File file) {
		try {
			FileInputStream inputStream = new FileInputStream(file);
			byte buffer[] = new byte[1024];
			StringBuffer s = new StringBuffer();
			try {
				while(inputStream.available() != 0) {
					int index = inputStream.read(buffer);
					s.append(new String(buffer, 0, index));
				}
			} catch (IOException e) {
				fail("Error reading " + file.getName());
			}
			assertOutput(msg, s.toString());		
		} catch (FileNotFoundException e) {
			fail("File " + file.getName() + " not found");
		}
	}

}
