/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jastadd.ast.AST.Grammar;
import org.jastadd.option.ArgumentParser;
import org.jastadd.option.BooleanOption;
import org.jastadd.option.FlagOption;
import org.jastadd.option.Option;
import org.jastadd.option.ValueOption;
import org.jastadd.tinytemplate.TemplateContext;

public class Configuration {
    protected List<String> indList = new ArrayList<String>(32);
    public String indent = "  ";
    public String license = "";
    Option<String> ASTNodeOption = new ValueOption("ASTNode", "set the name of the ASTNode type").acceptAnyValue().defaultValue("ASTNode").templateVariable("ASTNode");
    Option<String> ListOption = new ValueOption("List", "set the name of the List type").acceptAnyValue().defaultValue("List").templateVariable("List");
    Option<String> OptOption = new ValueOption("Opt", "set the name of the Opt type").acceptAnyValue().defaultValue("Opt").templateVariable("Opt");
    Option<String> stateClassNameOption = new ValueOption("stateClassName", "set the name of the AST state class").acceptAnyValue().defaultValue("ASTState").templateVariable("StateClass");
    Option<String> ASTNodeSuperOption = new ValueOption("ASTNodeSuper", "set the ASTNode supertype").acceptAnyValue().templateVariable("ASTNodeSuper");
    Option<Boolean> generateImplicitsOption = new BooleanOption("generateImplicits", "generate implicit node types").defaultValue(true).nonStandard();
    Option<Boolean> generateAnnotations = new BooleanOption("generateAnnotations", "generate Java annotations, e.g., describing attribute properties").defaultValue(true).templateVariable("generateAnnotations");
    Option<Boolean> jjtreeOption = new FlagOption("jjtree", "use JJTree base node").templateVariable("JJTree");
    Option<String> grammarOption = new ValueOption("grammar", "parser name when using --jjtree, used for generating visitor methods").templateVariable("ParserName");
    Option<String> defaultMapOption = new ValueOption("defaultMap", "expression used to create maps for attribute caches").acceptAnyValue().defaultValue("new java.util.HashMap(4)").nonStandard().templateVariable("CreateDefaultMap");
    Option<String> defaultSetOption = new ValueOption("defaultSet", "expression used to create sets for attribute caches").acceptAnyValue().defaultValue("new java.util.HashSet(4)").nonStandard().templateVariable("CreateDefaultSet");
    Option<Boolean> lazyMapsOption = new BooleanOption("lazyMaps", "use lazy maps").defaultValue(true).templateVariable("LazyMaps").nonStandard().deprecated("2.4.0");
    Option<Boolean> privateOption = new FlagOption("private", "generated methods will use the private modifier").templateVariable("PrivateModifier").nonStandard().deprecated("2.4.0");
    ValueOption rewriteOption = new ValueOption("rewrite", "enable and select rewrite mode (ReRAGs)").needsValue(false).acceptMultipleValues(false).addDefaultValue("none", "rewrites are disabled").addAcceptedValue("true", "enable rewrites").addAcceptedValue("regular", "enable rewrites using the default implementation (not using CNTAs)").addAcceptedValue("cnta", "evaluate rewrites with circular NTAs");
    Option<Boolean> beaverOption = new FlagOption("beaver", "use beaver.Symbol as ASTNode supertype").templateVariable("Beaver");
    Option<Boolean> lineColumnNumbersOption = new FlagOption("lineColumnNumbers", "generate interface for storing line and column numbers");
    Option<Boolean> visitCheckOption = new BooleanOption("visitCheck", "enable circularity check for attributes").defaultValue(true).templateVariable("VisitCheckEnabled");
    Option<Boolean> traceVisitCheckOption = new BooleanOption("traceVisitCheck", "just print an error rather than throwing a circularity check exception").nonStandard().templateVariable("TraceVisitCheck").deprecated("2.4.0");
    Option<Boolean> cacheCycleOption = new BooleanOption("cacheCycle", "Circular attributes run one last cycle to cache all\nattributes on the cycle.").defaultValue(true).templateVariable("CacheCycle").nonStandard();
    Option<Boolean> componentCheckOption = new BooleanOption("componentCheck", "Throw an exception if mutually circular attributes separated\nby non-circular attribute is detected.").templateVariable("ComponentCheck");
    Option<Boolean> inhEqCheckOption = new BooleanOption("inhEqCheck", "enable check for inherited equations").defaultValue(true).nonStandard().deprecated("2.4.0");
    Option<Boolean> refineLegacyOption = new BooleanOption("refineLegacy", "enable the legacy refine syntax").defaultValue(true).deprecated("2.4.0");
    Option<String> licenseOption = new ValueOption("license", "include the given file as a header in each generated file"){

        @Override
        public void reportWarnings(PrintStream out, String filename) {
            super.reportWarnings(out, filename);
            if (filename.isEmpty()) {
                out.println("Warning: empty license file name");
            } else {
                try {
                    Configuration.readFile(filename);
                }
                catch (IOException e) {
                    out.println("Warning: could not read license file " + filename);
                }
            }
        }
    };
    Option<Boolean> debugOption = new FlagOption("debug", "generate run-time checks for debugging").templateVariable("DebugMode").deprecated("2.4.0");
    Option<Boolean> staticStateOption = new BooleanOption("staticState", "the generated state field is static").defaultValue(true).templateVariable("StaticState").nonStandard();
    ValueOption outputDirOption = new ValueOption("o", "optional base output directory, default is current directory").acceptAnyValue().defaultValue(System.getProperty("user.dir"));
    ValueOption tracingOption = new ValueOption("tracing", "weaves in code collecting evaluation events").acceptMultipleValues(true).needsValue(false).addDefaultValue("none", "tracing is disabled").addDefaultValue("api", "tracing is disabled, but generate Trace class").addAcceptedValue("all", "trace all events").addAcceptedValue("compute", "trace begin and end of attribute computation").addAcceptedValue("cache", "trace value cached, read cache, and cache aborted").addAcceptedValue("rewrite", "trace rewrite evaluation").addAcceptedValue("circular", "trace circular attribute evaluation").addAcceptedValue("circularNTA", "trace circular attribute evaluation").addAcceptedValue("copy", "trace node copy operations").addAcceptedValue("flush", "trace flush operations").addAcceptedValue("coll", "trace collection attribute contributions").addAcceptedValue("token", "trace token reads").additionalDescription("All events are collected by default.\nListen to events by calling ASTState.Trace.setReceiver()");
    ValueOption flushOption = new ValueOption("flush", "generate methods for flushing attribute caches").acceptMultipleValues(true).needsValue(false).addAcceptedValue("full", "flushing of all caches (combines attr, coll, and rewrite)").addDefaultValue("attr", "flushing of attributes (syn, inh)").addDefaultValue("coll", "flushing of collection attributes").addAcceptedValue("none", "do not generate any flushing methods").addAcceptedValue("api", "all generated flushing methods are empty").addDefaultValue("rewrite", "deprecated, has no effect");
    ValueOption packageNameOption = new ValueOption("package", "optional package name for generated classes");
    FlagOption versionOption = new FlagOption("version", "print version info");
    FlagOption helpOption = new FlagOption("help", "print command-line usage info");
    FlagOption printNonStandardOptionsOption = new FlagOption("X", "print list of non-standard options and halt");
    Option<String> statisticsOption = new ValueOption("statistics", "write attribute statistics to a CSV file").acceptAnyValue().nonStandard();
    ValueOption indentOption = new ValueOption("indent", "indentation used in generated code").addDefaultValue("2space", "two spaces").addAcceptedValue("4space", "four spaces").addAcceptedValue("8space", "eight spaces").addAcceptedValue("tab", "use tabs");
    ValueOption minListSizeOption = new ValueOption("minListSize", "minimum (non-empty) list size"){
        {
            this.acceptAnyValue();
            this.defaultValue("4");
            this.templateVariable("MinListSize");
            this.nonStandard();
        }

        @Override
        public void reportWarnings(PrintStream out, String arg) {
            super.reportWarnings(out, arg);
            try {
                int size = Integer.parseInt(arg);
                if (size < 0) {
                    out.println("Warning: minimum list size option must have a positive integer value!");
                }
            }
            catch (NumberFormatException e) {
                out.println("Warning: minimum list size option must be an integer!");
            }
        }
    };
    ValueOption cacheOption = new ValueOption("cache", "global cache configuration overriding 'lazy' keyword").acceptMultipleValues(false).addAcceptedValue("none", "disable attribute caching").addAcceptedValue("all", "cache all attributes");
    ValueOption incrementalOption = new ValueOption("incremental", "incremental evaluation").acceptMultipleValues(true).addDefaultValue("none", "incremental evaluation disabled").addAcceptedValue("param", "dependency tracking on parameter level").addAcceptedValue("region", "dependency tracking on region level").addAcceptedValue("flush", "invalidate with flush").addAcceptedValue("full", "full change propagation").addAcceptedValue("debug", "generate code for debugging and dumping of dependencies");
    Option<Boolean> dotOption = new FlagOption("dot", "generate a Dot graph from the grammar").nonStandard();
    Option<Boolean> safeLazyOption = new FlagOption("safeLazy", "safe in-cycle caching of non-circular attributes").nonStandard();
    Option<Boolean> concurrentOption = new BooleanOption("concurrent", "generate concurrent attribute evaluation code").templateVariable("Concurrent");
    Option<String> numThreadsOption = new ValueOption("num_threads", "number of parallel threads to use for parallelized attributes").acceptAnyValue().defaultValue("4").templateVariable("NumThreads");
    Option<String> concurrentMap = new ValueOption("concurrentmap", "concurrent map implementation for concurrent parameterized memoization").acceptAnyValue().defaultValue("ConcurrentHashMap").templateVariable("ConcurrentMap");
    Collection<String> filenames = new LinkedList<String>();
    Option<Boolean> emptyContainerSingletons = new FlagOption("emptyContainerSingletons", "singleton optimization for empty container nodes").templateVariable("EmptyContainerSingletons").nonStandard();
    public final Option<Boolean> optimizeImports = new FlagOption("optimize-imports", "remove unused imports in generated code").nonStandard();
    final boolean unknownOptions;

    public final String ind(int level) {
        while (this.indList.size() <= level) {
            if (this.indList.size() == 0) {
                this.indList.add("");
                continue;
            }
            this.indList.add(this.indList.get(this.indList.size() - 1) + this.indent);
        }
        return this.indList.get(level);
    }

    public Configuration(String[] args, PrintStream err) {
        ArgumentParser argParser = this.argParser();
        this.unknownOptions = !argParser.parseArgs(args, err);
        this.filenames = argParser.getFilenames();
    }

    public Configuration() {
        this.unknownOptions = false;
    }

    private ArgumentParser argParser() {
        ArgumentParser parser = new ArgumentParser();
        parser.addOptions(this.allOptions());
        return parser;
    }

    private Collection<Option<?>> allOptions() {
        LinkedList allOptions = new LinkedList();
        allOptions.add(this.ASTNodeOption);
        allOptions.add(this.ListOption);
        allOptions.add(this.OptOption);
        allOptions.add(this.jjtreeOption);
        allOptions.add(this.grammarOption);
        allOptions.add(this.generateAnnotations);
        allOptions.add(this.defaultMapOption);
        allOptions.add(this.defaultSetOption);
        allOptions.add(this.lazyMapsOption);
        allOptions.add(this.privateOption);
        allOptions.add(this.rewriteOption);
        allOptions.add(this.beaverOption);
        allOptions.add(this.lineColumnNumbersOption);
        allOptions.add(this.visitCheckOption);
        allOptions.add(this.traceVisitCheckOption);
        allOptions.add(this.cacheCycleOption);
        allOptions.add(this.componentCheckOption);
        allOptions.add(this.inhEqCheckOption);
        allOptions.add(this.refineLegacyOption);
        allOptions.add(this.licenseOption);
        allOptions.add(this.debugOption);
        allOptions.add(this.outputDirOption);
        allOptions.add(this.staticStateOption);
        allOptions.add(this.tracingOption);
        allOptions.add(this.flushOption);
        allOptions.add(this.packageNameOption);
        allOptions.add(this.versionOption);
        allOptions.add(this.helpOption);
        allOptions.add(this.printNonStandardOptionsOption);
        allOptions.add(this.indentOption);
        allOptions.add(this.minListSizeOption);
        allOptions.add(this.cacheOption);
        allOptions.add(this.incrementalOption);
        allOptions.add(this.dotOption);
        allOptions.add(this.ASTNodeSuperOption);
        allOptions.add(this.generateImplicitsOption);
        allOptions.add(this.stateClassNameOption);
        allOptions.add(this.safeLazyOption);
        allOptions.add(this.statisticsOption);
        allOptions.add(this.emptyContainerSingletons);
        allOptions.add(this.concurrentOption);
        allOptions.add(this.numThreadsOption);
        allOptions.add(this.concurrentMap);
        allOptions.add(this.optimizeImports);
        return allOptions;
    }

    public File outputDir() {
        return new File(this.outputDirOption.value());
    }

    public boolean getPublicModifier() {
        return this.privateOption.value() == false;
    }

    public Grammar buildRoot() {
        Grammar root = new Grammar();
        root.setConfiguration(this);
        this.indent = this.indent();
        this.license = this.license();
        TemplateContext tt = root.templateContext();
        for (Option<?> option : this.allOptions()) {
            option.bind(tt);
        }
        String packageName = this.packageName();
        if (packageName.isEmpty()) {
            tt.bind("PackageDecl", "");
        } else {
            tt.bind("PackageDecl", "package " + packageName + ";");
        }
        tt.bind("DefaultMapType", this.typeDefaultMap());
        tt.bind("DefaultSetType", this.typeDefaultSet());
        tt.bind("RewriteEnabled", this.rewriteEnabled());
        tt.bind("RewriteCircularNTA", this.rewriteCircularNTA());
        tt.bind("LegacyRewrite", this.legacyRewrite());
        boolean flushEnabled = !this.flushOption.hasValue("none");
        boolean flushApi = this.flushOption.hasValue("api");
        boolean flushAll = this.flushOption.hasValue("full") || !this.flushOption.hasValue("attr") && !this.flushOption.hasValue("coll");
        tt.bind("FlushEnabled", flushEnabled);
        tt.bind("FlushAPI", flushApi);
        tt.bind("FlushAttr", flushEnabled && (this.flushOption.hasValue("attr") || flushAll));
        tt.bind("FlushColl", flushEnabled && (this.flushOption.hasValue("coll") || flushAll));
        tt.bind("IncrementalEnabled", this.incremental());
        tt.bind("IncrementalLevelParam", this.incrementalLevelParam());
        tt.bind("IncrementalLevelAttr", this.incrementalLevelAttr());
        tt.bind("IncrementalLevelNode", this.incrementalLevelNode());
        tt.bind("IncrementalLevelRegion", this.incrementalLevelRegion());
        tt.bind("IncrementalChangeFlush", this.incrementalChangeFlush());
        tt.bind("IncrementalChangeMark", this.incrementalChangeMark());
        tt.bind("IncrementalPropFull", this.incrementalPropFull());
        tt.bind("IncrementalPropLimit", this.incrementalPropLimit());
        tt.bind("IncrementalDebug", this.incrementalDebug());
        tt.bind("IncrementalTrack", this.incrementalTrack());
        tt.bind("DDGNodeName", this.astNodeType() + "$DepGraphNode");
        tt.bind("TracingEnabled", this.tracingEnabled());
        tt.bind("TraceCompute", this.traceCompute());
        tt.bind("TraceCache", this.traceCache());
        tt.bind("TraceRewrite", this.traceRewrite());
        tt.bind("TraceCircularNTA", this.traceCircularNTA());
        tt.bind("TraceCircular", this.traceCircular());
        tt.bind("TraceCopy", this.traceCopy());
        tt.bind("TraceFlush", this.traceFlush());
        tt.bind("TraceColl", this.traceColl());
        tt.bind("TraceToken", this.traceToken());
        tt.bind("VisitCheckEnabled", this.visitCheckEnabled());
        return root;
    }

    public boolean checkProblems(PrintStream out) {
        if (this.unknownOptions) {
            return true;
        }
        LinkedList<String> grammarFiles = new LinkedList<String>();
        for (String filename : this.filenames) {
            if (!filename.endsWith(".ast")) continue;
            grammarFiles.add(filename);
        }
        if (grammarFiles.isEmpty()) {
            out.println("Error: No grammar files specified.");
            return true;
        }
        for (String filename : this.filenames) {
            if (filename.endsWith(".ast") || filename.endsWith(".jrag") || filename.endsWith(".jadd")) continue;
            out.format("Error: Unrecognized file extension: %s%n", filename);
            return true;
        }
        File outputDir = this.outputDir();
        if (!outputDir.exists()) {
            out.format("Error: Output directory %s does not exist%n", outputDir.getAbsolutePath());
            return true;
        }
        if (!outputDir.isDirectory()) {
            out.format("Error: Output directory %s is not a directory%n", outputDir.getAbsolutePath());
            return true;
        }
        if (!outputDir.canWrite()) {
            out.format("Error: Output directory %s is write protected%n", outputDir.getAbsolutePath());
            return true;
        }
        if (!this.checkIncrementalConfig(out)) {
            return true;
        }
        if (!this.checkCacheConfig(out)) {
            return true;
        }
        if (this.jjtreeOption.value().booleanValue() && !this.ASTNodeSuperOption.value().isEmpty()) {
            out.println("Error: Cannot use --jjtree and --ASTNodeSuper at the same time!");
            return true;
        }
        if (this.beaverOption.value().booleanValue() && !this.ASTNodeSuperOption.value().isEmpty()) {
            out.println("Error: Cannot use --beaver and --ASTNodeSuper at the same time!");
            return true;
        }
        if (this.beaverOption.value().booleanValue() && this.jjtreeOption.value().booleanValue()) {
            out.println("Error: Cannot use --beaver and --jjtree at the same time!");
            return true;
        }
        return false;
    }

    private boolean checkCacheConfig(PrintStream out) {
        if (this.cacheOption.numValues() > 1) {
            out.println("Error: only one cache option may be enabled");
            return false;
        }
        return true;
    }

    private boolean checkIncrementalConfig(PrintStream out) {
        if (this.incrementalLevelAttr() && this.incrementalLevelNode() || this.incrementalLevelAttr() && this.incrementalLevelParam() || this.incrementalLevelNode() && this.incrementalLevelParam() || this.incrementalLevelParam() && this.incrementalLevelRegion() || this.incrementalLevelAttr() && this.incrementalLevelRegion() || this.incrementalLevelNode() && this.incrementalLevelRegion()) {
            out.println("error: Conflict in incremental evaluation configuration. Cannot combine \"param\", \"attr\", \"node\" and \"region\".");
            return false;
        }
        if (this.incrementalChangeFlush() && this.incrementalChangeMark()) {
            out.println("error: Conflict in incremental evaluation configuration. Cannot combine \"flush\" and \"mark\".");
            return false;
        }
        if (this.incrementalChangeMark()) {
            out.println("error: Unsupported incremental evaluation configuration: \"mark\".");
            return false;
        }
        if (this.incrementalPropFull() && this.incrementalPropLimit()) {
            out.println("error: Conflict in incremental evaluation configuration. Cannot combine \"full\" and \"limit\".");
            return false;
        }
        return true;
    }

    private static String readFile(String name) throws IOException {
        int i;
        StringBuilder buf = new StringBuilder();
        BufferedReader reader = new BufferedReader(new FileReader(name));
        char[] cbuf = new char[1024];
        while ((i = reader.read(cbuf)) != -1) {
            buf.append(String.valueOf(cbuf, 0, i));
        }
        ((Reader)reader).close();
        return buf.toString();
    }

    public Collection<String> getFiles() {
        ArrayList<String> files = new ArrayList<String>();
        for (String filename : this.filenames) {
            if (!filename.endsWith(".ast") && !filename.endsWith(".jrag") && !filename.endsWith(".jadd")) continue;
            files.add(filename);
        }
        return files;
    }

    public void printHelp(PrintStream out) {
        out.println("This program reads a number of .jrag, .jadd, and .ast files");
        out.println("and generates the Java classes for the abstract syntax tree.");
        out.println();
        out.println("Source files contain declarations of synthesized ");
        out.println("and inherited attributes and their corresponding equations,");
        out.println("as well as ordinary Java methods and fields.");
        out.println("Source file syntax is documented at http://jastadd.org");
        out.println();
        out.println("Options:");
        this.argParser().printHelp(out);
        out.println();
        out.println("Arguments:");
        out.println("  Names of abstract grammr (.ast) and aspect (.jrag and .jadd) files.");
        out.println();
        out.println("Example: The following command reads and translates NameAnalysis.jrag,");
        out.println("and weaves PrettyPrint.jadd into the abstract syntax classes");
        out.println("defined in the grammar file Toy.ast.");
        out.println("The result is the generated classes for the nodes in the AST that are placed");
        out.println("in the package ast.");
        out.println();
        out.println("java -jar jastadd2.jar --package=ast Toy.ast NameAnalysis.jrag PrettyPrint.jadd");
    }

    public void printNonStandardOptions(PrintStream out) {
        out.println("Non-standard options:");
        this.argParser().printNonStandardOptions(out);
    }

    public boolean shouldPrintVersion() {
        return this.versionOption.value();
    }

    public boolean shouldPrintHelp() {
        return this.helpOption.value();
    }

    public boolean shouldPrintNonStandardOptions() {
        return this.printNonStandardOptionsOption.value();
    }

    public boolean shouldWriteStatistics() {
        return !this.statisticsOption.value().isEmpty();
    }

    public String statisticsFile() {
        return this.statisticsOption.value();
    }

    public boolean tracingEnabled() {
        return !this.tracingOption.hasValue("none");
    }

    public boolean traceAll() {
        return this.tracingOption.hasValue("all") || this.tracingOption.value().isEmpty();
    }

    public boolean traceCompute() {
        return this.traceAll() || this.tracingOption.hasValue("compute");
    }

    public boolean traceCache() {
        return this.traceAll() || this.tracingOption.hasValue("cache");
    }

    public boolean traceRewrite() {
        return this.traceAll() || this.tracingOption.hasValue("rewrite");
    }

    public boolean traceCircularNTA() {
        return this.traceAll() || this.tracingOption.hasValue("circularNTA");
    }

    public boolean traceCircular() {
        return this.traceAll() || this.tracingOption.hasValue("circular");
    }

    public boolean traceCopy() {
        return this.traceAll() || this.tracingOption.hasValue("copy");
    }

    public boolean traceFlush() {
        return this.traceAll() || this.tracingOption.hasValue("flush");
    }

    public boolean traceColl() {
        return this.traceAll() || this.tracingOption.hasValue("coll");
    }

    public boolean traceToken() {
        return this.traceAll() || this.tracingOption.hasValue("token");
    }

    public String astNodeType() {
        return this.ASTNodeOption.value();
    }

    public String listType() {
        return this.ListOption.value();
    }

    public String optType() {
        return this.OptOption.value();
    }

    public String stateClassName() {
        return this.stateClassNameOption.value();
    }

    public String astNodeSuperType() {
        if (this.ASTNodeSuperOption.value().isEmpty()) {
            if (this.beaverOption.value().booleanValue()) {
                return "beaver.Symbol";
            }
            if (this.jjtree()) {
                return "SimpleNode";
            }
            return "";
        }
        return this.ASTNodeSuperOption.value();
    }

    public String indent() {
        String arg = this.indentOption.value();
        if (arg.equals("2space")) {
            return "  ";
        }
        if (arg.equals("4space")) {
            return "    ";
        }
        if (arg.equals("8space")) {
            return "        ";
        }
        if (arg.equals("tab")) {
            return "\t";
        }
        return "  ";
    }

    public String license() {
        String filename = this.licenseOption.value();
        if (!filename.isEmpty()) {
            try {
                return Configuration.readFile(filename);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return "";
    }

    public boolean visitCheckEnabled() {
        if (this.debugOption.value().booleanValue()) {
            return true;
        }
        return this.visitCheckOption.value();
    }

    public boolean cacheAll() {
        return this.cacheOption.hasValue("all");
    }

    public boolean cacheNone() {
        return this.cacheOption.hasValue("none");
    }

    public boolean incremental() {
        return !this.incrementalOption.hasValue("none");
    }

    public boolean incrementalLevelParam() {
        return this.incrementalOption.hasValue("param");
    }

    public boolean incrementalLevelAttr() {
        return this.incrementalOption.hasValue("attr") || !this.incrementalLevelNode() && !this.incrementalLevelParam() && !this.incrementalLevelRegion();
    }

    public boolean incrementalLevelNode() {
        return this.incrementalOption.hasValue("node");
    }

    public boolean incrementalLevelRegion() {
        return this.incrementalOption.hasValue("region");
    }

    public boolean incrementalChangeFlush() {
        return this.incrementalOption.hasValue("flush") || !this.incrementalChangeMark();
    }

    public boolean incrementalChangeMark() {
        return this.incrementalOption.hasValue("mark");
    }

    public boolean incrementalPropFull() {
        return this.incrementalOption.hasValue("full") || !this.incrementalPropLimit();
    }

    public boolean incrementalPropLimit() {
        return this.incrementalOption.hasValue("limit");
    }

    public boolean incrementalDebug() {
        return this.incrementalOption.hasValue("debug");
    }

    public boolean incrementalTrack() {
        return this.incrementalOption.hasValue("track");
    }

    public boolean lazyMaps() {
        return this.lazyMapsOption.value();
    }

    public String packageName() {
        return this.packageNameOption.value();
    }

    public boolean refineLegacy() {
        return this.refineLegacyOption.value();
    }

    public boolean rewriteCircularNTA() {
        return this.rewriteOption.hasValue("cnta");
    }

    public boolean legacyRewrite() {
        return this.rewriteEnabled() && !this.rewriteCircularNTA();
    }

    public boolean rewriteEnabled() {
        return !this.rewriteOption.hasValue("none");
    }

    public String typeDefaultMap() {
        return "java.util.Map";
    }

    public String typeDefaultSet() {
        return "java.util.Set";
    }

    public boolean debugMode() {
        return this.debugOption.value();
    }

    public boolean jjtree() {
        return this.jjtreeOption.value();
    }

    public String createDefaultMap() {
        return this.defaultMapOption.value();
    }

    public String createDefaultSet() {
        return this.defaultSetOption.value();
    }

    public boolean inhEqCheck() {
        return this.inhEqCheckOption.value();
    }

    public boolean useBeaverSymbol() {
        return this.beaverOption.value();
    }

    public boolean componentCheck() {
        return this.componentCheckOption.value();
    }

    public boolean lineColumnNumbers() {
        return this.lineColumnNumbersOption.value();
    }

    public int minListSize() {
        try {
            int size = Integer.parseInt(this.minListSizeOption.value());
            if (size < 0) {
                return 0;
            }
            return size;
        }
        catch (NumberFormatException e) {
            return 4;
        }
    }

    public boolean shouldGenerateDotGraph() {
        return this.dotOption.value();
    }

    public boolean generateImplicits() {
        return this.generateImplicitsOption.value();
    }

    public boolean safeLazy() {
        return this.safeLazyOption.value();
    }

    public boolean generateAnnotations() {
        return this.generateAnnotations.value();
    }

    public boolean emptyContainerSingletons() {
        return this.emptyContainerSingletons.value();
    }

    public boolean concurrentEval() {
        return this.concurrentOption.value();
    }
}

