/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd;

import java.io.PrintStream;

public abstract class Problem {
    private final String message;
    private final String file;
    private final int line;
    private final int column;

    protected Problem(String message, String file, int line, int column) {
        this.message = message;
        this.file = file;
        this.line = line;
        this.column = column;
    }

    public static ProblemBuilder builder() {
        return new ProblemBuilder();
    }

    public abstract boolean isError();

    public final void print(PrintStream out) {
        out.println(this.toString());
    }

    public String toString() {
        String loc;
        String kind = this.isError() ? "Error" : "Warning";
        String string = loc = this.file.isEmpty() ? "" : this.file;
        if (this.line != -1) {
            String string2 = loc = loc.isEmpty() ? "" + this.line : String.format("%s:%d", loc, this.line);
            if (this.column != -1) {
                loc = loc + ":" + this.column;
            }
        }
        if (!loc.isEmpty()) {
            loc = " at " + loc;
        }
        return String.format("%s%s: %s", kind, loc, this.message);
    }

    public static class Warning
    extends Problem {
        protected Warning(String message, String file, int line, int column) {
            super(message, file, line, column);
        }

        @Override
        public boolean isError() {
            return false;
        }
    }

    public static class Error
    extends Problem {
        protected Error(String message, String file, int line, int column) {
            super(message, file, line, column);
        }

        @Override
        public boolean isError() {
            return true;
        }
    }

    public static class ProblemBuilder {
        String message;
        String filename = "";
        int line = -1;
        int column = -1;

        public ProblemBuilder message(String format, Object ... args) {
            this.message = String.format(format, args);
            return this;
        }

        public ProblemBuilder message(String message) {
            this.message = message;
            return this;
        }

        public ProblemBuilder sourceFile(String filename) {
            if (filename == null) {
                throw new NullPointerException("filename cannot be null");
            }
            this.filename = filename;
            return this;
        }

        public ProblemBuilder sourceLine(int line) {
            this.line = line;
            return this;
        }

        public ProblemBuilder sourceColumn(int column) {
            this.column = column;
            return this;
        }

        public Error buildError() {
            this.checkNotNull();
            return new Error(this.message, this.filename, this.line, this.column);
        }

        public Warning buildWarning() {
            this.checkNotNull();
            return new Warning(this.message, this.filename, this.line, this.column);
        }

        private void checkNotNull() {
            if (this.message == null) {
                throw new NullPointerException("message cannot be null");
            }
        }
    }
}

