/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.ast.AST;

import java.io.PrintStream;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jastadd.Problem;
import org.jastadd.ast.AST.ASTDecl;
import org.jastadd.ast.AST.ASTNode;
import org.jastadd.ast.AST.ASTNode$State;
import org.jastadd.ast.AST.ASTNodeAnnotation;
import org.jastadd.ast.AST.Ast;
import org.jastadd.ast.AST.AstVisitor;
import org.jastadd.ast.AST.Grammar;
import org.jastadd.ast.AST.Node;
import org.jastadd.ast.AST.TypeDecl;
import org.jastadd.jrag.AST.JragParser;

public abstract class Component
extends ASTNode<ASTNode>
implements Cloneable {
    protected int typeDecl_visited = -1;
    protected boolean typeDecl_computed = false;
    protected TypeDecl typeDecl_value;
    protected int ntaShadowingNonNTA_visited = -1;
    protected int isNTA_visited = -1;
    protected Map checkComponentStructure_int_visited = new HashMap(4);
    protected int className_visited = -1;
    protected int hostClass_visited = -1;

    public abstract String componentString();

    public abstract String componentHtml();

    public boolean declared() {
        return this.grammar().lookup(this.type()) != null;
    }

    public abstract void jaddGen(int var1, boolean var2, ASTDecl var3);

    protected void parse(String s) {
        JragParser jp = new JragParser(new StringReader(s));
        jp.root = this.grammar();
        jp.setFileName("");
        try {
            jp.AspectBodyDeclarationsEOF();
        }
        catch (Exception e) {
            System.err.println("Aspect parsing error: " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    public Component(int i) {
        super(i);
    }

    public Component(Ast p, int i) {
        this(i);
        this.parser = p;
    }

    public Component() {
        this(0);
    }

    @Override
    public void init$Children() {
    }

    @Override
    public void dumpTree(String indent, PrintStream out) {
        out.print(indent + "Component");
        String childIndent = indent + "  ";
        for (int i = 0; i < this.getNumChild(); ++i) {
            ((ASTNode)this.getChild(i)).dumpTree(childIndent, out);
        }
    }

    @Override
    public Object jjtAccept(AstVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        this.checkChild(n, i);
        super.jjtAddChild(n, i);
    }

    @Override
    public void checkChild(Node n, int i) {
    }

    @Override
    public int getNumChild() {
        return 0;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void flushAttrCache() {
        super.flushAttrCache();
        this.typeDecl_reset();
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public Component clone() throws CloneNotSupportedException {
        Component node = (Component)super.clone();
        return node;
    }

    @Deprecated
    public abstract Component fullCopy();

    public abstract Component treeCopyNoTransform();

    public abstract Component treeCopy();

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="ConstructorParameterTypes", declaredAt="/jastadd/src/jastadd/ast/ComponentsUtil.jrag:120")
    public abstract String constrParmType();

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Names", declaredAt="/jastadd/src/jastadd/ast/ASTNameBinding.jrag:106")
    public abstract String name();

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Types", declaredAt="/jastadd/src/jastadd/ast/ASTNameBinding.jrag:121")
    public abstract String type();

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Kind", declaredAt="/jastadd/src/jastadd/ast/ASTNameBinding.jrag:139")
    public abstract String kind();

    private void typeDecl_reset() {
        this.typeDecl_computed = false;
        this.typeDecl_value = null;
        this.typeDecl_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="FindInheritedEquations", declaredAt="/jastadd/src/jastadd/ast/InheritedAttributes.jrag:346")
    public TypeDecl typeDecl() {
        ASTNode$State state = this.state();
        if (this.typeDecl_computed) {
            return this.typeDecl_value;
        }
        if (this.typeDecl_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute Component.typeDecl().");
        }
        this.typeDecl_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.typeDecl_value = this.grammar().lookup(this.type());
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.typeDecl_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.typeDecl_visited = -1;
        return this.typeDecl_value;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Comp", declaredAt="/jastadd/src/jastadd/ast/ComponentsUtil.jrag:90")
    public boolean ntaShadowingNonNTA() {
        if (this.ntaShadowingNonNTA_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute Component.ntaShadowingNonNTA().");
        }
        this.ntaShadowingNonNTA_visited = this.state().boundariesCrossed;
        try {
            if (!this.isNTA()) {
                boolean bl = false;
                return bl;
            }
            String name = this.name();
            TypeDecl hostClass = this.hostClass();
            block6: while (true) {
                TypeDecl typeDecl = hostClass = hostClass instanceof ASTDecl ? ((ASTDecl)hostClass).superClass() : null;
                if (hostClass == null) {
                    boolean bl = false;
                    return bl;
                }
                Iterator<Component> iterator = hostClass.components().iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block6;
                    Component comp = iterator.next();
                    if (comp.isNTA() || !name.equals(comp.name())) continue;
                    boolean bl = true;
                    return bl;
                }
                break;
            }
        }
        finally {
            this.ntaShadowingNonNTA_visited = -1;
        }
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="NTADetector", declaredAt="/jastadd/src/jastadd/ast/ComponentsUtil.jrag:112")
    public boolean isNTA() {
        if (this.isNTA_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute Component.isNTA().");
        }
        this.isNTA_visited = this.state().boundariesCrossed;
        boolean isNTA_value = false;
        this.isNTA_visited = -1;
        return isNTA_value;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="JaddCodeGen", declaredAt="/jastadd/src/jastadd/ast/JaddCodeGen.jrag:499")
    public String checkComponentStructure(int childIndex) {
        Integer _parameters = childIndex;
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.checkComponentStructure_int_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute Component.checkComponentStructure(int).");
        }
        this.checkComponentStructure_int_visited.put(_parameters, this.state().boundariesCrossed);
        String checkComponentStructure_int_value = "";
        this.checkComponentStructure_int_visited.remove(_parameters);
        return checkComponentStructure_int_value;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="ComponentHostClass", declaredAt="/jastadd/src/jastadd/ast/ASTNameBinding.jrag:131")
    public String className() {
        if (this.className_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute Component.className().");
        }
        this.className_visited = this.state().boundariesCrossed;
        String className_value = this.hostClass().name();
        this.className_visited = -1;
        return className_value;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.INH)
    @ASTNodeAnnotation.Source(aspect="ComponentHostClass", declaredAt="/jastadd/src/jastadd/ast/ComponentsUtil.jrag:128")
    public TypeDecl hostClass() {
        if (this.hostClass_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute Component.hostClass().");
        }
        this.hostClass_visited = this.state().boundariesCrossed;
        TypeDecl hostClass_value = this.getParent().Define_hostClass(this, null);
        this.hostClass_visited = -1;
        return hostClass_value;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    @Override
    protected void collect_contributors_Grammar_problems(Grammar _root, Map<ASTNode, Set<ASTNode>> _map) {
        Set<ASTNode> contributors;
        Grammar target;
        if (this.hostClass().lookupComponent(this.name()) != this) {
            target = this.grammar();
            contributors = _map.get(target);
            if (contributors == null) {
                contributors = new LinkedHashSet<ASTNode>();
                _map.put(target, contributors);
            }
            contributors.add(this);
        }
        if (!this.declared()) {
            target = this.grammar();
            contributors = _map.get(target);
            if (contributors == null) {
                contributors = new LinkedHashSet<ASTNode>();
                _map.put(target, contributors);
            }
            contributors.add(this);
        }
        super.collect_contributors_Grammar_problems(_root, _map);
    }

    @Override
    protected void contributeTo_Grammar_problems(Collection<Problem> collection) {
        super.contributeTo_Grammar_problems(collection);
        if (this.hostClass().lookupComponent(this.name()) != this) {
            collection.add(Problem.builder().message("Component name %s is not unique in production rule for %s (%s)", this.name(), this.hostClass().name(), this.hostClass().lookupComponent(this.name())).sourceFile(this.hostClass().getFileName()).sourceLine(this.hostClass().getStartLine()).buildError());
        }
        if (!this.declared()) {
            collection.add(Problem.builder().message("Type %s of component %s in production %s is not declared", this.type(), this.name(), this.hostClass().name()).sourceFile(this.hostClass().getFileName()).sourceLine(this.hostClass().getStartLine()).buildError());
        }
    }
}

