/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.ast.AST;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jastadd.Configuration;
import org.jastadd.Problem;
import org.jastadd.ast.AST.ASTDecl;
import org.jastadd.ast.AST.ASTNode;
import org.jastadd.ast.AST.ASTNode$State;
import org.jastadd.ast.AST.ASTNodeAnnotation;
import org.jastadd.ast.AST.Annotation;
import org.jastadd.ast.AST.Ast;
import org.jastadd.ast.AST.AstVisitor;
import org.jastadd.ast.AST.AttrDecl;
import org.jastadd.ast.AST.AttrEq;
import org.jastadd.ast.AST.AttrSignature;
import org.jastadd.ast.AST.BlockSurveyContribution;
import org.jastadd.ast.AST.CacheDecl;
import org.jastadd.ast.AST.CacheMode;
import org.jastadd.ast.AST.ClassBodyDecl;
import org.jastadd.ast.AST.ClassDecl;
import org.jastadd.ast.AST.CollDecl;
import org.jastadd.ast.AST.CollEq;
import org.jastadd.ast.AST.Component;
import org.jastadd.ast.AST.EnumDecl;
import org.jastadd.ast.AST.ExpressionSurveyContribution;
import org.jastadd.ast.AST.IdDecl;
import org.jastadd.ast.AST.ImportDecl;
import org.jastadd.ast.AST.ImportSet;
import org.jastadd.ast.AST.InhAttrSignature;
import org.jastadd.ast.AST.InhDecl;
import org.jastadd.ast.AST.InhEq;
import org.jastadd.ast.AST.InterfaceDecl;
import org.jastadd.ast.AST.List;
import org.jastadd.ast.AST.MultiImportDecl;
import org.jastadd.ast.AST.Node;
import org.jastadd.ast.AST.Parameter;
import org.jastadd.ast.AST.RegionDecl;
import org.jastadd.ast.AST.Rewrite;
import org.jastadd.ast.AST.SynDecl;
import org.jastadd.ast.AST.SynEq;
import org.jastadd.ast.AST.SynthesizedNta;
import org.jastadd.ast.AST.TokenComponent;
import org.jastadd.ast.AST.TypeDecl;
import org.jastadd.jrag.AST.ASTAspectFieldDeclaration;
import org.jastadd.jrag.AST.ASTAspectMethodDeclaration;
import org.jastadd.jrag.AST.ASTAspectRefineMethodDeclaration;
import org.jastadd.jrag.AST.ASTBlock;
import org.jastadd.jrag.AST.ASTCompilationUnit;
import org.jastadd.jrag.AST.SimpleNode;
import org.jastadd.jrag.ClassBodyObject;
import org.jastadd.jrag.Unparser;
import org.jastadd.tinytemplate.SimpleContext;
import org.jastadd.tinytemplate.TemplateContext;
import org.jastadd.tinytemplate.TemplateParser;
import org.jastadd.tinytemplate.TinyTemplate;

public class Grammar
extends ASTNode<ASTNode>
implements Cloneable {
    private Configuration configuration = null;
    public Collection<CollDecl> collDecls = new ArrayList<CollDecl>();
    public Collection<CollEq> collEqs = new ArrayList<CollEq>();
    public Collection<Problem> problems = new LinkedList<Problem>();
    public HashMap aspectMap = new HashMap();
    public ArrayList<CacheDecl> cacheDecls = new ArrayList();
    public Collection<SynDecl> synDecls = new ArrayList<SynDecl>();
    public Collection<SynEq> synEqs = new ArrayList<SynEq>();
    public Collection<InhDecl> inhDecls = new ArrayList<InhDecl>();
    public Collection<InhEq> inhEqs = new ArrayList<InhEq>();
    HashMap<String, TreeSet<AttrSignature>> lateBindingSignatures = new HashMap();
    public Map<String, Collection<ClassBodyObject>> interTypeDecls = new HashMap<String, Collection<ClassBodyObject>>();
    public Collection<ASTCompilationUnit> compilationUnits = new LinkedList<ASTCompilationUnit>();
    protected Map<ASTNode, Set<ASTNode>> contributorMap_Grammar_interfaceProblems = null;
    protected Map<ASTNode, Set<ASTNode>> contributorMap_Grammar_problems = null;
    protected Map<ASTNode, Set<ASTNode>> contributorMap_InterfaceDecl_interfaceAttributeProblems = null;
    protected Map<ASTNode, Set<ASTNode>> contributorMap_CollDecl_uses = null;
    protected Map targetJavaFile_String_visited = new HashMap(4);
    protected int packageDirectory_visited = -1;
    protected boolean packageDirectory_computed = false;
    protected File packageDirectory_value;
    protected int grammar_visited = -1;
    protected int config_visited = -1;
    protected int templateContext_visited = -1;
    protected boolean templateContext_computed = false;
    protected TemplateContext templateContext_value;
    protected int synDeclMap_visited = -1;
    protected boolean synDeclMap_computed = false;
    protected Map<String, Collection<SynDecl>> synDeclMap_value;
    protected int synEqMap_visited = -1;
    protected boolean synEqMap_computed = false;
    protected Map<String, Collection<SynEq>> synEqMap_value;
    protected int collDeclMap_visited = -1;
    protected int collEqMap_visited = -1;
    protected boolean collEqMap_computed = false;
    protected Map<TypeDecl, Collection<CollEq>> collEqMap_value;
    protected int inhEqMap_visited = -1;
    protected boolean inhEqMap_computed = false;
    protected HashMap inhEqMap_value;
    protected int missingInhEqs_visited = -1;
    protected boolean missingInhEqs_computed = false;
    protected Collection<InhDecl> missingInhEqs_value;
    protected int attributeProblems_visited = -1;
    protected int missingInhEqProblems_visited = -1;
    protected int subclassMap_visited = -1;
    protected boolean subclassMap_computed = false;
    protected Map<ASTDecl, Collection<ASTDecl>> subclassMap_value;
    protected int parentMap_visited = -1;
    protected boolean parentMap_computed = false;
    protected HashMap<TypeDecl, Collection<ASTDecl>> parentMap_value;
    protected int roots_visited = -1;
    protected boolean roots_computed = false;
    protected Collection<ASTDecl> roots_value;
    protected Map lookupCollDecl_String_String_visited = new HashMap(4);
    protected Map lookup_String_visited = new HashMap(4);
    protected int Grammar_interfaceProblems_visited = -1;
    protected boolean Grammar_interfaceProblems_computed = false;
    protected Collection<Problem> Grammar_interfaceProblems_value;
    protected int Grammar_problems_visited = -1;
    protected boolean Grammar_problems_computed = false;
    protected Collection<Problem> Grammar_problems_value;

    public void createPackageOutputDirectory() {
        File packageDir = this.packageDirectory();
        if (!packageDir.isDirectory()) {
            packageDir.mkdirs();
        }
    }

    public void setConfiguration(Configuration config) {
        this.configuration = config;
    }

    private void loadTemplates(TinyTemplate tt, String templateFile) {
        try {
            InputStream in = this.getClass().getResourceAsStream("/template/" + templateFile + ".tt");
            if (in == null) {
                System.err.println("WARNING: Could not load template file " + templateFile);
                return;
            }
            tt.loadTemplates(in);
            in.close();
        }
        catch (TemplateParser.SyntaxError e) {
            System.err.println("WARNING: Could not load template file " + templateFile);
            System.err.println(e.getMessage());
        }
        catch (IOException e) {
            System.err.println("WARNING: Could not load template file " + templateFile);
            System.err.println(e.getMessage());
        }
    }

    public void weaveInterfaceIntroductions() {
        for (TypeDecl tydecl : this.getTypeDeclList()) {
            if (!(tydecl instanceof ASTDecl)) continue;
            ASTDecl dest = (ASTDecl)tydecl;
            for (InterfaceDecl idecl : dest.implementedInterfaces()) {
                ClassBodyObject object;
                String name = idecl.name();
                if (!dest.implementsInterface(name)) continue;
                for (ClassBodyObject o : idecl.classBodyDecls) {
                    if (o.node instanceof ASTAspectMethodDeclaration) {
                        if (!Grammar.hasMethodBody((ASTAspectMethodDeclaration)o.node) || dest.hasClassBodyDecl(o.signature())) continue;
                        dest.classBodyDecls.add(new ClassBodyObject(o.node, o.fileName, o.line, o.getAspectName()));
                        continue;
                    }
                    if (o.node instanceof ASTAspectFieldDeclaration) {
                        if (dest.hasClassBodyDecl(o.signature())) continue;
                        dest.classBodyDecls.add(new ClassBodyObject(o.node, o.fileName, o.line, o.getAspectName()));
                        continue;
                    }
                    if (o.node instanceof ASTAspectRefineMethodDeclaration) {
                        object = new ClassBodyObject(o.node, o.fileName, o.line, o.getAspectName());
                        object.refinesAspect = o.refinesAspect;
                        dest.classBodyDecls.add(object);
                        continue;
                    }
                    if (!(o.node instanceof ASTBlock)) continue;
                    dest.classBodyDecls.add(new ClassBodyObject(o.node, o.fileName, o.line, o.getAspectName()));
                }
                for (ClassBodyObject o : idecl.refinedClassBodyDecls) {
                    if (o.node instanceof ASTAspectMethodDeclaration || o.node instanceof ASTAspectFieldDeclaration) {
                        if (dest.hasClassBodyDecl(o.signature())) continue;
                        dest.refinedClassBodyDecls.add(new ClassBodyObject(o.node, o.fileName, o.line, o.getAspectName()));
                        continue;
                    }
                    if (o.node instanceof ASTAspectRefineMethodDeclaration) {
                        object = new ClassBodyObject(o.node, o.fileName, o.line, o.getAspectName());
                        object.refinesAspect = o.refinesAspect;
                        dest.refinedClassBodyDecls.add(object);
                        continue;
                    }
                    if (!(o.node instanceof ASTBlock)) continue;
                    dest.classBodyDecls.add(new ClassBodyObject(o.node, o.fileName, o.line, o.getAspectName()));
                }
                Map<AttrSignature, TypeDecl> inhAttrImplsFromInterfaces = tydecl.attributeImplementationsWithInterfaces();
                for (InhDecl inhDecl : idecl.getInhDeclList()) {
                    dest.addInhDecl(inhDecl.fullCopy());
                }
                for (InhEq inhEq : idecl.getInhEqList()) {
                    AttrSignature sig = inhEq.attrSignature();
                    TypeDecl td = inhAttrImplsFromInterfaces.get(sig);
                    if (dest.implementedAttributeEquations().contains(InhAttrSignature.from(sig.signature(), "Child")) || td == null || td != inhEq.hostClass()) continue;
                    dest.addInhEq(inhEq.fullCopy());
                }
            }
        }
    }

    private static boolean hasMethodBody(ASTAspectMethodDeclaration decl) {
        for (int i = 0; i < decl.jjtGetNumChildren(); ++i) {
            if (!(decl.jjtGetChild(i) instanceof ASTBlock)) continue;
            return true;
        }
        return false;
    }

    public void jastAddGen(boolean publicModifier) {
        this.createPackageOutputDirectory();
        for (int i = 0; i < this.getNumTypeDecl(); ++i) {
            this.getTypeDecl(i).jastAddGen(publicModifier);
        }
    }

    public void writeStatistics(String filename) throws IOException {
        System.out.println("Writing attribute statistics to " + filename);
        File csv = new File(filename);
        PrintStream out = new PrintStream(new FileOutputStream(csv));
        out.println("node,is_ast,syndecl,syneq,inhdecl,inheq,colldecl,colleq,refinesyn,refineinh,refineitd");
        for (TypeDecl type : this.getTypeDeclList()) {
            type.writeStatistics(out);
        }
        out.close();
    }

    public Set<ImportDecl> importDecls() {
        LinkedHashSet<ImportDecl> imports = new LinkedHashSet<ImportDecl>();
        if (this.config().concurrentEval()) {
            imports.add(new ImportDecl("java.util.concurrent.atomic.AtomicInteger"));
            imports.add(new ImportDecl("java.util.concurrent.atomic.AtomicReference"));
            imports.add(new ImportDecl("java.util.concurrent.Future"));
            imports.add(new ImportDecl("java.util.concurrent.Executors"));
            imports.add(new ImportDecl("java.util.concurrent.ExecutorService"));
            imports.add(new ImportDecl("java.util.concurrent.ExecutionException"));
            imports.add(new ImportDecl("java.util.concurrent.Callable"));
            imports.add(new ImportDecl("java.util.concurrent.ConcurrentMap"));
            imports.add(new ImportDecl("java.util.concurrent.ConcurrentHashMap"));
            imports.add(new ImportDecl("java.util.ArrayList"));
            imports.add(new ImportDecl("java.util.LinkedList"));
            imports.add(new ImportDecl("java.util.Collection"));
        }
        for (ASTCompilationUnit u : this.compilationUnits) {
            imports.addAll(Unparser.getImports(u));
        }
        return imports;
    }

    public String genImportsList(String code) {
        Set<ImportDecl> imports = this.importDecls();
        ImportSet set = new ImportSet(imports);
        boolean optimize = this.config().optimizeImports.value();
        if (optimize) {
            for (int i = 0; i < code.length(); ++i) {
                int end;
                if (!Character.isJavaIdentifierStart(code.charAt(i))) continue;
                for (end = i + 1; end < code.length() && Character.isJavaIdentifierPart(code.charAt(end)); ++end) {
                }
                String id = code.substring(i, end);
                if (set.unmatched.containsKey(id)) {
                    set.unmatched.get((Object)id).matched = true;
                    set.unmatched.remove(id);
                    if (set.unmatched.isEmpty()) break;
                }
                i = end - 1;
            }
        }
        StringBuilder buf = new StringBuilder();
        for (ImportDecl decl : imports) {
            if (!(decl instanceof MultiImportDecl)) continue;
            buf.append(decl);
            buf.append('\n');
        }
        for (ImportSet.Node node : set.all.values()) {
            if (optimize && !node.matched) continue;
            for (ImportDecl decl : node.decls) {
                buf.append(decl);
                buf.append('\n');
            }
        }
        return buf.toString();
    }

    public Iterator inhAttrSet() {
        return this.inhEqMap().keySet().iterator();
    }

    public void removeDuplicateInhDecls() {
        for (TypeDecl td : this.getTypeDecls()) {
            td.removeDuplicateInhDecls();
        }
    }

    Map<String, InhDecl> inhDecls() {
        HashMap<String, InhDecl> decls = new HashMap<String, InhDecl>();
        for (TypeDecl type : this.getTypeDecls()) {
            for (int i = 0; i < type.getNumInhDecl(); ++i) {
                InhDecl decl = type.getInhDecl(i);
                decls.put(decl.signature(), decl);
            }
        }
        return decls;
    }

    public void addInterface(SimpleNode nameList, String className, String fileName) {
        if (nameList == null) {
            System.err.println("Panic");
        } else {
            TypeDecl c = this.lookup(className);
            if (c != null) {
                c.implementsList.add(nameList);
            } else {
                int line = nameList.firstToken.beginLine;
                this.error("cannot add interface to unknown class " + className, fileName, line);
            }
        }
    }

    public void extendInterface(SimpleNode nameList, String className, String fileName) {
        if (nameList == null) {
            System.err.println("Panic");
        } else {
            TypeDecl c = this.lookup(className);
            if (c instanceof InterfaceDecl) {
                c.implementsList.add(nameList);
            } else if (c != null) {
                int line = nameList.firstToken.beginLine;
                this.error(className + " is not an interface and can therefore not be extended", fileName, line);
            } else {
                int line = nameList.firstToken.beginLine;
                this.error("cannot add interface to unknown interface " + className, fileName, line);
            }
        }
    }

    public void genDotGraph(PrintStream out) {
        out.println("digraph {");
        out.println("  edge [dir=back];");
        out.println("  node [shape=box];");
        for (TypeDecl decl : this.getTypeDeclList()) {
            if (!(decl instanceof ASTDecl)) continue;
            ASTDecl astDecl = (ASTDecl)decl;
            if (astDecl.superClass() != null) {
                out.format("  %s -> %s;%n", astDecl.getSuperClass().name(), decl.name());
                continue;
            }
            if (!astDecl.isASTNodeDecl()) {
                out.format("  %s -> %s;%n", this.config().astNodeType(), decl.name());
                continue;
            }
            out.format("  %s;%n", decl.name());
        }
        out.println("}");
    }

    public void weaveCollectionAttributes() {
        for (TypeDecl td : this.getTypeDecls()) {
            td.weaveCollectionAttributes();
        }
    }

    public void addCollDecl(String name, String type, String className, String fileName, int startLine, int endLine, String startValue, String combOp, boolean isCircular, ArrayList<String> annotations, SimpleNode node, String root, String aspectName) {
        CollDecl decl = new CollDecl();
        decl.setName(name);
        decl.setType(type);
        decl.setCacheMode(CacheMode.LAZY);
        decl.setFileName(fileName);
        decl.setStartLine(startLine);
        decl.setEndLine(endLine);
        decl.setParameterList(new List<Parameter>());
        decl.setStartValue(startValue);
        decl.setCombOp(combOp);
        for (String annotation : annotations) {
            decl.addAnnotation(new Annotation(annotation));
        }
        decl.setCircularCollection(isCircular || annotations.contains("@Circular"));
        decl.setComment(Unparser.unparseComment(node));
        decl.setTarget(className);
        decl.root = root;
        decl.setAspectName(aspectName);
        decl.hostName = className;
        decl.grammar = this;
        this.collDecls.add(decl);
    }

    public void addCustomSurveyBlock(String collHost, String collName, String nodeType, String codeBlock, String fileName, int startLine, int endLine, SimpleNode commentNode, String aspectName, ArrayList<String> annotations) {
        TypeDecl type = this.lookup(nodeType);
        if (type != null && type instanceof ASTDecl) {
            ((ASTDecl)type).surveyContributions.add(new BlockSurveyContribution(collName, collHost, codeBlock, fileName, startLine, endLine, Unparser.unparseComment(commentNode), aspectName));
            for (String annotation : annotations) {
                this.errorf("annotation %s not allowed for custom survey blocks.", annotation);
            }
        } else {
            this.errorf("Cannot add custom collection survey code to unknown class %s in %s at line %d", nodeType, fileName, startLine);
        }
    }

    public void addCustomSurveyExpression(String collHost, String collName, String nodeType, String ntaExpression, String fileName, int startLine, int endLine, SimpleNode commentNode, String aspectName, ArrayList<String> annotations) {
        TypeDecl type = this.lookup(nodeType);
        if (type != null && type instanceof ASTDecl) {
            ((ASTDecl)type).surveyContributions.add(new ExpressionSurveyContribution(collName, collHost, ntaExpression, fileName, startLine, endLine, Unparser.unparseComment(commentNode), aspectName));
            for (String annotation : annotations) {
                this.errorf("annotation %s not allowed for custom survey blocks.", annotation);
            }
        } else {
            this.errorf("Cannot add custom collection survey code to unknown class %s in %s at line %d", nodeType, fileName, startLine);
        }
    }

    public CollEq addCollEq(String collHost, String collName, String nodeType, String reference, String fileName, int startLine, int endLine, boolean iterableValue, boolean iterableTarget, SimpleNode commentNode, String aspectName, ArrayList<String> annotations) {
        CollEq equ = new CollEq();
        equ.setChild(new List(), 0);
        equ.setChild(new List(), 1);
        equ.setName(collName);
        equ.hostName = collHost;
        equ.setTarget(nodeType);
        equ.setReference(reference);
        equ.setFileName(fileName);
        equ.setStartLine(startLine);
        equ.setEndLine(endLine);
        equ.setIterableValue(iterableValue);
        equ.setIterableTarget(iterableTarget);
        equ.setAspectName(aspectName);
        equ.setComment(Unparser.unparseComment(commentNode));
        equ.grammar = this;
        equ.setParameterList(new List<Parameter>());
        equ.setTargetAttributeName(collName);
        equ.setTargetName(collHost);
        equ.setValue("");
        for (String annotation : annotations) {
            equ.addAnnotation(new Annotation(annotation));
        }
        this.collEqs.add(equ);
        return equ;
    }

    public void error(String message, String file, int line) {
        this.problems.add(Problem.builder().message(message).sourceFile(file).sourceLine(line).buildError());
    }

    public void error(String message) {
        this.problems.add(Problem.builder().message(message).buildError());
    }

    public void errorf(String messagefmt, Object ... args) {
        this.error(String.format(messagefmt, args));
    }

    public Collection<Problem> weavingProblems() {
        return this.problems;
    }

    public void registerAspect(String name, String comment) {
        this.aspectMap.put(name, comment);
    }

    public void addRewrite(String className, SimpleNode condition, SimpleNode result, String type, String fileName, int startLine, int endLine, String aspectName) {
        if (!this.config().rewriteEnabled()) {
            this.error("cannot use rewrites while rewrites are disabled (enable with --rewrite=cnta)", fileName, startLine);
            return;
        }
        TypeDecl c = this.lookup(className);
        if (c != null && c instanceof ASTDecl) {
            Rewrite r = new Rewrite();
            r.setFileName(fileName);
            r.setStartLine(startLine);
            r.setEndLine(endLine);
            r.setCondition(condition);
            r.setResult(result);
            r.setReturnType(type);
            r.setAspectName(aspectName);
            ((ASTDecl)c).addRewrite(r);
        } else if (c != null) {
            this.error("cannot rewrite to non AST class '" + className + "'", fileName, startLine);
        } else {
            this.error("cannot rewrite to unknown class '" + className + "'", fileName, startLine);
        }
    }

    public void setAttributeCacheMode(String mode, String hostName, String attrName, List paramList, String fileName, int startLine) {
        CacheDecl decl = new CacheDecl();
        decl.mode = mode;
        decl.hostName = hostName;
        decl.attrName = attrName;
        decl.fileName = fileName;
        decl.startLine = startLine;
        StringBuilder signature = new StringBuilder();
        signature.append(attrName);
        for (int i = 0; i < paramList.getNumChild(); ++i) {
            signature.append("_" + ((Parameter)paramList.getChild(i)).getTypeInSignature());
        }
        decl.signature = signature.toString();
        this.cacheDecls.add(decl);
    }

    public void applyCacheMode(CacheDecl decl, Collection<Problem> problems) {
        TypeDecl type = this.lookup(decl.hostName);
        if (type == null) {
            problems.add(Problem.builder().message("cannot find attribute %s in unknown class %s", decl.attrName, decl.hostName).sourceFile(decl.fileName).sourceLine(decl.startLine).buildError());
            return;
        }
        AttrDecl attr = null;
        attr = type.lookupSynDecl(decl.signature);
        if (attr == null && (attr = type.lookupInhDecl(decl.signature)) == null) {
            problems.add(Problem.builder().message("cannot find attribute %s.%s", decl.hostName, decl.attrName).sourceFile(decl.fileName).sourceLine(decl.startLine).buildError());
            return;
        }
        if (decl.mode.equals("cache")) {
            attr.setCacheMode(CacheMode.CACHED);
        } else if (decl.mode.equals("uncache")) {
            attr.setCacheMode(CacheMode.UNCACHED);
        } else {
            problems.add(Problem.builder().message("unknown configuration %s for attribute %s.%s", decl.mode, decl.hostName, decl.attrName).sourceFile(decl.fileName).sourceLine(decl.startLine).buildError());
        }
    }

    public void addSynDecl(String name, String type, String className, boolean isLazy, String fileName, int startLine, int endLine, List parameterList, String bottomValue, boolean isFinal, boolean isNTA, SimpleNode node, String aspectName, ArrayList<String> annotations) {
        SynDecl decl = new SynDecl(parameterList, name, type, isLazy | isNTA ? CacheMode.LAZY : CacheMode.DEFAULT, fileName, startLine, endLine, isFinal | isNTA, isNTA, Unparser.unparseComment(node), aspectName, new List<Annotation>());
        for (String annotation : annotations) {
            decl.addAnnotation(new Annotation(annotation));
        }
        decl.setBottomValue(bottomValue);
        decl.hostName = className;
        this.synDecls.add(decl);
    }

    public void addSynEq(String name, String className, SimpleNode rhs, String fileName, int startLine, int endLine, List list, SimpleNode node, String aspectName, ArrayList<String> annotations) {
        SynEq equ = new SynEq();
        equ.setName(name);
        equ.setFileName(fileName);
        equ.setStartLine(startLine);
        equ.setEndLine(endLine);
        equ.setRHS(rhs);
        equ.setParameterList(list);
        equ.setComment(Unparser.unparseComment(node));
        equ.setAspectName(aspectName);
        for (String annotation : annotations) {
            equ.addAnnotation(new Annotation(annotation));
        }
        equ.hostName = className;
        this.recordAttributeForUnknownType(className, equ);
        this.synEqs.add(equ);
    }

    public void addInhDecl(String name, String type, String className, boolean isLazy, String fileName, int startLine, int endLine, List parameterList, String bottomValue, boolean isFinal, boolean isNTA, SimpleNode node, String aspectName, ArrayList<String> annotations) {
        InhDecl decl = new InhDecl(parameterList, name, type, isLazy | isNTA ? CacheMode.LAZY : CacheMode.DEFAULT, fileName, startLine, endLine, isFinal | isNTA, isNTA, Unparser.unparseComment(node), aspectName, new List<Annotation>());
        for (String annotation : annotations) {
            decl.addAnnotation(new Annotation(annotation));
        }
        decl.setBottomValue(bottomValue);
        decl.hostName = className;
        this.inhDecls.add(decl);
    }

    public void addInhEq(String childName, String name, String className, SimpleNode rhs, String fileName, int startLine, int endLine, List list, SimpleNode node, String aspectName, ArrayList<String> annotations) {
        this.addInhEq(childName, name, className, rhs, fileName, startLine, endLine, list, null, node, aspectName, annotations);
    }

    public void addInhEq(String childName, String name, String className, SimpleNode rhs, String fileName, int startLine, int endLine, List list, Parameter p, SimpleNode node, String aspectName, ArrayList<String> annotations) {
        InhEq equ = new InhEq();
        equ.setName(name);
        equ.setFileName(fileName);
        equ.setStartLine(startLine);
        equ.setEndLine(endLine);
        equ.setRHS(rhs);
        equ.setChildName(childName);
        equ.setParameterList(list);
        equ.setComment(Unparser.unparseComment(node));
        equ.setAspectName(aspectName);
        for (String annotation : annotations) {
            equ.addAnnotation(new Annotation(annotation));
        }
        if (p != null) {
            equ.setIndex(p);
        }
        equ.hostName = className;
        this.recordAttributeForUnknownType(className, equ);
        this.inhEqs.add(equ);
    }

    private void recordAttributeForUnknownType(String type, AttrEq equ) {
        if (!this.lateBindingSignatures.containsKey(type)) {
            this.lateBindingSignatures.put(type, new TreeSet());
        }
        this.lateBindingSignatures.get(type).add(equ.attrSignature());
    }

    public Collection<AttrSignature> removeLateBoundAttributeSignaturesForType(String type) {
        TreeSet<AttrSignature> result = this.lateBindingSignatures.get(type);
        if (result == null) {
            return null;
        }
        this.lateBindingSignatures.put(type, null);
        return result;
    }

    public void addComponents(String className, List componentsList) {
        TypeDecl d = this.lookup(className);
        if (d != null) {
            d.setComponentList(componentsList);
        }
    }

    public void addCompUnit(ASTCompilationUnit compUnit) {
        this.compilationUnits.add(compUnit);
    }

    public void addMethodDecl(SimpleNode n, String className, String fileName, String modifiers, String aspectName) {
        TypeDecl c = this.lookup(className);
        if (c != null) {
            ClassBodyObject obj = new ClassBodyObject(n, fileName, n.firstToken.beginLine, aspectName);
            obj.modifiers = modifiers;
            c.classBodyDecls.add(obj);
        } else {
            this.error("cannot add member to unknown class " + className, fileName, n.firstToken.beginLine);
        }
    }

    protected void addInterTypeDecl(String className, ClassBodyObject decl) {
        if (!this.interTypeDecls.containsKey(className)) {
            this.interTypeDecls.put(className, new ArrayList());
        }
        this.interTypeDecls.get(className).add(decl);
    }

    public void addClassBodyDecl(SimpleNode n, String className, String fileName, String aspectName) {
        this.addInterTypeDecl(className, new ClassBodyObject(n, fileName, n.firstToken.beginLine, aspectName));
    }

    public void addClassBodyDecl(SimpleNode n, String className, String fileName, String modifiers, String aspectName) {
        ClassBodyObject obj = new ClassBodyObject(n, fileName, n.firstToken.beginLine, aspectName);
        obj.modifiers = modifiers;
        this.addInterTypeDecl(className, obj);
    }

    public void processRefinements() {
        for (TypeDecl typeDecl : this.getTypeDecls()) {
            if (typeDecl instanceof InterfaceDecl) continue;
            typeDecl.processRefinedClassBodyDecls();
            typeDecl.processRefinedSynEqs();
            typeDecl.processRefinedInhEqs();
        }
    }

    public void processInterfaceRefinements() {
        for (TypeDecl typeDecl : this.getTypeDecls()) {
            if (!(typeDecl instanceof InterfaceDecl)) continue;
            typeDecl.processRefinedClassBodyDecls();
            typeDecl.processRefinedSynEqs();
            typeDecl.processRefinedInhEqs();
        }
    }

    public void addRefinedSynEq(String name, String className, SimpleNode rhs, String fileName, int startLine, int endLine, List list, String aspectName, SimpleNode node, String declaredAspect) {
        TypeDecl c = this.lookup(className);
        if (c != null) {
            SynEq equ = new SynEq();
            equ.setName(name);
            equ.setFileName(fileName);
            equ.setStartLine(startLine);
            equ.setEndLine(endLine);
            equ.setRHS(rhs);
            equ.setParameterList(list);
            equ.refinesAspect = aspectName;
            equ.setComment(Unparser.unparseComment(node));
            equ.setAspectName(declaredAspect);
            c.addRefinedSynEq(equ);
            equ.hostName = className;
        } else {
            this.error("cannot add equation for synthesized attribute " + name + " to unknown class " + className, fileName, startLine);
        }
    }

    public void addRefinedInhEq(String childName, String name, String className, SimpleNode rhs, String fileName, int startLine, int endLine, List list, String aspectName, SimpleNode node, String declaredAspect) {
        this.addRefinedInhEq(childName, name, className, rhs, fileName, startLine, endLine, list, null, aspectName, node, declaredAspect);
    }

    public void addRefinedInhEq(String childName, String name, String className, SimpleNode rhs, String fileName, int startLine, int endLine, List list, Parameter p, String aspectName, SimpleNode node, String declaredAspect) {
        TypeDecl c = this.lookup(className);
        if (c != null) {
            InhEq equ = new InhEq();
            equ.setName(name);
            equ.setFileName(fileName);
            equ.setStartLine(startLine);
            equ.setEndLine(endLine);
            equ.setRHS(rhs);
            equ.setChildName(childName);
            equ.setParameterList(list);
            equ.refinesAspect = aspectName;
            equ.setComment(Unparser.unparseComment(node));
            equ.setAspectName(declaredAspect);
            if (p != null) {
                equ.setIndex(p);
            }
            c.addRefinedInhEq(equ);
        } else {
            this.error("cannot add equation for inherited attribute " + name + " to unknown class " + className, fileName, startLine);
        }
    }

    public void addRefinedClassBodyDecl(SimpleNode n, String className, String fileName, String aspectName, String declaredAspect) {
        TypeDecl c = this.lookup(className);
        if (c != null) {
            ClassBodyObject o = new ClassBodyObject(n, fileName, n.firstToken.beginLine, declaredAspect);
            o.refinesAspect = aspectName;
            c.refinedClassBodyDecls.add(o);
            ++c.numRefinedCBDecls;
        } else {
            this.error("cannot add member to unknown class " + className + " in " + fileName);
        }
    }

    public void addImplicitNodeTypes() {
        ASTDecl cl = new ASTDecl();
        IdDecl name = new IdDecl();
        name.setID(this.config().astNodeType());
        cl.setIdDecl(name);
        cl.setFileName("");
        cl.modifiers = "public";
        this.addTypeDecl(cl);
        cl = new ASTDecl();
        name = new IdDecl();
        name.setID(this.config().listType());
        cl.setIdDecl(name);
        cl.setFileName("");
        cl.modifiers = "public";
        this.addTypeDecl(cl);
        cl = new ASTDecl();
        name = new IdDecl();
        name.setID(this.config().optType());
        cl.setIdDecl(name);
        cl.setFileName("");
        cl.modifiers = "public";
        this.addTypeDecl(cl);
    }

    public void genReset(PrintWriter out) {
        this.templateContext().expand("ASTState.reset", out);
    }

    public void emitStateClass(PrintWriter out) {
        this.templateContext().expand("ASTState", out);
    }

    public TypeDecl findClassDecl(String name, String comment, String fileName, int beginLine, String enclosingAspect) {
        TypeDecl t;
        if (!(comment = comment.trim()).startsWith("//") && !comment.startsWith("/*")) {
            comment = "";
        }
        if ((t = this.lookup(name)) == null) {
            t = new ClassDecl(new IdDecl(name), new List<ClassBodyDecl>(), new List<SynEq>(), new List<InhDecl>(), new List<InhEq>(), new List<Component>(), new List<CollDecl>(), new List<CollEq>(), fileName, beginLine, -1, comment, enclosingAspect);
            this.addTypeDecl(t);
        }
        return t;
    }

    public TypeDecl findInterfaceDecl(String name, String comment, String fileName, int beginLine, String enclosingAspect) {
        TypeDecl t;
        if (!(comment = comment.trim()).startsWith("//") && !comment.startsWith("/*")) {
            comment = "";
        }
        if ((t = this.lookup(name)) == null) {
            t = new InterfaceDecl(new IdDecl(name), new List<ClassBodyDecl>(), new List<SynEq>(), new List<InhDecl>(), new List<InhEq>(), new List<Component>(), new List<CollDecl>(), new List<CollEq>(), fileName, beginLine, -1, comment, enclosingAspect);
            this.addTypeDecl(t);
        }
        return t;
    }

    public TypeDecl findEnumDecl(String name, String comment, String fileName, int beginLine, String enclosingAspect) {
        TypeDecl t;
        if (!(comment = comment.trim()).startsWith("//") && !comment.startsWith("/*")) {
            comment = "";
        }
        if ((t = this.lookup(name)) == null) {
            t = new EnumDecl(new IdDecl(name), new List<ClassBodyDecl>(), new List<SynEq>(), new List<InhDecl>(), new List<InhEq>(), new List<Component>(), new List<CollDecl>(), new List<CollEq>(), fileName, beginLine, -1, comment, enclosingAspect);
            this.addTypeDecl(t);
        }
        return t;
    }

    public void genIncrementalDDGNode(PrintWriter out) {
        if (!this.config().incremental()) {
            return;
        }
        TemplateContext tt = this.templateContext();
        tt.expand("Grammar.emitDDGNode", out);
    }

    public Grammar(int i) {
        super(i);
        this.is$Final(true);
    }

    public Grammar(Ast p, int i) {
        this(i);
        this.parser = p;
    }

    public Grammar() {
        this(0);
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[2];
        this.setChild(new List(), 0);
        this.setChild(new List(), 1);
    }

    public Grammar(List<TypeDecl> p0, List<RegionDecl> p1) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
        this.is$Final(true);
    }

    @Override
    public void dumpTree(String indent, PrintStream out) {
        out.print(indent + "Grammar");
        String childIndent = indent + "  ";
        for (int i = 0; i < this.getNumChild(); ++i) {
            ((ASTNode)this.getChild(i)).dumpTree(childIndent, out);
        }
    }

    @Override
    public Object jjtAccept(AstVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        this.checkChild(n, i);
        super.jjtAddChild(n, i);
    }

    @Override
    public void checkChild(Node n, int i) {
        int k;
        if (i == 0) {
            if (!(n instanceof List)) {
                throw new Error("Child number 0 of Grammar has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            for (k = 0; k < ((List)n).getNumChildNoTransform(); ++k) {
                if (((List)n).getChildNoTransform(k) instanceof TypeDecl) continue;
                throw new Error("Child number " + k + " in TypeDeclList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of TypeDecl");
            }
        }
        if (i == 1) {
            if (!(n instanceof List)) {
                throw new Error("Child number 1 of Grammar has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            for (k = 0; k < ((List)n).getNumChildNoTransform(); ++k) {
                if (((List)n).getChildNoTransform(k) instanceof RegionDecl) continue;
                throw new Error("Child number " + k + " in RegionDeclList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of RegionDecl");
            }
        }
    }

    @Override
    public int getNumChild() {
        return 2;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void flushAttrCache() {
        super.flushAttrCache();
        this.packageDirectory_reset();
        this.templateContext_reset();
        this.synDeclMap_reset();
        this.synEqMap_reset();
        this.collEqMap_reset();
        this.inhEqMap_reset();
        this.missingInhEqs_reset();
        this.subclassMap_reset();
        this.parentMap_reset();
        this.roots_reset();
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
        this.Grammar_interfaceProblems_visited = -1;
        this.Grammar_interfaceProblems_computed = false;
        this.Grammar_interfaceProblems_value = null;
        this.Grammar_problems_visited = -1;
        this.Grammar_problems_computed = false;
        this.Grammar_problems_value = null;
        this.contributorMap_Grammar_interfaceProblems = null;
        this.contributorMap_Grammar_problems = null;
        this.contributorMap_InterfaceDecl_interfaceAttributeProblems = null;
        this.contributorMap_CollDecl_uses = null;
    }

    @Override
    public Grammar clone() throws CloneNotSupportedException {
        Grammar node = (Grammar)super.clone();
        return node;
    }

    public Grammar copy() {
        try {
            Grammar node = this.clone();
            node.parent = null;
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    @Deprecated
    public Grammar fullCopy() {
        return this.treeCopyNoTransform();
    }

    public Grammar treeCopyNoTransform() {
        Grammar tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode child = (ASTNode)this.children[i];
                if (child == null) continue;
                child = child.treeCopyNoTransform();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    public Grammar treeCopy() {
        this.doFullTraversal();
        return this.treeCopyNoTransform();
    }

    @Override
    protected boolean is$Equal(ASTNode node) {
        return super.is$Equal(node);
    }

    public void setTypeDeclList(List<TypeDecl> list) {
        this.setChild(list, 0);
    }

    public int getNumTypeDecl() {
        return this.getTypeDeclList().getNumChild();
    }

    public int getNumTypeDeclNoTransform() {
        return this.getTypeDeclListNoTransform().getNumChildNoTransform();
    }

    public TypeDecl getTypeDecl(int i) {
        return (TypeDecl)this.getTypeDeclList().getChild(i);
    }

    public boolean hasTypeDecl() {
        return this.getTypeDeclList().getNumChild() != 0;
    }

    public void addTypeDecl(TypeDecl node) {
        List<TypeDecl> list = this.parent == null ? this.getTypeDeclListNoTransform() : this.getTypeDeclList();
        list.addChild(node);
    }

    public void addTypeDeclNoTransform(TypeDecl node) {
        List<TypeDecl> list = this.getTypeDeclListNoTransform();
        list.addChild(node);
    }

    public void setTypeDecl(TypeDecl node, int i) {
        List<TypeDecl> list = this.getTypeDeclList();
        list.setChild(node, i);
    }

    @ASTNodeAnnotation.ListChild(name="TypeDecl")
    public List<TypeDecl> getTypeDeclList() {
        List list = (List)this.getChild(0);
        return list;
    }

    public List<TypeDecl> getTypeDeclListNoTransform() {
        return (List)this.getChildNoTransform(0);
    }

    public TypeDecl getTypeDeclNoTransform(int i) {
        return (TypeDecl)this.getTypeDeclListNoTransform().getChildNoTransform(i);
    }

    public List<TypeDecl> getTypeDecls() {
        return this.getTypeDeclList();
    }

    public List<TypeDecl> getTypeDeclsNoTransform() {
        return this.getTypeDeclListNoTransform();
    }

    public void setRegionDeclList(List<RegionDecl> list) {
        this.setChild(list, 1);
    }

    public int getNumRegionDecl() {
        return this.getRegionDeclList().getNumChild();
    }

    public int getNumRegionDeclNoTransform() {
        return this.getRegionDeclListNoTransform().getNumChildNoTransform();
    }

    public RegionDecl getRegionDecl(int i) {
        return (RegionDecl)this.getRegionDeclList().getChild(i);
    }

    public boolean hasRegionDecl() {
        return this.getRegionDeclList().getNumChild() != 0;
    }

    public void addRegionDecl(RegionDecl node) {
        List<RegionDecl> list = this.parent == null ? this.getRegionDeclListNoTransform() : this.getRegionDeclList();
        list.addChild(node);
    }

    public void addRegionDeclNoTransform(RegionDecl node) {
        List<RegionDecl> list = this.getRegionDeclListNoTransform();
        list.addChild(node);
    }

    public void setRegionDecl(RegionDecl node, int i) {
        List<RegionDecl> list = this.getRegionDeclList();
        list.setChild(node, i);
    }

    @ASTNodeAnnotation.ListChild(name="RegionDecl")
    public List<RegionDecl> getRegionDeclList() {
        List list = (List)this.getChild(1);
        return list;
    }

    public List<RegionDecl> getRegionDeclListNoTransform() {
        return (List)this.getChildNoTransform(1);
    }

    public RegionDecl getRegionDeclNoTransform(int i) {
        return (RegionDecl)this.getRegionDeclListNoTransform().getChildNoTransform(i);
    }

    public List<RegionDecl> getRegionDecls() {
        return this.getRegionDeclList();
    }

    public List<RegionDecl> getRegionDeclsNoTransform() {
        return this.getRegionDeclListNoTransform();
    }

    protected void survey_Grammar_interfaceProblems() {
        if (this.contributorMap_Grammar_interfaceProblems == null) {
            this.contributorMap_Grammar_interfaceProblems = new IdentityHashMap<ASTNode, Set<ASTNode>>();
            this.collect_contributors_Grammar_interfaceProblems(this, this.contributorMap_Grammar_interfaceProblems);
        }
    }

    protected void survey_Grammar_problems() {
        if (this.contributorMap_Grammar_problems == null) {
            this.contributorMap_Grammar_problems = new IdentityHashMap<ASTNode, Set<ASTNode>>();
            this.collect_contributors_Grammar_problems(this, this.contributorMap_Grammar_problems);
        }
    }

    protected void survey_InterfaceDecl_interfaceAttributeProblems() {
        if (this.contributorMap_InterfaceDecl_interfaceAttributeProblems == null) {
            this.contributorMap_InterfaceDecl_interfaceAttributeProblems = new IdentityHashMap<ASTNode, Set<ASTNode>>();
            this.collect_contributors_InterfaceDecl_interfaceAttributeProblems(this, this.contributorMap_InterfaceDecl_interfaceAttributeProblems);
        }
    }

    protected void survey_CollDecl_uses() {
        if (this.contributorMap_CollDecl_uses == null) {
            this.contributorMap_CollDecl_uses = new IdentityHashMap<ASTNode, Set<ASTNode>>();
            this.collect_contributors_CollDecl_uses(this, this.contributorMap_CollDecl_uses);
        }
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="OutputDestination", declaredAt="/jastadd/src/jastadd/core/Output.jrag:46")
    public File targetJavaFile(String typeName) {
        String _parameters = typeName;
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.targetJavaFile_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute Grammar.targetJavaFile(String).");
        }
        this.targetJavaFile_String_visited.put(_parameters, this.state().boundariesCrossed);
        File targetJavaFile_String_value = new File(this.packageDirectory(), typeName + ".java");
        this.targetJavaFile_String_visited.remove(_parameters);
        return targetJavaFile_String_value;
    }

    private void packageDirectory_reset() {
        this.packageDirectory_computed = false;
        this.packageDirectory_value = null;
        this.packageDirectory_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="OutputDestination", declaredAt="/jastadd/src/jastadd/core/Output.jrag:52")
    public File packageDirectory() {
        ASTNode$State state = this.state();
        if (this.packageDirectory_computed) {
            return this.packageDirectory_value;
        }
        if (this.packageDirectory_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute Grammar.packageDirectory().");
        }
        this.packageDirectory_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.packageDirectory_value = this.packageDirectory_compute();
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.packageDirectory_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.packageDirectory_visited = -1;
        return this.packageDirectory_value;
    }

    private File packageDirectory_compute() {
        String packageName = this.config().packageName();
        if (packageName.isEmpty()) {
            return this.config().outputDir();
        }
        String packagePath = packageName.replace('.', File.separatorChar);
        return new File(this.config().outputDir(), packagePath);
    }

    @Override
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Configuration", declaredAt="/jastadd/src/jastadd/core/Options.jrag:44")
    public Grammar grammar() {
        if (this.grammar_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute Grammar.grammar().");
        }
        this.grammar_visited = this.state().boundariesCrossed;
        Grammar grammar_value = this;
        this.grammar_visited = -1;
        return grammar_value;
    }

    @Override
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Configuration", declaredAt="/jastadd/src/jastadd/core/Options.jrag:58")
    public Configuration config() {
        if (this.config_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute Grammar.config().");
        }
        this.config_visited = this.state().boundariesCrossed;
        try {
            if (this.configuration == null) {
                throw new Error("Configuration object not initialized!");
            }
            Configuration configuration = this.configuration;
            return configuration;
        }
        finally {
            this.config_visited = -1;
        }
    }

    private void templateContext_reset() {
        this.templateContext_computed = false;
        this.templateContext_value = null;
        this.templateContext_visited = -1;
    }

    @Override
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="TemplateUtil", declaredAt="/jastadd/src/jastadd/core/TemplateUtil.jrag:36")
    public TemplateContext templateContext() {
        ASTNode$State state = this.state();
        if (this.templateContext_computed) {
            return this.templateContext_value;
        }
        if (this.templateContext_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTNode.templateContext().");
        }
        this.templateContext_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.templateContext_value = this.templateContext_compute();
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.templateContext_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.templateContext_visited = -1;
        return this.templateContext_value;
    }

    private TemplateContext templateContext_compute() {
        TinyTemplate tt = new TinyTemplate();
        tt.setIndentation(this.config().indent);
        TinyTemplate.throwExceptions(true);
        this.loadTemplates(tt, "ast/ASTNodeAnnotation");
        this.loadTemplates(tt, "ast/ASTNode");
        this.loadTemplates(tt, "ast/Attributes");
        this.loadTemplates(tt, "ast/Circular");
        this.loadTemplates(tt, "ast/CircularNTA");
        this.loadTemplates(tt, "ast/Collections");
        this.loadTemplates(tt, "ast/Comments");
        this.loadTemplates(tt, "ast/CopyNode");
        this.loadTemplates(tt, "ast/ImplicitDeclarations");
        this.loadTemplates(tt, "ast/InheritedAttributes");
        this.loadTemplates(tt, "ast/InterTypeDeclaration");
        this.loadTemplates(tt, "ast/JJTree");
        this.loadTemplates(tt, "ast/List");
        this.loadTemplates(tt, "ast/NodeConstructor");
        this.loadTemplates(tt, "ast/Rewrites");
        this.loadTemplates(tt, "ast/State");
        this.loadTemplates(tt, "ast/components/AggregateComponent");
        this.loadTemplates(tt, "ast/components/ListComponent");
        this.loadTemplates(tt, "ast/components/OptionalComponent");
        this.loadTemplates(tt, "ast/components/TokenComponent");
        this.loadTemplates(tt, "flush/Flush");
        if (this.config().incremental()) {
            this.loadTemplates(tt, "incremental/DDGNodeCopy");
            this.loadTemplates(tt, "incremental/Debug");
            this.loadTemplates(tt, "incremental/Notification");
            this.loadTemplates(tt, "incremental/Regions");
            this.loadTemplates(tt, "incremental/Rewrites");
        }
        this.loadTemplates(tt, "incremental/ASTChange");
        this.loadTemplates(tt, "incremental/DDGNode");
        this.loadTemplates(tt, "incremental/NTAs");
        this.loadTemplates(tt, "incremental/State");
        this.loadTemplates(tt, "incremental/Tracking");
        this.loadTemplates(tt, "incremental/Collections");
        this.loadTemplates(tt, "trace/Tracer");
        this.loadTemplates(tt, "trace/TraceHooks");
        if (this.config().concurrentEval()) {
            this.loadTemplates(tt, "concurrent/Attributes");
            this.loadTemplates(tt, "concurrent/InheritedAttributes");
            this.loadTemplates(tt, "concurrent/Collections");
            this.loadTemplates(tt, "concurrent/Flush");
            this.loadTemplates(tt, "concurrent/Circular");
            this.loadTemplates(tt, "concurrent/Trace");
        }
        return new SimpleContext(tt, this);
    }

    private void synDeclMap_reset() {
        this.synDeclMap_computed = false;
        this.synDeclMap_value = null;
        this.synDeclMap_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="AttributeWeaving", declaredAt="/jastadd/src/jastadd/ast/Weaving.jrag:42")
    public Map<String, Collection<SynDecl>> synDeclMap() {
        ASTNode$State state = this.state();
        if (this.synDeclMap_computed) {
            return this.synDeclMap_value;
        }
        if (this.synDeclMap_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute Grammar.synDeclMap().");
        }
        this.synDeclMap_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.synDeclMap_value = this.synDeclMap_compute();
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.synDeclMap_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.synDeclMap_visited = -1;
        return this.synDeclMap_value;
    }

    private Map<String, Collection<SynDecl>> synDeclMap_compute() {
        HashMap<String, Collection<SynDecl>> map = new HashMap<String, Collection<SynDecl>>();
        for (TypeDecl type : this.getTypeDecls()) {
            map.put(type.name(), new ArrayList());
        }
        for (SynDecl decl : this.grammar().synDecls) {
            if (!map.containsKey(decl.hostName)) continue;
            ((Collection)map.get(decl.hostName)).add(decl);
        }
        return map;
    }

    private void synEqMap_reset() {
        this.synEqMap_computed = false;
        this.synEqMap_value = null;
        this.synEqMap_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="AttributeWeaving", declaredAt="/jastadd/src/jastadd/ast/Weaving.jrag:89")
    public Map<String, Collection<SynEq>> synEqMap() {
        ASTNode$State state = this.state();
        if (this.synEqMap_computed) {
            return this.synEqMap_value;
        }
        if (this.synEqMap_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute Grammar.synEqMap().");
        }
        this.synEqMap_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.synEqMap_value = this.synEqMap_compute();
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.synEqMap_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.synEqMap_visited = -1;
        return this.synEqMap_value;
    }

    private Map<String, Collection<SynEq>> synEqMap_compute() {
        HashMap<String, Collection<SynEq>> map = new HashMap<String, Collection<SynEq>>();
        for (TypeDecl type : this.getTypeDecls()) {
            map.put(type.name(), new ArrayList());
        }
        for (SynEq equ : this.grammar().synEqs) {
            if (!map.containsKey(equ.hostName)) continue;
            ((Collection)map.get(equ.hostName)).add(equ);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="AttributeWeaving", declaredAt="/jastadd/src/jastadd/ast/Weaving.jrag:149")
    public Map<String, Collection<CollDecl>> collDeclMap() {
        if (this.collDeclMap_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute Grammar.collDeclMap().");
        }
        this.collDeclMap_visited = this.state().boundariesCrossed;
        try {
            HashMap map = new HashMap();
            for (TypeDecl type : this.getTypeDecls()) {
                map.put(type.name(), new ArrayList());
            }
            for (CollDecl decl : this.grammar().collDecls) {
                if (!map.containsKey(decl.hostName)) continue;
                ((Collection)map.get(decl.hostName)).add(decl);
            }
            HashMap hashMap = map;
            return hashMap;
        }
        finally {
            this.collDeclMap_visited = -1;
        }
    }

    private void collEqMap_reset() {
        this.collEqMap_computed = false;
        this.collEqMap_value = null;
        this.collEqMap_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="AttributeWeaving", declaredAt="/jastadd/src/jastadd/ast/Weaving.jrag:193")
    public Map<TypeDecl, Collection<CollEq>> collEqMap() {
        ASTNode$State state = this.state();
        if (this.collEqMap_computed) {
            return this.collEqMap_value;
        }
        if (this.collEqMap_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute Grammar.collEqMap().");
        }
        this.collEqMap_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.collEqMap_value = this.collEqMap_compute();
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.collEqMap_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.collEqMap_visited = -1;
        return this.collEqMap_value;
    }

    private Map<TypeDecl, Collection<CollEq>> collEqMap_compute() {
        HashMap<TypeDecl, Collection<CollEq>> typeDeclMap = new HashMap<TypeDecl, Collection<CollEq>>();
        for (TypeDecl type : this.getTypeDecls()) {
            typeDeclMap.put(type, new ArrayList());
        }
        for (CollEq collEq : this.grammar().collEqs) {
            TypeDecl target = this.lookup(collEq.getTarget());
            if (!typeDeclMap.containsKey(target)) continue;
            ((Collection)typeDeclMap.get(target)).add(collEq);
        }
        return typeDeclMap;
    }

    private void inhEqMap_reset() {
        this.inhEqMap_computed = false;
        this.inhEqMap_value = null;
        this.inhEqMap_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="JragCodeGen", declaredAt="/jastadd/src/jastadd/ast/JragCodeGen.jrag:968")
    public HashMap inhEqMap() {
        ASTNode$State state = this.state();
        if (this.inhEqMap_computed) {
            return this.inhEqMap_value;
        }
        if (this.inhEqMap_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute Grammar.inhEqMap().");
        }
        this.inhEqMap_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.inhEqMap_value = this.inhEqMap_compute();
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.inhEqMap_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.inhEqMap_visited = -1;
        return this.inhEqMap_value;
    }

    private HashMap inhEqMap_compute() {
        LinkedHashMap<String, LinkedList<InhEq>> map = new LinkedHashMap<String, LinkedList<InhEq>>();
        for (TypeDecl td : this.getTypeDecls()) {
            if (!(td instanceof ASTDecl)) continue;
            map.putAll(((ASTDecl)td).inhEqMap());
        }
        return map;
    }

    private void missingInhEqs_reset() {
        this.missingInhEqs_computed = false;
        this.missingInhEqs_value = null;
        this.missingInhEqs_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="FindInheritedEquations", declaredAt="/jastadd/src/jastadd/ast/InheritedAttributes.jrag:127")
    public Collection<InhDecl> missingInhEqs() {
        ASTNode$State state = this.state();
        if (this.missingInhEqs_computed) {
            return this.missingInhEqs_value;
        }
        if (this.missingInhEqs_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute Grammar.missingInhEqs().");
        }
        this.missingInhEqs_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.missingInhEqs_value = this.missingInhEqs_compute();
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.missingInhEqs_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.missingInhEqs_visited = -1;
        return this.missingInhEqs_value;
    }

    private Collection<InhDecl> missingInhEqs_compute() {
        HashSet<InhDecl> missing = new HashSet<InhDecl>();
        for (ASTDecl root : this.roots()) {
            missing.addAll(root.missingInhEqs());
        }
        return missing;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="AttributeProblems", declaredAt="/jastadd/src/jastadd/ast/AttributeProblems.jrag:44")
    public Collection<Problem> attributeProblems() {
        if (this.attributeProblems_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute Grammar.attributeProblems().");
        }
        this.attributeProblems_visited = this.state().boundariesCrossed;
        try {
            LinkedList<Problem> problems = new LinkedList<Problem>();
            if (this.config().inhEqCheck()) {
                problems.addAll(this.missingInhEqProblems());
            }
            for (int i = 0; i < this.getNumTypeDecl(); ++i) {
                problems.addAll(this.getTypeDecl(i).attributeProblems());
            }
            LinkedList<Problem> linkedList = problems;
            return linkedList;
        }
        finally {
            this.attributeProblems_visited = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="AttributeProblems", declaredAt="/jastadd/src/jastadd/ast/AttributeProblems.jrag:55")
    public Collection<Problem> missingInhEqProblems() {
        if (this.missingInhEqProblems_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute Grammar.missingInhEqProblems().");
        }
        this.missingInhEqProblems_visited = this.state().boundariesCrossed;
        try {
            LinkedList<Problem> problems = new LinkedList<Problem>();
            for (InhDecl inhDecl : this.missingInhEqs()) {
                if (inhDecl.hostClass().isRootNode()) continue;
                StringBuilder buf = new StringBuilder();
                buf.append("missing inherited equation for attribute " + inhDecl.name() + " ");
                boolean first1 = true;
                for (Map.Entry<ASTDecl, Map<ASTDecl, String>> e : inhDecl.missingEqs().entrySet()) {
                    if (!first1) {
                        buf.append(", and ");
                    }
                    first1 = false;
                    buf.append("in class " + e.getKey().name() + " when being child of ");
                    boolean first2 = true;
                    for (Map.Entry<ASTDecl, String> parent : e.getValue().entrySet()) {
                        if (!first2) {
                            buf.append(", ");
                        }
                        first2 = false;
                        buf.append(parent.getKey().name());
                        buf.append(" (path: " + parent.getValue() + ")");
                    }
                }
                problems.add(inhDecl.warning(buf.toString()));
            }
            LinkedList<Problem> linkedList = problems;
            return linkedList;
        }
        finally {
            this.missingInhEqProblems_visited = -1;
        }
    }

    private void subclassMap_reset() {
        this.subclassMap_computed = false;
        this.subclassMap_value = null;
        this.subclassMap_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Subclasses", declaredAt="/jastadd/src/jastadd/ast/ClassRelations.jrag:89")
    public Map<ASTDecl, Collection<ASTDecl>> subclassMap() {
        ASTNode$State state = this.state();
        if (this.subclassMap_computed) {
            return this.subclassMap_value;
        }
        if (this.subclassMap_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute Grammar.subclassMap().");
        }
        this.subclassMap_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.subclassMap_value = this.subclassMap_compute();
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.subclassMap_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.subclassMap_visited = -1;
        return this.subclassMap_value;
    }

    private Map<ASTDecl, Collection<ASTDecl>> subclassMap_compute() {
        ASTDecl decl;
        HashMap<ASTDecl, Collection<ASTDecl>> map = new HashMap<ASTDecl, Collection<ASTDecl>>();
        for (TypeDecl td : this.getTypeDecls()) {
            if (!(td instanceof ASTDecl)) continue;
            decl = (ASTDecl)td;
            map.put(decl, new ArrayList());
        }
        for (TypeDecl td : this.getTypeDecls()) {
            if (!(td instanceof ASTDecl) || (decl = (ASTDecl)td).superClass() == null) continue;
            ((Collection)map.get(decl.superClass())).add(decl);
        }
        return map;
    }

    private void parentMap_reset() {
        this.parentMap_computed = false;
        this.parentMap_value = null;
        this.parentMap_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Parents", declaredAt="/jastadd/src/jastadd/ast/ClassRelations.jrag:128")
    public HashMap<TypeDecl, Collection<ASTDecl>> parentMap() {
        ASTNode$State state = this.state();
        if (this.parentMap_computed) {
            return this.parentMap_value;
        }
        if (this.parentMap_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute Grammar.parentMap().");
        }
        this.parentMap_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.parentMap_value = this.parentMap_compute();
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.parentMap_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.parentMap_visited = -1;
        return this.parentMap_value;
    }

    private HashMap<TypeDecl, Collection<ASTDecl>> parentMap_compute() {
        LinkedHashMap<TypeDecl, Collection<ASTDecl>> map = new LinkedHashMap<TypeDecl, Collection<ASTDecl>>();
        for (TypeDecl td : this.getTypeDecls()) {
            if (!(td instanceof ASTDecl)) continue;
            map.put(td, new LinkedHashSet());
        }
        for (TypeDecl td : this.getTypeDecls()) {
            TypeDecl t;
            if (!(td instanceof ASTDecl)) continue;
            ASTDecl decl = (ASTDecl)td;
            for (Component component : decl.components()) {
                if (component instanceof TokenComponent || (t = this.lookup(component.type())) == null) continue;
                ((Collection)((HashMap)map).get(t)).add(decl);
            }
            for (SynthesizedNta synthesizedNta : decl.synNtaDecls()) {
                t = this.lookup(synthesizedNta.getType());
                if (!(t instanceof ASTDecl)) continue;
                ((Collection)((HashMap)map).get(t)).add(decl);
            }
        }
        return map;
    }

    private void roots_reset() {
        this.roots_computed = false;
        this.roots_value = null;
        this.roots_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="CollectionAttributes", declaredAt="/jastadd/src/jastadd/ast/CollectionAttributes.jrag:452")
    public Collection<ASTDecl> roots() {
        ASTNode$State state = this.state();
        if (this.roots_computed) {
            return this.roots_value;
        }
        if (this.roots_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute Grammar.roots().");
        }
        this.roots_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.roots_value = this.roots_compute();
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.roots_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.roots_visited = -1;
        return this.roots_value;
    }

    private Collection<ASTDecl> roots_compute() {
        HashSet<ASTDecl> roots = new HashSet<ASTDecl>();
        for (TypeDecl decl : this.getTypeDeclList()) {
            if (!decl.isRootNode()) continue;
            roots.add((ASTDecl)decl);
        }
        return roots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="CollectionAttributes", declaredAt="/jastadd/src/jastadd/ast/CollectionAttributes.jrag:566")
    public CollDecl lookupCollDecl(String hostName, String collName) {
        ArrayList<String> _parameters = new ArrayList<String>(2);
        _parameters.add(hostName);
        _parameters.add(collName);
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.lookupCollDecl_String_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute Grammar.lookupCollDecl(String,String).");
        }
        this.lookupCollDecl_String_String_visited.put(_parameters, this.state().boundariesCrossed);
        try {
            TypeDecl typeDecl = this.lookup(hostName);
            if (typeDecl != null) {
                for (CollDecl decl : typeDecl.collDecls()) {
                    if (!decl.getName().equals(collName)) continue;
                    CollDecl collDecl = decl;
                    return collDecl;
                }
            }
            Iterator<CollDecl> iterator = null;
            return iterator;
        }
        finally {
            this.lookupCollDecl_String_String_visited.remove(_parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Lookup", declaredAt="/jastadd/src/jastadd/ast/ASTNameBinding.jrag:32")
    public TypeDecl lookup(String name) {
        String _parameters = name;
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.lookup_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute Grammar.lookup(String).");
        }
        this.lookup_String_visited.put(_parameters, this.state().boundariesCrossed);
        try {
            for (TypeDecl td : this.getTypeDecls()) {
                if (!td.name().equals(name)) continue;
                TypeDecl typeDecl = td;
                return typeDecl;
            }
            Iterator<TypeDecl> iterator = null;
            return iterator;
        }
        finally {
            this.lookup_String_visited.remove(_parameters);
        }
    }

    @Override
    public Grammar Define_grammar(ASTNode _callerNode, ASTNode _childNode) {
        int childIndex = this.getIndexOfChild(_callerNode);
        return this;
    }

    @Override
    protected boolean canDefine_grammar(ASTNode _callerNode, ASTNode _childNode) {
        return true;
    }

    @Override
    public Configuration Define_config(ASTNode _callerNode, ASTNode _childNode) {
        int childIndex = this.getIndexOfChild(_callerNode);
        return this.config();
    }

    @Override
    protected boolean canDefine_config(ASTNode _callerNode, ASTNode _childNode) {
        return true;
    }

    @Override
    public TemplateContext Define_parentContext(ASTNode _callerNode, ASTNode _childNode) {
        int childIndex = this.getIndexOfChild(_callerNode);
        return this.templateContext();
    }

    @Override
    protected boolean canDefine_parentContext(ASTNode _callerNode, ASTNode _childNode) {
        return true;
    }

    @Override
    public boolean Define_insideInterface(ASTNode _callerNode, ASTNode _childNode) {
        int childIndex = this.getIndexOfChild(_callerNode);
        return false;
    }

    @Override
    protected boolean canDefine_insideInterface(ASTNode _callerNode, ASTNode _childNode) {
        return true;
    }

    @Override
    public Collection<ASTDecl> Define_findSubclasses(ASTNode _callerNode, ASTNode _childNode, ASTDecl target) {
        if (_callerNode == this.getTypeDeclListNoTransform()) {
            int childIndex = _callerNode.getIndexOfChild(_childNode);
            return this.subclassMap().get(target);
        }
        return this.getParent().Define_findSubclasses(this, _callerNode, target);
    }

    @Override
    protected boolean canDefine_findSubclasses(ASTNode _callerNode, ASTNode _childNode, ASTDecl target) {
        return true;
    }

    @Override
    public RegionDecl Define_lookupRegionDecl(ASTNode _callerNode, ASTNode _childNode, String name) {
        if (_callerNode == this.getTypeDeclListNoTransform()) {
            int childIndex = _callerNode.getIndexOfChild(_childNode);
            for (int i = 0; i < this.getNumRegionDecl(); ++i) {
                RegionDecl decl = this.getRegionDecl(i);
                if (!decl.name().equals(name)) continue;
                return decl;
            }
            return null;
        }
        return this.getParent().Define_lookupRegionDecl(this, _callerNode, name);
    }

    @Override
    protected boolean canDefine_lookupRegionDecl(ASTNode _callerNode, ASTNode _childNode, String name) {
        return true;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.COLL)
    @ASTNodeAnnotation.Source(aspect="Grammar", declaredAt="/jastadd/src/jastadd/ast/Grammar.jrag:96")
    public Collection<Problem> interfaceProblems() {
        ASTNode$State state = this.state();
        if (this.Grammar_interfaceProblems_computed) {
            return this.Grammar_interfaceProblems_value;
        }
        if (this.Grammar_interfaceProblems_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute Grammar.interfaceProblems().");
        }
        this.Grammar_interfaceProblems_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.Grammar_interfaceProblems_value = this.interfaceProblems_compute();
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.Grammar_interfaceProblems_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.Grammar_interfaceProblems_visited = -1;
        return this.Grammar_interfaceProblems_value;
    }

    private Collection<Problem> interfaceProblems_compute() {
        ASTNode node;
        for (node = this; node != null && !(node instanceof Grammar); node = node.getParent()) {
        }
        Grammar root = node;
        root.survey_Grammar_interfaceProblems();
        LinkedList<Problem> _computedValue = new LinkedList<Problem>();
        if (root.contributorMap_Grammar_interfaceProblems.containsKey(this)) {
            for (ASTNode contributor : root.contributorMap_Grammar_interfaceProblems.get(this)) {
                contributor.contributeTo_Grammar_interfaceProblems(_computedValue);
            }
        }
        return _computedValue;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.COLL)
    @ASTNodeAnnotation.Source(aspect="ASTErrors", declaredAt="/jastadd/src/jastadd/ast/ASTErrors.jrag:42")
    public Collection<Problem> problems() {
        ASTNode$State state = this.state();
        if (this.Grammar_problems_computed) {
            return this.Grammar_problems_value;
        }
        if (this.Grammar_problems_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute Grammar.problems().");
        }
        this.Grammar_problems_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.Grammar_problems_value = this.problems_compute();
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.Grammar_problems_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.Grammar_problems_visited = -1;
        return this.Grammar_problems_value;
    }

    private Collection<Problem> problems_compute() {
        ASTNode node;
        for (node = this; node != null && !(node instanceof Grammar); node = node.getParent()) {
        }
        Grammar root = node;
        root.survey_Grammar_problems();
        LinkedList<Problem> _computedValue = new LinkedList<Problem>();
        if (root.contributorMap_Grammar_problems.containsKey(this)) {
            for (ASTNode contributor : root.contributorMap_Grammar_problems.get(this)) {
                contributor.contributeTo_Grammar_problems(_computedValue);
            }
        }
        return _computedValue;
    }

    @Override
    protected void collect_contributors_Grammar_problems(Grammar _root, Map<ASTNode, Set<ASTNode>> _map) {
        if (this.roots().isEmpty()) {
            Grammar target = this;
            Set<ASTNode> contributors = _map.get(target);
            if (contributors == null) {
                contributors = new LinkedHashSet<ASTNode>();
                _map.put(target, contributors);
            }
            contributors.add(this);
        }
        for (CollDecl decl : this.collDecls) {
            decl.collect_contributors_Grammar_problems(_root, _map);
        }
        super.collect_contributors_Grammar_problems(_root, _map);
    }

    @Override
    protected void contributeTo_Grammar_problems(Collection<Problem> collection) {
        super.contributeTo_Grammar_problems(collection);
        if (this.roots().isEmpty()) {
            collection.add(Problem.builder().message("there is no root node in the grammar!").buildWarning());
        }
    }
}

