/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.ast.AST;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.jastadd.ast.AST.InheritanceOrder;

public class InheritanceConstraintOrdering<IOE extends InheritanceOrder<IOE>> {
    private Set<IOE> allInterfaces;

    public InheritanceConstraintOrdering(Collection<IOE> elements) {
        this.allInterfaces = new HashSet<IOE>(elements);
    }

    public InheritanceConstraintOrdering() {
        this(new ArrayList());
    }

    public ArrayList<IOE> getOrdered() {
        ArrayList<IOE> ioesBase = new ArrayList<IOE>(this.allInterfaces);
        Collections.sort(ioesBase, new Comparator<IOE>(){

            @Override
            public int compare(IOE if0, IOE if1) {
                return if0.name().compareTo(if1.name());
            }
        });
        ArrayList<InheritanceOrder> result = new ArrayList<InheritanceOrder>();
        LinkedList<IOE> ioes = new LinkedList<IOE>(ioesBase);
        while (!ioes.isEmpty()) {
            int lastSize = ioes.size();
            Iterator it = ioes.iterator();
            while (it.hasNext()) {
                InheritanceOrder candidate = (InheritanceOrder)it.next();
                for (InheritanceOrder remaining : ioes) {
                    if (!remaining.isSubInterfaceOf(candidate)) continue;
                    candidate = null;
                    break;
                }
                if (candidate == null) continue;
                result.add(candidate);
                it.remove();
            }
            if (ioes.size() < lastSize) continue;
            return result;
        }
        return result;
    }
}

