/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.ast.AST;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.jastadd.Problem;
import org.jastadd.ast.AST.ASTNode;
import org.jastadd.ast.AST.ASTNode$State;
import org.jastadd.ast.AST.ASTNodeAnnotation;
import org.jastadd.ast.AST.Ast;
import org.jastadd.ast.AST.AstVisitor;
import org.jastadd.ast.AST.ClassBodyDecl;
import org.jastadd.ast.AST.CollDecl;
import org.jastadd.ast.AST.CollEq;
import org.jastadd.ast.AST.Component;
import org.jastadd.ast.AST.Grammar;
import org.jastadd.ast.AST.IdDecl;
import org.jastadd.ast.AST.InhDecl;
import org.jastadd.ast.AST.InhEq;
import org.jastadd.ast.AST.InheritanceOrder;
import org.jastadd.ast.AST.List;
import org.jastadd.ast.AST.Node;
import org.jastadd.ast.AST.SynEq;
import org.jastadd.ast.AST.TypeDecl;
import org.jastadd.jrag.AST.ASTAspectMethodDeclaration;
import org.jastadd.jrag.AST.ASTAspectRefineMethodDeclaration;
import org.jastadd.jrag.AST.ASTBlock;
import org.jastadd.jrag.AST.SimpleNode;
import org.jastadd.jrag.ClassBodyDeclUnparser;
import org.jastadd.jrag.ClassBodyObject;
import org.jastadd.jrag.Unparser;

public class InterfaceDecl
extends TypeDecl
implements Cloneable,
InheritanceOrder<InterfaceDecl> {
    protected int typeDeclKind_visited = -1;
    protected int attributeProblems_visited = -1;
    protected Map missingSynEqs_String_visited = new HashMap(4);
    protected int asInterfaceDecl_visited = -1;
    protected int InterfaceDecl_interfaceAttributeProblems_visited = -1;
    protected boolean InterfaceDecl_interfaceAttributeProblems_computed = false;
    protected Collection<Problem> InterfaceDecl_interfaceAttributeProblems_value;

    @Override
    public String typeDeclarationString() {
        String interfaces = this.interfacesString();
        if (interfaces.equals("")) {
            return String.format("%sinterface %s%s {", this.modifiers(), this.getIdDecl().getID(), this.typeParameters);
        }
        return String.format("%sinterface %s%s extends %s {", this.modifiers(), this.getIdDecl().getID(), this.typeParameters, interfaces);
    }

    @Override
    public void jastAddGen(boolean publicModifier) {
        File file = this.grammar().targetJavaFile(this.name());
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintStream stream = new PrintStream((OutputStream)bos, true, "UTF-8");
            stream.println(this.docComment());
            this.templateContext().expand("TypeDecl.generatedAnnotations", stream);
            stream.println(this.typeDeclarationString());
            this.emitMembers(stream);
            this.emitAbstractSyns(stream);
            this.emitInhDeclarations(stream);
            stream.println("}");
            stream.close();
            String code = new String(bos.toByteArray(), StandardCharsets.UTF_8);
            PrintStream fstream = new PrintStream(new FileOutputStream(file));
            if (!this.config().license.isEmpty()) {
                fstream.println(this.config().license);
            }
            if (!this.config().packageName().isEmpty()) {
                fstream.println("package " + this.config().packageName() + ";\n");
            }
            fstream.println(this.grammar().genImportsList(code));
            fstream.print(code);
            fstream.close();
        }
        catch (IOException e) {
            System.err.println("Could not create file " + file.getName() + " in " + file.getParent());
            System.exit(1);
        }
    }

    @Override
    public void emitMembers(PrintStream out) {
        for (ClassBodyObject obj : this.classBodyDecls) {
            SimpleNode decl;
            StringBuffer buf;
            SimpleNode n = obj.node;
            if (n instanceof ASTAspectMethodDeclaration) {
                try {
                    buf = new StringBuffer();
                    decl = (ASTAspectMethodDeclaration)n;
                    ClassBodyDeclUnparser.unparseAbstract(decl, buf);
                    out.print(buf);
                }
                catch (Exception e) {
                    System.err.println("Error generating " + obj.signature() + " in " + this.name());
                    e.printStackTrace();
                }
            } else if (n instanceof ASTAspectRefineMethodDeclaration) {
                try {
                    buf = new StringBuffer();
                    decl = (ASTAspectRefineMethodDeclaration)n;
                    ClassBodyDeclUnparser.unparseAbstract((ASTAspectRefineMethodDeclaration)decl, buf);
                    out.print(buf);
                }
                catch (Exception e) {
                    System.err.println("Error generating " + obj.signature() + " in " + this.name());
                    e.printStackTrace();
                }
            } else if (n instanceof ASTBlock) {
                String block = Unparser.unparse(n);
                if (block.contains("/* interface implementation */")) {
                    out.print(block);
                }
            } else {
                if (!obj.comments.isEmpty()) {
                    out.print(obj.comments + " ");
                }
                out.print(obj.modifiers());
                buf = new StringBuffer();
                n.jjtAccept(new ClassBodyDeclUnparser(), buf);
                out.print(buf.toString());
            }
            out.println();
        }
    }

    @Override
    public boolean isSubInterfaceOf(InterfaceDecl other) {
        return this.transitiveSuperInterfacesSet().contains(other);
    }

    public InterfaceDecl(int i) {
        super(i);
    }

    public InterfaceDecl(Ast p, int i) {
        this(i);
        this.parser = p;
    }

    public InterfaceDecl() {
        this(0);
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[8];
        this.setChild(new List(), 1);
        this.setChild(new List(), 2);
        this.setChild(new List(), 3);
        this.setChild(new List(), 4);
        this.setChild(new List(), 5);
        this.setChild(new List(), 6);
        this.setChild(new List(), 7);
    }

    public InterfaceDecl(IdDecl p0, List<ClassBodyDecl> p1, List<SynEq> p2, List<InhDecl> p3, List<InhEq> p4, List<Component> p5, List<CollDecl> p6, List<CollEq> p7, String p8, int p9, int p10, String p11, String p12) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
        this.setChild(p2, 2);
        this.setChild(p3, 3);
        this.setChild(p4, 4);
        this.setChild(p5, 5);
        this.setChild(p6, 6);
        this.setChild(p7, 7);
        this.setFileName(p8);
        this.setStartLine(p9);
        this.setEndLine(p10);
        this.setComment(p11);
        this.setAspectName(p12);
    }

    @Override
    public void dumpTree(String indent, PrintStream out) {
        out.print(indent + "InterfaceDecl");
        out.print("\"" + this.getFileName() + "\"");
        out.print("\"" + this.getStartLine() + "\"");
        out.print("\"" + this.getEndLine() + "\"");
        out.print("\"" + this.getComment() + "\"");
        out.print("\"" + this.getAspectName() + "\"");
        String childIndent = indent + "  ";
        for (int i = 0; i < this.getNumChild(); ++i) {
            ((ASTNode)this.getChild(i)).dumpTree(childIndent, out);
        }
    }

    @Override
    public Object jjtAccept(AstVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        this.checkChild(n, i);
        super.jjtAddChild(n, i);
    }

    @Override
    public void checkChild(Node n, int i) {
        int k;
        if (i == 0 && !(n instanceof IdDecl)) {
            throw new Error("Child number 0 of TypeDecl has the type " + n.getClass().getName() + " which is not an instance of IdDecl");
        }
        if (i == 1) {
            if (!(n instanceof List)) {
                throw new Error("Child number 1 of TypeDecl has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            for (k = 0; k < ((List)n).getNumChildNoTransform(); ++k) {
                if (((List)n).getChildNoTransform(k) instanceof ClassBodyDecl) continue;
                throw new Error("Child number " + k + " in ClassBodyDeclList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of ClassBodyDecl");
            }
        }
        if (i == 2) {
            if (!(n instanceof List)) {
                throw new Error("Child number 2 of TypeDecl has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            for (k = 0; k < ((List)n).getNumChildNoTransform(); ++k) {
                if (((List)n).getChildNoTransform(k) instanceof SynEq) continue;
                throw new Error("Child number " + k + " in SynEqList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of SynEq");
            }
        }
        if (i == 3) {
            if (!(n instanceof List)) {
                throw new Error("Child number 3 of TypeDecl has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            for (k = 0; k < ((List)n).getNumChildNoTransform(); ++k) {
                if (((List)n).getChildNoTransform(k) instanceof InhDecl) continue;
                throw new Error("Child number " + k + " in InhDeclList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of InhDecl");
            }
        }
        if (i == 4) {
            if (!(n instanceof List)) {
                throw new Error("Child number 4 of TypeDecl has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            for (k = 0; k < ((List)n).getNumChildNoTransform(); ++k) {
                if (((List)n).getChildNoTransform(k) instanceof InhEq) continue;
                throw new Error("Child number " + k + " in InhEqList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of InhEq");
            }
        }
        if (i == 5) {
            if (!(n instanceof List)) {
                throw new Error("Child number 5 of TypeDecl has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            for (k = 0; k < ((List)n).getNumChildNoTransform(); ++k) {
                if (((List)n).getChildNoTransform(k) instanceof Component) continue;
                throw new Error("Child number " + k + " in ComponentList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of Component");
            }
        }
        if (i == 6) {
            if (!(n instanceof List)) {
                throw new Error("Child number 6 of TypeDecl has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            for (k = 0; k < ((List)n).getNumChildNoTransform(); ++k) {
                if (((List)n).getChildNoTransform(k) instanceof CollDecl) continue;
                throw new Error("Child number " + k + " in CollDeclList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of CollDecl");
            }
        }
        if (i == 7) {
            if (!(n instanceof List)) {
                throw new Error("Child number 7 of TypeDecl has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            for (k = 0; k < ((List)n).getNumChildNoTransform(); ++k) {
                if (((List)n).getChildNoTransform(k) instanceof CollEq) continue;
                throw new Error("Child number " + k + " in CollEqList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of CollEq");
            }
        }
    }

    @Override
    public int getNumChild() {
        return 8;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void flushAttrCache() {
        super.flushAttrCache();
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
        this.InterfaceDecl_interfaceAttributeProblems_visited = -1;
        this.InterfaceDecl_interfaceAttributeProblems_computed = false;
        this.InterfaceDecl_interfaceAttributeProblems_value = null;
    }

    @Override
    public InterfaceDecl clone() throws CloneNotSupportedException {
        InterfaceDecl node = (InterfaceDecl)super.clone();
        return node;
    }

    public InterfaceDecl copy() {
        try {
            InterfaceDecl node = this.clone();
            node.parent = null;
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    @Override
    @Deprecated
    public InterfaceDecl fullCopy() {
        return this.treeCopyNoTransform();
    }

    @Override
    public InterfaceDecl treeCopyNoTransform() {
        InterfaceDecl tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode child = (ASTNode)this.children[i];
                if (child == null) continue;
                child = child.treeCopyNoTransform();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    @Override
    public InterfaceDecl treeCopy() {
        this.doFullTraversal();
        return this.treeCopyNoTransform();
    }

    @Override
    protected boolean is$Equal(ASTNode node) {
        return super.is$Equal(node) && this.tokenString_FileName == ((InterfaceDecl)node).tokenString_FileName && this.tokenint_StartLine == ((InterfaceDecl)node).tokenint_StartLine && this.tokenint_EndLine == ((InterfaceDecl)node).tokenint_EndLine && this.tokenString_Comment == ((InterfaceDecl)node).tokenString_Comment && this.tokenString_AspectName == ((InterfaceDecl)node).tokenString_AspectName;
    }

    @Override
    public void setIdDecl(IdDecl node) {
        this.setChild(node, 0);
    }

    @Override
    @ASTNodeAnnotation.Child(name="IdDecl")
    public IdDecl getIdDecl() {
        return (IdDecl)this.getChild(0);
    }

    @Override
    public IdDecl getIdDeclNoTransform() {
        return (IdDecl)this.getChildNoTransform(0);
    }

    @Override
    public void setClassBodyDeclList(List<ClassBodyDecl> list) {
        this.setChild(list, 1);
    }

    @Override
    public int getNumClassBodyDecl() {
        return this.getClassBodyDeclList().getNumChild();
    }

    @Override
    public int getNumClassBodyDeclNoTransform() {
        return this.getClassBodyDeclListNoTransform().getNumChildNoTransform();
    }

    @Override
    public ClassBodyDecl getClassBodyDecl(int i) {
        return (ClassBodyDecl)this.getClassBodyDeclList().getChild(i);
    }

    @Override
    public boolean hasClassBodyDecl() {
        return this.getClassBodyDeclList().getNumChild() != 0;
    }

    @Override
    public void addClassBodyDecl(ClassBodyDecl node) {
        List<ClassBodyDecl> list = this.parent == null ? this.getClassBodyDeclListNoTransform() : this.getClassBodyDeclList();
        list.addChild(node);
    }

    @Override
    public void addClassBodyDeclNoTransform(ClassBodyDecl node) {
        List<ClassBodyDecl> list = this.getClassBodyDeclListNoTransform();
        list.addChild(node);
    }

    @Override
    public void setClassBodyDecl(ClassBodyDecl node, int i) {
        List<ClassBodyDecl> list = this.getClassBodyDeclList();
        list.setChild(node, i);
    }

    @Override
    @ASTNodeAnnotation.ListChild(name="ClassBodyDecl")
    public List<ClassBodyDecl> getClassBodyDeclList() {
        List list = (List)this.getChild(1);
        return list;
    }

    @Override
    public List<ClassBodyDecl> getClassBodyDeclListNoTransform() {
        return (List)this.getChildNoTransform(1);
    }

    @Override
    public ClassBodyDecl getClassBodyDeclNoTransform(int i) {
        return (ClassBodyDecl)this.getClassBodyDeclListNoTransform().getChildNoTransform(i);
    }

    @Override
    public List<ClassBodyDecl> getClassBodyDecls() {
        return this.getClassBodyDeclList();
    }

    @Override
    public List<ClassBodyDecl> getClassBodyDeclsNoTransform() {
        return this.getClassBodyDeclListNoTransform();
    }

    @Override
    public void setSynEqList(List<SynEq> list) {
        this.setChild(list, 2);
    }

    @Override
    public int getNumSynEq() {
        return this.getSynEqList().getNumChild();
    }

    @Override
    public int getNumSynEqNoTransform() {
        return this.getSynEqListNoTransform().getNumChildNoTransform();
    }

    @Override
    public SynEq getSynEq(int i) {
        return (SynEq)this.getSynEqList().getChild(i);
    }

    @Override
    public boolean hasSynEq() {
        return this.getSynEqList().getNumChild() != 0;
    }

    @Override
    public void addSynEq(SynEq node) {
        List<SynEq> list = this.parent == null ? this.getSynEqListNoTransform() : this.getSynEqList();
        list.addChild(node);
    }

    @Override
    public void addSynEqNoTransform(SynEq node) {
        List<SynEq> list = this.getSynEqListNoTransform();
        list.addChild(node);
    }

    @Override
    public void setSynEq(SynEq node, int i) {
        List<SynEq> list = this.getSynEqList();
        list.setChild(node, i);
    }

    @Override
    @ASTNodeAnnotation.ListChild(name="SynEq")
    public List<SynEq> getSynEqList() {
        List list = (List)this.getChild(2);
        return list;
    }

    @Override
    public List<SynEq> getSynEqListNoTransform() {
        return (List)this.getChildNoTransform(2);
    }

    @Override
    public SynEq getSynEqNoTransform(int i) {
        return (SynEq)this.getSynEqListNoTransform().getChildNoTransform(i);
    }

    @Override
    public List<SynEq> getSynEqs() {
        return this.getSynEqList();
    }

    @Override
    public List<SynEq> getSynEqsNoTransform() {
        return this.getSynEqListNoTransform();
    }

    @Override
    public void setInhDeclList(List<InhDecl> list) {
        this.setChild(list, 3);
    }

    @Override
    public int getNumInhDecl() {
        return this.getInhDeclList().getNumChild();
    }

    @Override
    public int getNumInhDeclNoTransform() {
        return this.getInhDeclListNoTransform().getNumChildNoTransform();
    }

    @Override
    public InhDecl getInhDecl(int i) {
        return (InhDecl)this.getInhDeclList().getChild(i);
    }

    @Override
    public boolean hasInhDecl() {
        return this.getInhDeclList().getNumChild() != 0;
    }

    @Override
    public void addInhDecl(InhDecl node) {
        List<InhDecl> list = this.parent == null ? this.getInhDeclListNoTransform() : this.getInhDeclList();
        list.addChild(node);
    }

    @Override
    public void addInhDeclNoTransform(InhDecl node) {
        List<InhDecl> list = this.getInhDeclListNoTransform();
        list.addChild(node);
    }

    @Override
    public void setInhDecl(InhDecl node, int i) {
        List<InhDecl> list = this.getInhDeclList();
        list.setChild(node, i);
    }

    @Override
    @ASTNodeAnnotation.ListChild(name="InhDecl")
    public List<InhDecl> getInhDeclList() {
        List list = (List)this.getChild(3);
        return list;
    }

    @Override
    public List<InhDecl> getInhDeclListNoTransform() {
        return (List)this.getChildNoTransform(3);
    }

    @Override
    public InhDecl getInhDeclNoTransform(int i) {
        return (InhDecl)this.getInhDeclListNoTransform().getChildNoTransform(i);
    }

    @Override
    public List<InhDecl> getInhDecls() {
        return this.getInhDeclList();
    }

    @Override
    public List<InhDecl> getInhDeclsNoTransform() {
        return this.getInhDeclListNoTransform();
    }

    @Override
    public void setInhEqList(List<InhEq> list) {
        this.setChild(list, 4);
    }

    @Override
    public int getNumInhEq() {
        return this.getInhEqList().getNumChild();
    }

    @Override
    public int getNumInhEqNoTransform() {
        return this.getInhEqListNoTransform().getNumChildNoTransform();
    }

    @Override
    public InhEq getInhEq(int i) {
        return (InhEq)this.getInhEqList().getChild(i);
    }

    @Override
    public boolean hasInhEq() {
        return this.getInhEqList().getNumChild() != 0;
    }

    @Override
    public void addInhEq(InhEq node) {
        List<InhEq> list = this.parent == null ? this.getInhEqListNoTransform() : this.getInhEqList();
        list.addChild(node);
    }

    @Override
    public void addInhEqNoTransform(InhEq node) {
        List<InhEq> list = this.getInhEqListNoTransform();
        list.addChild(node);
    }

    @Override
    public void setInhEq(InhEq node, int i) {
        List<InhEq> list = this.getInhEqList();
        list.setChild(node, i);
    }

    @Override
    @ASTNodeAnnotation.ListChild(name="InhEq")
    public List<InhEq> getInhEqList() {
        List list = (List)this.getChild(4);
        return list;
    }

    @Override
    public List<InhEq> getInhEqListNoTransform() {
        return (List)this.getChildNoTransform(4);
    }

    @Override
    public InhEq getInhEqNoTransform(int i) {
        return (InhEq)this.getInhEqListNoTransform().getChildNoTransform(i);
    }

    @Override
    public List<InhEq> getInhEqs() {
        return this.getInhEqList();
    }

    @Override
    public List<InhEq> getInhEqsNoTransform() {
        return this.getInhEqListNoTransform();
    }

    @Override
    public void setComponentList(List<Component> list) {
        this.setChild(list, 5);
    }

    @Override
    public int getNumComponent() {
        return this.getComponentList().getNumChild();
    }

    @Override
    public int getNumComponentNoTransform() {
        return this.getComponentListNoTransform().getNumChildNoTransform();
    }

    @Override
    public Component getComponent(int i) {
        return (Component)this.getComponentList().getChild(i);
    }

    @Override
    public boolean hasComponent() {
        return this.getComponentList().getNumChild() != 0;
    }

    @Override
    public void addComponent(Component node) {
        List<Component> list = this.parent == null ? this.getComponentListNoTransform() : this.getComponentList();
        list.addChild(node);
    }

    @Override
    public void addComponentNoTransform(Component node) {
        List<Component> list = this.getComponentListNoTransform();
        list.addChild(node);
    }

    @Override
    public void setComponent(Component node, int i) {
        List<Component> list = this.getComponentList();
        list.setChild(node, i);
    }

    @Override
    @ASTNodeAnnotation.ListChild(name="Component")
    public List<Component> getComponentList() {
        List list = (List)this.getChild(5);
        return list;
    }

    @Override
    public List<Component> getComponentListNoTransform() {
        return (List)this.getChildNoTransform(5);
    }

    @Override
    public Component getComponentNoTransform(int i) {
        return (Component)this.getComponentListNoTransform().getChildNoTransform(i);
    }

    @Override
    public List<Component> getComponents() {
        return this.getComponentList();
    }

    @Override
    public List<Component> getComponentsNoTransform() {
        return this.getComponentListNoTransform();
    }

    @Override
    public void setCollDeclList(List<CollDecl> list) {
        this.setChild(list, 6);
    }

    @Override
    public int getNumCollDecl() {
        return this.getCollDeclList().getNumChild();
    }

    @Override
    public int getNumCollDeclNoTransform() {
        return this.getCollDeclListNoTransform().getNumChildNoTransform();
    }

    @Override
    public CollDecl getCollDecl(int i) {
        return (CollDecl)this.getCollDeclList().getChild(i);
    }

    @Override
    public boolean hasCollDecl() {
        return this.getCollDeclList().getNumChild() != 0;
    }

    @Override
    public void addCollDecl(CollDecl node) {
        List<CollDecl> list = this.parent == null ? this.getCollDeclListNoTransform() : this.getCollDeclList();
        list.addChild(node);
    }

    @Override
    public void addCollDeclNoTransform(CollDecl node) {
        List<CollDecl> list = this.getCollDeclListNoTransform();
        list.addChild(node);
    }

    @Override
    public void setCollDecl(CollDecl node, int i) {
        List<CollDecl> list = this.getCollDeclList();
        list.setChild(node, i);
    }

    @Override
    @ASTNodeAnnotation.ListChild(name="CollDecl")
    public List<CollDecl> getCollDeclList() {
        List list = (List)this.getChild(6);
        return list;
    }

    @Override
    public List<CollDecl> getCollDeclListNoTransform() {
        return (List)this.getChildNoTransform(6);
    }

    @Override
    public CollDecl getCollDeclNoTransform(int i) {
        return (CollDecl)this.getCollDeclListNoTransform().getChildNoTransform(i);
    }

    @Override
    public List<CollDecl> getCollDecls() {
        return this.getCollDeclList();
    }

    @Override
    public List<CollDecl> getCollDeclsNoTransform() {
        return this.getCollDeclListNoTransform();
    }

    @Override
    public void setCollEqList(List<CollEq> list) {
        this.setChild(list, 7);
    }

    @Override
    public int getNumCollEq() {
        return this.getCollEqList().getNumChild();
    }

    @Override
    public int getNumCollEqNoTransform() {
        return this.getCollEqListNoTransform().getNumChildNoTransform();
    }

    @Override
    public CollEq getCollEq(int i) {
        return (CollEq)this.getCollEqList().getChild(i);
    }

    @Override
    public boolean hasCollEq() {
        return this.getCollEqList().getNumChild() != 0;
    }

    @Override
    public void addCollEq(CollEq node) {
        List<CollEq> list = this.parent == null ? this.getCollEqListNoTransform() : this.getCollEqList();
        list.addChild(node);
    }

    @Override
    public void addCollEqNoTransform(CollEq node) {
        List<CollEq> list = this.getCollEqListNoTransform();
        list.addChild(node);
    }

    @Override
    public void setCollEq(CollEq node, int i) {
        List<CollEq> list = this.getCollEqList();
        list.setChild(node, i);
    }

    @Override
    @ASTNodeAnnotation.ListChild(name="CollEq")
    public List<CollEq> getCollEqList() {
        List list = (List)this.getChild(7);
        return list;
    }

    @Override
    public List<CollEq> getCollEqListNoTransform() {
        return (List)this.getChildNoTransform(7);
    }

    @Override
    public CollEq getCollEqNoTransform(int i) {
        return (CollEq)this.getCollEqListNoTransform().getChildNoTransform(i);
    }

    @Override
    public List<CollEq> getCollEqs() {
        return this.getCollEqList();
    }

    @Override
    public List<CollEq> getCollEqsNoTransform() {
        return this.getCollEqListNoTransform();
    }

    @Override
    public void setFileName(String value) {
        this.tokenString_FileName = value;
    }

    @Override
    @ASTNodeAnnotation.Token(name="FileName")
    public String getFileName() {
        return this.tokenString_FileName != null ? this.tokenString_FileName : "";
    }

    @Override
    public void setStartLine(int value) {
        this.tokenint_StartLine = value;
    }

    @Override
    @ASTNodeAnnotation.Token(name="StartLine")
    public int getStartLine() {
        return this.tokenint_StartLine;
    }

    @Override
    public void setEndLine(int value) {
        this.tokenint_EndLine = value;
    }

    @Override
    @ASTNodeAnnotation.Token(name="EndLine")
    public int getEndLine() {
        return this.tokenint_EndLine;
    }

    @Override
    public void setComment(String value) {
        this.tokenString_Comment = value;
    }

    @Override
    @ASTNodeAnnotation.Token(name="Comment")
    public String getComment() {
        return this.tokenString_Comment != null ? this.tokenString_Comment : "";
    }

    @Override
    public void setAspectName(String value) {
        this.tokenString_AspectName = value;
    }

    @Override
    @ASTNodeAnnotation.Token(name="AspectName")
    public String getAspectName() {
        return this.tokenString_AspectName != null ? this.tokenString_AspectName : "";
    }

    @Override
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Comments", declaredAt="/jastadd/src/jastadd/ast/Comments.jrag:187")
    public String typeDeclKind() {
        if (this.typeDeclKind_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.typeDeclKind().");
        }
        this.typeDeclKind_visited = this.state().boundariesCrossed;
        String typeDeclKind_value = "interface";
        this.typeDeclKind_visited = -1;
        return typeDeclKind_value;
    }

    @Override
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="AttributeProblems", declaredAt="/jastadd/src/jastadd/ast/AttributeProblems.jrag:111")
    public Collection<Problem> attributeProblems() {
        if (this.attributeProblems_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute InterfaceDecl.attributeProblems().");
        }
        this.attributeProblems_visited = this.state().boundariesCrossed;
        Collection<Problem> attributeProblems_value = this.interfaceAttributeProblems();
        this.attributeProblems_visited = -1;
        return attributeProblems_value;
    }

    @Override
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="AttributeProblems", declaredAt="/jastadd/src/jastadd/ast/AttributeProblems.jrag:264")
    public Collection<? extends TypeDecl> missingSynEqs(String signature) {
        String _parameters = signature;
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.missingSynEqs_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.missingSynEqs(String).");
        }
        this.missingSynEqs_String_visited.put(_parameters, this.state().boundariesCrossed);
        java.util.List missingSynEqs_String_value = Collections.emptyList();
        this.missingSynEqs_String_visited.remove(_parameters);
        return missingSynEqs_String_value;
    }

    @Override
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Interfaces", declaredAt="/jastadd/src/jastadd/ast/Interfaces.jrag:260")
    public InterfaceDecl asInterfaceDecl() {
        if (this.asInterfaceDecl_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.asInterfaceDecl().");
        }
        this.asInterfaceDecl_visited = this.state().boundariesCrossed;
        InterfaceDecl asInterfaceDecl_value = this;
        this.asInterfaceDecl_visited = -1;
        return asInterfaceDecl_value;
    }

    @Override
    public boolean Define_insideInterface(ASTNode _callerNode, ASTNode _childNode) {
        int childIndex = this.getIndexOfChild(_callerNode);
        return true;
    }

    @Override
    protected boolean canDefine_insideInterface(ASTNode _callerNode, ASTNode _childNode) {
        return true;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.COLL)
    @ASTNodeAnnotation.Source(aspect="AttributeProblems", declaredAt="/jastadd/src/jastadd/ast/AttributeProblems.jrag:114")
    public Collection<Problem> interfaceAttributeProblems() {
        ASTNode$State state = this.state();
        if (this.InterfaceDecl_interfaceAttributeProblems_computed) {
            return this.InterfaceDecl_interfaceAttributeProblems_value;
        }
        if (this.InterfaceDecl_interfaceAttributeProblems_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute InterfaceDecl.interfaceAttributeProblems().");
        }
        this.InterfaceDecl_interfaceAttributeProblems_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.InterfaceDecl_interfaceAttributeProblems_value = this.interfaceAttributeProblems_compute();
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.InterfaceDecl_interfaceAttributeProblems_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.InterfaceDecl_interfaceAttributeProblems_visited = -1;
        return this.InterfaceDecl_interfaceAttributeProblems_value;
    }

    private Collection<Problem> interfaceAttributeProblems_compute() {
        ASTNode node;
        for (node = this; node != null && !(node instanceof Grammar); node = node.getParent()) {
        }
        Grammar root = (Grammar)node;
        root.survey_InterfaceDecl_interfaceAttributeProblems();
        LinkedList<Problem> _computedValue = new LinkedList<Problem>();
        if (root.contributorMap_InterfaceDecl_interfaceAttributeProblems.containsKey(this)) {
            for (ASTNode contributor : root.contributorMap_InterfaceDecl_interfaceAttributeProblems.get(this)) {
                contributor.contributeTo_InterfaceDecl_interfaceAttributeProblems(_computedValue);
            }
        }
        return _computedValue;
    }

    @Override
    protected void collect_contributors_Grammar_interfaceProblems(Grammar _root, Map<ASTNode, Set<ASTNode>> _map) {
        if (this.isSubInterfaceOf(this)) {
            Set<ASTNode> contributors = _map.get(_root);
            if (contributors == null) {
                contributors = new LinkedHashSet<ASTNode>();
                _map.put(_root, contributors);
            }
            contributors.add(this);
        }
        super.collect_contributors_Grammar_interfaceProblems(_root, _map);
    }

    @Override
    protected void contributeTo_Grammar_interfaceProblems(Collection<Problem> collection) {
        super.contributeTo_Grammar_interfaceProblems(collection);
        if (this.isSubInterfaceOf(this)) {
            collection.add(this.errorf("Circular inheritance for interface %s.", this.name()));
        }
    }
}

