/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.ast.AST;

class JavaDocParser {
    private static final String NL = System.getProperty("line.separator", "\n");
    int i;
    char[] javadoc;
    StringBuilder out;

    JavaDocParser() {
    }

    String parse(String comments) {
        if (comments == null) {
            return "";
        }
        int start = 0;
        int end = 0;
        block0: while (true) {
            int lnStart = comments.indexOf("//", end);
            int newStart = comments.indexOf("/**", end);
            if (newStart == -1) break;
            if (lnStart != -1 && lnStart < newStart) {
                int len = comments.length();
                for (int i = lnStart; i < len; ++i) {
                    char c = comments.charAt(i);
                    if (c == '\n') {
                        start = end = i;
                        continue block0;
                    }
                    if (c != '\r') continue;
                    end = i;
                    start = end++;
                    if (i >= len - 1 || comments.charAt(i + 1) != '\n') continue block0;
                    start = end;
                    continue block0;
                }
                start = end = comments.length();
                break;
            }
            int newEnd = comments.indexOf("*/", newStart + 3) + 2;
            if (newEnd == -1) break;
            start = newStart;
            end = newEnd;
        }
        if (end <= start + 3) {
            return "";
        }
        this.javadoc = comments.substring(start + 3, end - 2).toCharArray();
        this.out = new StringBuilder(this.javadoc.length);
        this.i = 0;
        while (this.i < this.javadoc.length) {
            if (this.skipNewline()) {
                this.skipWhitespace();
                if (!this.skipAsterisk()) continue;
                this.out.append(NL);
                this.out.append(" * ");
                this.skipWhitespace();
                continue;
            }
            this.out.append(this.javadoc[this.i++]);
        }
        return this.out.toString();
    }

    private boolean skipNewline() {
        if (this.javadoc[this.i] == '\r') {
            ++this.i;
            if (this.i < this.javadoc.length && this.javadoc[this.i] == '\n') {
                ++this.i;
            }
            return true;
        }
        if (this.javadoc[this.i] == '\n') {
            ++this.i;
            return true;
        }
        return false;
    }

    private void skipWhitespace() {
        while (this.i < this.javadoc.length && this.isWhitespace(this.javadoc[this.i])) {
            ++this.i;
        }
    }

    private boolean isWhitespace(char c) {
        return Character.isWhitespace(c) && c != '\n' && c != '\n';
    }

    private boolean skipAsterisk() {
        if (this.i < this.javadoc.length && this.javadoc[this.i] == '*') {
            ++this.i;
            return true;
        }
        return false;
    }
}

