/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.ast.AST;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jastadd.Problem;
import org.jastadd.ast.AST.ASTDecl;
import org.jastadd.ast.AST.ASTNode;
import org.jastadd.ast.AST.ASTNode$State;
import org.jastadd.ast.AST.ASTNodeAnnotation;
import org.jastadd.ast.AST.Ast;
import org.jastadd.ast.AST.AstVisitor;
import org.jastadd.ast.AST.AttrDecl;
import org.jastadd.ast.AST.AttrSignature;
import org.jastadd.ast.AST.ClassBodyDecl;
import org.jastadd.ast.AST.CollDecl;
import org.jastadd.ast.AST.CollEq;
import org.jastadd.ast.AST.Component;
import org.jastadd.ast.AST.Grammar;
import org.jastadd.ast.AST.IdDecl;
import org.jastadd.ast.AST.InhDecl;
import org.jastadd.ast.AST.InhEq;
import org.jastadd.ast.AST.InheritanceConstraintOrdering;
import org.jastadd.ast.AST.InterfaceDecl;
import org.jastadd.ast.AST.JavaDocParser;
import org.jastadd.ast.AST.List;
import org.jastadd.ast.AST.ListComponent;
import org.jastadd.ast.AST.Node;
import org.jastadd.ast.AST.SynDecl;
import org.jastadd.ast.AST.SynEq;
import org.jastadd.ast.AST.SynthesizedNta;
import org.jastadd.jrag.AST.ASTAspectConstructorDeclaration;
import org.jastadd.jrag.AST.ASTAspectMethodDeclaration;
import org.jastadd.jrag.AST.ASTAspectRefineConstructorDeclaration;
import org.jastadd.jrag.AST.ASTAspectRefineMethodDeclaration;
import org.jastadd.jrag.AST.ASTBlock;
import org.jastadd.jrag.AST.ASTBlockStatement;
import org.jastadd.jrag.AST.ASTExplicitConstructorInvocation;
import org.jastadd.jrag.AST.ASTInitializer;
import org.jastadd.jrag.AST.ASTMethodDeclarator;
import org.jastadd.jrag.AST.SimpleNode;
import org.jastadd.jrag.AST.Token;
import org.jastadd.jrag.ClassBodyDeclUnparser;
import org.jastadd.jrag.ClassBodyObject;
import org.jastadd.jrag.Unparser;
import org.jastadd.tinytemplate.TemplateContext;

public abstract class TypeDecl
extends ASTNode<ASTNode>
implements Cloneable {
    public String modifiers = "";
    public String typeParameters = "";
    public LinkedList<SimpleNode> implementsList = new LinkedList();
    private Set<String> processedCollectingSignatures = new HashSet<String>();
    public Collection<ClassBodyObject> classBodyDecls = new LinkedHashSet<ClassBodyObject>();
    private Set<String> implementedAttributeSignatures = new HashSet<String>();
    private boolean finalizedAttributeSignatures = false;
    public int numRefinedSynEqs = 0;
    private Collection<SynEq> refinedSynEqsQueue = new LinkedList<SynEq>();
    public int numRefinedInhEqs = 0;
    private Collection<InhEq> refinedInhEqsQueue = new HashSet<InhEq>();
    public int numRefinedCBDecls = 0;
    public Collection<ClassBodyObject> refinedClassBodyDecls = new LinkedList<ClassBodyObject>();
    protected String tokenString_FileName;
    protected int tokenint_StartLine;
    protected int tokenint_EndLine;
    protected String tokenString_Comment;
    protected String tokenString_AspectName;
    protected Map<ASTNode, Set<ASTNode>> contributorMap_TypeDecl_attributeProblems = null;
    protected int modifiers_visited = -1;
    protected int synDecls_visited = -1;
    protected boolean synDecls_computed = false;
    protected List<SynDecl> synDecls_value;
    protected int synEqs_visited = -1;
    protected boolean synEqs_computed = false;
    protected List<SynEq> synEqs_value;
    protected int synNtaDecls_visited = -1;
    protected boolean synNtaDecls_computed = false;
    protected List<SynthesizedNta> synNtaDecls_value;
    protected int collDecls_visited = -1;
    protected boolean collDecls_computed = false;
    protected List<CollDecl> collDecls_value;
    protected int collEqs_visited = -1;
    protected boolean collEqs_computed = false;
    protected List<CollEq> collEqs_value;
    protected Map hasInhEq_String_visited = new HashMap(4);
    protected Map lookupSynDeclPrefix_String_visited = new HashMap(4);
    protected Map lookupInhDeclPrefix_String_visited = new HashMap(4);
    protected Map lookupInhDecl_String_visited = new HashMap(4);
    protected Map lookupInhDecl_String_values = new HashMap(4);
    protected Map missingSynEqs_String_visited = new HashMap(4);
    protected Map collDeclIsAmbiguous_CollDecl_visited = new HashMap(4);
    protected Map error_String_visited = new HashMap(4);
    protected int implementedInterfaces_visited = -1;
    protected Map instanceOf_TypeDecl_visited = new HashMap(4);
    protected int parentsIntransitive_visited = -1;
    protected Map lookupSynDecl_String_visited = new HashMap(4);
    protected Map lookupSynDecl_String_values = new HashMap(4);
    protected Map lookupSynEq_String_visited = new HashMap(4);
    protected Map lookupSynEq_String_values = new HashMap(4);
    protected Map hasInhEq_InhDecl_Component_visited = new HashMap(4);
    protected Map hasInhEq_InhDecl_Component_values = new HashMap(4);
    protected Map lookupInhEq_String_String_visited = new HashMap(4);
    protected Map lookupInhEq_String_String_values = new HashMap(4);
    protected int inhEqMap_visited = -1;
    protected boolean inhEqMap_computed = false;
    protected HashMap<String, LinkedList<InhEq>> inhEqMap_value;
    protected int components_visited = -1;
    protected boolean components_computed = false;
    protected Collection<Component> components_value;
    protected int implementedInterfacesSet_visited = -1;
    protected int interfacesSetFromSuperclass_visited = -1;
    protected int transitiveSuperInterfacesSet_visited = -1;
    protected Map transitiveAttributeImplementationsExcluding_Set_TypeDecl__visited = new HashMap(4);
    protected Map transitiveAttributeImplementationsExcluding_Set_TypeDecl__values = new HashMap(4);
    protected int attributeImplementationsWithInterfaces_visited = -1;
    protected boolean attributeImplementationsWithInterfaces_computed = false;
    protected Map<AttrSignature, TypeDecl> attributeImplementationsWithInterfaces_value;
    protected int ambiguousAttributeImplementationsFromInterfaces_visited = -1;
    protected int asInterfaceDecl_visited = -1;
    protected int interfaceInheritanceConflicts_visited = -1;
    protected int interfaceInheritanceOrder_visited = -1;
    protected int inheritanceClash_visited = -1;
    protected Map hasCollEq_CollDecl_visited = new HashMap(4);
    protected int isRootNode_visited = -1;
    protected int isPotentialRootNode_visited = -1;
    protected Map component_String_visited = new HashMap(4);
    protected Map component_String_values = new HashMap(4);
    protected Map lookupComponent_String_visited = new HashMap(4);
    protected Map lookupComponent_String_values = new HashMap(4);
    protected int name_visited = -1;
    protected Map findSubclasses_ASTDecl_visited = new HashMap(4);
    protected Map findSubclasses_ASTDecl_values = new HashMap(4);
    protected int TypeDecl_attributeProblems_visited = -1;
    protected boolean TypeDecl_attributeProblems_computed = false;
    protected Collection<Problem> TypeDecl_attributeProblems_value;

    public String docComment(ClassBodyObject obj) {
        TemplateContext tt = this.templateContext(obj);
        return tt.expand("ASTDecl.docComment");
    }

    public TemplateContext templateContext(ClassBodyObject obj) {
        JavaDocParser parser = new JavaDocParser();
        TemplateContext tt = this.templateContext();
        tt.bind("SourceComment", parser.parse(obj.comments));
        tt.bind("HasAspectName", obj.aspectName() != null && obj.aspectName().length() > 0);
        tt.bind("AspectName", obj.aspectName());
        String declaredat = ASTNode.declaredat(obj.getFileName(), obj.getStartLine());
        tt.bind("HasDeclaredAt", declaredat.length() > 0);
        tt.bind("DeclaredAt", declaredat);
        tt.bind("SourceLocation", ASTNode.sourceLocation(obj.getFileName(), obj.getStartLine()));
        return tt;
    }

    @Override
    public TemplateContext templateContext() {
        TemplateContext tt = super.templateContext();
        JavaDocParser parser = new JavaDocParser();
        tt.bind("SourceComment", parser.parse(this.getComment()));
        tt.bind("HasAspectName", this.getAspectName().length() > 0);
        tt.bind("AspectName", this.getAspectName());
        String declaredat = ASTNode.declaredat(this.getFileName(), this.getStartLine());
        tt.bind("HasDeclaredAt", declaredat.length() > 0);
        tt.bind("DeclaredAt", declaredat);
        tt.bind("SourceLocation", ASTNode.sourceLocation(this.getFileName(), this.getStartLine()));
        return tt;
    }

    public String docComment() {
        TemplateContext tt = this.templateContext();
        return tt.expand("TypeDecl.docComment");
    }

    public String extraDocCommentLines() {
        return "";
    }

    public void writeStatistics(PrintStream out) {
        out.format("%s,FALSE,%d,%d,%d,%d,%d,%d,%d,%d,%d%n", this.name(), this.synDecls().getNumChild(), this.getNumSynEq(), this.getNumInhDecl(), this.inhAttrSet().size(), this.getNumCollDecl(), 0, this.numRefinedSynEqs, this.numRefinedInhEqs, this.numRefinedCBDecls);
    }

    public String typeDeclarationString() {
        return "";
    }

    public void jastAddGen(boolean publicModifier) {
    }

    public String interfacesString() {
        StringBuffer buf = new StringBuffer();
        Iterator iter = this.implementsList.iterator();
        if (iter.hasNext()) {
            buf.append(Unparser.unparse((SimpleNode)iter.next()));
            while (iter.hasNext()) {
                buf.append(", " + Unparser.unparse((SimpleNode)iter.next()));
            }
        }
        return buf.toString();
    }

    public void emitMembers(PrintStream out) {
        for (ClassBodyObject obj : this.classBodyDecls) {
            SimpleNode node = obj.node;
            out.print(obj.modifiers());
            TemplateContext tt = this.templateContext(obj);
            tt.bind("RawComment", this.docComment(obj));
            tt.bind("IsInitializerBlock", obj.node.jjtGetNumChildren() == 1 && obj.node.jjtGetChild(0) instanceof ASTInitializer);
            tt.expand("InterTypeDeclaration.member", out);
            out.print(this.config().indent);
            StringBuffer buf = new StringBuffer();
            node.jjtAccept(new ClassBodyDeclUnparser(), buf);
            out.print(buf.toString());
            out.println();
        }
    }

    public void emitAbstractSyns(PrintStream out) {
        for (AttrDecl attrDecl : this.synDecls()) {
            attrDecl.emitSynDecl(out);
        }
    }

    public boolean hasLazySynEqFor(AttrDecl attr) {
        if (attr instanceof SynDecl) {
            SynEq synEq = this.lookupSynEq(attr.signature());
            return synEq != null && synEq.decl().isMemoized();
        }
        return false;
    }

    public void emitInhDeclarations(PrintStream out) {
        for (int i = 0; i < this.getNumInhDecl(); ++i) {
            InhDecl attr = this.getInhDecl(i);
            attr.emitInhDecl(out);
        }
    }

    public void removeDuplicateInhDecls() {
    }

    static String unparse(SimpleNode node) {
        StringBuffer s = new StringBuffer();
        node.jjtAccept(new Unparser(), s);
        return s.toString().trim();
    }

    public boolean implementsInterface(String name) {
        for (SimpleNode parentTypeRef : this.implementsList) {
            String parentTypeName = TypeDecl.unparse(parentTypeRef);
            if (parentTypeName.equals(name)) {
                return true;
            }
            TypeDecl parentType = this.grammar().lookup(parentTypeName);
            if (parentType == null || !parentType.implementsInterface(name)) continue;
            return true;
        }
        return false;
    }

    public Problem errorf(String messagefmt, Object ... args) {
        return this.error(String.format(messagefmt, args));
    }

    protected void addClassDeclaration(String declaration, String sourceFile, int sourceLine) {
        ASTBlock n = new ASTBlock(0);
        n.firstToken = n.lastToken = Token.newToken(0);
        n.firstToken.image = declaration;
        this.classBodyDecls.add(new ClassBodyObject(n, sourceFile, sourceLine, "<NoAspect>"));
    }

    protected void addInterfaceDeclaration(String declaration, String sourceFile, int sourceLine) {
        ASTAspectMethodDeclaration n = new ASTAspectMethodDeclaration(0);
        n.firstToken = n.lastToken = Token.newToken(0);
        n.firstToken.image = declaration;
        this.classBodyDecls.add(new ClassBodyObject(n, sourceFile, sourceLine, "<NoAspect>"));
    }

    @Override
    public String toString() {
        return this.name();
    }

    public Collection<String> inhAttrSet() {
        return this.inhEqMap().keySet();
    }

    public Collection<InhEq> inhAttrEqs(String id) {
        LinkedList<InhEq> list = this.inhEqMap().get(id);
        return list != null ? list : Collections.emptyList();
    }

    void addImplementationMapOverrides(Map<AttrSignature, Collection<TypeDecl>> decls, Collection<TypeDecl> self, boolean override) {
        for (AttrSignature signature : this.implementedAttributeEquations()) {
            if (!override && decls.containsKey(signature)) continue;
            decls.put(signature, self);
        }
    }

    public boolean isSubInterfaceOf(TypeDecl other) {
        InterfaceDecl selfI = this.asInterfaceDecl();
        InterfaceDecl otherI = other.asInterfaceDecl();
        if (selfI != null && otherI != null) {
            return selfI.isSubInterfaceOf(otherI);
        }
        return false;
    }

    public void weaveCollectionAttributes() {
    }

    protected boolean processedCollectingSignature(String signature) {
        if (this.processedCollectingSignatures.contains(signature)) {
            return true;
        }
        this.processedCollectingSignatures.add(signature);
        return false;
    }

    protected String collectionReset() {
        StringBuilder res = new StringBuilder();
        for (TypeDecl typeDecl : this.grammar().getTypeDecls()) {
            for (CollDecl decl : typeDecl.collDecls()) {
                TemplateContext tt = decl.templateContext();
                if (decl.root() != this && (!(decl.root() instanceof InterfaceDecl) || !this.implementsInterface(decl.root().name()))) continue;
                res.append(tt.expand("Collection.flush"));
            }
        }
        return res.toString();
    }

    public Set<String> implementedAttributeSignatures() {
        Collection<AttrSignature> lateSignatures = this.grammar().removeLateBoundAttributeSignaturesForType(this.name());
        if (lateSignatures != null) {
            if (this.finalizedAttributeSignatures) {
                throw new RuntimeException("Internal error in JastAdd: TypeDecl.implementedAttributeSignatures() was called before we had seen all late-bound signatures.  The earlier call may therefore have reported incomplete results.  Fix your evaluation order!");
            }
            this.finalizedAttributeSignatures = true;
            for (AttrSignature s : lateSignatures) {
                this.storeDefinedSignature(s.signature());
            }
        }
        return this.implementedAttributeSignatures;
    }

    public Set<AttrSignature> implementedAttributeEquations() {
        Set result = this.grammar().lateBindingSignatures.get(this.name());
        if (result == null) {
            return Collections.emptySet();
        }
        return result;
    }

    public void storeDefinedSignature(String sig) {
        this.implementedAttributeSignatures.add(sig);
    }

    public void addRefinedSynEq(SynEq eqn) {
        ++this.numRefinedSynEqs;
        this.refinedSynEqsQueue.add(eqn);
        this.storeDefinedSignature(eqn.signature());
    }

    public void processRefinedSynEqs() {
        boolean change = true;
        while (change && !this.refinedSynEqsQueue.isEmpty()) {
            change = false;
            for (SynEq equ : this.synEqs()) {
                SynEq refinedEqu = null;
                Iterator<SynEq> outerIter = this.refinedSynEqsQueue.iterator();
                while (outerIter.hasNext()) {
                    boolean legacyCondition;
                    SynEq refinedCandidate = outerIter.next();
                    boolean bl = legacyCondition = this.config().refineLegacy() && equ.legacyAspectName().equals(refinedCandidate.refinesAspect);
                    if (!equ.signature().equals(refinedCandidate.signature()) || !equ.aspectName().equals(refinedCandidate.refinesAspect) && !legacyCondition) continue;
                    change = true;
                    if (refinedEqu == null) {
                        refinedEqu = refinedCandidate;
                    } else {
                        this.grammar().error("refinement previously defined at " + refinedCandidate.getFileName() + ":" + refinedCandidate.getStartLine(), refinedEqu.getFileName(), refinedEqu.getStartLine());
                    }
                    outerIter.remove();
                }
                if (refinedEqu == null) continue;
                this.refineWith(equ, refinedEqu);
            }
        }
        for (SynEq equ : this.refinedSynEqsQueue) {
            this.refineError("syn equation", equ.getFileName(), equ.getStartLine());
        }
    }

    public void refineWith(SynEq equ, SynEq refinedEqu) {
        Matcher matcher;
        StringBuffer s = new StringBuffer();
        String newMethodName = String.format("refined_%s_%s_%s", equ.aspectName(), this.name(), equ.signature());
        if (equ.decl() == null) {
            throw new Error(String.format("Error: could not find declaration of refined synthesized equation %s (%s:%d)", equ.name(), equ.getFileName(), equ.getStartLine()));
        }
        s.append(String.format("private %s %s(%s)\n", equ.decl().getType(), newMethodName, equ.parametersDecl()));
        if (equ.getRHS() instanceof ASTBlock) {
            s.append(Unparser.unparse(equ.getRHS()));
        } else {
            s.append("{ return " + Unparser.unparse(equ.getRHS()) + "; }");
        }
        SimpleNode n = new ASTBlock(0);
        n.firstToken = n.lastToken = Token.newToken(0);
        n.firstToken.image = s.toString();
        ClassBodyObject object = new ClassBodyObject(n, equ.getFileName(), equ.getStartLine(), equ.getAspectName());
        n = refinedEqu.getRHS() instanceof ASTBlock ? new ASTBlock(0) : new SimpleNode(0);
        n.firstToken = n.lastToken = Token.newToken(0);
        s = new StringBuffer();
        refinedEqu.getRHS().jjtAccept(new ClassBodyDeclUnparser(), s);
        String pattern = "\\brefined\\b";
        if (this.config().refineLegacy()) {
            StringBuffer buf = new StringBuffer();
            buf.append("(");
            buf.append(pattern);
            buf.append(")|(");
            buf.append("\\b");
            buf.append(equ.legacyAspectName());
            buf.append("\\.[a-zA-Z0-9_$]+\\.");
            buf.append(equ.name());
            buf.append("\\b)");
            pattern = buf.toString();
        }
        if ((matcher = Pattern.compile(pattern).matcher(s.toString())).find()) {
            n.firstToken.image = matcher.replaceAll(newMethodName);
            this.classBodyDecls.add(object);
        } else {
            n.firstToken.image = s.toString();
        }
        equ.setRHS(n);
        equ.setFileName(refinedEqu.getFileName());
        equ.setStartLine(refinedEqu.getStartLine());
        equ.setEndLine(refinedEqu.getEndLine());
        equ.setAspectName(refinedEqu.getAspectName());
    }

    public void addRefinedInhEq(InhEq eqn) {
        ++this.numRefinedInhEqs;
        this.refinedInhEqsQueue.add(eqn);
        this.storeDefinedSignature(eqn.signature());
    }

    public void processRefinedInhEqs() {
        boolean change = true;
        while (change && !this.refinedInhEqsQueue.isEmpty()) {
            change = false;
            for (int i = 0; i < this.getNumInhEq(); ++i) {
                InhEq equ = this.getInhEq(i);
                InhEq refinedEqu = null;
                Iterator<InhEq> outerIter = this.refinedInhEqsQueue.iterator();
                while (outerIter.hasNext()) {
                    boolean legacyCondition;
                    InhEq refinedCandidate = outerIter.next();
                    boolean bl = legacyCondition = this.config().refineLegacy() && equ.legacyAspectName().equals(refinedCandidate.refinesAspect);
                    if (!equ.signature().equals(refinedCandidate.signature()) || !equ.childName().equals(refinedCandidate.childName()) || !equ.aspectName().equals(refinedCandidate.refinesAspect) && !legacyCondition) continue;
                    change = true;
                    if (refinedEqu == null) {
                        refinedEqu = refinedCandidate;
                    } else {
                        this.grammar().error("refinement previously defined at " + refinedCandidate.getFileName() + ":" + refinedCandidate.getStartLine(), refinedEqu.getFileName(), refinedEqu.getStartLine());
                    }
                    outerIter.remove();
                }
                if (refinedEqu == null) continue;
                this.refineWith(equ, refinedEqu);
            }
        }
        for (InhEq equ : this.refinedInhEqsQueue) {
            this.refineError("inh equation", equ.getFileName(), equ.getStartLine());
        }
    }

    public void refineWith(InhEq equ, InhEq refinedEqu) {
        Matcher matcher;
        StringBuffer s = new StringBuffer();
        String newMethodName = "refined_" + equ.aspectName() + "_" + this.name() + "_" + equ.childName() + "_" + equ.signature();
        String indexName = "";
        String indexDecl = "";
        boolean isList = equ.getComponent() instanceof ListComponent;
        if (isList) {
            indexName = equ.hasIndex() ? equ.getIndex().getName() : "childIndex";
            indexDecl = "int " + indexName;
            if (equ.getNumParameter() != 0) {
                indexName = indexName + ", ";
                indexDecl = indexDecl + ", ";
            }
        }
        s.append(String.format("private %s %s(%s%s)\n", equ.decl().getType(), newMethodName, indexDecl, equ.parametersDecl()));
        if (equ.getRHS() instanceof ASTBlock) {
            s.append(Unparser.unparse(equ.getRHS()));
        } else {
            s.append("{ return " + Unparser.unparse(equ.getRHS()) + "; }");
        }
        SimpleNode n = new ASTBlock(0);
        n.firstToken = n.lastToken = Token.newToken(0);
        n.firstToken.image = s.toString();
        ClassBodyObject object = new ClassBodyObject(n, equ.getFileName(), equ.getStartLine(), equ.getAspectName());
        n = refinedEqu.getRHS() instanceof ASTBlock ? new ASTBlock(0) : new SimpleNode(0);
        n.firstToken = n.lastToken = Token.newToken(0);
        s = new StringBuffer();
        refinedEqu.getRHS().jjtAccept(new ClassBodyDeclUnparser(), s);
        String pattern = "refined\\(";
        if (this.config().refineLegacy()) {
            pattern = String.format("(%s)|(%s\\.[a-zA-Z0-9]+\\.get%s\\([^\\)]*\\)\\.%s\\()", pattern, equ.legacyAspectName(), equ.childName(), equ.name());
        }
        if ((matcher = Pattern.compile(pattern).matcher(s.toString())).find()) {
            n.firstToken.image = matcher.replaceAll(newMethodName + "(" + indexName);
            this.classBodyDecls.add(object);
        } else {
            n.firstToken.image = s.toString();
        }
        equ.setRHS(n);
        equ.setFileName(refinedEqu.getFileName());
        equ.setStartLine(refinedEqu.getStartLine());
        equ.setEndLine(refinedEqu.getEndLine());
        equ.setAspectName(refinedEqu.getAspectName());
    }

    public void processRefinedClassBodyDecls() {
        boolean change = true;
        ArrayList<ClassBodyObject> list = new ArrayList<ClassBodyObject>();
        while (change && !this.refinedClassBodyDecls.isEmpty()) {
            change = false;
            Iterator<ClassBodyObject> iter = this.classBodyDecls.iterator();
            while (iter.hasNext()) {
                ClassBodyObject decl = iter.next();
                ClassBodyObject refinedDecl = null;
                Iterator<ClassBodyObject> outerIter = this.refinedClassBodyDecls.iterator();
                while (outerIter.hasNext()) {
                    boolean legacyCondition;
                    ClassBodyObject refinedCandidate = outerIter.next();
                    boolean bl = legacyCondition = this.config().refineLegacy() && decl.legacyAspectName().equals(refinedCandidate.refinesAspect);
                    if (!decl.signature().equals(refinedCandidate.signature()) || !decl.aspectName().equals(refinedCandidate.refinesAspect) && !legacyCondition) continue;
                    change = true;
                    if (refinedDecl == null) {
                        refinedDecl = refinedCandidate;
                    } else {
                        this.grammar().error(String.format("refinement previously defined at %s:%s", refinedCandidate.getFileName(), refinedCandidate.getStartLine()), refinedDecl.getFileName(), refinedDecl.getStartLine());
                    }
                    outerIter.remove();
                }
                if (refinedDecl == null) continue;
                if (!this.refineWith(decl, refinedDecl)) {
                    iter.remove();
                }
                list.add(refinedDecl);
            }
            this.classBodyDecls.addAll(list);
        }
        for (ClassBodyObject decl : this.refinedClassBodyDecls) {
            this.refineError("method", decl.getFileName(), decl.getStartLine());
        }
    }

    private void replaceWith(ClassBodyObject o) {
        o.replaceAspect = null;
        SimpleNode node = o.node;
        node.firstToken = ((SimpleNode)node.jjtGetChild((int)1)).lastToken.next.next.next;
        node.jjtAddChild(node.jjtGetChild(2), 0);
        node.jjtAddChild(node.jjtGetChild(3), 1);
        node.jjtAddChild(node.jjtGetChild(4), 2);
        for (int i = 3; i < node.jjtGetNumChildren(); ++i) {
            node.jjtAddChild(null, i);
        }
    }

    private static String methodName(ClassBodyObject decl) {
        SimpleNode node = decl.node;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (!(node.jjtGetChild(i) instanceof ASTMethodDeclarator)) continue;
            return ((SimpleNode)node.jjtGetChild((int)i)).firstToken.image;
        }
        return "<unknown refinement target method>";
    }

    private static void setMethodName(ClassBodyObject decl, String name) {
        SimpleNode node = decl.node;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (!(node.jjtGetChild(i) instanceof ASTMethodDeclarator)) continue;
            ((SimpleNode)node.jjtGetChild((int)i)).firstToken.image = name;
            return;
        }
    }

    public boolean refineWith(ClassBodyObject original, ClassBodyObject refinedDecl) {
        SimpleNode refinement = refinedDecl.node;
        boolean keep = true;
        if (refinement instanceof ASTAspectConstructorDeclaration || refinement instanceof ASTAspectRefineConstructorDeclaration) {
            String s;
            StringBuffer buf;
            SimpleNode child;
            int index;
            String methodName = this.name();
            Token t1 = ((SimpleNode)original.node.jjtGetChild((int)0)).firstToken;
            Token t2 = original.node.firstToken;
            while (t2.next != t1) {
                t2 = t2.next;
            }
            t2.image = "void refined_" + original.aspectName() + "_" + this.name() + "_" + t2.image;
            SimpleNode parent = refinement;
            boolean first = true;
            keep = false;
            for (index = 1; index < parent.jjtGetNumChildren(); ++index) {
                child = (SimpleNode)parent.jjtGetChild(index);
                if (!(child instanceof ASTBlockStatement) && !(child instanceof ASTExplicitConstructorInvocation)) continue;
                refinement = child;
                buf = new StringBuffer();
                refinement.jjtAccept(new ClassBodyDeclUnparser(), buf);
                s = buf.toString();
                String pattern = "\\brefined\\b";
                if (this.config().refineLegacy()) {
                    buf = new StringBuffer();
                    buf.append("(");
                    buf.append(pattern);
                    buf.append(")|(");
                    buf.append("\\b");
                    buf.append(original.legacyAspectName());
                    buf.append("\\.[a-zA-Z0-9_$]+\\.");
                    buf.append(methodName);
                    buf.append("\\b)");
                    pattern = buf.toString();
                }
                String newContents = String.format("refined_%s_%s_%s", original.aspectName(), this.name(), methodName);
                Matcher matcher = Pattern.compile(pattern).matcher(s);
                if (matcher.find()) {
                    s = matcher.replaceAll(newContents);
                    keep = true;
                }
                if (first) {
                    s = " {" + s;
                    first = false;
                }
                if (index == parent.jjtGetNumChildren() - 1) {
                    s = s + "\n}\n";
                }
                Token token = Token.newToken(0);
                token.image = s;
                ((SimpleNode)parent.jjtGetChild((int)(index - 1))).lastToken.next = token;
                token.next = token;
                refinement = new ASTBlock(0);
                parent.lastToken = token;
                refinement.firstToken = refinement.lastToken = token;
                parent.jjtAddChild(refinement, index);
                refinement.jjtSetParent(parent);
            }
            parent = original.node;
            first = true;
            for (index = 1; index < parent.jjtGetNumChildren(); ++index) {
                child = (SimpleNode)parent.jjtGetChild(index);
                if (!(child instanceof ASTExplicitConstructorInvocation)) continue;
                refinement = child;
                buf = new StringBuffer();
                refinement.jjtAccept(new ClassBodyDeclUnparser(), buf);
                s = buf.toString();
                if (child instanceof ASTExplicitConstructorInvocation) {
                    s = "";
                }
                if (first) {
                    s = " {" + s;
                    first = false;
                }
                Token token = Token.newToken(0);
                token.image = s;
                ((SimpleNode)parent.jjtGetChild((int)(index - 1))).lastToken.next = token;
                token.next = refinement.lastToken.next;
                refinement = new ASTExplicitConstructorInvocation(0);
                refinement.firstToken = refinement.lastToken = token;
                parent.jjtAddChild(refinement, index);
                refinement.jjtSetParent(parent);
            }
        } else if (refinement instanceof ASTAspectMethodDeclaration || refinement instanceof ASTAspectRefineMethodDeclaration) {
            int index;
            String idDecl = TypeDecl.methodName(original);
            String methodName = idDecl.trim();
            idDecl = idDecl.replaceAll(methodName, "refined_" + original.aspectName() + "_" + this.name() + "_" + methodName);
            TypeDecl.setMethodName(original, idDecl);
            SimpleNode parent = refinement;
            for (index = 2; index < refinement.jjtGetNumChildren() && !(refinement.jjtGetChild(index) instanceof ASTBlock); ++index) {
            }
            if (index >= refinement.jjtGetNumChildren()) {
                throw new Error("Could not find block node");
            }
            refinement = (SimpleNode)refinement.jjtGetChild(index);
            StringBuffer buf = new StringBuffer();
            refinement.jjtAccept(new ClassBodyDeclUnparser(), buf);
            String s = buf.toString();
            String pattern = "\\brefined\\b";
            if (this.config().refineLegacy()) {
                buf = new StringBuffer();
                buf.append("(");
                buf.append(pattern);
                buf.append(")|(");
                buf.append("\\b");
                buf.append(original.legacyAspectName());
                buf.append("\\.[a-zA-Z0-9_$]+\\.");
                buf.append(methodName);
                buf.append("\\b)");
                pattern = buf.toString();
            }
            String newContents = "refined_" + original.aspectName() + "_" + this.name() + "_" + methodName;
            Matcher matcher = Pattern.compile(pattern).matcher(s);
            if (matcher.find()) {
                s = matcher.replaceAll(newContents);
            } else {
                keep = false;
            }
            Token token = Token.newToken(0);
            token.image = s;
            ((SimpleNode)parent.jjtGetChild((int)(index - 1))).lastToken.next = token;
            token.next = token;
            refinement = new ASTBlock(0);
            parent.lastToken = token;
            refinement.firstToken = refinement.lastToken = token;
            parent.jjtAddChild(refinement, index);
            refinement.jjtSetParent(parent);
        } else {
            throw new Error("Unexpected node type " + refinement.getClass().getName());
        }
        return keep;
    }

    public TypeDecl(int i) {
        super(i);
    }

    public TypeDecl(Ast p, int i) {
        this(i);
        this.parser = p;
    }

    public TypeDecl() {
        this(0);
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[8];
        this.setChild(new List(), 1);
        this.setChild(new List(), 2);
        this.setChild(new List(), 3);
        this.setChild(new List(), 4);
        this.setChild(new List(), 5);
        this.setChild(new List(), 6);
        this.setChild(new List(), 7);
    }

    public TypeDecl(IdDecl p0, List<ClassBodyDecl> p1, List<SynEq> p2, List<InhDecl> p3, List<InhEq> p4, List<Component> p5, List<CollDecl> p6, List<CollEq> p7, String p8, int p9, int p10, String p11, String p12) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
        this.setChild(p2, 2);
        this.setChild(p3, 3);
        this.setChild(p4, 4);
        this.setChild(p5, 5);
        this.setChild(p6, 6);
        this.setChild(p7, 7);
        this.setFileName(p8);
        this.setStartLine(p9);
        this.setEndLine(p10);
        this.setComment(p11);
        this.setAspectName(p12);
    }

    @Override
    public void dumpTree(String indent, PrintStream out) {
        out.print(indent + "TypeDecl");
        out.print("\"" + this.getFileName() + "\"");
        out.print("\"" + this.getStartLine() + "\"");
        out.print("\"" + this.getEndLine() + "\"");
        out.print("\"" + this.getComment() + "\"");
        out.print("\"" + this.getAspectName() + "\"");
        String childIndent = indent + "  ";
        for (int i = 0; i < this.getNumChild(); ++i) {
            ((ASTNode)this.getChild(i)).dumpTree(childIndent, out);
        }
    }

    @Override
    public Object jjtAccept(AstVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        this.checkChild(n, i);
        super.jjtAddChild(n, i);
    }

    @Override
    public void checkChild(Node n, int i) {
        int k;
        if (i == 0 && !(n instanceof IdDecl)) {
            throw new Error("Child number 0 of TypeDecl has the type " + n.getClass().getName() + " which is not an instance of IdDecl");
        }
        if (i == 1) {
            if (!(n instanceof List)) {
                throw new Error("Child number 1 of TypeDecl has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            for (k = 0; k < ((List)n).getNumChildNoTransform(); ++k) {
                if (((List)n).getChildNoTransform(k) instanceof ClassBodyDecl) continue;
                throw new Error("Child number " + k + " in ClassBodyDeclList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of ClassBodyDecl");
            }
        }
        if (i == 2) {
            if (!(n instanceof List)) {
                throw new Error("Child number 2 of TypeDecl has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            for (k = 0; k < ((List)n).getNumChildNoTransform(); ++k) {
                if (((List)n).getChildNoTransform(k) instanceof SynEq) continue;
                throw new Error("Child number " + k + " in SynEqList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of SynEq");
            }
        }
        if (i == 3) {
            if (!(n instanceof List)) {
                throw new Error("Child number 3 of TypeDecl has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            for (k = 0; k < ((List)n).getNumChildNoTransform(); ++k) {
                if (((List)n).getChildNoTransform(k) instanceof InhDecl) continue;
                throw new Error("Child number " + k + " in InhDeclList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of InhDecl");
            }
        }
        if (i == 4) {
            if (!(n instanceof List)) {
                throw new Error("Child number 4 of TypeDecl has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            for (k = 0; k < ((List)n).getNumChildNoTransform(); ++k) {
                if (((List)n).getChildNoTransform(k) instanceof InhEq) continue;
                throw new Error("Child number " + k + " in InhEqList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of InhEq");
            }
        }
        if (i == 5) {
            if (!(n instanceof List)) {
                throw new Error("Child number 5 of TypeDecl has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            for (k = 0; k < ((List)n).getNumChildNoTransform(); ++k) {
                if (((List)n).getChildNoTransform(k) instanceof Component) continue;
                throw new Error("Child number " + k + " in ComponentList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of Component");
            }
        }
        if (i == 6) {
            if (!(n instanceof List)) {
                throw new Error("Child number 6 of TypeDecl has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            for (k = 0; k < ((List)n).getNumChildNoTransform(); ++k) {
                if (((List)n).getChildNoTransform(k) instanceof CollDecl) continue;
                throw new Error("Child number " + k + " in CollDeclList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of CollDecl");
            }
        }
        if (i == 7) {
            if (!(n instanceof List)) {
                throw new Error("Child number 7 of TypeDecl has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            for (k = 0; k < ((List)n).getNumChildNoTransform(); ++k) {
                if (((List)n).getChildNoTransform(k) instanceof CollEq) continue;
                throw new Error("Child number " + k + " in CollEqList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of CollEq");
            }
        }
    }

    @Override
    public int getNumChild() {
        return 8;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void flushAttrCache() {
        super.flushAttrCache();
        this.synDecls_reset();
        this.synEqs_reset();
        this.synNtaDecls_reset();
        this.collDecls_reset();
        this.collEqs_reset();
        this.lookupInhDecl_String_reset();
        this.lookupSynDecl_String_reset();
        this.lookupSynEq_String_reset();
        this.hasInhEq_InhDecl_Component_reset();
        this.lookupInhEq_String_String_reset();
        this.inhEqMap_reset();
        this.components_reset();
        this.transitiveAttributeImplementationsExcluding_Set_TypeDecl__reset();
        this.attributeImplementationsWithInterfaces_reset();
        this.component_String_reset();
        this.lookupComponent_String_reset();
        this.findSubclasses_ASTDecl_reset();
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
        this.TypeDecl_attributeProblems_visited = -1;
        this.TypeDecl_attributeProblems_computed = false;
        this.TypeDecl_attributeProblems_value = null;
        this.contributorMap_TypeDecl_attributeProblems = null;
    }

    @Override
    public TypeDecl clone() throws CloneNotSupportedException {
        TypeDecl node = (TypeDecl)super.clone();
        return node;
    }

    @Deprecated
    public abstract TypeDecl fullCopy();

    public abstract TypeDecl treeCopyNoTransform();

    public abstract TypeDecl treeCopy();

    public void setIdDecl(IdDecl node) {
        this.setChild(node, 0);
    }

    @ASTNodeAnnotation.Child(name="IdDecl")
    public IdDecl getIdDecl() {
        return (IdDecl)this.getChild(0);
    }

    public IdDecl getIdDeclNoTransform() {
        return (IdDecl)this.getChildNoTransform(0);
    }

    public void setClassBodyDeclList(List<ClassBodyDecl> list) {
        this.setChild(list, 1);
    }

    public int getNumClassBodyDecl() {
        return this.getClassBodyDeclList().getNumChild();
    }

    public int getNumClassBodyDeclNoTransform() {
        return this.getClassBodyDeclListNoTransform().getNumChildNoTransform();
    }

    public ClassBodyDecl getClassBodyDecl(int i) {
        return (ClassBodyDecl)this.getClassBodyDeclList().getChild(i);
    }

    public boolean hasClassBodyDecl() {
        return this.getClassBodyDeclList().getNumChild() != 0;
    }

    public void addClassBodyDecl(ClassBodyDecl node) {
        List<ClassBodyDecl> list = this.parent == null ? this.getClassBodyDeclListNoTransform() : this.getClassBodyDeclList();
        list.addChild(node);
    }

    public void addClassBodyDeclNoTransform(ClassBodyDecl node) {
        List<ClassBodyDecl> list = this.getClassBodyDeclListNoTransform();
        list.addChild(node);
    }

    public void setClassBodyDecl(ClassBodyDecl node, int i) {
        List<ClassBodyDecl> list = this.getClassBodyDeclList();
        list.setChild(node, i);
    }

    @ASTNodeAnnotation.ListChild(name="ClassBodyDecl")
    public List<ClassBodyDecl> getClassBodyDeclList() {
        List list = (List)this.getChild(1);
        return list;
    }

    public List<ClassBodyDecl> getClassBodyDeclListNoTransform() {
        return (List)this.getChildNoTransform(1);
    }

    public ClassBodyDecl getClassBodyDeclNoTransform(int i) {
        return (ClassBodyDecl)this.getClassBodyDeclListNoTransform().getChildNoTransform(i);
    }

    public List<ClassBodyDecl> getClassBodyDecls() {
        return this.getClassBodyDeclList();
    }

    public List<ClassBodyDecl> getClassBodyDeclsNoTransform() {
        return this.getClassBodyDeclListNoTransform();
    }

    public void setSynEqList(List<SynEq> list) {
        this.setChild(list, 2);
    }

    public int getNumSynEq() {
        return this.getSynEqList().getNumChild();
    }

    public int getNumSynEqNoTransform() {
        return this.getSynEqListNoTransform().getNumChildNoTransform();
    }

    public SynEq getSynEq(int i) {
        return (SynEq)this.getSynEqList().getChild(i);
    }

    public boolean hasSynEq() {
        return this.getSynEqList().getNumChild() != 0;
    }

    public void addSynEq(SynEq node) {
        List<SynEq> list = this.parent == null ? this.getSynEqListNoTransform() : this.getSynEqList();
        list.addChild(node);
    }

    public void addSynEqNoTransform(SynEq node) {
        List<SynEq> list = this.getSynEqListNoTransform();
        list.addChild(node);
    }

    public void setSynEq(SynEq node, int i) {
        List<SynEq> list = this.getSynEqList();
        list.setChild(node, i);
    }

    @ASTNodeAnnotation.ListChild(name="SynEq")
    public List<SynEq> getSynEqList() {
        List list = (List)this.getChild(2);
        return list;
    }

    public List<SynEq> getSynEqListNoTransform() {
        return (List)this.getChildNoTransform(2);
    }

    public SynEq getSynEqNoTransform(int i) {
        return (SynEq)this.getSynEqListNoTransform().getChildNoTransform(i);
    }

    public List<SynEq> getSynEqs() {
        return this.getSynEqList();
    }

    public List<SynEq> getSynEqsNoTransform() {
        return this.getSynEqListNoTransform();
    }

    public void setInhDeclList(List<InhDecl> list) {
        this.setChild(list, 3);
    }

    public int getNumInhDecl() {
        return this.getInhDeclList().getNumChild();
    }

    public int getNumInhDeclNoTransform() {
        return this.getInhDeclListNoTransform().getNumChildNoTransform();
    }

    public InhDecl getInhDecl(int i) {
        return (InhDecl)this.getInhDeclList().getChild(i);
    }

    public boolean hasInhDecl() {
        return this.getInhDeclList().getNumChild() != 0;
    }

    public void addInhDecl(InhDecl node) {
        List<InhDecl> list = this.parent == null ? this.getInhDeclListNoTransform() : this.getInhDeclList();
        list.addChild(node);
    }

    public void addInhDeclNoTransform(InhDecl node) {
        List<InhDecl> list = this.getInhDeclListNoTransform();
        list.addChild(node);
    }

    public void setInhDecl(InhDecl node, int i) {
        List<InhDecl> list = this.getInhDeclList();
        list.setChild(node, i);
    }

    @ASTNodeAnnotation.ListChild(name="InhDecl")
    public List<InhDecl> getInhDeclList() {
        List list = (List)this.getChild(3);
        return list;
    }

    public List<InhDecl> getInhDeclListNoTransform() {
        return (List)this.getChildNoTransform(3);
    }

    public InhDecl getInhDeclNoTransform(int i) {
        return (InhDecl)this.getInhDeclListNoTransform().getChildNoTransform(i);
    }

    public List<InhDecl> getInhDecls() {
        return this.getInhDeclList();
    }

    public List<InhDecl> getInhDeclsNoTransform() {
        return this.getInhDeclListNoTransform();
    }

    public void setInhEqList(List<InhEq> list) {
        this.setChild(list, 4);
    }

    public int getNumInhEq() {
        return this.getInhEqList().getNumChild();
    }

    public int getNumInhEqNoTransform() {
        return this.getInhEqListNoTransform().getNumChildNoTransform();
    }

    public InhEq getInhEq(int i) {
        return (InhEq)this.getInhEqList().getChild(i);
    }

    public boolean hasInhEq() {
        return this.getInhEqList().getNumChild() != 0;
    }

    public void addInhEq(InhEq node) {
        List<InhEq> list = this.parent == null ? this.getInhEqListNoTransform() : this.getInhEqList();
        list.addChild(node);
    }

    public void addInhEqNoTransform(InhEq node) {
        List<InhEq> list = this.getInhEqListNoTransform();
        list.addChild(node);
    }

    public void setInhEq(InhEq node, int i) {
        List<InhEq> list = this.getInhEqList();
        list.setChild(node, i);
    }

    @ASTNodeAnnotation.ListChild(name="InhEq")
    public List<InhEq> getInhEqList() {
        List list = (List)this.getChild(4);
        return list;
    }

    public List<InhEq> getInhEqListNoTransform() {
        return (List)this.getChildNoTransform(4);
    }

    public InhEq getInhEqNoTransform(int i) {
        return (InhEq)this.getInhEqListNoTransform().getChildNoTransform(i);
    }

    public List<InhEq> getInhEqs() {
        return this.getInhEqList();
    }

    public List<InhEq> getInhEqsNoTransform() {
        return this.getInhEqListNoTransform();
    }

    public void setComponentList(List<Component> list) {
        this.setChild(list, 5);
    }

    public int getNumComponent() {
        return this.getComponentList().getNumChild();
    }

    public int getNumComponentNoTransform() {
        return this.getComponentListNoTransform().getNumChildNoTransform();
    }

    public Component getComponent(int i) {
        return (Component)this.getComponentList().getChild(i);
    }

    public boolean hasComponent() {
        return this.getComponentList().getNumChild() != 0;
    }

    public void addComponent(Component node) {
        List<Component> list = this.parent == null ? this.getComponentListNoTransform() : this.getComponentList();
        list.addChild(node);
    }

    public void addComponentNoTransform(Component node) {
        List<Component> list = this.getComponentListNoTransform();
        list.addChild(node);
    }

    public void setComponent(Component node, int i) {
        List<Component> list = this.getComponentList();
        list.setChild(node, i);
    }

    @ASTNodeAnnotation.ListChild(name="Component")
    public List<Component> getComponentList() {
        List list = (List)this.getChild(5);
        return list;
    }

    public List<Component> getComponentListNoTransform() {
        return (List)this.getChildNoTransform(5);
    }

    public Component getComponentNoTransform(int i) {
        return (Component)this.getComponentListNoTransform().getChildNoTransform(i);
    }

    public List<Component> getComponents() {
        return this.getComponentList();
    }

    public List<Component> getComponentsNoTransform() {
        return this.getComponentListNoTransform();
    }

    public void setCollDeclList(List<CollDecl> list) {
        this.setChild(list, 6);
    }

    public int getNumCollDecl() {
        return this.getCollDeclList().getNumChild();
    }

    public int getNumCollDeclNoTransform() {
        return this.getCollDeclListNoTransform().getNumChildNoTransform();
    }

    public CollDecl getCollDecl(int i) {
        return (CollDecl)this.getCollDeclList().getChild(i);
    }

    public boolean hasCollDecl() {
        return this.getCollDeclList().getNumChild() != 0;
    }

    public void addCollDecl(CollDecl node) {
        List<CollDecl> list = this.parent == null ? this.getCollDeclListNoTransform() : this.getCollDeclList();
        list.addChild(node);
    }

    public void addCollDeclNoTransform(CollDecl node) {
        List<CollDecl> list = this.getCollDeclListNoTransform();
        list.addChild(node);
    }

    public void setCollDecl(CollDecl node, int i) {
        List<CollDecl> list = this.getCollDeclList();
        list.setChild(node, i);
    }

    @ASTNodeAnnotation.ListChild(name="CollDecl")
    public List<CollDecl> getCollDeclList() {
        List list = (List)this.getChild(6);
        return list;
    }

    public List<CollDecl> getCollDeclListNoTransform() {
        return (List)this.getChildNoTransform(6);
    }

    public CollDecl getCollDeclNoTransform(int i) {
        return (CollDecl)this.getCollDeclListNoTransform().getChildNoTransform(i);
    }

    public List<CollDecl> getCollDecls() {
        return this.getCollDeclList();
    }

    public List<CollDecl> getCollDeclsNoTransform() {
        return this.getCollDeclListNoTransform();
    }

    public void setCollEqList(List<CollEq> list) {
        this.setChild(list, 7);
    }

    public int getNumCollEq() {
        return this.getCollEqList().getNumChild();
    }

    public int getNumCollEqNoTransform() {
        return this.getCollEqListNoTransform().getNumChildNoTransform();
    }

    public CollEq getCollEq(int i) {
        return (CollEq)this.getCollEqList().getChild(i);
    }

    public boolean hasCollEq() {
        return this.getCollEqList().getNumChild() != 0;
    }

    public void addCollEq(CollEq node) {
        List<CollEq> list = this.parent == null ? this.getCollEqListNoTransform() : this.getCollEqList();
        list.addChild(node);
    }

    public void addCollEqNoTransform(CollEq node) {
        List<CollEq> list = this.getCollEqListNoTransform();
        list.addChild(node);
    }

    public void setCollEq(CollEq node, int i) {
        List<CollEq> list = this.getCollEqList();
        list.setChild(node, i);
    }

    @ASTNodeAnnotation.ListChild(name="CollEq")
    public List<CollEq> getCollEqList() {
        List list = (List)this.getChild(7);
        return list;
    }

    public List<CollEq> getCollEqListNoTransform() {
        return (List)this.getChildNoTransform(7);
    }

    public CollEq getCollEqNoTransform(int i) {
        return (CollEq)this.getCollEqListNoTransform().getChildNoTransform(i);
    }

    public List<CollEq> getCollEqs() {
        return this.getCollEqList();
    }

    public List<CollEq> getCollEqsNoTransform() {
        return this.getCollEqListNoTransform();
    }

    public void setFileName(String value) {
        this.tokenString_FileName = value;
    }

    @ASTNodeAnnotation.Token(name="FileName")
    public String getFileName() {
        return this.tokenString_FileName != null ? this.tokenString_FileName : "";
    }

    public void setStartLine(int value) {
        this.tokenint_StartLine = value;
    }

    @ASTNodeAnnotation.Token(name="StartLine")
    public int getStartLine() {
        return this.tokenint_StartLine;
    }

    public void setEndLine(int value) {
        this.tokenint_EndLine = value;
    }

    @ASTNodeAnnotation.Token(name="EndLine")
    public int getEndLine() {
        return this.tokenint_EndLine;
    }

    public void setComment(String value) {
        this.tokenString_Comment = value;
    }

    @ASTNodeAnnotation.Token(name="Comment")
    public String getComment() {
        return this.tokenString_Comment != null ? this.tokenString_Comment : "";
    }

    public void setAspectName(String value) {
        this.tokenString_AspectName = value;
    }

    @ASTNodeAnnotation.Token(name="AspectName")
    public String getAspectName() {
        return this.tokenString_AspectName != null ? this.tokenString_AspectName : "";
    }

    protected void survey_TypeDecl_attributeProblems() {
        if (this.contributorMap_TypeDecl_attributeProblems == null) {
            this.contributorMap_TypeDecl_attributeProblems = new IdentityHashMap<ASTNode, Set<ASTNode>>();
            this.collect_contributors_TypeDecl_attributeProblems(this, this.contributorMap_TypeDecl_attributeProblems);
        }
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Comments", declaredAt="/jastadd/src/jastadd/ast/Comments.jrag:187")
    public abstract String typeDeclKind();

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="JastAddCodeGen", declaredAt="/jastadd/src/jastadd/ast/JastAddCodeGen.jadd:189")
    public String modifiers() {
        if (this.modifiers_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.modifiers().");
        }
        this.modifiers_visited = this.state().boundariesCrossed;
        try {
            if (this.modifiers == null) {
                String string = "";
                return string;
            }
            String string = this.modifiers + " ";
            return string;
        }
        finally {
            this.modifiers_visited = -1;
        }
    }

    private void synDecls_reset() {
        this.synDecls_computed = false;
        this.synDecls_value = null;
        this.synDecls_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN, isNTA=true)
    @ASTNodeAnnotation.Source(aspect="AttributeWeaving", declaredAt="/jastadd/src/jastadd/ast/Weaving.jrag:58")
    public List<SynDecl> synDecls() {
        ASTNode$State state = this.state();
        if (this.synDecls_computed) {
            return this.synDecls_value;
        }
        if (this.synDecls_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.synDecls().");
        }
        this.synDecls_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.synDecls_value = this.synDecls_compute();
        this.synDecls_value.setParent(this);
        this.synDecls_value.is$Final = true;
        this.synDecls_computed = true;
        this.state().leaveLazyAttribute();
        this.synDecls_visited = -1;
        return this.synDecls_value;
    }

    private List<SynDecl> synDecls_compute() {
        List<SynDecl> decls = new List<SynDecl>();
        Collection<SynDecl> parsedDecls = this.grammar().synDeclMap().get(this.name());
        if (parsedDecls != null) {
            for (SynDecl decl : parsedDecls) {
                decls.add(decl);
            }
        }
        for (InterfaceDecl iface : this.implementedInterfaces()) {
            for (SynDecl declInt : iface.synDecls()) {
                Boolean equFlag = false;
                for (SynDecl decl : decls) {
                    if (!decl.signature().equals(declInt.signature())) continue;
                    equFlag = true;
                }
                if (equFlag.booleanValue()) continue;
                declInt.hostName = this.name();
                decls.add(declInt);
            }
        }
        return decls;
    }

    private void synEqs_reset() {
        this.synEqs_computed = false;
        this.synEqs_value = null;
        this.synEqs_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN, isNTA=true)
    @ASTNodeAnnotation.Source(aspect="AttributeWeaving", declaredAt="/jastadd/src/jastadd/ast/Weaving.jrag:105")
    public List<SynEq> synEqs() {
        ASTNode$State state = this.state();
        if (this.synEqs_computed) {
            return this.synEqs_value;
        }
        if (this.synEqs_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.synEqs().");
        }
        this.synEqs_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.synEqs_value = this.synEqs_compute();
        this.synEqs_value.setParent(this);
        this.synEqs_value.is$Final = true;
        this.synEqs_computed = true;
        this.state().leaveLazyAttribute();
        this.synEqs_visited = -1;
        return this.synEqs_value;
    }

    private List<SynEq> synEqs_compute() {
        List<SynEq> equations = new List<SynEq>();
        Collection<SynEq> parsedEqs = this.grammar().synEqMap().get(this.name());
        for (SynEq equ : parsedEqs) {
            equations.add(equ);
        }
        for (InterfaceDecl iface : this.implementedInterfaces()) {
            for (SynEq declInt : iface.synEqs()) {
                Boolean equFlag = false;
                for (SynEq decl : equations) {
                    if (!decl.signature().equals(declInt.signature())) continue;
                    equFlag = true;
                }
                if (equFlag.booleanValue()) continue;
                SynEq eq = declInt.treeCopyNoTransform();
                eq.hostName = this.name();
                equations.add(eq);
            }
        }
        return equations;
    }

    private void synNtaDecls_reset() {
        this.synNtaDecls_computed = false;
        this.synNtaDecls_value = null;
        this.synNtaDecls_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN, isNTA=true)
    @ASTNodeAnnotation.Source(aspect="AttributeWeaving", declaredAt="/jastadd/src/jastadd/ast/Weaving.jrag:133")
    public List<SynthesizedNta> synNtaDecls() {
        ASTNode$State state = this.state();
        if (this.synNtaDecls_computed) {
            return this.synNtaDecls_value;
        }
        if (this.synNtaDecls_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.synNtaDecls().");
        }
        this.synNtaDecls_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.synNtaDecls_value = this.synNtaDecls_compute();
        this.synNtaDecls_value.setParent(this);
        this.synNtaDecls_value.is$Final = true;
        this.synNtaDecls_computed = true;
        this.state().leaveLazyAttribute();
        this.synNtaDecls_visited = -1;
        return this.synNtaDecls_value;
    }

    private List<SynthesizedNta> synNtaDecls_compute() {
        List<SynthesizedNta> decls = new List<SynthesizedNta>();
        for (SynDecl synDecl : this.synDecls()) {
            if (!synDecl.getNTA()) continue;
            decls.addChild(new SynthesizedNta(synDecl.getName(), synDecl.getType()));
        }
        return decls;
    }

    private void collDecls_reset() {
        this.collDecls_computed = false;
        this.collDecls_value = null;
        this.collDecls_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN, isNTA=true)
    @ASTNodeAnnotation.Source(aspect="AttributeWeaving", declaredAt="/jastadd/src/jastadd/ast/Weaving.jrag:165")
    public List<CollDecl> collDecls() {
        ASTNode$State state = this.state();
        if (this.collDecls_computed) {
            return this.collDecls_value;
        }
        if (this.collDecls_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.collDecls().");
        }
        this.collDecls_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.collDecls_value = this.collDecls_compute();
        this.collDecls_value.setParent(this);
        this.collDecls_value.is$Final = true;
        this.collDecls_computed = true;
        this.state().leaveLazyAttribute();
        this.collDecls_visited = -1;
        return this.collDecls_value;
    }

    private List<CollDecl> collDecls_compute() {
        List<CollDecl> decls = new List<CollDecl>();
        Collection<CollDecl> parsedDecls = this.grammar().collDeclMap().get(this.name());
        for (CollDecl decl : parsedDecls) {
            decls.add(decl);
        }
        for (InterfaceDecl iface : this.implementedInterfaces()) {
            for (CollDecl declInt : iface.collDecls()) {
                Boolean equFlag = false;
                for (CollDecl decl : decls) {
                    if (!decl.signature().equals(declInt.signature())) continue;
                    equFlag = true;
                }
                if (equFlag.booleanValue()) continue;
                decls.add(declInt);
            }
        }
        return decls;
    }

    private void collEqs_reset() {
        this.collEqs_computed = false;
        this.collEqs_value = null;
        this.collEqs_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN, isNTA=true)
    @ASTNodeAnnotation.Source(aspect="AttributeWeaving", declaredAt="/jastadd/src/jastadd/ast/Weaving.jrag:214")
    public List<CollEq> collEqs() {
        ASTNode$State state = this.state();
        if (this.collEqs_computed) {
            return this.collEqs_value;
        }
        if (this.collEqs_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.collEqs().");
        }
        this.collEqs_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.collEqs_value = this.collEqs_compute();
        this.collEqs_value.setParent(this);
        this.collEqs_value.is$Final = true;
        this.collEqs_computed = true;
        this.state().leaveLazyAttribute();
        this.collEqs_visited = -1;
        return this.collEqs_value;
    }

    private List<CollEq> collEqs_compute() {
        List<CollEq> equations = new List<CollEq>();
        Collection<CollEq> parsedEqs = this.grammar().collEqMap().get(this);
        for (CollEq equ : parsedEqs) {
            equations.add(equ);
        }
        for (InterfaceDecl iface : this.implementedInterfaces()) {
            for (CollEq declInt : iface.collEqs()) {
                Boolean equFlag = false;
                for (CollEq decl : equations) {
                    if (decl.origin() != declInt.origin()) continue;
                    equFlag = true;
                }
                if (equFlag.booleanValue()) continue;
                equations.add(declInt.cloneForHost(this.name()));
            }
        }
        return equations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="JragCodeGen", declaredAt="/jastadd/src/jastadd/ast/JragCodeGen.jrag:893")
    public boolean hasInhEq(String attrName) {
        String _parameters = attrName;
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.hasInhEq_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.hasInhEq(String).");
        }
        this.hasInhEq_String_visited.put(_parameters, this.state().boundariesCrossed);
        try {
            for (int i = 0; i < this.getNumInhEq(); ++i) {
                InhEq equ = this.getInhEq(i);
                if (!equ.getName().equals(attrName)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.hasInhEq_String_visited.remove(_parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="JragCodeGen", declaredAt="/jastadd/src/jastadd/ast/JragCodeGen.jrag:928")
    public SynDecl lookupSynDeclPrefix(String signature) {
        String _parameters = signature;
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.lookupSynDeclPrefix_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.lookupSynDeclPrefix(String).");
        }
        this.lookupSynDeclPrefix_String_visited.put(_parameters, this.state().boundariesCrossed);
        try {
            for (SynDecl decl : this.synDecls()) {
                if (!decl.signature().equals(signature) && !decl.signature().startsWith(signature + "_")) continue;
                SynDecl synDecl = decl;
                return synDecl;
            }
            Iterator<SynDecl> iterator = null;
            return iterator;
        }
        finally {
            this.lookupSynDeclPrefix_String_visited.remove(_parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="JragCodeGen", declaredAt="/jastadd/src/jastadd/ast/JragCodeGen.jrag:946")
    public InhDecl lookupInhDeclPrefix(String signature) {
        String _parameters = signature;
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.lookupInhDeclPrefix_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.lookupInhDeclPrefix(String).");
        }
        this.lookupInhDeclPrefix_String_visited.put(_parameters, this.state().boundariesCrossed);
        try {
            for (int i = 0; i < this.getNumInhDecl(); ++i) {
                if (!this.getInhDecl(i).signature().equals(signature) && !this.getInhDecl(i).signature().startsWith(signature + "_")) continue;
                InhDecl inhDecl = this.getInhDecl(i);
                return inhDecl;
            }
            InhDecl inhDecl = null;
            return inhDecl;
        }
        finally {
            this.lookupInhDeclPrefix_String_visited.remove(_parameters);
        }
    }

    private void lookupInhDecl_String_reset() {
        this.lookupInhDecl_String_values = new HashMap(4);
        this.lookupInhDecl_String_visited = new HashMap(4);
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="InheritedAttributes", declaredAt="/jastadd/src/jastadd/ast/InheritedAttributes.jrag:86")
    public InhDecl lookupInhDecl(String signature) {
        String _parameters = signature;
        ASTNode$State state = this.state();
        if (this.lookupInhDecl_String_values.containsKey(_parameters)) {
            return (InhDecl)this.lookupInhDecl_String_values.get(_parameters);
        }
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.lookupInhDecl_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.lookupInhDecl(String).");
        }
        this.lookupInhDecl_String_visited.put(_parameters, this.state().boundariesCrossed);
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        InhDecl lookupInhDecl_String_value = this.lookupInhDecl_compute(signature);
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.lookupInhDecl_String_values.put(_parameters, lookupInhDecl_String_value);
        }
        this.state().leaveLazyAttribute();
        this.lookupInhDecl_String_visited.remove(_parameters);
        return lookupInhDecl_String_value;
    }

    private InhDecl lookupInhDecl_compute(String signature) {
        for (int i = 0; i < this.getNumInhDecl(); ++i) {
            if (!this.getInhDecl(i).signature().equals(signature)) continue;
            return this.getInhDecl(i);
        }
        return null;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="AttributeProblems", declaredAt="/jastadd/src/jastadd/ast/AttributeProblems.jrag:264")
    public Collection<? extends TypeDecl> missingSynEqs(String signature) {
        String _parameters = signature;
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.missingSynEqs_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.missingSynEqs(String).");
        }
        this.missingSynEqs_String_visited.put(_parameters, this.state().boundariesCrossed);
        Collection<Object> missingSynEqs_String_value = this.lookupSynEq(signature) == null ? Collections.singleton(this) : Collections.emptyList();
        this.missingSynEqs_String_visited.remove(_parameters);
        return missingSynEqs_String_value;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="AttributeProblems", declaredAt="/jastadd/src/jastadd/ast/AttributeProblems.jrag:531")
    public String collDeclIsAmbiguous(CollDecl decl) {
        CollDecl _parameters = decl;
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.collDeclIsAmbiguous_CollDecl_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.collDeclIsAmbiguous(CollDecl).");
        }
        this.collDeclIsAmbiguous_CollDecl_visited.put(_parameters, this.state().boundariesCrossed);
        String collDeclIsAmbiguous_CollDecl_value = null;
        this.collDeclIsAmbiguous_CollDecl_visited.remove(_parameters);
        return collDeclIsAmbiguous_CollDecl_value;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Grammar", declaredAt="/jastadd/src/jastadd/ast/Grammar.jrag:81")
    public Problem error(String message) {
        String _parameters = message;
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.error_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.error(String).");
        }
        this.error_String_visited.put(_parameters, this.state().boundariesCrossed);
        Problem.Error error_String_value = Problem.builder().message(message).sourceFile(this.getFileName()).sourceLine(this.getStartLine()).buildError();
        this.error_String_visited.remove(_parameters);
        return error_String_value;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Grammar", declaredAt="/jastadd/src/jastadd/ast/Grammar.jrag:154")
    public Collection<InterfaceDecl> implementedInterfaces() {
        if (this.implementedInterfaces_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.implementedInterfaces().");
        }
        this.implementedInterfaces_visited = this.state().boundariesCrossed;
        try {
            Collection<InterfaceDecl> collection = this.interfaceInheritanceOrder();
            return collection;
        }
        finally {
            this.implementedInterfaces_visited = -1;
        }
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="InstanceOf", declaredAt="/jastadd/src/jastadd/ast/ClassRelations.jrag:77")
    public boolean instanceOf(TypeDecl c) {
        TypeDecl _parameters = c;
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.instanceOf_TypeDecl_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.instanceOf(TypeDecl).");
        }
        this.instanceOf_TypeDecl_visited.put(_parameters, this.state().boundariesCrossed);
        boolean instanceOf_TypeDecl_value = c == this;
        this.instanceOf_TypeDecl_visited.remove(_parameters);
        return instanceOf_TypeDecl_value;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Parents", declaredAt="/jastadd/src/jastadd/ast/ClassRelations.jrag:170")
    public Collection<ASTDecl> parentsIntransitive() {
        if (this.parentsIntransitive_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.parentsIntransitive().");
        }
        this.parentsIntransitive_visited = this.state().boundariesCrossed;
        Collection<ASTDecl> parentsIntransitive_value = this.grammar().parentMap().get(this);
        this.parentsIntransitive_visited = -1;
        return parentsIntransitive_value;
    }

    private void lookupSynDecl_String_reset() {
        this.lookupSynDecl_String_values = new HashMap(4);
        this.lookupSynDecl_String_visited = new HashMap(4);
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="BindSynEquations", declaredAt="/jastadd/src/jastadd/ast/NameBinding.jrag:105")
    public SynDecl lookupSynDecl(String signature) {
        String _parameters = signature;
        ASTNode$State state = this.state();
        if (this.lookupSynDecl_String_values.containsKey(_parameters)) {
            return (SynDecl)this.lookupSynDecl_String_values.get(_parameters);
        }
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.lookupSynDecl_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.lookupSynDecl(String).");
        }
        this.lookupSynDecl_String_visited.put(_parameters, this.state().boundariesCrossed);
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        SynDecl lookupSynDecl_String_value = this.lookupSynDecl_compute(signature);
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.lookupSynDecl_String_values.put(_parameters, lookupSynDecl_String_value);
        }
        this.state().leaveLazyAttribute();
        this.lookupSynDecl_String_visited.remove(_parameters);
        return lookupSynDecl_String_value;
    }

    private SynDecl lookupSynDecl_compute(String signature) {
        for (SynDecl decl : this.synDecls()) {
            if (!decl.signature().equals(signature)) continue;
            return decl;
        }
        return null;
    }

    private void lookupSynEq_String_reset() {
        this.lookupSynEq_String_values = new HashMap(4);
        this.lookupSynEq_String_visited = new HashMap(4);
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="BindSynEquations", declaredAt="/jastadd/src/jastadd/ast/NameBinding.jrag:122")
    public SynEq lookupSynEq(String signature) {
        String _parameters = signature;
        ASTNode$State state = this.state();
        if (this.lookupSynEq_String_values.containsKey(_parameters)) {
            return (SynEq)this.lookupSynEq_String_values.get(_parameters);
        }
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.lookupSynEq_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.lookupSynEq(String).");
        }
        this.lookupSynEq_String_visited.put(_parameters, this.state().boundariesCrossed);
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        SynEq lookupSynEq_String_value = this.lookupSynEq_compute(signature);
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.lookupSynEq_String_values.put(_parameters, lookupSynEq_String_value);
        }
        this.state().leaveLazyAttribute();
        this.lookupSynEq_String_visited.remove(_parameters);
        return lookupSynEq_String_value;
    }

    private SynEq lookupSynEq_compute(String signature) {
        for (SynEq equ : this.synEqs()) {
            if (!equ.signature().equals(signature)) continue;
            return equ;
        }
        return null;
    }

    private void hasInhEq_InhDecl_Component_reset() {
        this.hasInhEq_InhDecl_Component_values = new HashMap(4);
        this.hasInhEq_InhDecl_Component_visited = new HashMap(4);
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="BindSynEquations", declaredAt="/jastadd/src/jastadd/ast/NameBinding.jrag:139")
    public boolean hasInhEq(InhDecl decl, Component c) {
        boolean hasInhEq_InhDecl_Component_value;
        ArrayList<ASTNode> _parameters = new ArrayList<ASTNode>(2);
        _parameters.add(decl);
        _parameters.add(c);
        ASTNode$State state = this.state();
        if (this.hasInhEq_InhDecl_Component_values.containsKey(_parameters)) {
            return (Boolean)this.hasInhEq_InhDecl_Component_values.get(_parameters);
        }
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.hasInhEq_InhDecl_Component_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.hasInhEq(InhDecl,Component).");
        }
        this.hasInhEq_InhDecl_Component_visited.put(_parameters, this.state().boundariesCrossed);
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        boolean bl = hasInhEq_InhDecl_Component_value = this.lookupInhEq(decl.signature(), c.name()) != null;
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.hasInhEq_InhDecl_Component_values.put(_parameters, hasInhEq_InhDecl_Component_value);
        }
        this.state().leaveLazyAttribute();
        this.hasInhEq_InhDecl_Component_visited.remove(_parameters);
        return hasInhEq_InhDecl_Component_value;
    }

    private void lookupInhEq_String_String_reset() {
        this.lookupInhEq_String_String_values = new HashMap(4);
        this.lookupInhEq_String_String_visited = new HashMap(4);
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="BindSynEquations", declaredAt="/jastadd/src/jastadd/ast/NameBinding.jrag:142")
    public InhEq lookupInhEq(String signature, String childName) {
        ArrayList<String> _parameters = new ArrayList<String>(2);
        _parameters.add(signature);
        _parameters.add(childName);
        ASTNode$State state = this.state();
        if (this.lookupInhEq_String_String_values.containsKey(_parameters)) {
            return (InhEq)this.lookupInhEq_String_String_values.get(_parameters);
        }
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.lookupInhEq_String_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.lookupInhEq(String,String).");
        }
        this.lookupInhEq_String_String_visited.put(_parameters, this.state().boundariesCrossed);
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        InhEq lookupInhEq_String_String_value = this.lookupInhEq_compute(signature, childName);
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.lookupInhEq_String_String_values.put(_parameters, lookupInhEq_String_String_value);
        }
        this.state().leaveLazyAttribute();
        this.lookupInhEq_String_String_visited.remove(_parameters);
        return lookupInhEq_String_String_value;
    }

    private InhEq lookupInhEq_compute(String signature, String childName) {
        int i;
        for (i = 0; i < this.getNumInhEq(); ++i) {
            if (!this.getInhEq(i).signature().equals(signature) || !this.getInhEq(i).childName().equals(childName)) continue;
            return this.getInhEq(i);
        }
        for (i = 0; i < this.getNumInhEq(); ++i) {
            if (!this.getInhEq(i).signature().equals(signature) || !this.getInhEq(i).childName().equals("Child")) continue;
            return this.getInhEq(i);
        }
        return null;
    }

    private void inhEqMap_reset() {
        this.inhEqMap_computed = false;
        this.inhEqMap_value = null;
        this.inhEqMap_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="ASTDecl", declaredAt="/jastadd/src/jastadd/ast/NameBinding.jrag:177")
    public HashMap<String, LinkedList<InhEq>> inhEqMap() {
        ASTNode$State state = this.state();
        if (this.inhEqMap_computed) {
            return this.inhEqMap_value;
        }
        if (this.inhEqMap_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.inhEqMap().");
        }
        this.inhEqMap_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.inhEqMap_value = this.inhEqMap_compute();
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.inhEqMap_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.inhEqMap_visited = -1;
        return this.inhEqMap_value;
    }

    private HashMap<String, LinkedList<InhEq>> inhEqMap_compute() {
        LinkedHashMap<String, LinkedList<InhEq>> map = new LinkedHashMap<String, LinkedList<InhEq>>();
        for (int i = 0; i < this.getNumInhEq(); ++i) {
            InhEq equ = this.getInhEq(i);
            String id = equ.type() + "_" + equ.signature();
            LinkedList<InhEq> list = (LinkedList<InhEq>)((HashMap)map).get(id);
            if (list == null) {
                list = new LinkedList<InhEq>();
                map.put(id, list);
            }
            if (equ.getChildName().equals("getChild")) {
                list.add(equ);
                continue;
            }
            if (equ.getComponent() != null && equ.getComponent().isNTA()) {
                list.add(0, equ);
                continue;
            }
            list.add(0, equ);
        }
        return map;
    }

    private void components_reset() {
        this.components_computed = false;
        this.components_value = null;
        this.components_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Comp", declaredAt="/jastadd/src/jastadd/ast/ComponentsUtil.jrag:78")
    public Collection<Component> components() {
        ASTNode$State state = this.state();
        if (this.components_computed) {
            return this.components_value;
        }
        if (this.components_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.components().");
        }
        this.components_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.components_value = this.components_compute();
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.components_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.components_visited = -1;
        return this.components_value;
    }

    private Collection<Component> components_compute() {
        LinkedList<Component> list = new LinkedList<Component>();
        for (int i = 0; i < this.getNumComponent(); ++i) {
            list.add(this.getComponent(i));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Interfaces", declaredAt="/jastadd/src/jastadd/ast/Interfaces.jrag:44")
    public Set<InterfaceDecl> implementedInterfacesSet() {
        if (this.implementedInterfacesSet_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.implementedInterfacesSet().");
        }
        this.implementedInterfacesSet_visited = this.state().boundariesCrossed;
        try {
            HashSet<InterfaceDecl> interfaceSet = new HashSet<InterfaceDecl>();
            for (TypeDecl td : this.grammar().getTypeDecls()) {
                if (!(td instanceof InterfaceDecl) || !this.implementsInterface(td.name())) continue;
                interfaceSet.add((InterfaceDecl)td);
            }
            HashSet<InterfaceDecl> hashSet = interfaceSet;
            return hashSet;
        }
        finally {
            this.implementedInterfacesSet_visited = -1;
        }
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Interfaces", declaredAt="/jastadd/src/jastadd/ast/Interfaces.jrag:57")
    public Set<InterfaceDecl> interfacesSetFromSuperclass() {
        if (this.interfacesSetFromSuperclass_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.interfacesSetFromSuperclass().");
        }
        this.interfacesSetFromSuperclass_visited = this.state().boundariesCrossed;
        Set<InterfaceDecl> interfacesSetFromSuperclass_value = Collections.emptySet();
        this.interfacesSetFromSuperclass_visited = -1;
        return interfacesSetFromSuperclass_value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Interfaces", declaredAt="/jastadd/src/jastadd/ast/Interfaces.jrag:70")
    public Set<InterfaceDecl> transitiveSuperInterfacesSet() {
        if (this.transitiveSuperInterfacesSet_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.transitiveSuperInterfacesSet().");
        }
        this.transitiveSuperInterfacesSet_visited = this.state().boundariesCrossed;
        try {
            HashSet<InterfaceDecl> superInterfaceSet = new HashSet<InterfaceDecl>();
            LinkedList<InterfaceDecl> workQueue = new LinkedList<InterfaceDecl>();
            workQueue.addAll(this.implementedInterfacesSet());
            while (!workQueue.isEmpty()) {
                InterfaceDecl workItem = (InterfaceDecl)workQueue.remove();
                if (!superInterfaceSet.add(workItem)) continue;
                for (InterfaceDecl idecl : workItem.implementedInterfacesSet()) {
                    if (superInterfaceSet.contains(idecl)) continue;
                    workQueue.add(idecl);
                }
            }
            HashSet<InterfaceDecl> hashSet = superInterfaceSet;
            return hashSet;
        }
        finally {
            this.transitiveSuperInterfacesSet_visited = -1;
        }
    }

    private void transitiveAttributeImplementationsExcluding_Set_TypeDecl__reset() {
        this.transitiveAttributeImplementationsExcluding_Set_TypeDecl__values = new HashMap(4);
        this.transitiveAttributeImplementationsExcluding_Set_TypeDecl__visited = new HashMap(4);
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Interfaces", declaredAt="/jastadd/src/jastadd/ast/Interfaces.jrag:101")
    public Map<AttrSignature, Collection<TypeDecl>> transitiveAttributeImplementationsExcluding(Set<TypeDecl> exclusions) {
        Set<TypeDecl> _parameters = exclusions;
        ASTNode$State state = this.state();
        if (this.transitiveAttributeImplementationsExcluding_Set_TypeDecl__values.containsKey(_parameters)) {
            return (Map)this.transitiveAttributeImplementationsExcluding_Set_TypeDecl__values.get(_parameters);
        }
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.transitiveAttributeImplementationsExcluding_Set_TypeDecl__visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.transitiveAttributeImplementationsExcluding(Set_TypeDecl_).");
        }
        this.transitiveAttributeImplementationsExcluding_Set_TypeDecl__visited.put(_parameters, this.state().boundariesCrossed);
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        Map<AttrSignature, Collection<TypeDecl>> transitiveAttributeImplementationsExcluding_Set_TypeDecl__value = this.transitiveAttributeImplementationsExcluding_compute(exclusions);
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.transitiveAttributeImplementationsExcluding_Set_TypeDecl__values.put(_parameters, transitiveAttributeImplementationsExcluding_Set_TypeDecl__value);
        }
        this.state().leaveLazyAttribute();
        this.transitiveAttributeImplementationsExcluding_Set_TypeDecl__visited.remove(_parameters);
        return transitiveAttributeImplementationsExcluding_Set_TypeDecl__value;
    }

    private Map<AttrSignature, Collection<TypeDecl>> transitiveAttributeImplementationsExcluding_compute(Set<TypeDecl> exclusions) {
        if (exclusions.contains(this)) {
            return new TreeMap<AttrSignature, Collection<TypeDecl>>();
        }
        HashSet<TypeDecl> recursiveExclusions = new HashSet<TypeDecl>(exclusions);
        recursiveExclusions.add(this);
        recursiveExclusions.addAll(this.interfacesSetFromSuperclass());
        TreeMap<AttrSignature, Collection<TypeDecl>> results = new TreeMap<AttrSignature, Collection<TypeDecl>>();
        for (InterfaceDecl superInterface : this.implementedInterfacesSet()) {
            Map<AttrSignature, Collection<TypeDecl>> superContributions = superInterface.transitiveAttributeImplementationsExcluding(recursiveExclusions);
            for (Map.Entry<AttrSignature, Collection<TypeDecl>> entry : superContributions.entrySet()) {
                if (!results.containsKey(entry.getKey())) {
                    results.put(entry.getKey(), new HashSet<TypeDecl>(entry.getValue()));
                }
                Collection decls = (Collection)results.get(entry.getKey());
                for (TypeDecl newDecl : entry.getValue()) {
                    boolean viable = true;
                    if (decls.contains(newDecl)) continue;
                    for (TypeDecl existingDecl : decls) {
                        if (!existingDecl.isSubInterfaceOf(newDecl)) continue;
                        viable = false;
                        break;
                    }
                    if (!viable) continue;
                    ArrayList<TypeDecl> obsoleteDecls = new ArrayList<TypeDecl>();
                    for (TypeDecl existingDecl : decls) {
                        if (!newDecl.isSubInterfaceOf(existingDecl)) continue;
                        obsoleteDecls.add(existingDecl);
                    }
                    decls.removeAll(obsoleteDecls);
                    decls.add(newDecl);
                }
            }
        }
        ArrayList<TypeDecl> self = new ArrayList<TypeDecl>(1);
        self.add(this);
        this.addImplementationMapOverrides(results, self, true);
        return results;
    }

    private void attributeImplementationsWithInterfaces_reset() {
        this.attributeImplementationsWithInterfaces_computed = false;
        this.attributeImplementationsWithInterfaces_value = null;
        this.attributeImplementationsWithInterfaces_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Interfaces", declaredAt="/jastadd/src/jastadd/ast/Interfaces.jrag:224")
    public Map<AttrSignature, TypeDecl> attributeImplementationsWithInterfaces() {
        ASTNode$State state = this.state();
        if (this.attributeImplementationsWithInterfaces_computed) {
            return this.attributeImplementationsWithInterfaces_value;
        }
        if (this.attributeImplementationsWithInterfaces_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.attributeImplementationsWithInterfaces().");
        }
        this.attributeImplementationsWithInterfaces_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.attributeImplementationsWithInterfaces_value = this.attributeImplementationsWithInterfaces_compute();
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.attributeImplementationsWithInterfaces_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.attributeImplementationsWithInterfaces_visited = -1;
        return this.attributeImplementationsWithInterfaces_value;
    }

    private Map<AttrSignature, TypeDecl> attributeImplementationsWithInterfaces_compute() {
        TreeMap<AttrSignature, TypeDecl> result = new TreeMap<AttrSignature, TypeDecl>();
        for (Map.Entry<AttrSignature, Collection<TypeDecl>> entry : this.transitiveAttributeImplementationsExcluding(Collections.<TypeDecl>emptySet()).entrySet()) {
            if (entry.getValue().size() != 1) continue;
            for (TypeDecl d : entry.getValue()) {
                result.put(entry.getKey(), d);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Interfaces", declaredAt="/jastadd/src/jastadd/ast/Interfaces.jrag:241")
    public Map<AttrSignature, Collection<InterfaceDecl>> ambiguousAttributeImplementationsFromInterfaces() {
        if (this.ambiguousAttributeImplementationsFromInterfaces_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.ambiguousAttributeImplementationsFromInterfaces().");
        }
        this.ambiguousAttributeImplementationsFromInterfaces_visited = this.state().boundariesCrossed;
        try {
            TreeMap result = new TreeMap();
            for (Map.Entry<AttrSignature, Collection<TypeDecl>> entry : this.transitiveAttributeImplementationsExcluding(Collections.<TypeDecl>emptySet()).entrySet()) {
                if (entry.getValue().size() <= 1) continue;
                ArrayList<InterfaceDecl> clashingInterfaces = new ArrayList<InterfaceDecl>();
                for (TypeDecl td : entry.getValue()) {
                    clashingInterfaces.add((InterfaceDecl)td);
                }
                result.put(entry.getKey(), clashingInterfaces);
            }
            TreeMap treeMap = result;
            return treeMap;
        }
        finally {
            this.ambiguousAttributeImplementationsFromInterfaces_visited = -1;
        }
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Interfaces", declaredAt="/jastadd/src/jastadd/ast/Interfaces.jrag:260")
    public InterfaceDecl asInterfaceDecl() {
        if (this.asInterfaceDecl_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.asInterfaceDecl().");
        }
        this.asInterfaceDecl_visited = this.state().boundariesCrossed;
        InterfaceDecl asInterfaceDecl_value = null;
        this.asInterfaceDecl_visited = -1;
        return asInterfaceDecl_value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Interfaces", declaredAt="/jastadd/src/jastadd/ast/Interfaces.jrag:376")
    public ArrayList<String> interfaceInheritanceConflicts() {
        if (this.interfaceInheritanceConflicts_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.interfaceInheritanceConflicts().");
        }
        this.interfaceInheritanceConflicts_visited = this.state().boundariesCrossed;
        try {
            Map<AttrSignature, Collection<InterfaceDecl>> conflicts = this.ambiguousAttributeImplementationsFromInterfaces();
            ArrayList<String> errors = new ArrayList<String>();
            for (Map.Entry<AttrSignature, Collection<InterfaceDecl>> conflict : conflicts.entrySet()) {
                ArrayList<String> interfaces = new ArrayList<String>();
                for (InterfaceDecl iface : conflict.getValue()) {
                    interfaces.add(iface.toString());
                }
                Collections.sort(interfaces);
                errors.add("- " + conflict.getKey() + ": defined in " + interfaces);
            }
            ArrayList<String> arrayList = errors;
            return arrayList;
        }
        finally {
            this.interfaceInheritanceConflicts_visited = -1;
        }
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Interfaces", declaredAt="/jastadd/src/jastadd/ast/Interfaces.jrag:394")
    public Collection<InterfaceDecl> interfaceInheritanceOrder() {
        if (this.interfaceInheritanceOrder_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.interfaceInheritanceOrder().");
        }
        this.interfaceInheritanceOrder_visited = this.state().boundariesCrossed;
        try {
            ArrayList<InterfaceDecl> arrayList = new InheritanceConstraintOrdering<InterfaceDecl>(this.implementedInterfacesSet()).getOrdered();
            return arrayList;
        }
        finally {
            this.interfaceInheritanceOrder_visited = -1;
        }
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Interfaces", declaredAt="/jastadd/src/jastadd/ast/Interfaces.jrag:403")
    public String inheritanceClash() {
        if (this.inheritanceClash_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.inheritanceClash().");
        }
        this.inheritanceClash_visited = this.state().boundariesCrossed;
        try {
            ArrayList<String> clashes = this.interfaceInheritanceConflicts();
            if (clashes.isEmpty()) {
                String string = null;
                return string;
            }
            String string = String.join((CharSequence)System.lineSeparator(), clashes) + System.lineSeparator();
            return string;
        }
        finally {
            this.inheritanceClash_visited = -1;
        }
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="CollectionAttributes", declaredAt="/jastadd/src/jastadd/ast/CollectionAttributes.jrag:160")
    public boolean hasCollEq(CollDecl decl) {
        CollDecl _parameters = decl;
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.hasCollEq_CollDecl_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.hasCollEq(CollDecl).");
        }
        this.hasCollEq_CollDecl_visited.put(_parameters, this.state().boundariesCrossed);
        boolean hasCollEq_CollDecl_value = false;
        this.hasCollEq_CollDecl_visited.remove(_parameters);
        return hasCollEq_CollDecl_value;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="CollectionAttributes", declaredAt="/jastadd/src/jastadd/ast/CollectionAttributes.jrag:466")
    public boolean isRootNode() {
        if (this.isRootNode_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.isRootNode().");
        }
        this.isRootNode_visited = this.state().boundariesCrossed;
        boolean isRootNode_value = false;
        this.isRootNode_visited = -1;
        return isRootNode_value;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="CollectionAttributes", declaredAt="/jastadd/src/jastadd/ast/CollectionAttributes.jrag:470")
    public boolean isPotentialRootNode() {
        if (this.isPotentialRootNode_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.isPotentialRootNode().");
        }
        this.isPotentialRootNode_visited = this.state().boundariesCrossed;
        boolean isPotentialRootNode_value = false;
        this.isPotentialRootNode_visited = -1;
        return isPotentialRootNode_value;
    }

    private void component_String_reset() {
        this.component_String_values = new HashMap(4);
        this.component_String_visited = new HashMap(4);
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Attributes", declaredAt="/jastadd/src/jastadd/ast/Attributes.jrag:489")
    public Component component(String name) {
        String _parameters = name;
        ASTNode$State state = this.state();
        if (this.component_String_values.containsKey(_parameters)) {
            return (Component)this.component_String_values.get(_parameters);
        }
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.component_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.component(String).");
        }
        this.component_String_visited.put(_parameters, this.state().boundariesCrossed);
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        Component component_String_value = this.component_compute(name);
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.component_String_values.put(_parameters, component_String_value);
        }
        this.state().leaveLazyAttribute();
        this.component_String_visited.remove(_parameters);
        return component_String_value;
    }

    private Component component_compute(String name) {
        for (Component c : this.components()) {
            if (!c.name().equals(name)) continue;
            return c;
        }
        return null;
    }

    private void lookupComponent_String_reset() {
        this.lookupComponent_String_values = new HashMap(4);
        this.lookupComponent_String_visited = new HashMap(4);
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Lookup", declaredAt="/jastadd/src/jastadd/ast/ASTNameBinding.jrag:90")
    public Component lookupComponent(String name) {
        String _parameters = name;
        ASTNode$State state = this.state();
        if (this.lookupComponent_String_values.containsKey(_parameters)) {
            return (Component)this.lookupComponent_String_values.get(_parameters);
        }
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.lookupComponent_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.lookupComponent(String).");
        }
        this.lookupComponent_String_visited.put(_parameters, this.state().boundariesCrossed);
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        Component lookupComponent_String_value = null;
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.lookupComponent_String_values.put(_parameters, lookupComponent_String_value);
        }
        this.state().leaveLazyAttribute();
        this.lookupComponent_String_visited.remove(_parameters);
        return lookupComponent_String_value;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Names", declaredAt="/jastadd/src/jastadd/ast/ASTNameBinding.jrag:103")
    public String name() {
        if (this.name_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.name().");
        }
        this.name_visited = this.state().boundariesCrossed;
        String name_value = this.getIdDecl().name();
        this.name_visited = -1;
        return name_value;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.INH)
    @ASTNodeAnnotation.Source(aspect="Subclasses", declaredAt="/jastadd/src/jastadd/ast/ClassRelations.jrag:108")
    public Collection<ASTDecl> findSubclasses(ASTDecl target) {
        ASTDecl _parameters = target;
        ASTNode$State state = this.state();
        if (this.findSubclasses_ASTDecl_values.containsKey(_parameters)) {
            return (Collection)this.findSubclasses_ASTDecl_values.get(_parameters);
        }
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.findSubclasses_ASTDecl_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.findSubclasses(ASTDecl).");
        }
        this.findSubclasses_ASTDecl_visited.put(_parameters, this.state().boundariesCrossed);
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        Collection<ASTDecl> findSubclasses_ASTDecl_value = this.getParent().Define_findSubclasses(this, null, target);
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.findSubclasses_ASTDecl_values.put(_parameters, findSubclasses_ASTDecl_value);
        }
        this.state().leaveLazyAttribute();
        this.findSubclasses_ASTDecl_visited.remove(_parameters);
        return findSubclasses_ASTDecl_value;
    }

    private void findSubclasses_ASTDecl_reset() {
        this.findSubclasses_ASTDecl_values = new HashMap(4);
        this.findSubclasses_ASTDecl_visited = new HashMap(4);
    }

    @Override
    public TypeDecl Define_hostClass(ASTNode _callerNode, ASTNode _childNode) {
        int childIndex = this.getIndexOfChild(_callerNode);
        return this;
    }

    @Override
    protected boolean canDefine_hostClass(ASTNode _callerNode, ASTNode _childNode) {
        return true;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.COLL)
    @ASTNodeAnnotation.Source(aspect="AttributeProblems", declaredAt="/jastadd/src/jastadd/ast/AttributeProblems.jrag:91")
    public Collection<Problem> attributeProblems() {
        ASTNode$State state = this.state();
        if (this.TypeDecl_attributeProblems_computed) {
            return this.TypeDecl_attributeProblems_value;
        }
        if (this.TypeDecl_attributeProblems_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.attributeProblems().");
        }
        this.TypeDecl_attributeProblems_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.TypeDecl_attributeProblems_value = this.attributeProblems_compute();
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.TypeDecl_attributeProblems_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.TypeDecl_attributeProblems_visited = -1;
        return this.TypeDecl_attributeProblems_value;
    }

    private Collection<Problem> attributeProblems_compute() {
        ASTNode node;
        for (node = this; node != null && !(node instanceof TypeDecl); node = node.getParent()) {
        }
        TypeDecl root = node;
        root.survey_TypeDecl_attributeProblems();
        LinkedList<Problem> _computedValue = new LinkedList<Problem>();
        if (root.contributorMap_TypeDecl_attributeProblems.containsKey(this)) {
            for (ASTNode contributor : root.contributorMap_TypeDecl_attributeProblems.get(this)) {
                contributor.contributeTo_TypeDecl_attributeProblems(_computedValue);
            }
        }
        return _computedValue;
    }

    @Override
    protected void collect_contributors_Grammar_interfaceProblems(Grammar _root, Map<ASTNode, Set<ASTNode>> _map) {
        if (this.inheritanceClash() != null) {
            Set<ASTNode> contributors = _map.get(_root);
            if (contributors == null) {
                contributors = new LinkedHashSet<ASTNode>();
                _map.put(_root, contributors);
            }
            contributors.add(this);
        }
        super.collect_contributors_Grammar_interfaceProblems(_root, _map);
    }

    @Override
    protected void collect_contributors_Grammar_problems(Grammar _root, Map<ASTNode, Set<ASTNode>> _map) {
        if (this.grammar().lookup(this.name()) != this) {
            Grammar target = this.grammar();
            Set<ASTNode> contributors = _map.get(target);
            if (contributors == null) {
                contributors = new LinkedHashSet<ASTNode>();
                _map.put(target, contributors);
            }
            contributors.add(this);
        }
        super.collect_contributors_Grammar_problems(_root, _map);
    }

    @Override
    protected void collect_contributors_TypeDecl_attributeProblems(TypeDecl _root, Map<ASTNode, Set<ASTNode>> _map) {
        this.synEqs().collect_contributors_TypeDecl_attributeProblems(_root, _map);
        this.synDecls().collect_contributors_TypeDecl_attributeProblems(_root, _map);
        this.collDecls().collect_contributors_TypeDecl_attributeProblems(_root, _map);
        this.collEqs().collect_contributors_TypeDecl_attributeProblems(_root, _map);
        super.collect_contributors_TypeDecl_attributeProblems(_root, _map);
        this.collDecls().collect_contributors_TypeDecl_attributeProblems(_root, _map);
    }

    @Override
    protected void collect_contributors_CollDecl_uses(Grammar _root, Map<ASTNode, Set<ASTNode>> _map) {
        this.collEqs().collect_contributors_CollDecl_uses(_root, _map);
        super.collect_contributors_CollDecl_uses(_root, _map);
    }

    @Override
    protected void contributeTo_Grammar_interfaceProblems(Collection<Problem> collection) {
        super.contributeTo_Grammar_interfaceProblems(collection);
        if (this.inheritanceClash() != null) {
            collection.add(this.errorf("Type %s inherits clashing interfaces:\n%s\nSome possible resolutions: (1) rename attributes, (2) make higher-priority interfaces extend lower-priority ones, (3) provide custom attribute specifications in %s\n", this.name(), this.inheritanceClash(), this.name()));
        }
    }

    @Override
    protected void contributeTo_Grammar_problems(Collection<Problem> collection) {
        super.contributeTo_Grammar_problems(collection);
        if (this.grammar().lookup(this.name()) != this) {
            collection.add(Problem.builder().message("multiple production rule for non-terminal %s", this.name()).buildError());
        }
    }
}

