/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.jrag.AST;

import java.lang.reflect.Constructor;
import org.jastadd.jrag.AST.JragParser;
import org.jastadd.jrag.AST.JragParserTreeConstants;
import org.jastadd.jrag.AST.JragParserVisitor;
import org.jastadd.jrag.AST.Node;
import org.jastadd.jrag.AST.Token;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected JragParser parser;
    public Token firstToken;
    public Token lastToken;

    public SimpleNode(int i) {
        this.id = i;
    }

    public SimpleNode(JragParser p, int i) {
        this(i);
        this.parser = p;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    @Override
    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    @Override
    public Object jjtAccept(JragParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object childrenAccept(JragParserVisitor visitor, Object data) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].jjtAccept(visitor, data);
            }
        }
        return data;
    }

    public String toString() {
        return JragParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n == null) continue;
                n.dump(prefix + " ");
            }
        }
    }

    public SimpleNode copy() {
        try {
            Constructor<?> c = this.getClass().getDeclaredConstructor(Integer.TYPE);
            SimpleNode node = (SimpleNode)c.newInstance(new Integer(this.id));
            if (this.children != null) {
                node.children = (Node[])this.children.clone();
            }
            return node;
        }
        catch (Exception exception) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public SimpleNode fullCopy() {
        SimpleNode res = this.copy();
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            SimpleNode node = (SimpleNode)this.jjtGetChild(i);
            if (node != null) {
                node = node.fullCopy();
            }
            node.jjtSetParent(res);
            res.jjtAddChild(node, i);
        }
        return res;
    }
}

