/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.option;

import java.io.PrintStream;
import org.jastadd.tinytemplate.TemplateContext;

public abstract class Option<ValueType>
implements Comparable<Option<?>> {
    public static final String PREFIX = "--";
    public static final String VALUE_SEPARATOR = "=";
    protected static final int TAB_1 = 2;
    protected static final int TAB_2 = 20;
    protected static final int TAB_3 = 22;
    protected static final int TAB_4 = 33;
    protected String description = "";
    protected String name;
    private String templateVariable = "";
    protected boolean isNonStandard = false;
    protected boolean isDeprecated = false;
    protected String deprecationMessage = "";
    protected String deprecatedSince = "";
    protected boolean isMatched = false;

    public Option(String optionName, String description) {
        this.name = optionName;
        this.description = description;
    }

    public final Option<ValueType> templateVariable(String templateName) {
        this.templateVariable = templateName;
        return this;
    }

    public final Option<ValueType> nonStandard() {
        this.isNonStandard = true;
        return this;
    }

    public final Option<ValueType> deprecated(String since) {
        this.isDeprecated = true;
        this.deprecatedSince = since;
        return this;
    }

    public final Option<ValueType> deprecated(String since, String message) {
        this.deprecationMessage = message;
        return this.deprecated(since);
    }

    public final void printHelp(PrintStream out) {
        this.printIndent(out, 2);
        String longName = PREFIX + this.name;
        out.print(longName);
        this.printIndent(out, Math.max(20 - longName.length() - 2, 1));
        this.printDescription(out);
    }

    protected void printDescription(PrintStream out) {
        this.printDescription(out, this.description(), 20);
    }

    protected String description() {
        if (this.isDeprecated && !this.deprecationMessage.isEmpty()) {
            return this.deprecationMessage;
        }
        return this.description;
    }

    protected void printDescription(PrintStream out, String desc, int col) {
        String[] lines = desc.split("\n", -1);
        for (int i = 0; i < lines.length; ++i) {
            if (i != 0) {
                this.printIndent(out, col);
            }
            out.println(lines[i]);
        }
    }

    protected void printIndent(PrintStream out, int nbr) {
        for (int i = 0; i < nbr; ++i) {
            out.print(' ');
        }
    }

    public void matchWithoutArg(PrintStream err) {
        this.onMatch(err);
    }

    public void matchWithArg(PrintStream err, String arg) {
        err.println("Warning: the option '" + this.name + "' does not take an argument. The argument value '" + arg + "' will be ignored!");
        this.onMatch(err);
    }

    protected void onMatch(PrintStream out) {
        this.reportWarnings(out);
        this.isMatched = true;
    }

    public boolean isMatched() {
        return this.isMatched;
    }

    public void reportWarnings(PrintStream out) {
        if (this.isMatched) {
            out.println("Warning: the option " + this.name + " occurs more than once in the argument list!");
        } else if (this.isDeprecated) {
            out.print("Warning: the option " + this.name + " has been deprecated since version " + this.deprecatedSince);
            if (!this.deprecationMessage.isEmpty()) {
                out.print(" (");
                out.print(this.deprecationMessage);
                out.print(")");
            }
            out.println(". Use of this option is discouraged!");
        }
    }

    public String toString() {
        return PREFIX + this.name;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public String name() {
        return this.name;
    }

    public void bind(TemplateContext context) {
        if (!this.templateVariable.isEmpty()) {
            context.bind(this.templateVariable, this.value());
        }
    }

    public abstract ValueType value();

    @Override
    public int compareTo(Option<?> other) {
        return this.name.compareToIgnoreCase(other.name);
    }
}

