/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.tinytemplate;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.jastadd.tinytemplate.TemplateContext;
import org.jastadd.tinytemplate.fragment.AbstractFragment;
import org.jastadd.tinytemplate.fragment.Fragment;

public class Indentation {
    private final String indentation;
    private final List<String> ind = new ArrayList<String>(32);
    private static final List<Fragment> fragments = new ArrayList<Fragment>(32);

    public Indentation(String indent) {
        this.indentation = indent;
        this.ind.add("");
    }

    public static Fragment getFragment(int level) {
        while (fragments.size() < level + 1) {
            fragments.add(new IndentationFragment(fragments.size()));
        }
        return fragments.get(level);
    }

    public String get(int level) {
        while (this.ind.size() < level + 1) {
            this.ind.add(this.ind.get(this.ind.size() - 1) + this.indentation);
        }
        return this.ind.get(level);
    }

    public static class IndentationFragment
    extends AbstractFragment {
        private final int level;

        protected IndentationFragment(int indentLevel) {
            this.level = indentLevel;
        }

        @Override
        public void expand(TemplateContext context, StringBuilder out) {
            out.append(context.evalIndentation(this.level));
        }

        @Override
        public boolean isWhitespace() {
            return true;
        }

        @Override
        public boolean isIndentation() {
            return true;
        }

        @Override
        public void printAspectCode(Indentation ind, int lvl, PrintStream out) {
            out.println(ind.get(lvl) + "out.indent(" + this.level + ");");
        }
    }
}

