/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.tinytemplate.fragment;

import java.io.PrintStream;
import org.jastadd.tinytemplate.Indentation;
import org.jastadd.tinytemplate.TemplateContext;
import org.jastadd.tinytemplate.TemplateExpansionWarning;
import org.jastadd.tinytemplate.TemplateParser;
import org.jastadd.tinytemplate.fragment.NestedIndentationFragment;

public class Concat
extends NestedIndentationFragment {
    private String iterable;
    private final String sep;
    private boolean isAttribute;

    public Concat(String iterable) throws TemplateParser.SyntaxError {
        this(iterable, null);
    }

    public Concat(String iterable, String separator) throws TemplateParser.SyntaxError {
        if (iterable.startsWith("#")) {
            this.iterable = iterable.substring(1);
            this.isAttribute = true;
        } else if (iterable.startsWith("$")) {
            this.iterable = iterable.substring(1);
            this.isAttribute = false;
        }
        if (separator == null) {
            throw new NullPointerException();
        }
        this.sep = separator;
    }

    @Override
    public void expand(TemplateContext context, StringBuilder out) {
        if (!this.isAttribute) {
            throw new TemplateExpansionWarning("Variable " + this.iterable + " is not iterable");
        }
        this.expandAttribute(context, out);
    }

    private void expandAttribute(TemplateContext context, StringBuilder out) {
        StringBuilder sb;
        Object value = context.evalAttribute(this.iterable);
        if (value instanceof Iterable) {
            Iterable itr = (Iterable)value;
            sb = new StringBuilder();
            boolean first = true;
            for (Object o : itr) {
                if (this.sep != null && !first) {
                    sb.append(this.sep);
                }
                first = false;
                sb.append(String.valueOf(o));
            }
        } else {
            throw new TemplateExpansionWarning("Attribute " + this.iterable + " is not iterable");
        }
        this.expandWithIndentation(sb.toString(), context, out);
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public boolean isExpansion() {
        return true;
    }

    @Override
    public void printAspectCode(Indentation ind, int lvl, PrintStream out) {
        out.println(ind.get(lvl++) + "{");
        if (!this.sep.isEmpty()) {
            out.println(ind.get(lvl) + "boolean first = true;");
        }
        out.print(ind.get(lvl++) + "for (PrettyPrintable p: ");
        if (this.isAttribute) {
            out.print(this.iterable + "()");
        } else {
            out.print("get" + this.iterable + "()");
        }
        out.println(") {");
        if (!this.sep.isEmpty()) {
            out.println(ind.get(lvl++) + "if (!first) {");
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < this.sep.length(); ++i) {
                if (i + 1 < this.sep.length() && this.sep.charAt(i) == '\\' && this.sep.charAt(i + 1) == 'n') {
                    ++i;
                    if (buf.length() > 0) {
                        out.println(ind.get(lvl) + "out.print(\"" + buf.toString() + "\");");
                    }
                    out.println(ind.get(lvl) + "out.println();");
                    buf.setLength(0);
                    continue;
                }
                buf.append(this.sep.charAt(i));
            }
            if (buf.length() > 0) {
                out.println(ind.get(lvl) + "out.print(\"" + buf.toString() + "\");");
            }
            out.println(ind.get(--lvl) + "}");
            out.println(ind.get(lvl) + "first = false;");
        }
        out.println(ind.get(lvl) + "out.print(p);");
        out.println(ind.get(--lvl) + "}");
        out.println(ind.get(--lvl) + "}");
    }
}

