/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.jastadd.Configuration;
import org.jastadd.JastAdd;
import org.jastadd.option.FlagOption;
import org.jastadd.option.Option;

public class JastAddTask
extends Task {
    private final Configuration config = new Configuration();

    private void setOption(Option<?> option, boolean value) {
        if (option instanceof FlagOption) {
            if (value) {
                option.matchWithoutArg(System.err);
            } else {
                option.reportWarnings(System.err);
            }
        } else {
            option.matchWithArg(System.err, "" + value);
        }
    }

    private void setOption(Option<?> option, String value) {
        option.matchWithArg(System.err, value);
    }

    public void init() {
        super.init();
    }

    public void addConfiguredFileSet(FileSet fileset) {
        DirectoryScanner s = fileset.getDirectoryScanner(this.getProject());
        String[] files = s.getIncludedFiles();
        String baseDir = s.getBasedir().getPath();
        for (int i = 0; i < files.length; ++i) {
            this.config.filenames.add(baseDir + File.separator + files[i]);
        }
    }

    public void setASTNode(String arg) {
        this.setOption(this.config.ASTNodeOption, arg);
    }

    public void setList(String arg) {
        this.setOption(this.config.ListOption, arg);
    }

    public void setOpt(String arg) {
        this.setOption(this.config.OptOption, arg);
    }

    public void setStateClassName(String arg) {
        this.setOption(this.config.stateClassNameOption, arg);
    }

    public void setASTNodeSuper(String arg) {
        this.setOption(this.config.ASTNodeSuperOption, arg);
    }

    public void setGenerateImplicits(boolean enable) {
        this.setOption(this.config.generateImplicitsOption, enable);
    }

    public void setJjtree(boolean enable) {
        this.setOption(this.config.jjtreeOption, enable);
    }

    public void setGrammar(String arg) {
        this.setOption(this.config.grammarOption, arg);
    }

    public void setBeaver(boolean enable) {
        this.setOption(this.config.beaverOption, enable);
    }

    public void setLineColumnNumbers(boolean enable) {
        this.setOption(this.config.lineColumnNumbersOption, enable);
    }

    public void setPackage(String arg) {
        this.setOption(this.config.packageNameOption, arg);
    }

    public void setOutdir(String arg) {
        this.setOption(this.config.outputDirOption, arg);
    }

    public void setDefaultMap(String arg) {
        this.setOption(this.config.defaultMapOption, arg);
    }

    public void setDefaultSet(String arg) {
        this.setOption(this.config.defaultSetOption, arg);
    }

    public void setLazyMaps(boolean enable) {
        this.setOption(this.config.lazyMapsOption, enable);
    }

    public void setNoLazyMaps(boolean enable) {
        this.setOption(this.config.noLazyMapsOption, enable);
    }

    public void setRewrite(String arg) {
        this.setOption(this.config.rewriteOption, arg);
    }

    public void setVisitCheck(boolean enable) {
        this.setOption(this.config.visitCheckOption, enable);
    }

    public void setNovisitcheck(boolean enable) {
        this.setOption(this.config.noVisitCheckOption, enable);
    }

    public void setCacheCycle(boolean enable) {
        this.setOption(this.config.cacheCycleOption, enable);
    }

    public void setNoCacheCycle(boolean enable) {
        this.setOption(this.config.noCacheCycleOption, enable);
    }

    public void setComponentCheck(boolean enable) {
        this.setOption(this.config.componentCheckOption, enable);
    }

    public void setNoComponentCheck(boolean enable) {
        this.setOption(this.config.noComponentCheckOption, enable);
    }

    public void setNoInhEqCheck(boolean enable) {
        this.setOption(this.config.noInhEqCheckOption, enable);
    }

    public void setSuppressWarnings(boolean enable) {
        this.setOption(this.config.suppressWarningsOption, enable);
    }

    public void setDoc(boolean enable) {
        this.setOption(this.config.docOption, enable);
    }

    public void setDoxygen(boolean enable) {
        this.setOption(this.config.doxygenOption, enable);
    }

    public void setLicense(String arg) {
        this.setOption(this.config.licenseOption, arg);
    }

    public void setJava14(boolean enable) {
        this.setOption(this.config.java1_4Option, enable);
    }

    public void setDebug(boolean enable) {
        this.setOption(this.config.debugOption, enable);
    }

    public void setSynch(boolean enable) {
        this.setOption(this.config.synchOption, enable);
    }

    public void setStaticState(boolean enable) {
        this.setOption(this.config.staticStateOption, enable);
    }

    public void setNoStatic(boolean enable) {
        this.setOption(this.config.noStaticOption, enable);
    }

    public void setRefineLegacy(boolean enable) {
        this.setOption(this.config.refineLegacyOption, enable);
    }

    public void setNoRefineLegacy(boolean enable) {
        this.setOption(this.config.noRefineLegacyOption, enable);
    }

    public void setStagedRewrites(boolean enable) {
        this.setOption(this.config.stagedRewritesOption, enable);
    }

    public void setDeterministic(boolean enable) {
        this.setOption(this.config.deterministicOption, enable);
    }

    public void setTracing(String arg) {
        this.setOption(this.config.tracingOption, arg);
    }

    public void setCache(String arg) {
        this.setOption(this.config.cacheOption, arg);
    }

    public void setCacheAll(boolean enable) {
        this.setOption(this.config.cacheAllOption, enable);
    }

    public void setNoCaching(boolean enable) {
        this.setOption(this.config.noCachingOption, enable);
    }

    public void setCacheNone(boolean enable) {
        this.setOption(this.config.cacheNoneOption, enable);
    }

    public void setCacheImplicit(boolean enable) {
        this.setOption(this.config.cacheImplicitOption, enable);
    }

    public void setIgnoreLazy(boolean enable) {
        this.setOption(this.config.ignoreLazyOption, enable);
    }

    public void setIncremental(String arg) {
        this.setOption(this.config.incrementalOption, arg);
    }

    public void setFullFlush(boolean enable) {
        this.setOption(this.config.fullFlushOption, enable);
    }

    public void setFlush(String arg) {
        this.setOption(this.config.flushOption, arg);
    }

    public void setIndent(String arg) {
        this.setOption(this.config.indentOption, arg);
    }

    public void setMinListSize(String arg) {
        this.setOption(this.config.minListSizeOption, arg);
    }

    public void setDot(boolean enable) {
        this.setOption(this.config.dotOption, enable);
    }

    public void setSafeLazy(boolean enable) {
        this.setOption(this.config.safeLazyOption, enable);
    }

    public void execute() throws BuildException {
        System.err.println("generating node types and weaving aspects");
        JastAdd jastadd = new JastAdd(this.config);
        int exitVal = jastadd.compile(System.out, System.err);
        if (exitVal != 0) {
            throw new BuildException("Failed to generate AST!");
        }
        System.err.println("done");
    }
}

