/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.ast.AST;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import org.jastadd.ast.AST.ASTNode;
import org.jastadd.ast.AST.Ast;
import org.jastadd.ast.AST.AstVisitor;
import org.jastadd.ast.AST.Node;

public class List<T extends ASTNode>
extends ASTNode<T>
implements Cloneable,
Iterable<T> {
    private boolean list$touched = true;

    public List(int i) {
        super(i);
    }

    public List(Ast p, int i) {
        this(i);
        this.parser = p;
    }

    public List() {
        this(0);
    }

    @Override
    public void init$Children() {
    }

    public List(T ... initialChildren) {
        this.children = new ASTNode[initialChildren.length];
        for (int i = 0; i < this.children.length; ++i) {
            this.addChild(initialChildren[i]);
        }
    }

    @Override
    public void dumpTree(String indent, PrintStream out) {
        out.print(indent + "List");
        String childIndent = indent + "  ";
        for (int i = 0; i < this.getNumChild(); ++i) {
            ((ASTNode)this.getChild(i)).dumpTree(childIndent, out);
        }
    }

    @Override
    public Object jjtAccept(AstVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        this.checkChild(n, i);
        super.jjtAddChild(n, i);
    }

    @Override
    public void checkChild(Node n, int i) {
        if (!(n instanceof ASTNode)) {
            throw new Error("The node type of child " + i + " must be an instance of ASTNode");
        }
    }

    public List<T> add(T node) {
        this.addChild(node);
        return this;
    }

    public List<T> addAll(Collection<? extends T> c) {
        for (ASTNode node : c) {
            this.addChild(node);
        }
        return this;
    }

    @Override
    public void insertChild(ASTNode node, int i) {
        this.list$touched = true;
        super.insertChild(node, i);
    }

    @Override
    public void addChild(T node) {
        this.list$touched = true;
        super.addChild(node);
    }

    @Override
    public void removeChild(int i) {
        this.list$touched = true;
        super.removeChild(i);
    }

    @Override
    public int getNumChild() {
        if (this.list$touched) {
            for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
                this.getChild(i);
            }
            this.list$touched = false;
        }
        return this.getNumChildNoTransform();
    }

    @Override
    public Iterator<T> iterator() {
        return this.astChildIterator();
    }

    @Override
    public boolean mayHaveRewrite() {
        return true;
    }

    @Override
    public void flushAttrCache() {
        super.flushAttrCache();
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public void flushRewriteCache() {
        super.flushRewriteCache();
    }

    @Override
    public List<T> clone() throws CloneNotSupportedException {
        List node = (List)super.clone();
        return node;
    }

    @Override
    public List<T> copy() {
        try {
            ASTNode node = this.clone();
            ((List)node).parent = null;
            if (this.children != null) {
                ((List)node).children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    @Override
    @Deprecated
    public List<T> fullCopy() {
        return this.treeCopyNoTransform();
    }

    @Override
    public List<T> treeCopyNoTransform() {
        ASTNode tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode child = (ASTNode)this.children[i];
                if (child == null) continue;
                child = child.treeCopyNoTransform();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    @Override
    public List<T> treeCopy() {
        this.doFullTraversal();
        return this.treeCopyNoTransform();
    }

    @Override
    protected boolean is$Equal(ASTNode node) {
        return super.is$Equal(node);
    }

    @Override
    public ASTNode rewriteTo() {
        if (this.list$touched) {
            for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
                this.getChild(i);
            }
            this.list$touched = false;
            return this;
        }
        return super.rewriteTo();
    }
}

