/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.option;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jastadd.option.Option;

public class ArgumentParser {
    private final Map<String, Option<?>> options = new HashMap();
    private final Collection<String> filenames = new ArrayList<String>();

    public void addOption(Option<?> option) {
        String name = ("--" + option.name).toLowerCase();
        this.options.put(name, option);
    }

    public void addOptions(Collection<Option<?>> additionalOptions) {
        for (Option<?> option : additionalOptions) {
            String name = ("--" + option.name).toLowerCase();
            this.options.put(name, option);
        }
    }

    public boolean parseArgs(String[] args, PrintStream err) {
        boolean haveUnknown = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i].toLowerCase();
            if (arg.startsWith("--")) {
                Option<?> option = null;
                int sep = args[i].indexOf("=");
                if (sep != -1) {
                    String namePart = arg.substring(0, sep);
                    String argPart = args[i].substring(sep + 1);
                    option = this.options.get(namePart);
                    if (option != null) {
                        option.matchWithArg(err, argPart);
                    }
                } else {
                    option = this.options.get(arg);
                    if (option != null) {
                        option.matchWithoutArg(err);
                    }
                }
                if (option != null) continue;
                err.println("Error: unknown option '" + args[i] + "'");
                haveUnknown = true;
                continue;
            }
            this.filenames.add(args[i]);
        }
        return !haveUnknown;
    }

    public void printHelp(PrintStream out) {
        ArrayList theOptions = new ArrayList(this.options.values());
        Collections.sort(theOptions);
        for (Option option : theOptions) {
            if (option.isNonStandard || option.isDeprecated) continue;
            option.printHelp(out);
        }
    }

    public void printNonStandardOptions(PrintStream out) {
        ArrayList theOptions = new ArrayList(this.options.values());
        Collections.sort(theOptions);
        for (Option option : theOptions) {
            if (!option.isNonStandard) continue;
            option.printHelp(out);
        }
    }

    public Collection<String> getFilenames() {
        return this.filenames;
    }
}

