/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.option;

import java.io.PrintStream;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import org.jastadd.option.Option;

public class ValueOption
extends Option<String> {
    protected String additionalDescription = "";
    protected boolean acceptsMultipleValues = false;
    protected boolean needsValue = true;
    protected boolean restricted = true;
    private final Set<String> acceptedValues = new LinkedHashSet<String>();
    private final Collection<String[]> valueDescriptions = new LinkedList<String[]>();
    private final Collection<String> values = new LinkedList<String>();
    private final Collection<String> defaultValues = new LinkedList<String>();

    public ValueOption(String optionName, String description) {
        super(optionName, description);
    }

    public ValueOption defaultValue(String defaultValue) {
        this.addDefaultValue(defaultValue, "");
        return this;
    }

    public ValueOption needsValue(boolean needsValue) {
        this.needsValue = needsValue;
        return this;
    }

    public ValueOption acceptAnyValue() {
        this.restricted = false;
        return this;
    }

    public ValueOption acceptMultipleValues(boolean multipleValues) {
        this.acceptsMultipleValues = multipleValues;
        return this;
    }

    @Override
    public void matchWithoutArg(PrintStream err) {
        if (this.needsValue) {
            err.println("Warning: Missing value for option " + this.name);
        }
        this.onMatch(err);
    }

    @Override
    public void matchWithArg(PrintStream err, String arg) {
        this.onMatch(err, arg);
    }

    @Override
    protected String description() {
        if (this.defaultValues.isEmpty()) {
            return this.description;
        }
        StringBuilder desc = new StringBuilder();
        desc.append(this.description);
        desc.append(" (default='");
        boolean first = true;
        for (String value : this.defaultValues) {
            if (!first) {
                desc.append(",");
            }
            first = false;
            desc.append(value);
        }
        desc.append("')");
        return desc.toString();
    }

    @Override
    protected void printDescription(PrintStream out) {
        super.printDescription(out);
        if (this.restricted && !this.acceptedValues.isEmpty()) {
            this.printIndent(out, 20);
            out.format("%s %s of the following%s values:", this.needsValue ? "requires " : "accepts ", this.acceptsMultipleValues ? "some" : "one", this.needsValue ? "" : " optional");
            out.println();
            for (String[] s : this.valueDescriptions) {
                this.printIndent(out, 22);
                String value = "'" + s[0] + "'";
                out.print(value);
                this.printIndent(out, Math.max(33 - value.length() - 22, 1));
                this.printDescription(out, s[1], 33);
            }
        }
        if (!this.additionalDescription.isEmpty()) {
            this.printIndent(out, 20);
            this.printDescription(out, this.additionalDescription, 20);
        }
    }

    public ValueOption addDefaultValue(String value, String desc) {
        this.acceptedValues.add(value);
        this.valueDescriptions.add(new String[]{value, desc});
        this.values.add(value);
        this.defaultValues.add(value);
        return this;
    }

    public ValueOption addAcceptedValue(String value, String desc) {
        this.acceptedValues.add(value);
        this.valueDescriptions.add(new String[]{value, desc});
        return this;
    }

    public ValueOption additionalDescription(String desc) {
        this.additionalDescription = desc;
        return this;
    }

    @Override
    protected void onMatch(PrintStream out) {
        this.reportWarnings(out);
        this.values.clear();
        this.isMatched = true;
    }

    protected final void onMatch(PrintStream out, String arg) {
        this.reportWarnings(out);
        this.values.clear();
        if (this.restricted) {
            StringTokenizer tokenizer = new StringTokenizer(arg, ",");
            boolean first = true;
            while (tokenizer.hasMoreTokens()) {
                if (!first && !this.acceptsMultipleValues) {
                    out.println("Warning: too many values given to option '" + this.name + "'. The extraneous values will be ignored!");
                    break;
                }
                first = false;
                String value = tokenizer.nextToken();
                this.reportWarnings(out, value);
                this.values.add(value);
            }
        } else {
            this.values.add(arg);
        }
        this.isMatched = true;
    }

    public void reportWarnings(PrintStream out, String arg) {
        if (!this.acceptedValues.isEmpty() && !this.acceptedValues.contains(arg)) {
            out.format("Warning: the option '%s' does not accept the value '%s'", this.name, arg);
            out.println();
        }
    }

    @Override
    public String value() {
        if (!this.values.isEmpty()) {
            return this.values.iterator().next();
        }
        return "";
    }

    public boolean hasValue(String query) {
        for (String value : this.values) {
            if (!query.equals(value)) continue;
            return true;
        }
        return false;
    }

    public int numValues() {
        return this.values.size();
    }
}

