/*
 * Decompiled with CFR 0.152.
 */
package ast.AST;

import ast.AST.ASTDecl;
import ast.AST.ASTNode;
import ast.AST.Ast;
import ast.AST.AstVisitor;
import ast.AST.AttrDecl;
import ast.AST.List;
import ast.AST.Node;
import ast.AST.Parameter;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;

public class InhDecl
extends AttrDecl
implements Cloneable {
    protected int error_visited = -1;
    protected int attributeKind_visited = -1;
    protected int declaredNTA_visited = -1;

    public void flushCache() {
        super.flushCache();
        this.error_visited = -1;
        this.attributeKind_visited = -1;
        this.declaredNTA_visited = -1;
    }

    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    public Object clone() throws CloneNotSupportedException {
        InhDecl node = (InhDecl)super.clone();
        node.error_visited = -1;
        node.attributeKind_visited = -1;
        node.declaredNTA_visited = -1;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public ASTNode copy() {
        try {
            InhDecl node = (InhDecl)this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public ASTNode fullCopy() {
        InhDecl res = (InhDecl)this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            ASTNode node = this.getChildNoTransform(i);
            if (node != null) {
                node = node.fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    public String callCompute() {
        if (ASTNode.parentInterface) {
            return super.callCompute();
        }
        if (this.getLazy() && this.getNumParameter() == 0) {
            return String.valueOf(this.inhDebugString()) + InhDecl.ind(2) + "#NAME#_value = getParent().Define_#TYPEINSIGNATURE#_#METHODNAME#(" + this.interfaceParametersStart() + ");\n";
        }
        return String.valueOf(this.inhDebugString()) + InhDecl.ind(2) + "#TYPE# #NAME#_value = getParent().Define_#TYPEINSIGNATURE#_#METHODNAME#(" + this.interfaceParametersStart() + ");\n";
    }

    public String circularComputeCall() {
        if (!ASTNode.parentInterface) {
            return "getParent().Define_#TYPEINSIGNATURE#_#METHODNAME#(" + this.interfaceParametersStart() + ")";
        }
        return "#METHODNAME#_compute(#PARM#)";
    }

    public InhDecl(int i) {
        super(i);
    }

    public InhDecl(Ast p, int i) {
        this(i);
        this.parser = p;
    }

    public InhDecl() {
        this(0);
        this.setChild(new List(), 0);
    }

    public InhDecl(List p0, String p1, String p2, boolean p3, String p4, int p5, int p6, boolean p7, boolean p8, String p9, String p10) {
        this.setChild(p0, 0);
        this.setName(p1);
        this.setType(p2);
        this.setLazy(p3);
        this.setFileName(p4);
        this.setStartLine(p5);
        this.setEndLine(p6);
        this.setFinal(p7);
        this.setNTA(p8);
        this.setComment(p9);
        this.setAspectName(p10);
    }

    public void dumpTree(String indent, PrintStream pStream) {
        pStream.println(String.valueOf(indent) + "InhDecl" + "\"" + this.getName() + "\"" + "\"" + this.getType() + "\"" + "\"" + this.getLazy() + "\"" + "\"" + this.getFileName() + "\"" + "\"" + this.getStartLine() + "\"" + "\"" + this.getEndLine() + "\"" + "\"" + this.getFinal() + "\"" + "\"" + this.getNTA() + "\"" + "\"" + this.getComment() + "\"" + "\"" + this.getAspectName() + "\"");
        String childIndent = String.valueOf(indent) + "  ";
        int i = 0;
        while (i < this.getNumChild()) {
            this.getChild(i).dumpTree(childIndent, pStream);
            ++i;
        }
    }

    public Object jjtAccept(AstVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void jjtAddChild(Node n, int i) {
        this.checkChild(n, i);
        super.jjtAddChild(n, i);
    }

    public void checkChild(Node n, int i) {
        if (i == 0) {
            if (!(n instanceof List)) {
                throw new Error("Child number 0 of AttrDecl has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            int k = 0;
            while (k < ((List)n).getNumChildNoTransform()) {
                if (!(((List)n).getChildNoTransform(k) instanceof Parameter)) {
                    throw new Error("Child number " + k + " in ParameterList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of Parameter");
                }
                ++k;
            }
        }
    }

    public int getNumChild() {
        return 1;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void setParameterList(List list) {
        this.setChild(list, 0);
    }

    public int getNumParameter() {
        return this.getParameterList().getNumChild();
    }

    public Parameter getParameter(int i) {
        return (Parameter)this.getParameterList().getChild(i);
    }

    public void addParameter(Parameter node) {
        List list = this.parent == null || ASTNode.state == null ? this.getParameterListNoTransform() : this.getParameterList();
        list.addChild(node);
    }

    public void addParameterNoTransform(Parameter node) {
        List list = this.getParameterListNoTransform();
        list.addChild(node);
    }

    public void setParameter(Parameter node, int i) {
        List list = this.getParameterList();
        list.setChild(node, i);
    }

    public List getParameterList() {
        List list = (List)this.getChild(0);
        list.getNumChild();
        return list;
    }

    public List getParameterListNoTransform() {
        return (List)this.getChildNoTransform(0);
    }

    public void setName(String value) {
        this.tokenString_Name = value;
    }

    public String getName() {
        return this.tokenString_Name != null ? this.tokenString_Name : "";
    }

    public void setType(String value) {
        this.tokenString_Type = value;
    }

    public String getType() {
        return this.tokenString_Type != null ? this.tokenString_Type : "";
    }

    public void setLazy(boolean value) {
        this.tokenboolean_Lazy = value;
    }

    public boolean refined__InhDecl_getLazy() {
        return this.tokenboolean_Lazy;
    }

    public void setFileName(String value) {
        this.tokenString_FileName = value;
    }

    public String getFileName() {
        return this.tokenString_FileName != null ? this.tokenString_FileName : "";
    }

    public void setStartLine(int value) {
        this.tokenint_StartLine = value;
    }

    public int getStartLine() {
        return this.tokenint_StartLine;
    }

    public void setEndLine(int value) {
        this.tokenint_EndLine = value;
    }

    public int getEndLine() {
        return this.tokenint_EndLine;
    }

    public void setFinal(boolean value) {
        this.tokenboolean_Final = value;
    }

    public boolean getFinal() {
        return this.tokenboolean_Final;
    }

    public void setNTA(boolean value) {
        this.tokenboolean_NTA = value;
    }

    public boolean getNTA() {
        return this.tokenboolean_NTA;
    }

    public void setComment(String value) {
        this.tokenString_Comment = value;
    }

    public String getComment() {
        return this.tokenString_Comment != null ? this.tokenString_Comment : "";
    }

    public void setAspectName(String value) {
        this.tokenString_AspectName = value;
    }

    public String getAspectName() {
        return this.tokenString_AspectName != null ? this.tokenString_AspectName : "";
    }

    public boolean getLazy() {
        if (ASTNode.cacheAll) {
            return true;
        }
        if (ASTNode.cacheNone) {
            return this.declaredNTA();
        }
        return this.declaredNTA() || this.refined__InhDecl_getLazy();
    }

    public String error() {
        this.state();
        if (this.error_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: error in class: ");
        }
        this.error_visited = this.state().boundariesCrossed;
        String error_value = this.error_compute();
        this.error_visited = -1;
        return error_value;
    }

    private String error_compute() {
        StringBuffer result = new StringBuffer();
        if (!ASTNode.noInhEqCheck) {
            if (this.hostClass().lookupInhDecl(this.signature()) != this) {
                result.append(String.valueOf(this.getFileName()) + ":" + this.getStartLine() + " ");
                result.append("Multiple declaration of attribute " + this.name() + " in class " + this.hostClass().name() + "\n");
            } else {
                HashSet set = new HashSet();
                if (this.hostClass() instanceof ASTDecl) {
                    Iterator iter = ((ASTDecl)this.hostClass()).fathers().iterator();
                    while (iter.hasNext()) {
                        ASTDecl father = (ASTDecl)iter.next();
                        if (father.hasInhEqFor((ASTDecl)this.hostClass(), this.signature(), set)) continue;
                        result.append(String.valueOf(this.getFileName()) + ":" + this.getStartLine() + " ");
                        result.append("Missing inherited equation for attribute " + this.name() + " in class " + this.hostClass().name() + " when being child of " + father.name() + "\n");
                        System.out.println(String.valueOf(father.name()) + "->" + this.hostClass().name());
                        System.out.print(String.valueOf(this.getFileName()) + ":" + this.getStartLine() + " ");
                        System.out.print("Missing inherited equation for attribute " + this.name() + " in class " + this.hostClass().name() + " when being child of " + father.name() + "\n");
                    }
                }
            }
        }
        return result.toString();
    }

    public String attributeKind() {
        this.state();
        if (this.attributeKind_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: attributeKind in class: ");
        }
        this.attributeKind_visited = this.state().boundariesCrossed;
        String attributeKind_value = this.attributeKind_compute();
        this.attributeKind_visited = -1;
        return attributeKind_value;
    }

    private String attributeKind_compute() {
        return "inh";
    }

    public boolean declaredNTA() {
        this.state();
        if (this.declaredNTA_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: declaredNTA in class: ");
        }
        this.declaredNTA_visited = this.state().boundariesCrossed;
        boolean declaredNTA_value = this.declaredNTA_compute();
        this.declaredNTA_visited = -1;
        return declaredNTA_value;
    }

    private boolean declaredNTA_compute() {
        return this.getNTA();
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

