/*
 * Decompiled with CFR 0.152.
 */
package ast.AST;

import ast.AST.ASTNode;
import ast.AST.ASTNode$State;
import ast.AST.Ast;
import ast.AST.AstVisitor;
import ast.AST.AttrDecl;
import ast.AST.AttrEq;
import ast.AST.Components;
import ast.AST.List;
import ast.AST.ListComponents;
import ast.AST.Node;
import ast.AST.Opt;
import ast.AST.Parameter;
import ast.AST.TypeDecl;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class InhEq
extends AttrEq
implements Cloneable {
    protected String tokenString_SonName;
    protected int error_visited = -1;
    protected int getComponents_visited = -1;
    protected int sonName_visited = -1;
    protected int getSonAttrDecl_visited = -1;
    protected int decl_visited = -1;
    protected boolean decl_computed = false;
    protected AttrDecl decl_value;

    public void flushCache() {
        super.flushCache();
        this.error_visited = -1;
        this.getComponents_visited = -1;
        this.sonName_visited = -1;
        this.getSonAttrDecl_visited = -1;
        this.decl_visited = -1;
        this.decl_computed = false;
        this.decl_value = null;
    }

    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    public Object clone() throws CloneNotSupportedException {
        InhEq node = (InhEq)super.clone();
        node.error_visited = -1;
        node.getComponents_visited = -1;
        node.sonName_visited = -1;
        node.getSonAttrDecl_visited = -1;
        node.decl_visited = -1;
        node.decl_computed = false;
        node.decl_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public ASTNode copy() {
        try {
            InhEq node = (InhEq)this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public ASTNode fullCopy() {
        InhEq res = (InhEq)this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            ASTNode node = this.getChildNoTransform(i);
            if (node != null) {
                node = node.fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    public InhEq(int i) {
        super(i);
    }

    public InhEq(Ast p, int i) {
        this(i);
        this.parser = p;
    }

    public InhEq() {
        this(0);
        this.setChild(new List(), 0);
        this.setChild(new Opt(), 1);
    }

    public InhEq(List p0, String p1, String p2, int p3, int p4, String p5, String p6, String p7, Opt p8) {
        this.setChild(p0, 0);
        this.setName(p1);
        this.setFileName(p2);
        this.setStartLine(p3);
        this.setEndLine(p4);
        this.setComment(p5);
        this.setAspectName(p6);
        this.setSonName(p7);
        this.setChild(p8, 1);
    }

    public void dumpTree(String indent, PrintStream pStream) {
        pStream.println(String.valueOf(indent) + "InhEq" + "\"" + this.getName() + "\"" + "\"" + this.getFileName() + "\"" + "\"" + this.getStartLine() + "\"" + "\"" + this.getEndLine() + "\"" + "\"" + this.getComment() + "\"" + "\"" + this.getAspectName() + "\"" + "\"" + this.getSonName() + "\"");
        String childIndent = String.valueOf(indent) + "  ";
        int i = 0;
        while (i < this.getNumChild()) {
            this.getChild(i).dumpTree(childIndent, pStream);
            ++i;
        }
    }

    public Object jjtAccept(AstVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void jjtAddChild(Node n, int i) {
        this.checkChild(n, i);
        super.jjtAddChild(n, i);
    }

    public void checkChild(Node n, int i) {
        if (i == 0) {
            if (!(n instanceof List)) {
                throw new Error("Child number 0 of InhEq has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            int k = 0;
            while (k < ((List)n).getNumChildNoTransform()) {
                if (!(((List)n).getChildNoTransform(k) instanceof Parameter)) {
                    throw new Error("Child number " + k + " in ParameterList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of Parameter");
                }
                ++k;
            }
        }
        if (i == 1) {
            if (!(n instanceof Opt)) {
                throw new Error("Child number 1 of InhEq has the type " + n.getClass().getName() + " which is not an instance of Opt");
            }
            if (((Opt)n).getNumChildNoTransform() != 0 && !(((Opt)n).getChildNoTransform(0) instanceof Parameter)) {
                throw new Error("Optional Index has the type " + ((Opt)n).getChildNoTransform(0).getClass().getName() + " which is not an instance of Parameter");
            }
        }
    }

    public int getNumChild() {
        return 2;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void setParameterList(List list) {
        this.setChild(list, 0);
    }

    public int getNumParameter() {
        return this.getParameterList().getNumChild();
    }

    public Parameter getParameter(int i) {
        return (Parameter)this.getParameterList().getChild(i);
    }

    public void addParameter(Parameter node) {
        List list = this.parent == null || ASTNode.state == null ? this.getParameterListNoTransform() : this.getParameterList();
        list.addChild(node);
    }

    public void addParameterNoTransform(Parameter node) {
        List list = this.getParameterListNoTransform();
        list.addChild(node);
    }

    public void setParameter(Parameter node, int i) {
        List list = this.getParameterList();
        list.setChild(node, i);
    }

    public List getParameterList() {
        List list = (List)this.getChild(0);
        list.getNumChild();
        return list;
    }

    public List getParameterListNoTransform() {
        return (List)this.getChildNoTransform(0);
    }

    public void setName(String value) {
        this.tokenString_Name = value;
    }

    public String getName() {
        return this.tokenString_Name != null ? this.tokenString_Name : "";
    }

    public void setFileName(String value) {
        this.tokenString_FileName = value;
    }

    public String getFileName() {
        return this.tokenString_FileName != null ? this.tokenString_FileName : "";
    }

    public void setStartLine(int value) {
        this.tokenint_StartLine = value;
    }

    public int getStartLine() {
        return this.tokenint_StartLine;
    }

    public void setEndLine(int value) {
        this.tokenint_EndLine = value;
    }

    public int getEndLine() {
        return this.tokenint_EndLine;
    }

    public void setComment(String value) {
        this.tokenString_Comment = value;
    }

    public String getComment() {
        return this.tokenString_Comment != null ? this.tokenString_Comment : "";
    }

    public void setAspectName(String value) {
        this.tokenString_AspectName = value;
    }

    public String getAspectName() {
        return this.tokenString_AspectName != null ? this.tokenString_AspectName : "";
    }

    public void setSonName(String value) {
        this.tokenString_SonName = value;
    }

    public String getSonName() {
        return this.tokenString_SonName != null ? this.tokenString_SonName : "";
    }

    public void setIndexOpt(Opt opt) {
        this.setChild(opt, 1);
    }

    public boolean hasIndex() {
        return this.getIndexOpt().getNumChild() != 0;
    }

    public Parameter getIndex() {
        return (Parameter)this.getIndexOpt().getChild(0);
    }

    public void setIndex(Parameter node) {
        this.getIndexOpt().setChild(node, 0);
    }

    public Opt getIndexOpt() {
        return (Opt)this.getChild(1);
    }

    public Opt getIndexOptNoTransform() {
        return (Opt)this.getChildNoTransform(1);
    }

    public String error() {
        this.state();
        if (this.error_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: error in class: ");
        }
        this.error_visited = this.state().boundariesCrossed;
        String error_value = this.error_compute();
        this.error_visited = -1;
        return error_value;
    }

    private String error_compute() {
        StringBuffer result = new StringBuffer();
        if (this.getComponents() == null && this.getSonName().startsWith("get") && !this.getSonName().equals("getChild")) {
            result.append(String.valueOf(this.getFileName()) + ":" + this.getStartLine() + " ");
            result.append("Inherited equation for unknown son " + this.sonName() + " in class " + this.hostClass().name() + "\n");
            Iterator iter = this.hostClass().getComponents();
            while (iter.hasNext()) {
                Components c = (Components)iter.next();
                result.append(String.valueOf(c.type()) + " " + c.name() + "\n");
            }
        } else if (this.getComponents() == null && !this.getSonName().equals("getChild")) {
            AttrDecl decl = this.getSonAttrDecl();
            if (decl == null) {
                result.append(String.valueOf(this.getFileName()) + ":" + this.getStartLine() + " ");
                result.append("Inherited equation for unknown NTA " + this.sonName() + " in class " + this.hostClass().name() + "\n");
            } else if (!decl.getNTA()) {
                result.append(String.valueOf(this.getFileName()) + ":" + this.getStartLine() + " ");
                result.append("Inherited equation for attribute " + this.sonName() + " which is not a NTA");
            }
        } else {
            InhEq equation = this.hostClass().lookupInhEq(this.signature(), this.sonName());
            if (equation != null && equation != this) {
                result.append(String.valueOf(this.getFileName()) + ":" + this.getStartLine() + " ");
                result.append("Multiple equation for inherited attribute " + this.sonName() + "." + this.name() + " in class " + this.hostClass().name());
                result.append(" and " + equation.name() + " in class " + equation.hostClass().name() + " in " + equation.getFileName() + ":" + equation.getStartLine() + "\n");
            } else if (this.hasIndex() && !(this.getComponents() instanceof ListComponents) && !this.getSonName().equals("getChild")) {
                result.append(String.valueOf(this.getFileName()) + ":" + this.getStartLine() + " ");
                result.append("May not supply index for non list child " + this.sonName() + " in class " + this.hostClass().name() + "\n");
            }
        }
        return result.toString();
    }

    public Components getComponents() {
        this.state();
        if (this.getComponents_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getComponents in class: ");
        }
        this.getComponents_visited = this.state().boundariesCrossed;
        Components getComponents_value = this.getComponents_compute();
        this.getComponents_visited = -1;
        return getComponents_value;
    }

    private Components getComponents_compute() {
        TypeDecl c = this.hostClass();
        if (c != null) {
            return c.components(this.sonName());
        }
        return null;
    }

    public String sonName() {
        this.state();
        if (this.sonName_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: sonName in class: ");
        }
        this.sonName_visited = this.state().boundariesCrossed;
        String sonName_value = this.sonName_compute();
        this.sonName_visited = -1;
        return sonName_value;
    }

    private String sonName_compute() {
        return this.getSonName().startsWith("get") ? this.getSonName().substring(3) : this.getSonName();
    }

    public AttrDecl getSonAttrDecl() {
        this.state();
        if (this.getSonAttrDecl_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getSonAttrDecl in class: ");
        }
        this.getSonAttrDecl_visited = this.state().boundariesCrossed;
        AttrDecl getSonAttrDecl_value = this.getSonAttrDecl_compute();
        this.getSonAttrDecl_visited = -1;
        return getSonAttrDecl_value;
    }

    private AttrDecl getSonAttrDecl_compute() {
        AttrDecl decl = this.hostClass().lookupSynDeclPrefix(this.sonName());
        if (decl == null) {
            decl = this.hostClass().lookupInhDeclPrefix(this.sonName());
        }
        return decl;
    }

    public AttrDecl decl() {
        if (this.decl_computed) {
            return this.decl_value;
        }
        ASTNode$State state = this.state();
        if (this.decl_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: decl in class: ");
        }
        this.decl_visited = this.state().boundariesCrossed;
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.decl_value = this.decl_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.decl_computed = true;
        }
        this.decl_visited = -1;
        return this.decl_value;
    }

    private AttrDecl decl_compute() {
        return this.hostClass().getInhDeclFor(this.signature(), new LinkedHashSet());
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

