/*
 * Decompiled with CFR 0.152.
 */
package ast.AST;

import ast.AST.ASTDecl;
import ast.AST.ASTNode;
import ast.AST.Ast;
import ast.AST.AstVisitor;
import ast.AST.Components;
import ast.AST.Id;
import ast.AST.Node;
import jastadd.JastAddCodeGen;
import java.io.PrintStream;
import java.io.PrintWriter;

public class OptionalComponent
extends Components
implements Cloneable {
    protected int constrParmType_visited = -1;
    protected int name_visited = -1;
    protected int type_visited = -1;

    public void flushCache() {
        super.flushCache();
        this.constrParmType_visited = -1;
        this.name_visited = -1;
        this.type_visited = -1;
    }

    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    public Object clone() throws CloneNotSupportedException {
        OptionalComponent node = (OptionalComponent)super.clone();
        node.constrParmType_visited = -1;
        node.name_visited = -1;
        node.type_visited = -1;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public ASTNode copy() {
        try {
            OptionalComponent node = (OptionalComponent)this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public ASTNode fullCopy() {
        OptionalComponent res = (OptionalComponent)this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            ASTNode node = this.getChildNoTransform(i);
            if (node != null) {
                node = node.fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    public void jjtGenCheckTreeStructure(PrintWriter stream, int j) {
        stream.println(String.valueOf(OptionalComponent.ind(2)) + "if(i == " + j + ") {");
        stream.println(String.valueOf(OptionalComponent.ind(3)) + "if(!(n instanceof Opt))\n" + OptionalComponent.ind(4) + "throw new Error(\"Child number " + j + " of " + this.hostClass().name() + " has the type \" + n.getClass().getName() + \" which is not an instance of Opt\");");
        stream.println(String.valueOf(OptionalComponent.ind(3)) + "if(((Opt)n).getNumChildNoTransform() != 0 && !(((Opt)n).getChildNoTransform(0) instanceof " + this.type() + "))\n" + OptionalComponent.ind(4) + "throw new Error(\"Optional " + this.name() + " has the type \" + ((Opt)n).getChildNoTransform(0).getClass().getName() + \" which is not an instance of " + this.type() + "\");");
        stream.println(String.valueOf(OptionalComponent.ind(2)) + "}");
    }

    String setNameOptComment() {
        return String.valueOf(ASTNode.ind) + "/**\n" + ASTNode.ind + " * Replaces the optional node for the #NAME# child. This is the {@code Opt} node containing the child #NAME#, not the actual child!\n" + ASTNode.ind + " * @param opt The new node to be used as the optional node for the #NAME# child.\n" + ASTNode.ind + " * @apilevel low-level\n" + ASTNode.ind + " */\n";
    }

    String hasNameComment() {
        return String.valueOf(ASTNode.ind) + "/**\n" + ASTNode.ind + " * Check whether the optional #NAME# child exists.\n" + ASTNode.ind + " * @return {@code true} if the optional #NAME# child exists, {@code false} if it does not.\n" + ASTNode.ind + " * @apilevel high-level\n" + ASTNode.ind + " */\n";
    }

    String getNameComment() {
        return String.valueOf(ASTNode.ind) + "/**\n" + ASTNode.ind + " * Retrieves the (optional) #NAME# child.\n" + ASTNode.ind + " * @return The #NAME# child, if it exists. Returns {@code null} otherwise.\n" + ASTNode.ind + " * @apilevel low-level\n" + ASTNode.ind + " */\n";
    }

    String setNameComment() {
        return String.valueOf(ASTNode.ind) + "/**\n" + ASTNode.ind + " * Replaces the (optional) #NAME# child.\n" + ASTNode.ind + " * @param node The new node to be used as the #NAME# child.\n" + ASTNode.ind + " * @apilevel high-level\n" + ASTNode.ind + " */\n";
    }

    String getNameOptComment() {
        return String.valueOf(ASTNode.ind) + "/**\n" + ASTNode.ind + " * Retrieves the optional node for the #NAME# child. This is the {@code Opt} node containing the child #NAME#, not the actual child!\n" + ASTNode.ind + " * @return The optional node for child the #NAME# child.\n" + ASTNode.ind + " * @apilevel low-level\n" + ASTNode.ind + " */\n";
    }

    public void jaddGen(PrintWriter stream, int index, boolean publicModifier, ASTDecl decl) {
        String name = decl.name();
        String s = String.valueOf(this.setNameOptComment()) + ASTNode.ind + "public void #HOST#.set#NAME#Opt(#OPTTYPE# opt) {\n" + (ASTNode.block ? ASTNode.blockBegin : "") + OptionalComponent.ind(2) + "setChild(opt, #INDEX#);\n" + (ASTNode.block ? ASTNode.blockEnd : "") + ASTNode.ind + "}\n" + this.hasNameComment() + ASTNode.ind + "public boolean #HOST#.has#NAME#() {\n" + (ASTNode.block ? ASTNode.blockBegin : "") + OptionalComponent.ind(2) + "return get#NAME#Opt().getNumChild() != 0;\n" + (ASTNode.block ? ASTNode.blockEnd : "") + ASTNode.ind + "}\n" + this.getNameComment() + "#ANNOTATIONS#" + ASTNode.ind + "public #TYPE# #HOST#.get#NAME#() {\n" + (ASTNode.block ? ASTNode.blockBegin : "") + OptionalComponent.ind(2) + "return (#TYPE#)get#NAME#Opt().getChild(0);\n" + (ASTNode.block ? ASTNode.blockEnd : "") + ASTNode.ind + "}\n" + this.setNameComment() + ASTNode.ind + "public void #HOST#.set#NAME#(#TYPE# node) {\n" + (ASTNode.block ? ASTNode.blockBegin : "") + OptionalComponent.ind(2) + "get#NAME#Opt().setChild(node, 0);\n" + (ASTNode.block ? ASTNode.blockEnd : "") + ASTNode.ind + "}\n";
        s = !this.isNTA() ? String.valueOf(s) + this.getNameOptComment() + "#ANNOTATIONS#" + ASTNode.ind + "public #OPTTYPE# #HOST#.get#NAME#Opt() {\n" + (ASTNode.block ? ASTNode.blockBegin : "") + OptionalComponent.ind(2) + "return (#OPTTYPE#)getChild(#INDEX#);\n" + (ASTNode.block ? ASTNode.blockEnd : "") + ASTNode.ind + "}\n" + ASTNode.ind + "/**\n" + ASTNode.ind + " * Retrieves the optional node for child #NAME#. This is the {@code Opt} node containing the child #NAME#, not the actual child!\n" + ASTNode.ind + " * <p><em>This method does not invoke AST transformations.</em></p>\n" + ASTNode.ind + " * @return The optional node for child #NAME#.\n" + ASTNode.ind + " * @apilevel low-level\n" + ASTNode.ind + " */\n" + "#ANNOTATIONS#" + ASTNode.ind + "public #OPTTYPE# #HOST#.get#NAME#OptNoTransform() {\n" + (ASTNode.block ? ASTNode.blockBegin : "") + OptionalComponent.ind(2) + "return (#OPTTYPE#)getChildNoTransform(#INDEX#);\n" + (ASTNode.block ? ASTNode.blockEnd : "") + ASTNode.ind + "}\n" : String.valueOf(s) + ASTNode.ind + "/**\n" + ASTNode.ind + " * Retrieves the optional node for child #NAME#. This is the {@code Opt} node containing the child #NAME#, not the actual child!\n" + ASTNode.ind + " * <p><em>This method does not invoke AST transformations.</em></p>\n" + ASTNode.ind + " * @return The optional node for child #NAME#.\n" + ASTNode.ind + " * @apilevel low-level\n" + ASTNode.ind + " */\n" + "#ANNOTATIONS#" + ASTNode.ind + "public #OPTTYPE# #HOST#.get#NAME#OptNoTransform() {\n" + (ASTNode.block ? ASTNode.blockBegin : "") + OptionalComponent.ind(2) + "return (#OPTTYPE#)getChildNoTransform(#INDEX#);\n" + (ASTNode.block ? ASTNode.blockEnd : "") + ASTNode.ind + "}\n" + ASTNode.ind + "/**\n" + ASTNode.ind + " * Retrieves the child position of the optional child #NAME#.\n" + ASTNode.ind + " * @return The the child position of the optional child #NAME#.\n" + ASTNode.ind + " * @apilevel low-level\n" + ASTNode.ind + " */\n" + ASTNode.ind + "protected int #HOST#.get#NAME#OptChildPosition() {\n" + OptionalComponent.ind(2) + "return #INDEX#;\n" + ASTNode.ind + "}\n";
        s = s.replaceAll("#OPTTYPE#", ASTNode.java5 ? "Opt<" + this.getId().type() + ">" : "Opt");
        s = s.replaceAll("#ANNOTATIONS#", ASTNode.suppressWarnings());
        s = s.replaceAll("#TYPE#", this.getId().type());
        s = s.replaceAll("#NAME#", this.getId().name());
        s = s.replaceAll("#INDEX#", String.valueOf(index));
        s = s.replaceAll("#HOST#", name);
        if (!publicModifier) {
            s = s.replaceAll(String.valueOf(ASTNode.ind) + "public ", String.valueOf(ASTNode.ind) + "private ");
        }
        this.parse(s);
    }

    public OptionalComponent(int i) {
        super(i);
    }

    public OptionalComponent(Ast p, int i) {
        this(i);
        this.parser = p;
    }

    public OptionalComponent() {
        this(0);
    }

    public OptionalComponent(Id p0) {
        this.setChild(p0, 0);
    }

    public void dumpTree(String indent, PrintStream pStream) {
        pStream.println(String.valueOf(indent) + "OptionalComponent");
        String childIndent = String.valueOf(indent) + "  ";
        int i = 0;
        while (i < this.getNumChild()) {
            this.getChild(i).dumpTree(childIndent, pStream);
            ++i;
        }
    }

    public Object jjtAccept(AstVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void jjtAddChild(Node n, int i) {
        this.checkChild(n, i);
        super.jjtAddChild(n, i);
    }

    public void checkChild(Node n, int i) {
        if (i == 0 && !(n instanceof Id)) {
            throw new Error("Child number 0 of OptionalComponent has the type " + n.getClass().getName() + " which is not an instance of Id");
        }
    }

    public int getNumChild() {
        return 1;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void setId(Id node) {
        this.setChild(node, 0);
    }

    public Id getId() {
        return (Id)this.getChild(0);
    }

    public Id getIdNoTransform() {
        return (Id)this.getChildNoTransform(0);
    }

    public String constrParmType() {
        this.state();
        if (this.constrParmType_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: constrParmType in class: ");
        }
        this.constrParmType_visited = this.state().boundariesCrossed;
        String constrParmType_value = this.constrParmType_compute();
        this.constrParmType_visited = -1;
        return constrParmType_value;
    }

    private String constrParmType_compute() {
        return ASTNode.java5 ? "Opt<" + this.getId().type() + ">" : "Opt";
    }

    public String name() {
        this.state();
        if (this.name_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: name in class: ");
        }
        this.name_visited = this.state().boundariesCrossed;
        String name_value = this.name_compute();
        this.name_visited = -1;
        return name_value;
    }

    private String name_compute() {
        return this.getId().name();
    }

    public String type() {
        this.state();
        if (this.type_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: type in class: ");
        }
        this.type_visited = this.state().boundariesCrossed;
        String type_value = this.type_compute();
        this.type_visited = -1;
        return type_value;
    }

    private String type_compute() {
        return this.getId().type();
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    public String componentString() {
        return JastAddCodeGen.ajc$interMethod$jastadd_JastAddCodeGen$ast_AST_OptionalComponent$componentString(this);
    }
}

