/*
 * Decompiled with CFR 0.152.
 */
package ast.AST;

import ast.AST.ASTDecl;
import ast.AST.ASTNode;
import ast.AST.AggregateComponentsNTA;
import ast.AST.Ast;
import ast.AST.AstVisitor;
import ast.AST.AttrDecl;
import ast.AST.Components;
import ast.AST.List;
import ast.AST.ListComponentsNTA;
import ast.AST.Node;
import ast.AST.OptionalComponentNTA;
import ast.AST.Parameter;
import ast.AST.TokenComponentNTA;
import java.io.PrintStream;

public class SynDecl
extends AttrDecl
implements Cloneable {
    protected int error_visited = -1;
    protected int attributeKind_visited = -1;
    protected int declaredNTA_visited = -1;

    public void flushCache() {
        super.flushCache();
        this.error_visited = -1;
        this.attributeKind_visited = -1;
        this.declaredNTA_visited = -1;
    }

    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    public Object clone() throws CloneNotSupportedException {
        SynDecl node = (SynDecl)super.clone();
        node.error_visited = -1;
        node.attributeKind_visited = -1;
        node.declaredNTA_visited = -1;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public ASTNode copy() {
        try {
            SynDecl node = (SynDecl)this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public ASTNode fullCopy() {
        SynDecl res = (SynDecl)this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            ASTNode node = this.getChildNoTransform(i);
            if (node != null) {
                node = node.fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    public String circularComputeCall() {
        return "#METHODNAME#_compute(#PARM#)";
    }

    public boolean isNTA() {
        return this.findCorrespondingNTA() != null;
    }

    public String higherOrderAttributeCode() {
        StringBuffer result = new StringBuffer();
        if (this.getNTA()) {
            if (ASTNode.rewriteEnabled) {
                if (ASTNode.stagedRewrites) {
                    if (this.getNumParameter() == 0) {
                        return String.valueOf(SynDecl.ind(2)) + "#NAME#_value.setParent(this);\n" + SynDecl.ind(2) + "#NAME#_value.is$Final = java.lang.Integer.MAX_VALUE;\n";
                    }
                    return String.valueOf(SynDecl.ind(2)) + "if(#NAME#_list == null) {\n" + SynDecl.ind(3) + "#NAME#_list = new List();\n" + SynDecl.ind(3) + "#NAME#_list.is$Final = java.lang.Integer.MAX_VALUE;\n" + SynDecl.ind(3) + "#NAME#_list.setParent(this);\n" + SynDecl.ind(2) + "}\n" + SynDecl.ind(2) + "if(#NAME#_value != null) {\n" + SynDecl.ind(3) + "#NAME#_list.add(#NAME#_value);\n" + SynDecl.ind(3) + "#NAME#_value.is$Final = java.lang.Integer.MAX_VALUE;\n" + SynDecl.ind(2) + "}\n";
                }
                if (this.getNumParameter() == 0) {
                    return String.valueOf(SynDecl.ind(2)) + "#NAME#_value.setParent(this);\n" + SynDecl.ind(2) + "#NAME#_value.is$Final = true;\n";
                }
                return String.valueOf(SynDecl.ind(2)) + "if(#NAME#_list == null) {\n" + SynDecl.ind(3) + "#NAME#_list = new List();\n" + SynDecl.ind(3) + "#NAME#_list.is$Final = true;\n" + SynDecl.ind(3) + "#NAME#_list.setParent(this);\n" + SynDecl.ind(2) + "}\n" + SynDecl.ind(2) + "if(#NAME#_value != null) {\n" + SynDecl.ind(3) + "#NAME#_list.add(#NAME#_value);\n" + SynDecl.ind(3) + "#NAME#_value.is$Final = true;\n" + SynDecl.ind(2) + "}\n";
            }
            if (this.getNumParameter() == 0) {
                return String.valueOf(SynDecl.ind(2)) + "#NAME#_value.setParent(this);\n";
            }
            return String.valueOf(SynDecl.ind(2)) + "if(#NAME#_list == null) {\n" + SynDecl.ind(3) + "#NAME#_list = new List();\n" + SynDecl.ind(3) + "#NAME#_list.setParent(this);\n" + SynDecl.ind(2) + "}\n" + SynDecl.ind(2) + "#NAME#_list.add(#NAME#_value);\n";
        }
        Components comp = this.findCorrespondingNTA();
        if (comp != null) {
            String attrName = this.getName().substring(3);
            if (comp.name().equals(attrName) && (comp instanceof OptionalComponentNTA || comp instanceof TokenComponentNTA || comp instanceof AggregateComponentsNTA)) {
                result.append(String.valueOf(SynDecl.ind(3)) + "set" + attrName + "(#NAME#_value);\n");
            }
            if (attrName.equals(String.valueOf(comp.name()) + "Opt") && comp instanceof OptionalComponentNTA) {
                result.append(String.valueOf(SynDecl.ind(2)) + "set" + attrName + "(#NAME#_value);\n");
            }
            if (attrName.equals(String.valueOf(comp.name()) + "List") && comp instanceof ListComponentsNTA) {
                result.append(String.valueOf(SynDecl.ind(2)) + "set" + attrName + "(#NAME#_value);\n");
            }
        }
        return result.toString();
    }

    public SynDecl(int i) {
        super(i);
    }

    public SynDecl(Ast p, int i) {
        this(i);
        this.parser = p;
    }

    public SynDecl() {
        this(0);
        this.setChild(new List(), 0);
    }

    public SynDecl(List p0, String p1, String p2, boolean p3, String p4, int p5, int p6, boolean p7, boolean p8, String p9, String p10) {
        this.setChild(p0, 0);
        this.setName(p1);
        this.setType(p2);
        this.setLazy(p3);
        this.setFileName(p4);
        this.setStartLine(p5);
        this.setEndLine(p6);
        this.setFinal(p7);
        this.setNTA(p8);
        this.setComment(p9);
        this.setAspectName(p10);
    }

    public void dumpTree(String indent, PrintStream pStream) {
        pStream.println(String.valueOf(indent) + "SynDecl" + "\"" + this.getName() + "\"" + "\"" + this.getType() + "\"" + "\"" + this.getLazy() + "\"" + "\"" + this.getFileName() + "\"" + "\"" + this.getStartLine() + "\"" + "\"" + this.getEndLine() + "\"" + "\"" + this.getFinal() + "\"" + "\"" + this.getNTA() + "\"" + "\"" + this.getComment() + "\"" + "\"" + this.getAspectName() + "\"");
        String childIndent = String.valueOf(indent) + "  ";
        int i = 0;
        while (i < this.getNumChild()) {
            this.getChild(i).dumpTree(childIndent, pStream);
            ++i;
        }
    }

    public Object jjtAccept(AstVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void jjtAddChild(Node n, int i) {
        this.checkChild(n, i);
        super.jjtAddChild(n, i);
    }

    public void checkChild(Node n, int i) {
        if (i == 0) {
            if (!(n instanceof List)) {
                throw new Error("Child number 0 of AttrDecl has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            int k = 0;
            while (k < ((List)n).getNumChildNoTransform()) {
                if (!(((List)n).getChildNoTransform(k) instanceof Parameter)) {
                    throw new Error("Child number " + k + " in ParameterList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of Parameter");
                }
                ++k;
            }
        }
    }

    public int getNumChild() {
        return 1;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void setParameterList(List list) {
        this.setChild(list, 0);
    }

    public int getNumParameter() {
        return this.getParameterList().getNumChild();
    }

    public Parameter getParameter(int i) {
        return (Parameter)this.getParameterList().getChild(i);
    }

    public void addParameter(Parameter node) {
        List list = this.parent == null || ASTNode.state == null ? this.getParameterListNoTransform() : this.getParameterList();
        list.addChild(node);
    }

    public void addParameterNoTransform(Parameter node) {
        List list = this.getParameterListNoTransform();
        list.addChild(node);
    }

    public void setParameter(Parameter node, int i) {
        List list = this.getParameterList();
        list.setChild(node, i);
    }

    public List getParameterList() {
        List list = (List)this.getChild(0);
        list.getNumChild();
        return list;
    }

    public List getParameterListNoTransform() {
        return (List)this.getChildNoTransform(0);
    }

    public void setName(String value) {
        this.tokenString_Name = value;
    }

    public String getName() {
        return this.tokenString_Name != null ? this.tokenString_Name : "";
    }

    public void setType(String value) {
        this.tokenString_Type = value;
    }

    public String getType() {
        return this.tokenString_Type != null ? this.tokenString_Type : "";
    }

    public void setLazy(boolean value) {
        this.tokenboolean_Lazy = value;
    }

    public boolean refined__SynDecl_getLazy() {
        return this.tokenboolean_Lazy;
    }

    public void setFileName(String value) {
        this.tokenString_FileName = value;
    }

    public String getFileName() {
        return this.tokenString_FileName != null ? this.tokenString_FileName : "";
    }

    public void setStartLine(int value) {
        this.tokenint_StartLine = value;
    }

    public int getStartLine() {
        return this.tokenint_StartLine;
    }

    public void setEndLine(int value) {
        this.tokenint_EndLine = value;
    }

    public int getEndLine() {
        return this.tokenint_EndLine;
    }

    public void setFinal(boolean value) {
        this.tokenboolean_Final = value;
    }

    public boolean getFinal() {
        return this.tokenboolean_Final;
    }

    public void setNTA(boolean value) {
        this.tokenboolean_NTA = value;
    }

    public boolean getNTA() {
        return this.tokenboolean_NTA;
    }

    public void setComment(String value) {
        this.tokenString_Comment = value;
    }

    public String getComment() {
        return this.tokenString_Comment != null ? this.tokenString_Comment : "";
    }

    public void setAspectName(String value) {
        this.tokenString_AspectName = value;
    }

    public String getAspectName() {
        return this.tokenString_AspectName != null ? this.tokenString_AspectName : "";
    }

    public boolean getLazy() {
        if (ASTNode.cacheAll) {
            return true;
        }
        if (ASTNode.cacheNone) {
            return this.declaredNTA();
        }
        return this.declaredNTA() || this.refined__SynDecl_getLazy();
    }

    public String error() {
        this.state();
        if (this.error_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: error in class: ");
        }
        this.error_visited = this.state().boundariesCrossed;
        String error_value = this.error_compute();
        this.error_visited = -1;
        return error_value;
    }

    private String error_compute() {
        StringBuffer result = new StringBuffer();
        SynDecl decl = this.hostClass().lookupSynDecl(this.signature());
        if (decl != null && decl != this) {
            result.append(String.valueOf(this.getFileName()) + ":" + this.getStartLine() + " ");
            result.append("Multiple declaration of attribute " + this.name() + " in class " + this.hostClass().name());
            result.append(" and " + decl.name() + " in class " + decl.hostClass().name() + " in " + decl.getFileName() + ":" + decl.getStartLine() + "\n");
        } else {
            StringBuffer r = new StringBuffer();
            this.hostClass().checkSynEqs(this.signature(), r);
            if (r.length() != 0) {
                result.append(String.valueOf(this.getFileName()) + ":" + this.getStartLine() + " ");
                result.append("Syn eq for " + this.name() + " missing in the following classes:");
                result.append(r.toString());
                result.append("\n");
            }
        }
        String[] types = this.type().split("<");
        if (this.getNTA() && !(this.hostClass().env().lookup(types[0]) instanceof ASTDecl)) {
            result.append(String.valueOf(this.getFileName()) + ":" + this.getStartLine() + " ");
            result.append("Return type for NTA must be an AST node");
        }
        return result.toString();
    }

    public String attributeKind() {
        this.state();
        if (this.attributeKind_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: attributeKind in class: ");
        }
        this.attributeKind_visited = this.state().boundariesCrossed;
        String attributeKind_value = this.attributeKind_compute();
        this.attributeKind_visited = -1;
        return attributeKind_value;
    }

    private String attributeKind_compute() {
        return this.isNTA() ? "syn nta" : "syn";
    }

    public boolean declaredNTA() {
        this.state();
        if (this.declaredNTA_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: declaredNTA in class: ");
        }
        this.declaredNTA_visited = this.state().boundariesCrossed;
        boolean declaredNTA_value = this.declaredNTA_compute();
        this.declaredNTA_visited = -1;
        return declaredNTA_value;
    }

    private boolean declaredNTA_compute() {
        return this.getNTA();
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

