/*
 * Decompiled with CFR 0.152.
 */
package jastadd;

import ast.AST.ASTDecl;
import ast.AST.ASTNode;
import ast.AST.Ast;
import ast.AST.Components;
import ast.AST.Grammar;
import ast.AST.ParseException;
import ast.AST.TokenComponent;
import ast.AST.TokenMgrError;
import jastadd.CommandLineArguments;
import jastadd.JastAddCodeGen;
import jastadd.Option;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import jrag.AST.JragParser;

public class JastAdd {
    private static ResourceBundle resources = null;
    private static String resourcename = "JastAdd";
    protected List files;
    protected List cacheFiles;
    protected Grammar root;
    protected String pack;
    protected File outputDir;
    protected String grammar;
    protected boolean publicModifier;

    private static String getString(String key) {
        if (resources == null) {
            try {
                resources = ResourceBundle.getBundle(resourcename);
            }
            catch (MissingResourceException missingResourceException) {
                throw new Error("Could not open the resource " + resourcename);
            }
        }
        return resources.getString(key);
    }

    public static String getVersionString() {
        return "JastAdd2 " + JastAdd.getString("jastadd.version");
    }

    public static String getLongVersionString() {
        return "JastAdd2 (http://jastadd.org) version " + JastAdd.getString("jastadd.version");
    }

    public static void main(String[] args) {
        new JastAdd().compile(args);
        Runtime.getRuntime().gc();
    }

    /*
     * Unable to fully structure code
     */
    public void compile(String[] args) {
        try {
            this.files = new ArrayList<E>();
            this.cacheFiles = new ArrayList<E>();
            if (this.readArgs(args)) {
                System.exit(1);
            }
            time = System.currentTimeMillis();
            this.root = new Grammar();
            this.root.abstractAncestors();
            errors = new ArrayList<String>();
            iter = this.files.iterator();
            while (iter.hasNext()) {
                fileName = (String)iter.next();
                if (!fileName.endsWith(".ast")) continue;
                try {
                    parser = new Ast(new FileInputStream(fileName));
                    parser.fileName = fileName;
                    g = parser.Grammar();
                    i = 0;
                    while (i < g.getNumTypeDecl()) {
                        this.root.addTypeDecl(g.getTypeDecl(i));
                        ++i;
                    }
                    errorIter = parser.getErrors();
                    while (errorIter.hasNext()) {
                        s = ((String)errorIter.next()).split(";");
                        errors.add("Syntax error in " + fileName + " at line " + s[0] + ", column " + s[1]);
                    }
                }
                catch (TokenMgrError e) {
                    System.err.println("Lexical error in " + fileName + ": " + e.getMessage());
                    System.exit(1);
                }
                catch (ParseException v0) {
                }
                catch (FileNotFoundException v1) {
                    System.err.println("File error: Abstract syntax grammar file " + fileName + " not found");
                    System.exit(1);
                }
            }
            if (!errors.isEmpty()) {
                iter = errors.iterator();
                while (iter.hasNext()) {
                    System.err.println(iter.next());
                }
                System.exit(1);
            }
            astParseTime = System.currentTimeMillis() - time;
            astErrors = this.root.astErrors();
            astErrorTime = System.currentTimeMillis() - time - astParseTime;
            if (!astErrors.equals("")) {
                System.err.println("Semantic error:");
                System.err.println(astErrors);
                System.exit(1);
            }
            ASTNode.resetGlobalErrors();
            writer = new StringWriter();
            this.root.jjtGenASTNode$State(new PrintWriter(writer), this.grammar, ASTNode.jjtree, ASTNode.rewriteEnabled);
            jp = new JragParser(new StringReader(writer.toString()));
            jp.root = this.root;
            jp.setFileName("ASTNode");
            jp.className = "ASTNode";
            jp.pushTopLevelOrAspect(true);
            try {
                while (true) {
                    jp.AspectBodyDeclaration();
                }
            }
            catch (Exception e) {
                e.getMessage();
                jp.popTopLevelOrAspect();
                iter = this.files.iterator();
                ** while (iter.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                fileName = (String)iter.next();
                if (!fileName.endsWith(".jrag") && !fileName.endsWith(".jadd")) continue;
                try {
                    inputStream = new FileInputStream(fileName);
                    jp = new JragParser(inputStream);
                    jp.inputStream = inputStream;
                    jp.root = this.root;
                    jp.setFileName(fileName);
                    au = jp.CompilationUnit();
                    this.root.addCompUnit(au);
                }
                catch (jrag.AST.ParseException e) {
                    msg = new StringBuffer();
                    msg.append("Syntax error in " + fileName + " at line " + e.currentToken.next.beginLine + ", column " + e.currentToken.next.beginColumn);
                    System.err.println(msg.toString());
                    System.exit(1);
                }
                catch (FileNotFoundException v2) {
                    System.err.println("File error: Aspect file " + fileName + " not found");
                    System.exit(1);
                }
                catch (Throwable e) {
                    System.err.println("Exception occurred while parsing " + fileName);
                    e.printStackTrace();
                }
                continue;
            }
lbl97:
            // 1 sources

            jragParseTime = System.currentTimeMillis() - time - astErrorTime;
            JastAddCodeGen.ajc$interMethodDispatch1$jastadd_JastAddCodeGen$ast_AST_Grammar$weaveInterfaceIntroductions(this.root);
            i = 0;
            while (i < this.root.getNumTypeDecl()) {
                if (this.root.getTypeDecl(i) instanceof ASTDecl) {
                    decl = (ASTDecl)this.root.getTypeDecl(i);
                    writer = new StringWriter();
                    decl.jjtGen(new PrintWriter(writer), this.grammar, ASTNode.jjtree, ASTNode.rewriteEnabled);
                    jp = new JragParser(new StringReader(writer.toString()));
                    jp.root = this.root;
                    jp.setFileName("");
                    jp.className = "ASTNode";
                    jp.pushTopLevelOrAspect(true);
                    try {
                        while (true) {
                            jp.AspectBodyDeclaration();
                        }
                    }
                    catch (Exception e) {
                        e.getMessage();
                        jp.popTopLevelOrAspect();
                        j = 0;
                        iter = decl.getComponents();
                        ** while (iter.hasNext())
                    }
lbl-1000:
                    // 1 sources

                    {
                        c = (Components)iter.next();
                        if (c instanceof TokenComponent) {
                            c.jaddGen(null, j, this.publicModifier, decl);
                            continue;
                        }
                        c.jaddGen(null, j, this.publicModifier, decl);
                        ++j;
                        continue;
                    }
                }
lbl128:
                // 3 sources

                ++i;
            }
            this.root.processRefinements();
            iter = this.cacheFiles.iterator();
            while (iter.hasNext()) {
                fileName = (String)iter.next();
                try {
                    inputStream = new FileInputStream(fileName);
                    jp = new JragParser(inputStream);
                    jp.inputStream = inputStream;
                    jp.root = this.root;
                    jp.setFileName(fileName);
                    jp.CacheDeclarations();
                }
                catch (jrag.AST.ParseException e) {
                    msg = new StringBuffer();
                    msg.append("Syntax error in " + fileName + " at line " + e.currentToken.next.beginLine + ", column " + e.currentToken.next.beginColumn);
                    System.err.println(msg.toString());
                    System.exit(1);
                }
                catch (FileNotFoundException v3) {
                    System.err.println("File error: Aspect file " + fileName + " not found");
                    System.exit(1);
                }
            }
            this.root.weaveCollectionAttributes();
            err = this.root.errors();
            if (!err.equals("") || !ASTNode.globalErrors.equals("")) {
                System.err.println("Semantic errors: \n" + err + ASTNode.globalErrors);
                System.exit(1);
            }
            jragErrorTime = System.currentTimeMillis() - time - jragParseTime;
            JastAddCodeGen.ajc$interMethodDispatch1$jastadd_JastAddCodeGen$ast_AST_Grammar$jastAddGen(this.root, this.outputDir, this.grammar, this.pack, this.publicModifier);
            try {
                this.root.createInterfaces(this.outputDir, this.pack);
            }
            catch (FileNotFoundException v4) {
                System.err.println("File error: Output directory " + this.outputDir + " does not exist or is write protected");
                System.exit(1);
            }
            System.currentTimeMillis() - time - jragErrorTime;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public boolean readArgs(String[] args) {
        CommandLineArguments cla = new CommandLineArguments();
        Option jjtree = new Option("jjtree", "use jjtree base node, this requires --grammar to be set");
        Option grammarOption = new Option("grammar", "the name of the grammar's parser, required when using --jjtree", true);
        Option defaultMap = new Option("defaultMap", "use this expression to construct maps for attribute caches", true);
        Option defaultSet = new Option("defaultSet", "use this expression to construct sets for attribute caches", true);
        Option lazyMaps = new Option("lazyMaps", "use lazy maps");
        Option noLazyMaps = new Option("noLazyMaps", "don't use lazy maps");
        Option privateOption = new Option("private", "");
        Option rewrite = new Option("rewrite", "enable ReRAGs support");
        Option beaver = new Option("beaver", "use beaver base node");
        Option noVisitCheck = new Option("noVisitCheck", "disable circularity check for attributes");
        Option noCacheCycle = new Option("noCacheCycle", "disable cache cycle optimization for circular attributes");
        Option noComponentCheck = new Option("noComponentCheck", "enable strongly connected component optimization for circular attributes");
        Option componentCheck = new Option("componentCheck", "disable strongly connected component optimization for circular attributes");
        Option noInhEqCheck = new Option("noInhEqCheck", "disable check for inherited equations");
        Option suppressWarnings = new Option("suppressWarnings", "suppress warnings when using Java 5");
        Option parentInterface = new Option("parentInterface", "search equations for inherited attributes using interfaces");
        Option refineLegacy = new Option("refineLegacy", "enable the legacy refine syntax");
        Option noRefineLegacy = new Option("noRefineLegacy", "disable the legacy refine syntax");
        Option stagedRewrites = new Option("stagedRewrites", "");
        Option doc = new Option("doc", "generate javadoc like .html pages from sources");
        Option license = new Option("license", "include the given file in each generated file", true);
        Option java1_4 = new Option("java1.4", "generate for Java 1.4");
        Option debug = new Option("debug", "generate run-time checks for debugging");
        Option synch = new Option("synch", "");
        Option noStatic = new Option("noStatic", "");
        Option deterministic = new Option("deterministic", "");
        Option j2me = new Option("j2me", "generate for J2ME");
        Option outputDirOption = new Option("o", "optional base output directory, default is current directory", true);
        Option tracing = new Option("tracing", "weaves in code generating a cache tree");
        Option cacheAll = new Option("cacheAll", "cache all attributes");
        Option noCaching = new Option("noCaching", "");
        Option doxygen = new Option("doxygen", "enhance navigation and documentation when using doxygen");
        Option cacheNone = new Option("cacheNone", "cache no attributes, except NTAs");
        Option cacheImplicit = new Option("cacheImplicit", "make caching implicit, .caching files have higher priority");
        Option ignoreLazy = new Option("ignoreLazy", "ignore the \"lazy\" keyword");
        Option packageOption = new Option("package", "optional package for generated files", true);
        Option version = new Option("version", "print version string and halts");
        Option help = new Option("help", "prints a short help output and halts");
        Option printNonStandardOptions = new Option("X", "print list of non-standard options and halt");
        defaultMap.setNonStandard();
        defaultSet.setNonStandard();
        privateOption.setNonStandard();
        stagedRewrites.setNonStandard();
        synch.setNonStandard();
        noStatic.setNonStandard();
        noCaching.setNonStandard();
        grammarOption.setDefaultValue("Unknown");
        defaultMap.setDefaultValue("new java.util.HashMap(4)");
        defaultSet.setDefaultValue("new java.util.HashSet(4)");
        outputDirOption.setValue(System.getProperty("user.dir"));
        packageOption.setDefaultValue("");
        cla.addOption(jjtree);
        cla.addOption(grammarOption);
        cla.addOption(defaultMap);
        cla.addOption(defaultSet);
        cla.addOption(lazyMaps);
        cla.addOption(noLazyMaps);
        cla.addOption(privateOption);
        cla.addOption(rewrite);
        cla.addOption(beaver);
        cla.addOption(noVisitCheck);
        cla.addOption(noCacheCycle);
        cla.addOption(noComponentCheck);
        cla.addOption(componentCheck);
        cla.addOption(noInhEqCheck);
        cla.addOption(suppressWarnings);
        cla.addOption(parentInterface);
        cla.addOption(refineLegacy);
        cla.addOption(noRefineLegacy);
        cla.addOption(stagedRewrites);
        cla.addOption(doc);
        cla.addOption(license);
        cla.addOption(java1_4);
        cla.addOption(debug);
        cla.addOption(synch);
        cla.addOption(noStatic);
        cla.addOption(deterministic);
        cla.addOption(j2me);
        cla.addOption(outputDirOption);
        cla.addOption(tracing);
        cla.addOption(cacheAll);
        cla.addOption(noCaching);
        cla.addOption(doxygen);
        cla.addOption(cacheNone);
        cla.addOption(cacheImplicit);
        cla.addOption(ignoreLazy);
        cla.addOption(packageOption);
        cla.addOption(version);
        cla.addOption(help);
        cla.addOption(printNonStandardOptions);
        cla.match(args);
        if (printNonStandardOptions.matched()) {
            System.err.println("Non-standard options:");
            cla.printNonStandardOptions();
            System.exit(0);
        }
        if (jjtree.matched() && !grammarOption.matched()) {
            System.err.println("Missing grammar option. It is required in jjtree-mode!");
            return true;
        }
        ASTNode.jjtree = jjtree.matched();
        this.grammar = grammarOption.value();
        ASTNode.createDefaultMap = defaultMap.value();
        ASTNode.createDefaultSet = defaultSet.value();
        ASTNode.lazyMaps = !noLazyMaps.matched();
        this.publicModifier = !privateOption.matched();
        ASTNode.rewriteEnabled = rewrite.matched();
        ASTNode.beaver = beaver.matched();
        ASTNode.visitCheckEnabled = !noVisitCheck.matched();
        ASTNode.cacheCycle = !noCacheCycle.matched();
        ASTNode.componentCheck = componentCheck.matched();
        ASTNode.noInhEqCheck = noInhEqCheck.matched();
        ASTNode.suppressWarnings = suppressWarnings.matched();
        ASTNode.parentInterface = parentInterface.matched();
        ASTNode.refineLegacy = !noRefineLegacy.matched();
        ASTNode.stagedRewrites = stagedRewrites.matched();
        ASTNode.doc = doc.matched();
        ASTNode.license = "";
        if (license.matched()) {
            String fileName = license.value();
            try {
                if (fileName != null) {
                    ASTNode.license = this.readFile(fileName);
                }
            }
            catch (IOException iOException) {
                System.err.println("Error loading license file " + fileName);
                System.exit(1);
            }
        }
        boolean bl = ASTNode.java5 = !java1_4.matched();
        if (debug.matched()) {
            ASTNode.debugMode = true;
            ASTNode.cycleLimit = 100;
            ASTNode.rewriteLimit = 100;
            ASTNode.visitCheckEnabled = true;
        }
        ASTNode.block = synch.matched();
        ASTNode.noStatic = noStatic.matched();
        ASTNode.deterministic = deterministic.matched();
        if (ASTNode.deterministic) {
            ASTNode.createDefaultMap = "new java.util.LinkedHashMap(4)";
            ASTNode.createDefaultSet = "new java.util.LinkedHashSet(4)";
        }
        ASTNode.j2me = j2me.matched();
        String outputDirName = outputDirOption.value();
        this.outputDir = new File(outputDirName);
        if (!this.outputDir.exists()) {
            System.err.println("Output directory does not exist");
            System.exit(1);
        }
        if (!this.outputDir.isDirectory()) {
            System.err.println("Output directory is not a directory");
            System.exit(1);
        }
        if (!this.outputDir.canWrite()) {
            System.err.println("Output directory is write protected");
            System.exit(1);
        }
        if (ASTNode.j2me) {
            if (ASTNode.deterministic) {
                System.err.println("J2ME can not be used in deterministic mode");
                System.exit(1);
            }
            if (ASTNode.debugMode) {
                System.err.println("J2ME can not be used in debug mode");
                System.exit(1);
            }
            if (ASTNode.java5) {
                System.err.println("J2ME can not be used in java5 mode");
                System.exit(1);
            }
            ASTNode.createDefaultMap = "new java.util.Hashtable(4)";
            ASTNode.createDefaultSet = "new ASTNode$State.HashtableBasedSet(4)";
            ASTNode.typeDefaultMap = "java.util.Hashtable";
            ASTNode.typeDefaultSet = "ASTNode$State.HashtableBasedSet";
            ASTNode.createContributorSet = "new ASTNode$State.HashtableBasedSet(4)";
        }
        ASTNode.tracing = tracing.matched();
        ASTNode.cacheAll = cacheAll.matched();
        ASTNode.noCaching = noCaching.matched();
        ASTNode.doxygen = doxygen.matched();
        ASTNode.cacheNone = cacheNone.matched();
        ASTNode.cacheImplicit = cacheImplicit.matched();
        ASTNode.ignoreLazy = ignoreLazy.matched();
        this.pack = packageOption.value().replace('/', '.');
        int n = cla.getNumOperands();
        int k = 0;
        while (k < n) {
            String fileName = cla.getOperand(k);
            if (fileName.endsWith(".ast") || fileName.endsWith(".jrag") || fileName.endsWith(".jadd")) {
                this.files.add(fileName);
            } else if (fileName.endsWith(".caching")) {
                this.cacheFiles.add(fileName);
            } else {
                System.err.println("FileError: " + fileName + " is of unknown file type");
                return true;
            }
            ++k;
        }
        if (version.matched()) {
            System.err.println(JastAdd.getVersionString());
            System.exit(0);
        }
        if (help.matched() || this.files.isEmpty()) {
            System.err.println(String.valueOf(JastAdd.getLongVersionString()) + "\n");
            this.printHelp(cla);
            System.exit(0);
        }
        return false;
    }

    private String readFile(String name) throws IOException {
        StringBuffer buf = new StringBuffer();
        BufferedReader reader = new BufferedReader(new FileReader(name));
        char[] cbuf = new char[1024];
        int i = 0;
        while ((i = reader.read(cbuf)) != -1) {
            buf.append(String.valueOf(cbuf, 0, i));
        }
        ((Reader)reader).close();
        return buf.toString();
    }

    private void checkMem() {
        Runtime runtime = Runtime.getRuntime();
        long total = runtime.totalMemory();
        long free = runtime.freeMemory();
        long use = total - free;
        System.out.println("Before GC: Total " + total + ", use " + use);
        runtime.gc();
        total = runtime.totalMemory();
        free = runtime.freeMemory();
        use = total - free;
        System.out.println("After GC: Total " + total + ", use " + use);
    }

    public void printHelp(CommandLineArguments cla) {
        System.err.println("This program reads a number of .jrag, .jadd, and .ast files");
        System.err.println("and creates the nodes in the abstract syntax tree");
        System.err.println();
        System.err.println("The .jrag source files may contain declarations of synthesized ");
        System.err.println("and inherited attributes and their corresponding equations.");
        System.err.println("It may also contain ordinary Java methods and fields.");
        System.err.println();
        System.err.println("Source file syntax can be found at http://jastadd.org");
        System.err.println();
        System.err.println("Options:");
        cla.printHelp();
        System.err.println();
        System.err.println("Arguments:");
        System.err.println("Names of .ast, .jrag, .jadd and .caching source files");
        System.err.println();
        System.err.println("Example: The following command reads and translates files NameAnalysis.jrag");
        System.err.println("and TypeAnalysis.jrag, weaves PrettyPrint.jadd into the abstract syntax tree");
        System.err.println("defined in the grammar Toy.ast.");
        System.err.println("The result is the generated classes for the nodes in the AST that are placed");
        System.err.println("in the package ast.");
        System.err.println();
        System.err.println("java -jar jastadd2.jar --package=ast Toy.ast NameAnalysis.jrag TypeAnalysis.jrag PrettyPrinter.jadd");
    }
}

