/*
 * Decompiled with CFR 0.152.
 */
package jastadd;

import jastadd.Option;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CommandLineArguments {
    private List options = new LinkedList();
    private List operands = new ArrayList();

    public void addOption(Option option) {
        this.options.add(option);
    }

    public void match(String[] args) {
        int i = 0;
        Option lastMatch = null;
        while (i < args.length) {
            Iterator iter = this.options.iterator();
            while (iter.hasNext() && i < args.length) {
                Option option = (Option)iter.next();
                int num = option.match(args, i);
                if (num > 0) {
                    lastMatch = option;
                    i += num;
                    continue;
                }
                if (lastMatch == option) {
                    if (args[i].startsWith("--")) {
                        System.err.println("Unknown option \"" + args[i] + "\" will be ignored");
                    } else {
                        this.operands.add(args[i]);
                    }
                    ++i;
                    continue;
                }
                if (lastMatch != null) continue;
                lastMatch = option;
            }
        }
    }

    public void printHelp() {
        Iterator iter = this.options.iterator();
        while (iter.hasNext()) {
            Option option = (Option)iter.next();
            if (option.nonStandard || option.deprecated) continue;
            option.printHelp();
        }
    }

    public void printNonStandardOptions() {
        Iterator iter = this.options.iterator();
        while (iter.hasNext()) {
            Option option = (Option)iter.next();
            if (!option.nonStandard) continue;
            option.printHelp();
        }
    }

    public int getNumOperands() {
        return this.operands.size();
    }

    public String getOperand(int k) {
        return (String)this.operands.get(k);
    }
}

