/*
 * Decompiled with CFR 0.152.
 */
package jastadd;

public class Option {
    public static final String OPTION_PREFIX = "--";
    protected String desc;
    protected String name;
    protected String longName;
    protected String longNameLower;
    protected boolean nonStandard = false;
    protected boolean deprecated = false;
    protected boolean matched = false;
    protected String value;
    protected String defaultValue;
    protected boolean needsValue = false;
    protected boolean hasDefaultValue = false;

    public Option(String optionName, String description) {
        this(optionName, description, false);
    }

    public Option(String optionName, String description, boolean needsValue) {
        this(optionName, description, needsValue, false);
    }

    public Option(String optionName, String description, boolean needsValue, boolean isNonStandard) {
        this.name = optionName;
        this.longName = OPTION_PREFIX + optionName;
        this.longNameLower = this.longName.toLowerCase();
        this.desc = description;
        this.nonStandard = isNonStandard;
        this.value = "";
        this.needsValue = needsValue;
    }

    public void setNonStandard() {
        this.nonStandard = true;
    }

    public void setDeprecated() {
        this.deprecated = true;
    }

    public boolean matched() {
        return this.matched;
    }

    public String value() {
        return this.value;
    }

    public void setValue(String v) {
        this.value = v;
    }

    public void setDefaultValue(String v) {
        this.defaultValue = v;
        this.value = v;
        this.hasDefaultValue = true;
    }

    public void printHelp() {
        int col = 18;
        System.err.print("  " + this.longName);
        if ((col -= this.longName.length()) < 1) {
            col = 1;
        }
        int i = 0;
        while (i < col) {
            System.err.print(' ');
            ++i;
        }
        if (this.hasDefaultValue) {
            System.err.print(this.desc);
            System.err.println(" (default = \"" + this.defaultValue + "\")");
        } else {
            System.err.println(this.desc);
        }
    }

    public int match(String[] args, int index) {
        int offset = 0;
        boolean currentMatch = false;
        if (args[index].toLowerCase().equals(this.longNameLower)) {
            if (this.needsValue) {
                if (index < args.length - 1 && !args[index + 1].startsWith(OPTION_PREFIX)) {
                    this.value = args[index + 1];
                    offset = 2;
                } else {
                    System.err.println("Warning: Missing value for option " + this.name);
                    offset = 1;
                }
            }
            currentMatch = true;
            offset = 1;
        } else if (this.needsValue && args[index].toLowerCase().startsWith(String.valueOf(this.longNameLower) + "=")) {
            this.value = args[index].substring(this.longNameLower.length() + 1);
            currentMatch = true;
            offset = 1;
        }
        if (currentMatch && this.matched) {
            System.err.println("Warning: option " + this.name + " occurs more than once in the argument list!");
        } else if (currentMatch && this.deprecated) {
            System.err.println("Warning: option " + this.name + " has been deprecated! Use of this option is discouraged!");
        }
        this.matched = currentMatch || this.matched;
        return offset;
    }
}

