/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.internal;

import java.util.ArrayList;
import java.util.List;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.TaskListManager;
import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;

public class AjdeMessageHandler
implements IMessageHandler {
    private TaskListManager taskListManager;
    private List ignoring = new ArrayList();

    public AjdeMessageHandler() {
        this.ignore(IMessage.INFO);
        this.ignore(IMessage.WEAVEINFO);
        this.taskListManager = Ajde.getDefault().getTaskListManager();
    }

    public boolean handleMessage(IMessage message) throws AbortException {
        IMessage.Kind kind = message.getKind();
        if (kind == IMessage.ABORT) {
            return this.handleAbort(message);
        }
        if (this.isIgnoring(kind)) {
            return true;
        }
        this.taskListManager.addSourcelineTask(message);
        return true;
    }

    private boolean handleAbort(IMessage abortMessage) {
        throw new AbortException(abortMessage);
    }

    public void dontIgnore(IMessage.Kind kind) {
        if (null != kind) {
            this.ignoring.remove(kind);
        }
    }

    public boolean isIgnoring(IMessage.Kind kind) {
        return null != kind && this.ignoring.contains(kind);
    }

    public void ignore(IMessage.Kind kind) {
        if (null != kind && !this.ignoring.contains(kind)) {
            this.ignoring.add(kind);
        }
    }
}

