/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.classfmt;

import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ClassFileStruct;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.AttributeNamesConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryMethod;

public class MethodInfo
extends ClassFileStruct
implements IBinaryMethod,
AttributeNamesConstants,
Comparable {
    private static final char[][] noException = CharOperation.NO_CHAR_CHAR;
    private int accessFlags;
    private int attributeBytes;
    private int[] constantPoolOffsets;
    private char[] descriptor;
    private char[][] exceptionNames;
    private char[] name;
    private char[] signature;
    private int signatureUtf8Offset;
    private long tagBits;

    public MethodInfo(byte[] classFileBytes, int[] offsets, int offset) {
        super(classFileBytes, offset);
        this.constantPoolOffsets = offsets;
        this.accessFlags = -1;
        int attributesCount = this.u2At(6);
        int readOffset = 8;
        this.signatureUtf8Offset = -1;
        int i = 0;
        while (i < attributesCount) {
            int utf8Offset = this.constantPoolOffsets[this.u2At(readOffset)] - this.structOffset;
            char[] attributeName = this.utf8At(utf8Offset + 3, this.u2At(utf8Offset + 1));
            if (attributeName.length > 0) {
                switch (attributeName[0]) {
                    case 'S': {
                        if (!CharOperation.equals(AttributeNamesConstants.SignatureName, attributeName)) break;
                        this.signatureUtf8Offset = this.constantPoolOffsets[this.u2At(readOffset + 6)] - this.structOffset;
                        break;
                    }
                    case 'R': {
                        if (!CharOperation.equals(attributeName, AttributeNamesConstants.RuntimeVisibleAnnotationsName)) break;
                        this.decodeStandardAnnotations(readOffset);
                    }
                }
            }
            readOffset = (int)((long)readOffset + (6L + this.u4At(readOffset + 2)));
            ++i;
        }
        this.attributeBytes = readOffset;
    }

    public int compareTo(Object o) {
        if (!(o instanceof MethodInfo)) {
            throw new ClassCastException();
        }
        MethodInfo otherMethod = (MethodInfo)o;
        int result = new String(this.getSelector()).compareTo(new String(otherMethod.getSelector()));
        if (result != 0) {
            return result;
        }
        return new String(this.getMethodDescriptor()).compareTo(new String(otherMethod.getMethodDescriptor()));
    }

    private int decodeAnnotation(int offset) {
        int readOffset = offset;
        int utf8Offset = this.constantPoolOffsets[this.u2At(offset)] - this.structOffset;
        char[] typeName = this.utf8At(utf8Offset + 3, this.u2At(utf8Offset + 1));
        int numberOfPairs = this.u2At(offset + 2);
        readOffset += 4;
        if (typeName.length == 22 && CharOperation.equals(typeName, ConstantPool.JAVA_LANG_DEPRECATED)) {
            this.tagBits |= 0x200000000000L;
            return readOffset;
        }
        int i = 0;
        while (i < numberOfPairs) {
            readOffset += 2;
            readOffset = this.decodeElementValue(readOffset);
            ++i;
        }
        return readOffset;
    }

    private int decodeElementValue(int offset) {
        int readOffset = offset;
        int tag = this.u1At(readOffset);
        ++readOffset;
        switch (tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                readOffset += 2;
                break;
            }
            case 101: {
                readOffset += 4;
                break;
            }
            case 99: {
                readOffset += 2;
                break;
            }
            case 64: {
                readOffset = this.decodeAnnotation(readOffset);
                break;
            }
            case 91: {
                int numberOfValues = this.u2At(readOffset);
                readOffset += 2;
                int i = 0;
                while (i < numberOfValues) {
                    readOffset = this.decodeElementValue(readOffset);
                    ++i;
                }
                break;
            }
        }
        return readOffset;
    }

    private void decodeStandardAnnotations(int offset) {
        int numberOfAnnotations = this.u2At(offset + 6);
        int readOffset = offset + 8;
        int i = 0;
        while (i < numberOfAnnotations) {
            readOffset = this.decodeAnnotation(readOffset);
            ++i;
        }
    }

    public char[][] getArgumentNames() {
        return null;
    }

    public char[][] getExceptionTypeNames() {
        if (this.exceptionNames == null) {
            this.readExceptionAttributes();
        }
        return this.exceptionNames;
    }

    public char[] getGenericSignature() {
        if (this.signatureUtf8Offset != -1) {
            if (this.signature == null) {
                this.signature = this.utf8At(this.signatureUtf8Offset + 3, this.u2At(this.signatureUtf8Offset + 1));
            }
            return this.signature;
        }
        return null;
    }

    public char[] getMethodDescriptor() {
        if (this.descriptor == null) {
            int utf8Offset = this.constantPoolOffsets[this.u2At(4)] - this.structOffset;
            this.descriptor = this.utf8At(utf8Offset + 3, this.u2At(utf8Offset + 1));
        }
        return this.descriptor;
    }

    public int getModifiers() {
        if (this.accessFlags == -1) {
            this.accessFlags = this.u2At(0);
            this.readModifierRelatedAttributes();
        }
        return this.accessFlags;
    }

    public char[] getSelector() {
        if (this.name == null) {
            int utf8Offset = this.constantPoolOffsets[this.u2At(2)] - this.structOffset;
            this.name = this.utf8At(utf8Offset + 3, this.u2At(utf8Offset + 1));
        }
        return this.name;
    }

    public long getTagBits() {
        return this.tagBits;
    }

    void initialize() {
        this.getModifiers();
        this.getSelector();
        this.getMethodDescriptor();
        this.getExceptionTypeNames();
        this.getGenericSignature();
        this.reset();
    }

    public boolean isClinit() {
        char[] selector = this.getSelector();
        return selector[0] == '<' && selector.length == 8;
    }

    public boolean isConstructor() {
        char[] selector = this.getSelector();
        return selector[0] == '<' && selector.length == 6;
    }

    public boolean isSynthetic() {
        return (this.getModifiers() & 0x1000) != 0;
    }

    private void readExceptionAttributes() {
        int attributesCount = this.u2At(6);
        int readOffset = 8;
        int i = 0;
        while (i < attributesCount) {
            int utf8Offset = this.constantPoolOffsets[this.u2At(readOffset)] - this.structOffset;
            char[] attributeName = this.utf8At(utf8Offset + 3, this.u2At(utf8Offset + 1));
            if (CharOperation.equals(attributeName, AttributeNamesConstants.ExceptionsName)) {
                int entriesNumber = this.u2At(readOffset + 6);
                readOffset += 8;
                if (entriesNumber == 0) {
                    this.exceptionNames = noException;
                } else {
                    this.exceptionNames = new char[entriesNumber][];
                    int j = 0;
                    while (j < entriesNumber) {
                        utf8Offset = this.constantPoolOffsets[this.u2At(this.constantPoolOffsets[this.u2At(readOffset)] - this.structOffset + 1)] - this.structOffset;
                        this.exceptionNames[j] = this.utf8At(utf8Offset + 3, this.u2At(utf8Offset + 1));
                        readOffset += 2;
                        ++j;
                    }
                }
            } else {
                readOffset = (int)((long)readOffset + (6L + this.u4At(readOffset + 2)));
            }
            ++i;
        }
        if (this.exceptionNames == null) {
            this.exceptionNames = noException;
        }
    }

    private void readModifierRelatedAttributes() {
        int attributesCount = this.u2At(6);
        int readOffset = 8;
        int i = 0;
        while (i < attributesCount) {
            int utf8Offset = this.constantPoolOffsets[this.u2At(readOffset)] - this.structOffset;
            char[] attributeName = this.utf8At(utf8Offset + 3, this.u2At(utf8Offset + 1));
            if (attributeName.length != 0) {
                switch (attributeName[0]) {
                    case 'D': {
                        if (!CharOperation.equals(attributeName, AttributeNamesConstants.DeprecatedName)) break;
                        this.accessFlags |= 0x100000;
                        break;
                    }
                    case 'S': {
                        if (!CharOperation.equals(attributeName, AttributeNamesConstants.SyntheticName)) break;
                        this.accessFlags |= 0x1000;
                        break;
                    }
                    case 'A': {
                        if (!CharOperation.equals(attributeName, AttributeNamesConstants.AnnotationDefaultName)) break;
                        this.accessFlags |= 0x20000;
                    }
                }
            }
            readOffset = (int)((long)readOffset + (6L + this.u4At(readOffset + 2)));
            ++i;
        }
    }

    protected void reset() {
        this.constantPoolOffsets = null;
        super.reset();
    }

    public int sizeInBytes() {
        return this.attributeBytes;
    }

    public String toString() {
        int modifiers = this.getModifiers();
        char[] desc = this.getGenericSignature();
        if (desc == null) {
            desc = this.getMethodDescriptor();
        }
        StringBuffer buffer = new StringBuffer(this.getClass().getName());
        return buffer.append("{").append(String.valueOf((modifiers & 0x100000) != 0 ? "deprecated " : "") + ((modifiers & 1) == 1 ? "public " : "") + ((modifiers & 2) == 2 ? "private " : "") + ((modifiers & 4) == 4 ? "protected " : "") + ((modifiers & 8) == 8 ? "static " : "") + ((modifiers & 0x10) == 16 ? "final " : "") + ((modifiers & 0x40) == 64 ? "volatile " : "") + ((modifiers & 0x80) == 128 ? "varargs " : "")).append(this.getSelector()).append(desc).append("}").toString();
    }
}

