/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.preferences.ExportedPreferences;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IExportedPreferences;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ProjectPreferences
extends EclipsePreferences {
    private int segmentCount;
    private String qualifier;
    private IProject project;
    private IEclipsePreferences loadLevel;
    private IFile file;
    protected static Set loadedNodes = new HashSet();
    private boolean isWriting;
    private boolean initialized = false;

    public ProjectPreferences() {
        super(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ProjectPreferences(EclipsePreferences parent, String name) {
        super(parent, name);
        String path = this.absolutePath();
        this.segmentCount = ProjectPreferences.getSegmentCount(path);
        if (this.segmentCount == 1) {
            return;
        }
        String projectName = ProjectPreferences.getSegment(path, 1);
        if (projectName != null) {
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        if (this.segmentCount > 2) {
            this.qualifier = ProjectPreferences.getSegment(path, 2);
        }
        if (this.segmentCount != 2) {
            return;
        }
        if (this.initialized) {
            return;
        }
        try {
            ProjectPreferences projectPreferences = this;
            synchronized (projectPreferences) {
                String[] names = this.computeChildren();
                int i = 0;
                while (true) {
                    block12: {
                        if (i < names.length) break block12;
                        break;
                    }
                    this.addChild(names[i], null);
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.initialized = true;
            throw throwable;
        }
        {
            Object var8_10 = null;
            this.initialized = true;
            return;
        }
    }

    public boolean nodeExists(String path) throws BackingStoreException {
        if (this.segmentCount != 1) {
            return super.nodeExists(path);
        }
        if (path.length() == 0) {
            return super.nodeExists(path);
        }
        if (path.charAt(0) == '/') {
            return super.nodeExists(path);
        }
        if (path.indexOf(47) != -1) {
            return super.nodeExists(path);
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(path).exists() || super.nodeExists(path);
    }

    protected IPath getLocation() {
        if (this.project == null || this.qualifier == null) {
            return null;
        }
        IPath path = this.project.getLocation();
        return this.computeLocation(path, this.qualifier);
    }

    protected boolean isAlreadyLoaded(IEclipsePreferences node) {
        return loadedNodes.contains(node.absolutePath());
    }

    protected boolean isAlreadyLoaded(String path) {
        return loadedNodes.contains(path);
    }

    protected void loaded() {
        loadedNodes.add(this.absolutePath());
    }

    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.project == null || this.qualifier == null) {
                return null;
            }
            EclipsePreferences node = this;
            int i = 3;
            while (i < this.segmentCount) {
                node = (EclipsePreferences)node.parent();
                ++i;
            }
            this.loadLevel = node;
        }
        return this.loadLevel;
    }

    protected EclipsePreferences internalCreate(EclipsePreferences nodeParent, String nodeName, Plugin context) {
        return new ProjectPreferences(nodeParent, nodeName);
    }

    private IFile getFile() {
        if (this.file == null) {
            if (this.project == null || this.qualifier == null) {
                return null;
            }
            this.file = ProjectPreferences.getFile(this.project, this.qualifier);
        }
        return this.file;
    }

    static IFile getFile(IProject project, String qualifier) {
        return project.getFile(new Path(".settings").append(qualifier).addFileExtension("prefs"));
    }

    static IFile getFile(IFolder folder, String qualifier) {
        Assert.isLegal(folder.getName().equals(".settings"));
        return folder.getFile(new Path(qualifier).addFileExtension("prefs"));
    }

    static IFile getFile(IEclipsePreferences node) {
        String path = node.absolutePath();
        String projectName = ProjectPreferences.getSegment(path, 2);
        if (projectName == null) {
            return null;
        }
        String qualifier = ProjectPreferences.getSegment(path, 3);
        if (qualifier == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(projectName).append(".settings").append(qualifier).addFileExtension("prefs"));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void save() throws BackingStoreException {
        final IFile fileInWorkspace = this.getFile();
        if (fileInWorkspace == null) {
            if (!Policy.DEBUG_PREFERENCES) return;
            Policy.debug("Not saving preferences since there is no file for node: " + this.absolutePath());
            return;
        }
        Properties table = this.convertToProperties(new SortedProperties(), "");
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IResourceRuleFactory factory = workspace.getRuleFactory();
        try {
            if (table.isEmpty()) {
                IWorkspaceRunnable operation = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        if (fileInWorkspace.exists()) {
                            IStatus status;
                            if (Policy.DEBUG_PREFERENCES) {
                                Policy.debug("Deleting preference file: " + fileInWorkspace.getFullPath());
                            }
                            if (fileInWorkspace.isReadOnly() && !(status = fileInWorkspace.getWorkspace().validateEdit(new IFile[]{fileInWorkspace}, null)).isOK()) {
                                throw new CoreException(status);
                            }
                            try {
                                fileInWorkspace.delete(true, null);
                            }
                            catch (CoreException coreException) {
                                String message = NLS.bind((String)Messages.preferences_deleteException, (Object)fileInWorkspace.getFullPath());
                                ProjectPreferences.log(new Status(2, "org.eclipse.core.resources", 2, message, null));
                            }
                        }
                    }
                };
                ISchedulingRule rule = factory.deleteRule(fileInWorkspace);
                try {
                    ResourcesPlugin.getWorkspace().run(operation, rule, 0, null);
                    return;
                }
                catch (OperationCanceledException operationCanceledException) {
                    throw new BackingStoreException(Messages.preferences_operationCanceled);
                }
            }
            table.put("eclipse.preferences.version", "1");
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try {
                try {
                    table.store(output, null);
                }
                catch (IOException e) {
                    String message = NLS.bind((String)Messages.preferences_saveProblems, (Object)this.absolutePath());
                    ProjectPreferences.log(new Status(4, "org.eclipse.core.runtime", 4, message, e));
                    throw new BackingStoreException(message);
                }
            }
            catch (Throwable throwable) {
                Object var8_15 = null;
                try {
                    output.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var8_16 = null;
            }
            try {}
            catch (IOException iOException) {}
            output.close();
            final BufferedInputStream input = new BufferedInputStream(new ByteArrayInputStream(output.toByteArray()));
            IWorkspaceRunnable operation = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    if (fileInWorkspace.exists()) {
                        IStatus status;
                        if (Policy.DEBUG_PREFERENCES) {
                            Policy.debug("Setting preference file contents for: " + fileInWorkspace.getFullPath());
                        }
                        if (fileInWorkspace.isReadOnly() && !(status = fileInWorkspace.getWorkspace().validateEdit(new IFile[]{fileInWorkspace}, null)).isOK()) {
                            throw new CoreException(status);
                        }
                        fileInWorkspace.setContents(input, 2, null);
                    } else {
                        IFolder folder = (IFolder)fileInWorkspace.getParent();
                        if (!folder.exists()) {
                            if (Policy.DEBUG_PREFERENCES) {
                                Policy.debug("Creating parent preference directory: " + folder.getFullPath());
                            }
                            folder.create(0, true, null);
                        }
                        if (Policy.DEBUG_PREFERENCES) {
                            Policy.debug("Creating preference file: " + fileInWorkspace.getLocation());
                        }
                        fileInWorkspace.create(input, 0, null);
                    }
                }
            };
            try {
                if (((Workspace)workspace).getWorkManager().isLockAlreadyAcquired()) {
                    operation.run(null);
                    return;
                }
                ISchedulingRule rule = MultiRule.combine(factory.createRule(fileInWorkspace.getParent()), factory.modifyRule(fileInWorkspace));
                workspace.run(operation, rule, 0, null);
                return;
            }
            catch (OperationCanceledException operationCanceledException) {
                throw new BackingStoreException(Messages.preferences_operationCanceled);
            }
        }
        catch (CoreException e) {
            String message = NLS.bind((String)Messages.preferences_saveProblems, (Object)fileInWorkspace.getFullPath());
            ProjectPreferences.log(new Status(4, "org.eclipse.core.resources", 4, message, e));
            throw new BackingStoreException(message);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void load() throws BackingStoreException {
        Properties fromDisk;
        block11: {
            IFile localFile = this.getFile();
            if (localFile == null || !localFile.exists()) {
                if (!Policy.DEBUG_PREFERENCES) return;
                Policy.debug("Unable to determine preference file or file does not exist for node: " + this.absolutePath());
                return;
            }
            if (Policy.DEBUG_PREFERENCES) {
                Policy.debug("Loading preferences from file: " + localFile.getFullPath());
            }
            fromDisk = new Properties();
            BufferedInputStream input = null;
            try {
                try {
                    input = new BufferedInputStream(localFile.getContents(true));
                    fromDisk.load(input);
                }
                catch (CoreException e) {
                    String message = NLS.bind((String)Messages.preferences_loadException, (Object)localFile.getFullPath());
                    ProjectPreferences.log(new Status(4, "org.eclipse.core.resources", 4, message, e));
                    throw new BackingStoreException(message);
                }
                catch (IOException e) {
                    String message = NLS.bind((String)Messages.preferences_loadException, (Object)localFile.getFullPath());
                    ProjectPreferences.log(new Status(4, "org.eclipse.core.resources", 4, message, e));
                    throw new BackingStoreException(message);
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                if (input == null) throw throwable;
                try {
                    ((InputStream)input).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var6_10 = null;
                if (input == null) break block11;
            }
            try {}
            catch (IOException iOException) {}
            ((InputStream)input).close();
        }
        ProjectPreferences.convertFromProperties(this, fromDisk, true);
    }

    /*
     * Exception decompiling
     */
    private static Properties loadProperties(IFile file) throws BackingStoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 174->177)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void read(ProjectPreferences node, IFile file) throws BackingStoreException, CoreException {
        if (file == null || !file.exists()) {
            if (Policy.DEBUG_PREFERENCES) {
                Policy.debug("Unable to determine preference file or file does not exist for node: " + node.absolutePath());
            }
            return;
        }
        Properties fromDisk = ProjectPreferences.loadProperties(file);
        if (fromDisk.isEmpty()) {
            return;
        }
        IExportedPreferences myNode = (IExportedPreferences)ExportedPreferences.newRoot().node(node.absolutePath());
        ProjectPreferences.convertFromProperties((EclipsePreferences)((Object)myNode), fromDisk, false);
        Platform.getPreferencesService().applyPreferences(myNode);
    }

    public static void updatePreferences(IFile file) throws CoreException {
        IPath path = file.getFullPath();
        if (!"prefs".equals(path.getFileExtension())) {
            return;
        }
        String project = path.segment(0);
        String qualifier = path.removeFileExtension().lastSegment();
        IEclipsePreferences root = Platform.getPreferencesService().getRootNode();
        Preferences node = root.node("project").node(project).node(qualifier);
        String message = null;
        try {
            message = NLS.bind((String)Messages.preferences_syncException, (Object)node.absolutePath());
            if (!(node instanceof ProjectPreferences)) {
                return;
            }
            ProjectPreferences projectPrefs = (ProjectPreferences)node;
            if (projectPrefs.isWriting) {
                return;
            }
            ProjectPreferences.read(projectPrefs, file);
            if ("org.eclipse.core.resources".equals(qualifier)) {
                ProjectPreferences.preferencesChanged(file.getProject());
            }
        }
        catch (BackingStoreException e) {
            Status status = new Status(4, "org.eclipse.core.resources", 4, message, e);
            throw new CoreException(status);
        }
    }

    private static void preferencesChanged(IProject project) {
        Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();
        workspace.getCharsetManager().projectPreferencesChanged(project);
        workspace.getContentDescriptionManager().projectPreferencesChanged(project);
    }

    static void removeNode(Preferences node) throws CoreException {
        String message = NLS.bind((String)Messages.preferences_removeNodeException, (Object)node.absolutePath());
        try {
            node.removeNode();
        }
        catch (BackingStoreException e) {
            Status status = new Status(4, "org.eclipse.core.resources", 4, message, e);
            throw new CoreException(status);
        }
        String path = node.absolutePath();
        Iterator i = loadedNodes.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!key.startsWith(path)) continue;
            i.remove();
        }
    }

    static void deleted(IProject project) throws CoreException {
        IEclipsePreferences root = Platform.getPreferencesService().getRootNode();
        Preferences projectNode = root.node("project").node(project.getName());
        boolean hasResourcesSettings = ProjectPreferences.getFile(project, "org.eclipse.core.resources").exists();
        ProjectPreferences.removeNode(projectNode);
        if (hasResourcesSettings) {
            ProjectPreferences.preferencesChanged(project);
        }
    }

    static void deleted(IFile file) throws CoreException {
        IPath path = file.getFullPath();
        int count = path.segmentCount();
        if (count != 3) {
            return;
        }
        if (!".settings".equals(path.segment(1))) {
            return;
        }
        IEclipsePreferences root = Platform.getPreferencesService().getRootNode();
        String project = path.segment(0);
        String qualifier = path.removeFileExtension().lastSegment();
        ProjectPreferences projectNode = (ProjectPreferences)root.node("project").node(project);
        try {
            if (!projectNode.nodeExists(qualifier)) {
                return;
            }
        }
        catch (BackingStoreException backingStoreException) {}
        String childPath = String.valueOf(projectNode.absolutePath()) + '/' + qualifier;
        if (projectNode.isAlreadyLoaded(childPath)) {
            ProjectPreferences.removeNode(projectNode.node(qualifier));
        } else {
            projectNode.removeNode(qualifier);
        }
        if (qualifier.equals("org.eclipse.core.resources")) {
            ProjectPreferences.preferencesChanged(file.getProject());
        }
    }

    private synchronized void removeNode(String path) {
        if (this.children != null) {
            if (this.children.remove(path) != null) {
                this.makeDirty();
            }
            if (this.children.isEmpty()) {
                this.children = null;
            }
        }
    }

    static void deleted(IResource resource) throws CoreException {
        switch (resource.getType()) {
            case 1: {
                ProjectPreferences.deleted((IFile)resource);
                return;
            }
            case 2: {
                ProjectPreferences.deleted((IFolder)resource);
                return;
            }
            case 4: {
                ProjectPreferences.deleted((IProject)resource);
                return;
            }
        }
    }

    static void deleted(IFolder folder) throws CoreException {
        IPath path = folder.getFullPath();
        int count = path.segmentCount();
        if (count != 2) {
            return;
        }
        if (!".settings".equals(path.segment(1))) {
            return;
        }
        IEclipsePreferences root = Platform.getPreferencesService().getRootNode();
        String project = path.segment(0);
        Preferences projectNode = root.node("project").node(project);
        boolean hasResourcesSettings = ProjectPreferences.getFile(folder, "org.eclipse.core.resources").exists();
        ProjectPreferences.removeNode(projectNode);
        if (hasResourcesSettings) {
            ProjectPreferences.preferencesChanged(folder.getProject());
        }
    }

    private String[] computeChildren() {
        if (this.project == null) {
            return EMPTY_STRING_ARRAY;
        }
        IFolder folder = this.project.getFolder(".settings");
        if (!folder.exists()) {
            return EMPTY_STRING_ARRAY;
        }
        IResource[] members = null;
        try {
            members = folder.members();
        }
        catch (CoreException coreException) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < members.length) {
            IResource resource = members[i];
            if (resource.getType() == 1 && resource.getFullPath().getFileExtension().equals("prefs")) {
                result.add(resource.getFullPath().removeFileExtension().lastSegment());
            }
            ++i;
        }
        return result.toArray(EMPTY_STRING_ARRAY);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void flush() throws BackingStoreException {
        this.isWriting = true;
        try {
            super.flush();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.isWriting = false;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.isWriting = false;
            return;
        }
    }

    class SortedProperties
    extends Properties {
        private static final long serialVersionUID = 1L;

        SortedProperties() {
        }

        public synchronized Enumeration keys() {
            TreeSet<Object> set = new TreeSet<Object>();
            Enumeration<Object> e = super.keys();
            while (e.hasMoreElements()) {
                set.add(e.nextElement());
            }
            return new IteratorWrapper(set.iterator());
        }

        class IteratorWrapper
        implements Enumeration {
            Iterator iterator;

            public IteratorWrapper(Iterator iterator) {
                this.iterator = iterator;
            }

            public boolean hasMoreElements() {
                return this.iterator.hasNext();
            }

            public Object nextElement() {
                return this.iterator.next();
            }
        }
    }
}

