/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.BasicLocation;
import org.eclipse.core.runtime.internal.adaptor.Locker;
import org.eclipse.osgi.framework.internal.reliablefile.ReliableFile;
import org.eclipse.osgi.framework.internal.reliablefile.ReliableFileInputStream;
import org.eclipse.osgi.framework.internal.reliablefile.ReliableFileOutputStream;

public class FileManager {
    static final int FILETYPE_STANDARD = 0;
    static final int FILETYPE_RELIABLEFILE = 1;
    private static boolean tempCleanup = Boolean.valueOf(System.getProperty("osgi.embedded.cleanTempFiles"));
    private static boolean openCleanup = Boolean.valueOf(System.getProperty("osgi.embedded.cleanupOnOpen"));
    private File base;
    private File managerRoot;
    private String lockMode = null;
    private File tableFile = null;
    private File lockFile;
    private Locker locker;
    private File instanceFile = null;
    private Locker instanceLocker = null;
    private boolean readOnly;
    private boolean open;
    private int tableStamp = -1;
    private Properties table = new Properties();
    private static final String MANAGER_FOLDER = ".manager";
    private static final String TABLE_FILE = ".fileTable";
    private static final String LOCK_FILE = ".fileTableLock";
    private static final int MAX_LOCK_WAIT = 5000;

    public FileManager(File base, String lockMode) {
        this(base, lockMode, false);
    }

    public FileManager(File base, String lockMode, boolean readOnly) {
        this.base = base;
        this.lockMode = lockMode;
        this.managerRoot = new File(base, MANAGER_FOLDER);
        if (!readOnly) {
            this.managerRoot.mkdirs();
        }
        this.tableFile = new File(this.managerRoot, TABLE_FILE);
        this.lockFile = new File(this.managerRoot, LOCK_FILE);
        this.readOnly = readOnly;
        this.open = false;
    }

    private void initializeInstanceFile() throws IOException {
        if (this.instanceFile != null || this.readOnly) {
            return;
        }
        this.instanceFile = File.createTempFile(".tmp", ".instance", this.managerRoot);
        this.instanceFile.deleteOnExit();
        this.instanceLocker = BasicLocation.createLocker(this.instanceFile, this.lockMode);
        this.instanceLocker.lock();
    }

    private String getAbsolutePath(String file) {
        return new File(this.base, file).getAbsolutePath();
    }

    public void add(String file) throws IOException {
        this.add(file, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void add(String file, int fileType) throws IOException {
        if (!this.open) {
            throw new IOException(EclipseAdaptorMsg.fileManager_notOpen);
        }
        if (this.readOnly) {
            throw new IOException(EclipseAdaptorMsg.fileManager_illegalInReadOnlyMode);
        }
        if (!this.lock(true)) {
            throw new IOException(EclipseAdaptorMsg.fileManager_cannotLock);
        }
        try {
            this.updateTable();
            Entry entry = (Entry)this.table.get(file);
            if (entry == null) {
                entry = new Entry(0, 1, fileType);
                this.table.put(file, entry);
                int oldestGeneration = this.findOldestGeneration(file);
                if (oldestGeneration != 0) {
                    entry.setWriteId(oldestGeneration + 1);
                }
                this.save();
            } else if (entry.getFileType() != fileType) {
                entry.setFileType(fileType);
                this.updateTable();
                this.save();
            }
            Object var5_7 = null;
            this.release();
            return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.release();
            throw throwable;
        }
    }

    private int findOldestGeneration(String file) {
        String[] files = this.base.list();
        int oldestGeneration = 0;
        if (files != null) {
            String name = String.valueOf(file) + '.';
            int len = name.length();
            int i = 0;
            while (i < files.length) {
                if (files[i].startsWith(name)) {
                    try {
                        int generation = Integer.parseInt(files[i].substring(len));
                        if (generation > oldestGeneration) {
                            oldestGeneration = generation;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                ++i;
            }
        }
        return oldestGeneration;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(String[] targets, String[] sources) throws IOException {
        if (!this.open) {
            throw new IOException(EclipseAdaptorMsg.fileManager_notOpen);
        }
        if (this.readOnly) {
            throw new IOException(EclipseAdaptorMsg.fileManager_illegalInReadOnlyMode);
        }
        if (!this.lock(true)) {
            throw new IOException(EclipseAdaptorMsg.fileManager_cannotLock);
        }
        try {
            block12: {
                this.updateTable();
                int[] originalReadIDs = new int[targets.length];
                boolean error = false;
                int i = 0;
                while (true) {
                    if (i >= targets.length) {
                        if (error) {
                            break;
                        }
                        break block12;
                    }
                    originalReadIDs[i] = this.getId(targets[i]);
                    if (!this.update(targets[i], sources[i])) {
                        error = true;
                    }
                    ++i;
                }
                i = 0;
                while (true) {
                    if (i >= targets.length) {
                        throw new IOException(EclipseAdaptorMsg.fileManager_updateFailed);
                    }
                    Entry entry = (Entry)this.table.get(targets[i]);
                    entry.setReadId(originalReadIDs[i]);
                    ++i;
                }
            }
            this.save();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.release();
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.release();
            return;
        }
    }

    public String[] getFiles() {
        if (!this.open) {
            return null;
        }
        Set<Object> set = this.table.keySet();
        String[] keys = set.toArray(new String[set.size()]);
        String[] result = new String[keys.length];
        int i = 0;
        while (i < keys.length) {
            result[i] = new String(keys[i]);
            ++i;
        }
        return result;
    }

    public File getBase() {
        return this.base;
    }

    public int getId(String target) {
        if (!this.open) {
            return -1;
        }
        Entry entry = (Entry)this.table.get(target);
        if (entry == null) {
            return -1;
        }
        return entry.getReadId();
    }

    protected int getFileType(String target) {
        Entry entry;
        if (this.open && (entry = (Entry)this.table.get(target)) != null) {
            return entry.getFileType();
        }
        return -1;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    private boolean lock(boolean wait) throws IOException {
        long time;
        boolean locked;
        if (this.readOnly) {
            return false;
        }
        if (this.locker == null) {
            this.locker = BasicLocation.createLocker(this.lockFile, this.lockMode);
            if (this.locker == null) {
                throw new IOException(EclipseAdaptorMsg.fileManager_cannotLock);
            }
        }
        if ((locked = this.locker.lock()) || !wait) {
            return locked;
        }
        long start = System.currentTimeMillis();
        do {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
            locked = this.locker.lock();
            if (!locked) continue;
            return true;
        } while ((time = System.currentTimeMillis() - start) <= 5000L);
        return false;
    }

    public File lookup(String target, boolean add) throws IOException {
        if (!this.open) {
            throw new IOException(EclipseAdaptorMsg.fileManager_notOpen);
        }
        Entry entry = (Entry)this.table.get(target);
        if (entry == null) {
            if (add) {
                this.add(target);
                entry = (Entry)this.table.get(target);
            } else {
                return null;
            }
        }
        return new File(this.getAbsolutePath(String.valueOf(target) + '.' + entry.getReadId()));
    }

    private boolean move(String source, String target) {
        File original = new File(source);
        File targetFile = new File(target);
        if (!original.exists() || targetFile.exists()) {
            return false;
        }
        return original.renameTo(targetFile);
    }

    private void release() {
        if (this.locker == null) {
            return;
        }
        this.locker.release();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(String file) throws IOException {
        if (!this.open) {
            throw new IOException(EclipseAdaptorMsg.fileManager_notOpen);
        }
        if (this.readOnly) {
            throw new IOException(EclipseAdaptorMsg.fileManager_illegalInReadOnlyMode);
        }
        if (!this.lock(true)) {
            throw new IOException(EclipseAdaptorMsg.fileManager_cannotLock);
        }
        try {
            this.updateTable();
            this.table.remove(file);
            this.save();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.release();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.release();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateTable() throws IOException {
        int stamp = ReliableFile.lastModifiedVersion((File)this.tableFile);
        if (stamp == this.tableStamp || stamp == -1) {
            return;
        }
        Properties diskTable = new Properties();
        ReliableFileInputStream input = new ReliableFileInputStream(this.tableFile);
        try {
            diskTable.load((InputStream)input);
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            input.close();
            throw throwable;
        }
        {
            Object var4_8 = null;
            input.close();
        }
        this.tableStamp = stamp;
        Enumeration<Object> e = diskTable.keys();
        while (e.hasMoreElements()) {
            int fileType;
            int id;
            String file = (String)e.nextElement();
            String value = diskTable.getProperty(file);
            if (value == null) continue;
            Entry entry = (Entry)this.table.get(file);
            int idx = value.indexOf(44);
            if (idx != -1) {
                id = Integer.parseInt(value.substring(0, idx));
                fileType = Integer.parseInt(value.substring(idx + 1));
            } else {
                id = Integer.parseInt(value);
                fileType = 0;
            }
            if (entry == null) {
                this.table.put(file, new Entry(id, id + 1, fileType));
                continue;
            }
            entry.setWriteId(id + 1);
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void save() throws IOException {
        block8: {
            if (this.readOnly) {
                return;
            }
            this.updateTable();
            Properties props = new Properties();
            Enumeration<Object> e = this.table.keys();
            while (e.hasMoreElements()) {
                String file = (String)e.nextElement();
                Entry entry = (Entry)this.table.get(file);
                String value = entry.getFileType() != 0 ? String.valueOf(Integer.toString(entry.getWriteId() - 1)) + ',' + Integer.toString(entry.getFileType()) : Integer.toString(entry.getWriteId() - 1);
                props.put(file, value);
            }
            ReliableFileOutputStream fileStream = new ReliableFileOutputStream(this.tableFile);
            try {
                Object var4_5;
                boolean error = true;
                try {
                    props.store((OutputStream)fileStream, "safe table");
                    fileStream.close();
                    error = false;
                    var4_5 = null;
                    if (!error) break block8;
                }
                catch (Throwable throwable) {
                    var4_5 = null;
                    if (error) {
                        fileStream.abort();
                    }
                    throw throwable;
                }
                fileStream.abort();
            }
            catch (IOException iOException) {
                throw new IOException(EclipseAdaptorMsg.fileManager_couldNotSave);
            }
        }
        this.tableStamp = ReliableFile.lastModifiedVersion((File)this.tableFile);
    }

    protected boolean update(String target, String source) {
        Entry entry = (Entry)this.table.get(target);
        int newId = entry.getWriteId();
        boolean success = this.move(this.getAbsolutePath(source), String.valueOf(this.getAbsolutePath(target)) + '.' + newId);
        if (!success) {
            newId = this.findOldestGeneration(target) + 1;
            success = this.move(this.getAbsolutePath(source), String.valueOf(this.getAbsolutePath(target)) + '.' + newId);
        }
        if (!success) {
            return false;
        }
        entry.setReadId(newId);
        entry.setWriteId(newId + 1);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cleanup() throws IOException {
        if (this.readOnly) {
            return;
        }
        if (!this.lock(true)) {
            throw new IOException(EclipseAdaptorMsg.fileManager_cannotLock);
        }
        try {
            String[] files = this.managerRoot.list();
            if (files != null) {
                int i = 0;
                while (i < files.length) {
                    if (files[i].endsWith(".instance") && this.instanceFile != null && !files[i].equalsIgnoreCase(this.instanceFile.getName())) {
                        Locker tmpLocker = BasicLocation.createLocker(new File(this.managerRoot, files[i]), this.lockMode);
                        if (!tmpLocker.lock()) {
                            tmpLocker.release();
                            Object var8_7 = null;
                            this.release();
                            return;
                        }
                        tmpLocker.release();
                        new File(this.managerRoot, files[i]).delete();
                    }
                    ++i;
                }
            }
            this.updateTable();
            Set<Map.Entry<Object, Object>> managedFiles = this.table.entrySet();
            Iterator iter = managedFiles.iterator();
            while (iter.hasNext()) {
                Map.Entry fileEntry = (Map.Entry)iter.next();
                String fileName = (String)fileEntry.getKey();
                Entry info = (Entry)fileEntry.getValue();
                if (info.getFileType() == 1) {
                    ReliableFile.cleanupGenerations((File)new File(this.base, fileName));
                    continue;
                }
                String readId = Integer.toString(info.getWriteId() - 1);
                this.deleteCopies(fileName, readId);
            }
            if (tempCleanup && (files = this.base.list()) != null) {
                int i = 0;
                while (i < files.length) {
                    if (files[i].endsWith(".tmp")) {
                        new File(this.base, files[i]).delete();
                    }
                    ++i;
                }
            }
            Object var8_9 = null;
            this.release();
            return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.release();
            throw throwable;
        }
    }

    private void deleteCopies(String fileName, String exceptionNumber) {
        String notToDelete = String.valueOf(fileName) + '.' + exceptionNumber;
        String[] files = this.base.list();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            if (files[i].startsWith(String.valueOf(fileName) + '.') && !files[i].equals(notToDelete)) {
                new File(this.base, files[i]).delete();
            }
            ++i;
        }
    }

    public void close() {
        if (!this.open) {
            return;
        }
        this.open = false;
        if (this.readOnly) {
            return;
        }
        try {
            this.cleanup();
        }
        catch (IOException iOException) {}
        if (this.instanceLocker != null) {
            this.instanceLocker.release();
        }
        if (this.instanceFile != null) {
            this.instanceFile.delete();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void open(boolean wait) throws IOException {
        boolean locked;
        if (openCleanup) {
            this.cleanup();
        }
        if (!this.readOnly && !(locked = this.lock(wait)) && wait) {
            throw new IOException(EclipseAdaptorMsg.fileManager_cannotLock);
        }
        try {
            this.initializeInstanceFile();
            this.updateTable();
            this.open = true;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.release();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.release();
            return;
        }
    }

    public File createTempFile(String file) throws IOException {
        if (this.readOnly) {
            throw new IOException(EclipseAdaptorMsg.fileManager_illegalInReadOnlyMode);
        }
        File tmpFile = File.createTempFile(file, ".tmp", this.base);
        tmpFile.deleteOnExit();
        return tmpFile;
    }

    private class Entry {
        int readId;
        int writeId;
        int fileType;

        Entry(int readId, int writeId, int type) {
            this.readId = readId;
            this.writeId = writeId;
            this.fileType = type;
        }

        int getReadId() {
            return this.readId;
        }

        int getWriteId() {
            return this.writeId;
        }

        int getFileType() {
            return this.fileType;
        }

        void setReadId(int value) {
            this.readId = value;
        }

        void setWriteId(int value) {
            this.writeId = value;
        }

        void setFileType(int type) {
            this.fileType = type;
        }
    }
}

