/*
 * Decompiled with CFR 0.152.
 */
package ast.AST;

import ast.AST.ASTNode;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;

public class ASTNode$State {
    public boolean IN_CIRCLE = false;
    public int CIRCLE_INDEX = 1;
    public boolean CHANGE = false;
    public boolean LAST_CYCLE = false;
    public boolean RESET_CYCLE = false;
    public Set circularEvalSet = new HashSet(4);
    public Stack circularEvalStack = new Stack();
    public static final int REWRITE_CHANGE = 1;
    public static final int REWRITE_NOCHANGE = 2;
    public static final int REWRITE_INTERRUPT = 3;
    public int boundariesCrossed = 0;
    private int[] stack = new int[64];
    private int pos = 0;
    protected int duringClassRelations = 0;

    public void addEvalEntry(ASTNode node, String attrName, Object parameters) {
        this.circularEvalSet.add(new CircularEvalEntry(node, attrName, parameters));
    }

    public boolean containsEvalEntry(ASTNode node, String attrName, Object parameters) {
        return this.circularEvalSet.contains(new CircularEvalEntry(node, attrName, parameters));
    }

    public void pushEvalStack() {
        this.circularEvalStack.push(new CircularStackEntry(this.circularEvalSet, this.CHANGE));
        this.circularEvalSet = new HashSet(4);
        this.CHANGE = false;
    }

    public void popEvalStack() {
        CircularStackEntry c = (CircularStackEntry)this.circularEvalStack.pop();
        this.circularEvalSet = c.circularEvalSet;
        this.CHANGE = c.changeValue;
    }

    private void ensureSize(int size) {
        if (size < this.stack.length) {
            return;
        }
        int[] newStack = new int[this.stack.length * 2];
        System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
        this.stack = newStack;
    }

    public void push(int i) {
        this.ensureSize(this.pos + 1);
        this.stack[this.pos++] = i;
    }

    public int pop() {
        return this.stack[--this.pos];
    }

    public int peek() {
        return this.stack[this.pos - 1];
    }

    public void reset() {
        this.IN_CIRCLE = false;
        this.CIRCLE_INDEX = 1;
        this.CHANGE = false;
        this.LAST_CYCLE = false;
        this.circularEvalSet = new HashSet(4);
        this.circularEvalStack = new Stack();
        this.boundariesCrossed = 0;
        if (this.duringClassRelations != 0) {
            System.out.println("Warning: resetting duringClassRelations");
            this.duringClassRelations = 0;
        }
    }

    public static class CircularValue {
        Object value;
        int visited = -1;
    }

    static class CircularEvalEntry {
        ASTNode node;
        String attrName;
        Object parameters;

        public CircularEvalEntry(ASTNode node, String attrName, Object parameters) {
            this.node = node;
            this.attrName = attrName;
            this.parameters = parameters;
        }

        public boolean equals(Object rhs) {
            CircularEvalEntry s = (CircularEvalEntry)rhs;
            if (this.parameters == null && s.parameters == null) {
                return this.node == s.node && this.attrName.equals(s.attrName);
            }
            if (this.parameters != null && s.parameters != null) {
                return this.node == s.node && this.attrName.equals(s.attrName) && this.parameters.equals(s.parameters);
            }
            return false;
        }

        public int hashCode() {
            return this.node.hashCode();
        }
    }

    static class CircularStackEntry {
        Set circularEvalSet;
        boolean changeValue;

        public CircularStackEntry(Set set, boolean change) {
            this.circularEvalSet = set;
            this.changeValue = change;
        }
    }

    static class IdentityHashSet
    extends AbstractSet
    implements Set {
        private IdentityHashMap map;
        private static final Object PRESENT = new Object();

        public IdentityHashSet(int initialCapacity) {
            this.map = new IdentityHashMap(initialCapacity);
        }

        public Iterator iterator() {
            return this.map.keySet().iterator();
        }

        public int size() {
            return this.map.size();
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public boolean contains(Object o) {
            return this.map.containsKey(o);
        }

        public boolean add(Object o) {
            return this.map.put(o, PRESENT) == null;
        }

        public boolean remove(Object o) {
            return this.map.remove(o) == PRESENT;
        }

        public void clear() {
            this.map.clear();
        }
    }
}

